/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.olap.OLAPArb;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.UISettings;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.view.TemplateContext;

public class TemplateListHyperView
implements PropertyChangeListener {
    private TemplateList templateList;
    private List<TemplateGroupHyperView> templateGroupHyperViews = new ArrayList<TemplateGroupHyperView>();
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private JPanel panel = new JPanel();

    public TemplateListHyperView(TemplateContext templateContext, TemplateHyperContext templateHyperContext, Class clazz, String string) throws SQLException, IOException {
        this.loadTemplatesFromXML(clazz, string);
        for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            TemplateGroupHyperView templateGroupHyperView = new TemplateGroupHyperView(templateContext, templateHyperContext, templateGroup, hashMap);
            templateGroupHyperView.addPropertyChangeListener(this);
            this.templateGroupHyperViews.add(templateGroupHyperView);
        }
        this.layoutComponents();
    }

    public void addTemplateList(TemplateList templateList) {
        this.templateList = templateList;
    }

    public String getExpression() throws SQLException, IOException {
        Iterator<TemplateGroupHyperView> iterator = this.templateGroupHyperViews.iterator();
        if (iterator.hasNext()) {
            TemplateGroupHyperView templateGroupHyperView = iterator.next();
            String string = templateGroupHyperView.getExpression();
            return string;
        }
        return null;
    }

    public String getExpression(String string) throws SQLException, IOException {
        Iterator<TemplateGroupHyperView> iterator = this.templateGroupHyperViews.iterator();
        if (iterator.hasNext()) {
            TemplateGroupHyperView templateGroupHyperView = iterator.next();
            String string2 = templateGroupHyperView.getExpression(string);
            return string2;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("VALUE_CHANGED")) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private boolean loadTemplatesFromXML(Class clazz, String string) {
        try {
            String string2 = "";
            string2 = JavaXMLBind.LoadDocument(clazz, string);
            String string3 = TemplateList.class.getPackage().getName();
            this.bindToJavaStr(string2, string3, this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    private void bindToJavaStr(String string, String string2, Object object) throws Exception {
        JavaXMLBind.BindToJavaStr(string, string2, object);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void layoutComponents() throws SQLException, IOException {
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 12);
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(String.format("<html><b>%s</b></html>", OLAPArb.get("CUBE_QUERY_DIMENSION_CONDITION_LABEL")));
        this.panel.add((Component)jLabel, gridBagConstraints);
        boolean bl = false;
        for (TemplateGroupHyperView templateGroupHyperView : this.templateGroupHyperViews) {
            JPanel jPanel = templateGroupHyperView.getPanel();
            if (jPanel == null) continue;
            Dimension dimension = jPanel.getSize();
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.panel.add((Component)jPanel, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)new JPanel(), gridBagConstraints);
    }
}

