/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.view;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.CalcToTemplate;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;

public class HyperTemplateManager {
    private TemplateList templateList;

    public HyperTemplateManager(Class clazz, String string) throws Exception {
        this.loadXML(clazz, string);
    }

    public HyperTemplateManager() throws Exception {
        String string = "c://calceq.xml";
        this.loadXML(null, string);
    }

    public HyperTemplateManager(String string) throws Exception {
        this.loadXML(null, string);
    }

    public HyperTemplateManager(URL uRL) throws Exception {
        this.loadXML(uRL);
    }

    private void loadXML(URL uRL) throws Exception {
        String string = TemplateList.class.getPackage().getName();
        JavaXMLBind.BindToJava(uRL, string, (Object)this);
    }

    public TemplateList getTemplateList() {
        return this.templateList;
    }

    public void addTemplateList(TemplateList templateList) {
        this.templateList = templateList;
    }

    public List<String> getTemplateGroups() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
            arrayList.add(templateGroup.getName());
        }
        return arrayList;
    }

    public List<String> getTemplates(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
            if (!templateGroup.getName().equals(string)) continue;
            for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                arrayList.add(baseTemplate.getName());
            }
        }
        return arrayList;
    }

    public String getGroupForTemplate(String string) {
        for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
            for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                if (!baseTemplate.getName().equals(string)) continue;
                return templateGroup.getName();
            }
        }
        return "";
    }

    public boolean isTime(String string) {
        for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
            for (Template template : templateGroup.getTemplatesOnly()) {
                if (!template.getName().equals(string) || !template.isTime()) continue;
                return true;
            }
        }
        return false;
    }

    private void loadXML(Class clazz, String string) throws Exception {
        String string2 = TemplateList.class.getPackage().getName();
        if (clazz != null) {
            String string3 = CalcToTemplate.transform(new StreamSource(clazz.getResourceAsStream(string)));
            JavaXMLBind.BindToJavaStr(string3, string2, this);
        } else {
            if (string.startsWith("file:")) {
                CalcToTemplate.transform(new StreamSource(new File(new URI(string))));
            } else {
                CalcToTemplate.transform(new StreamSource(new FileInputStream(string)));
            }
            JavaXMLBind.BindToJava(string, string2, (Object)this);
        }
    }
}

