/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.view;

import java.awt.Component;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JPanel;
import oracle.olap.app.Resources;
import oracle.olap.app.db.Database;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.HyperTemplateManager;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.util.OLAPFetchIcon;

public class HyperTemplateView {
    private String templateName;
    private TemplateContext context;
    private TemplateGroupHyperView groupView;
    private HyperTemplateManager templateManager;
    private Component parent;

    public HyperTemplateView(Component component, Database database, HyperTemplateManager hyperTemplateManager, TemplateMetadata templateMetadata, String string, String string2, Resources resources) throws Exception {
        this.templateManager = hyperTemplateManager;
        this.templateName = string2;
        this.parent = component;
        this.context = new TemplateContext(database, templateMetadata);
        for (TemplateGroup templateGroup : hyperTemplateManager.getTemplateList().getTemplateGroups()) {
            if (!templateGroup.getName().equals(string)) continue;
            this.groupView = new TemplateGroupHyperView(this.context, new TemplateHyperContextImpl(database.getConnection(), resources, new OLAPFetchIcon()), templateGroup);
        }
        if (this.groupView == null) {
            throw new Exception(string + " not found");
        }
    }

    public String getExpression() throws SQLException, IOException {
        for (TemplateHyperView templateHyperView : this.groupView.getTemplateViews()) {
            if (!templateHyperView.getName().equals(this.templateName)) continue;
            String string = templateHyperView.getExpression();
            return string;
        }
        return "";
    }

    public JPanel getPanel(Resources resources) throws SQLException, IOException {
        for (TemplateGroup templateGroup : this.templateManager.getTemplateList().getTemplateGroups()) {
            for (BaseTemplate baseTemplate : templateGroup.getTemplates()) {
                if (!baseTemplate.getName().equals(this.templateName) || baseTemplate.getUi() == null || baseTemplate.getUi().trim().length() <= 0) continue;
                return this.groupView.getPanel();
            }
        }
        return this.groupView.getPanel();
    }
}

