/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.olap.app.actions.PopupMenuHandler;
import oracle.olap.app.actions.data.Actions;
import oracle.olap.app.context.Context;
import oracle.olap.app.context.ContextCallback;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.Tree;
import oracle.olap.app.tree.model.VirtualTreeModel;
import oracle.olap.app.tree.view.ArrowImage;
import oracle.olap.app.tree.view.CTransferableTreePath;
import oracle.olap.app.tree.view.CustomTreeCellRenderer;
import oracle.olap.app.tree.view.JTree2;

public class JTreeV
extends JTree2
implements Autoscroll,
ContextCallback,
DragSourceListener,
DragGestureListener,
TreeExpansionListener,
TreeWillExpandListener,
TreeSelectionListener {
    private CustomTreeCellRenderer tc;
    private Map<String, Object> contextPropertiesMap;
    private TreePath _pathSource;
    private BufferedImage _imgGhost;
    private Point _ptOffset = new Point();
    final String TREEDATA = "TREEDATA";
    private static final int AUTOSCROLL_MARGIN = 12;
    private TreeNode sourceNode;
    private TreeNode targetNode;
    private Cursor origCursor;

    public JTreeV(VirtualTreeModel virtualTreeModel) {
        super(virtualTreeModel);
        this.setExpandsSelectedPaths(true);
        this.setLargeModel(true);
        if (virtualTreeModel.isMultipleRoot()) {
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
        }
        this.tc = new CustomTreeCellRenderer();
        this.setCellRenderer(this.tc);
        this.addTreeWillExpandListener(this);
        this.addTreeExpansionListener(this);
        this.contextPropertiesMap = new HashMap<String, Object>();
    }

    public VirtualTreeModel getVirtualModel() {
        return (VirtualTreeModel)this.getModel();
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        if (treeModel instanceof VirtualTreeModel) {
            VirtualTreeModel virtualTreeModel = (VirtualTreeModel)treeModel;
            this.setRootVisible(!virtualTreeModel.isMultipleRoot());
        }
    }

    public Tree getDataTree() {
        if (this.getModel() instanceof VirtualTreeModel) {
            VirtualTreeModel virtualTreeModel = (VirtualTreeModel)this.getModel();
            return virtualTreeModel.getTree();
        }
        return null;
    }

    @Override
    public void setupContext(Context context) {
        context.setSource(this);
        if (this.treeModel instanceof VirtualTreeModel) {
            VirtualTreeModel virtualTreeModel = (VirtualTreeModel)this.treeModel;
            context.setProperty("TREEDATA", virtualTreeModel.getTree());
            for (String string : this.contextPropertiesMap.keySet()) {
                context.setProperty(string, this.contextPropertiesMap.get(string));
            }
        }
    }

    public final void setContextProperty(String string, Object object) {
        this.contextPropertiesMap.put(string, object);
    }

    @Override
    public void autoscroll(Point point) {
        int n = this.getRowForLocation(point.x, point.y);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        n = point.y + rectangle.y <= 12 ? (n <= 0 ? 0 : n - 1) : (n < this.getRowCount() - 1 ? n + 1 : n);
        this.scrollRowToVisible(n);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        return new Insets(rectangle2.y - rectangle.y + 12, rectangle2.x - rectangle.x + 12, rectangle.height - rectangle2.height - rectangle2.y + rectangle.y + 12, rectangle.width - rectangle2.width - rectangle2.x + rectangle.x + 12);
    }

    private TreeNode getNodeForEvent(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        TreePath treePath = this.getClosestPathForLocation(point.x, point.y);
        return (TreeNode)treePath.getLastPathComponent();
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(true);
        this.setDragEnabled(true);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        DropTarget dropTarget = new DropTarget(this, new DropTargetListener(){
            private TreePath _pathLast = null;
            private Point _ptLast = new Point();
            private int _nLeftRight = 0;
            private Color _colorCueLine;
            private Rectangle2D _raGhost = new Rectangle2D.Float();
            private Rectangle2D _raCueLine = new Rectangle2D.Float();
            private Timer _timerHover;
            private BufferedImage _imgRight = new ArrowImage(15, 15, 3);
            private BufferedImage _imgLeft = new ArrowImage(15, 15, 2);
            private int _nShift = 0;
            {
                this._colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
                this._timerHover = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        _nLeftRight = 0;
                        if (JTreeV.this.isRootPath(_pathLast)) {
                            return;
                        }
                        if (JTreeV.this.isExpanded(_pathLast)) {
                            JTreeV.this.collapsePath(_pathLast);
                        } else {
                            JTreeV.this.expandPath(_pathLast);
                        }
                    }
                });
                this._timerHover.setRepeats(false);
            }

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            private void setDragImage(DropTargetDragEvent dropTargetDragEvent) {
                Point point = dropTargetDragEvent.getLocation();
                if (point.equals(this._ptLast)) {
                    return;
                }
                int n = point.x - this._ptLast.x;
                if (this._nLeftRight > 0 && n < 0 || this._nLeftRight < 0 && n > 0) {
                    this._nLeftRight = 0;
                }
                this._nLeftRight += n;
                this._ptLast = point;
                Graphics2D graphics2D = (Graphics2D)JTreeV.this.getGraphics();
                if (!DragSource.isDragImageSupported()) {
                    JTreeV.this.paintImmediately(this._raGhost.getBounds());
                    this._raGhost.setRect(point.x - ((JTreeV)JTreeV.this)._ptOffset.x, point.y - ((JTreeV)JTreeV.this)._ptOffset.y, JTreeV.this._imgGhost.getWidth(), JTreeV.this._imgGhost.getHeight());
                    graphics2D.drawImage(JTreeV.this._imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
                } else {
                    JTreeV.this.paintImmediately(this._raCueLine.getBounds());
                }
                TreePath treePath = JTreeV.this.getClosestPathForLocation(point.x, point.y);
                if (treePath != this._pathLast) {
                    this._nLeftRight = 0;
                    this._pathLast = treePath;
                    this._timerHover.restart();
                }
                Rectangle rectangle = JTreeV.this.getPathBounds(treePath);
                this._raCueLine.setRect(0.0, rectangle.y + (int)rectangle.getHeight(), JTreeV.this.getWidth(), 2.0);
                graphics2D.setColor(this._colorCueLine);
                graphics2D.fill(this._raCueLine);
                if (this._nLeftRight > 20) {
                    graphics2D.drawImage(this._imgRight, AffineTransform.getTranslateInstance(point.x - ((JTreeV)JTreeV.this)._ptOffset.x, point.y - ((JTreeV)JTreeV.this)._ptOffset.y), null);
                    this._nShift = 1;
                } else if (this._nLeftRight < -20) {
                    graphics2D.drawImage(this._imgLeft, AffineTransform.getTranslateInstance(point.x - ((JTreeV)JTreeV.this)._ptOffset.x, point.y - ((JTreeV)JTreeV.this)._ptOffset.y), null);
                    this._nShift = -1;
                } else {
                    this._nShift = 0;
                }
                this._raGhost = this._raGhost.createUnion(this._raCueLine);
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                this.setDragImage(dropTargetDragEvent);
                TreeNode treeNode = JTreeV.this.getNodeForEvent(dropTargetDragEvent);
                JTreeV.this.sourceNode = null;
                JTreeV.this.targetNode = treeNode;
                if (JTreeV.this.getLastSelectedPathComponent() != null) {
                    JTreeV.this.sourceNode = (TreeNode)JTreeV.this.getLastSelectedPathComponent();
                }
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                JTreeV.this.dropAction(dropTargetDropEvent);
            }
        });
    }

    private void dropAction(DropTargetDropEvent dropTargetDropEvent) {
        VirtualTreeModel virtualTreeModel = (VirtualTreeModel)this.treeModel;
        virtualTreeModel.moveNode((Node)this.sourceNode, (Node)this.targetNode);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node = (Node)this.targetNode; node != null; node = node.getParent()) {
            arrayList.add(node);
        }
        Collections.reverse(arrayList);
        Object[] objectArray = arrayList.toArray();
        arrayList.add((Node)this.sourceNode);
        Object[] objectArray2 = arrayList.toArray();
        TreePath treePath = new TreePath(objectArray2);
        TreePath treePath2 = new TreePath(objectArray);
        this.expandPath(treePath2);
        this.setSelectionPath(treePath);
        this.expandPath(treePath);
        this.updateUI();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        if (this.isRootPath(treePath)) {
            return;
        }
        Rectangle rectangle = this.getPathBounds(treePath);
        this._ptOffset.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        JLabel jLabel = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, this.isExpanded(treePath), this.getModel().isLeaf(treePath.getLastPathComponent()), 0, false);
        jLabel.setSize((int)rectangle.getWidth(), (int)rectangle.getHeight());
        this._imgGhost = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 3);
        Graphics2D graphics2D = this._imgGhost.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
        jLabel.paint(graphics2D);
        Icon icon = jLabel.getIcon();
        int n = icon == null ? 0 : icon.getIconWidth() + jLabel.getIconTextGap();
        graphics2D.setComposite(AlphaComposite.getInstance(4, 0.5f));
        graphics2D.setPaint(new GradientPaint(n, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        graphics2D.fillRect(n, 0, this.getWidth(), this._imgGhost.getHeight());
        graphics2D.dispose();
        this.setSelectionPath(treePath);
        System.out.println("DRAGGING: " + treePath.getLastPathComponent());
        CTransferableTreePath cTransferableTreePath = new CTransferableTreePath(treePath);
        this._pathSource = treePath;
        Cursor cursor = null;
        BufferedImage bufferedImage = this._imgGhost;
        Point point2 = new Point(5, 5);
        dragGestureEvent.startDrag(cursor, bufferedImage, point2, cTransferableTreePath, this);
    }

    private boolean isRootPath(TreePath treePath) {
        return this.isRootVisible() && this.getRowForPath(treePath) == 0;
    }

    public void setActions(Class clazz, String string) throws Exception {
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(clazz, string, this);
        this.setupPopupMenuHandler(popupMenuHandler);
    }

    public void setActions(Actions actions) {
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(actions);
        this.setupPopupMenuHandler(popupMenuHandler);
    }

    private void setupPopupMenuHandler(PopupMenuHandler popupMenuHandler) {
        final JPopupMenu jPopupMenu = popupMenuHandler.getPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = JTreeV.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    JTreeV.this.setSelectionPath(treePath);
                    jPopupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }
        });
    }

    public void setLeafIcon(Icon icon) {
        this.tc.setLeafIcon(icon);
    }

    public void setFolderIcon(Icon icon) {
        this.tc.setFolderIcon(icon);
    }

    public void expandAll() {
        this.expandAll(true);
    }

    public void collapseAll() {
        this.expandAll(false);
    }

    public void expandAll(boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                this.expandRow(i);
                continue;
            }
            this.collapseRow(i);
        }
    }

    public void find(String string, String string2, SearchOptions searchOptions) {
        VirtualTreeModel virtualTreeModel;
        Node node;
        if (this.treeModel instanceof VirtualTreeModel && (node = (virtualTreeModel = (VirtualTreeModel)this.treeModel).findNode(string, string2, searchOptions)) != null) {
            this.selectNode(node);
        }
    }

    public void findNodes(String string, String string2, SearchOptions searchOptions, List<Node> list) {
        if (this.treeModel instanceof VirtualTreeModel) {
            VirtualTreeModel virtualTreeModel = (VirtualTreeModel)this.treeModel;
            virtualTreeModel.findNodes(string, string2, searchOptions, list);
        }
    }

    public void selectNode(Node node) {
        if (this.treeModel instanceof VirtualTreeModel) {
            VirtualTreeModel virtualTreeModel = (VirtualTreeModel)this.treeModel;
            int n = node.getDepth();
            if (virtualTreeModel.getTree().isMultipleRoots()) {
                ++n;
            }
            Object[] objectArray = new Object[n + 1];
            while (n >= 0 && node != null) {
                objectArray[n] = node;
                node = node.getParent();
                --n;
            }
            if (virtualTreeModel.getTree().isMultipleRoots()) {
                objectArray[0] = virtualTreeModel.getRoot();
            }
            TreePath treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        this.origCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.setCursor(this.origCursor);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }
}

