/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.Namespace;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.OLAPArb;
import oracle.olap.actions.BuildRunnable;
import oracle.olap.actions.BuildTask;
import oracle.olap.build.BuildObject;
import oracle.olap.build.log.BuildLog;
import oracle.olap.build.log.BuildLog112;
import oracle.olap.buildreports.BuildStatusDialog;
import oracle.olap.db.DatabaseConnection;
import oracle.olap.db.OracleDatabaseInfo;
import oracle.olap.dml.DMLObject;

public class OLAPBuildRun {
    private Connection conn;
    private Connection clonedConnection = null;
    private Connection buildConn = null;
    private String schemaName;
    private Namespace buildWizardData;
    private BuildStatusDialog builddlg = null;
    private static String m_enableAllLogsScript = null;
    private Boolean isAWPreviouslyAttachedRWInSession = null;
    private String logLevel;
    private int logMaxErrors;

    public OLAPBuildRun(Connection connection, String string, Namespace namespace) {
        this.conn = connection;
        this.schemaName = string;
        this.buildWizardData = namespace;
    }

    public void runBuild() throws Exception {
        boolean bl = (Boolean)this.buildWizardData.get("RUNNOW");
        boolean bl2 = (Boolean)this.buildWizardData.get("RUN_IN_JOBQ");
        boolean bl3 = (Boolean)this.buildWizardData.get("RUN_IN_JOBQ_NOW");
        String string = (String)this.buildWizardData.get("SQL_FILENAME");
        this.logLevel = (String)this.buildWizardData.get("BUILD_LOG_LEVEL");
        this.logMaxErrors = (Integer)this.buildWizardData.get("BUILD_LOG_MAX_ERRORS");
        String string2 = "";
        String string3 = "";
        this.createBuildLogTables(this.conn, this.schemaName, this.logLevel, this.logMaxErrors);
        List list = (List)this.buildWizardData.get("BUILD_OBJECTS");
        for (BuildObject buildObject : list) {
            String string4 = buildObject.getType();
            String string5 = buildObject.getInlineBuildSpecification();
            String string6 = buildObject.getCubeScriptName();
            String string7 = "";
            string7 = buildObject.getDefaultBuildSpecificationName();
            if (!string2.isEmpty()) {
                string2 = string2 + ",";
            }
            if (string4.equalsIgnoreCase("CUBE")) {
                if (!string5.isEmpty()) {
                    string2 = string2 + buildObject.getFullyQualifiedName() + " USING (" + string5 + ")";
                } else if (string6.isEmpty() || string6.equalsIgnoreCase(string7)) {
                    string2 = string2 + buildObject.getFullyQualifiedName();
                } else if (!string6.isEmpty()) {
                    string2 = string2 + buildObject.getFullyQualifiedName() + " USING " + string6;
                }
                string3 = string3 + buildObject.getRefreshMethod();
            }
            if (!string4.equalsIgnoreCase("CUBE DIMENSION")) continue;
            boolean bl4 = buildObject.isSortOn();
            boolean bl5 = buildObject.isSynchOn();
            String string8 = buildObject.getLoadOption();
            String string9 = this.generateDimensionUsingClause(string8, bl4, string6, string5);
            string3 = string3 + buildObject.getRefreshMethod();
            string2 = string2 + buildObject.getFullyQualifiedName();
            if (bl5 && bl4 && string6.isEmpty() && string5.isEmpty()) continue;
            string2 = string2 + string9;
        }
        string2 = string2.replaceAll("'", "''");
        if (string != null && !string.isEmpty()) {
            this.generateSQLScript(string2, string3, string);
        }
        if (bl) {
            this.runBuildInSession(string2, string3);
        } else if (bl2) {
            this.runBuildInJobQ(string2, string3, false);
        } else if (bl3) {
            this.runBuildInJobQ(string2, string3, true);
        }
    }

    private String generateDimensionUsingClause(String string, boolean bl, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(" USING");
        StringBuffer stringBuffer2 = new StringBuffer("LOAD ");
        StringBuffer stringBuffer3 = new StringBuffer("COMPILE ");
        if (!string3.isEmpty()) {
            stringBuffer.append("(");
            stringBuffer.append(string3 + ")");
        } else if (!string2.isEmpty()) {
            stringBuffer.append(string2);
        } else {
            if (string.equalsIgnoreCase("SYNCH")) {
                stringBuffer2.append("SYNCH");
            } else if (string.equalsIgnoreCase("NOSYNCH")) {
                stringBuffer2.append("NO SYNCH");
            } else if (string.equalsIgnoreCase("RETAIN")) {
                stringBuffer2.append("RETAIN");
            }
            stringBuffer.append("(");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(",");
            if (bl) {
                stringBuffer3.append("SORT");
            } else {
                stringBuffer3.append("NO SORT");
            }
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private void runBuildInSession(String string, String string2) throws Exception {
        String string3 = String.format("select %s.CUBE_BUILD_ID.nextval from dual", this.schemaName);
        int n = 0;
        int n2 = 0;
        String string4 = null;
        this.clonedConnection = DatabaseConnection.getInstance().getClonedConnection(this.conn);
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.clonedConnection);
        List list = (List)this.buildWizardData.get("BUILD_OBJECTS");
        BuildObject buildObject = (BuildObject)list.get(0);
        final String string5 = buildObject.getOwner();
        final String string6 = buildObject.getAWName();
        this.buildConn = this.conn;
        if (!this.isAWPreviouslyAttachedRWInSession(this.conn, string6)) {
            this.buildConn = this.clonedConnection;
        }
        this.isAWPreviouslyAttachedRWInSession = null;
        this.attachAnalyticWorkspace(this.buildConn, string5, string6);
        string4 = dBUtil.executeReturnOneCol(string3);
        if (string4 != null) {
            n = Integer.valueOf(string4);
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        BuildRunnable buildRunnable = new BuildRunnable(this.buildConn, this.buildWizardData, string, string2, n, bl);
        String string7 = OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_LOG_HEADER");
        string7 = MessageFormat.format(string7, "");
        ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string7, (Runnable)buildRunnable, true);
        progressBar.setCancelable(false);
        buildRunnable.setProgressBar(progressBar);
        this.getBuildLog(this.buildConn, this.schemaName).disableAllBuildLogs();
        progressBar.start(OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_LOG_BUSYBAR"), null);
        this.getBuildLog(this.buildConn, this.schemaName).enableAllBuildLogs(this.logLevel, this.logMaxErrors);
        string4 = dBUtil.executeReturnOneCol(string3);
        if (string4 != null) {
            n2 = Integer.valueOf(string4);
        }
        n2 = Integer.valueOf(string4);
        this.builddlg = new BuildStatusDialog((JFrame)Ide.getMainWindow(), this.conn, n, n2);
        bl = false;
        BuildTask buildTask = new BuildTask(this.buildConn, this.buildWizardData, string, string2, n2, this.builddlg, bl, OLAPArb.format("BUILD_PROGRESSBAR_TITLE", string), bl2, IRaptorTaskRunMode.NO_GUI, bl3, bl4);
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        final int n3 = n;
        buildTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), throwable.getLocalizedMessage());
                        try {
                            OLAPBuildRun.this.detachAnalyticWorkspace(OLAPBuildRun.this.buildConn, string5, string6, true);
                            if (n3 > 0) {
                                OLAPBuildRun.this.getBuildLog(OLAPBuildRun.this.buildConn, OLAPBuildRun.this.schemaName).deleteBuildLogEntries(n3, "DBMS_CUBE_LOG.TYPE_BUILD");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OLAPBuildRun.this.detachAnalyticWorkspace(OLAPBuildRun.this.buildConn, string5, string6, true);
                            if (n3 > 0) {
                                OLAPBuildRun.this.getBuildLog(OLAPBuildRun.this.buildConn, OLAPBuildRun.this.schemaName).deleteBuildLogEntries(n3, "DBMS_CUBE_LOG.TYPE_BUILD");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        raptorTaskManager.addTask((RaptorTask)buildTask);
        this.builddlg.runDialog();
    }

    private void attachAnalyticWorkspace(Connection connection, String string, String string2) throws SQLException, IOException {
        String string3 = String.format("%s.%s", string, string2);
        try {
            if (!this.isAWPreviouslyAttachedRWInSession(connection, string3)) {
                DMLObject.runDML(connection, "ATTACH_AW", string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private void detachAnalyticWorkspace(Connection connection, String string, String string2, boolean bl) throws SQLException, IOException {
        String string3 = String.format("%s.%s", string, string2);
        try {
            if (bl && !this.isAWPreviouslyAttachedRWInSession(connection, string3) || !bl) {
                DMLObject.runDML(connection, "DETACH_AW", string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private boolean isAWPreviouslyAttachedRWInSession(Connection connection, String string) throws SQLException, IOException {
        if (this.isAWPreviouslyAttachedRWInSession == null) {
            this.isAWPreviouslyAttachedRWInSession = Boolean.FALSE;
            String string2 = DMLObject.getAWAttachModeInSession(connection, string);
            if (string2 != null && string2.equalsIgnoreCase("RW")) {
                this.isAWPreviouslyAttachedRWInSession = Boolean.TRUE;
            }
        }
        return this.isAWPreviouslyAttachedRWInSession;
    }

    private void runBuildInJobQ(String string, String string2, boolean bl) throws Exception {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.buildWizardData.get("JOBQ_SCHED_TIME");
        boolean bl2 = false;
        int n = 0;
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        List list = (List)this.buildWizardData.get("BUILD_OBJECTS");
        BuildObject buildObject = (BuildObject)list.get(0);
        String string3 = buildObject.getOwner();
        String string4 = buildObject.getAWName();
        String string5 = String.format("%s.%s", string3, string4);
        bl2 = OracleDatabaseInfo.isDatabaseCompatible11_2_OrGreater(this.conn);
        String string6 = String.format("select %s.CUBE_BUILD_ID.nextval from dual", this.schemaName);
        String string7 = dBUtil.executeReturnOneCol(string6);
        if (string7 != null) {
            n = Integer.valueOf(string7);
        }
        String string8 = String.format("OLAP$_%s", n);
        StringBuffer stringBuffer = new StringBuffer();
        if (m_enableAllLogsScript != null) {
            stringBuffer.append(m_enableAllLogsScript);
        }
        Boolean bl3 = (Boolean)this.buildWizardData.get("ISATOMIC");
        Boolean bl4 = (Boolean)this.buildWizardData.get("REFRESH_AFTER_ERROR");
        Boolean bl5 = (Boolean)this.buildWizardData.get("AUTOORDER");
        Boolean bl6 = (Boolean)this.buildWizardData.get("ADDDIM");
        int n2 = (Integer)this.buildWizardData.get("PARALLEL_PROC_NUM");
        String string9 = "";
        string9 = string9 + "begin dbms_cube.build('" + string + "', '" + string2 + "', " + bl4 + ", " + n2 + ", " + bl3 + ", " + bl5 + ", " + bl6 + ", '" + string8 + "'";
        if (bl2) {
            string9 = string9 + ", " + n;
        }
        string9 = string9 + "); end;";
        String string10 = "begin ";
        string10 = string10 + stringBuffer.toString() + string9 + "end;";
        Timestamp timestamp = null;
        if (!bl) {
            timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
        } else {
            this.isAWPreviouslyAttachedRWInSession = null;
            if (this.isAWPreviouslyAttachedRWInSession(this.conn, string5)) {
                int n3 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.format("BUILD_WIZARD_ANALYTIC_WORKSPACE_DETACH", string5), OLAPArb.get("BUILD_JOB_SUBMITTED_TO_QUEUE_TITLE"), 0);
                if (n3 != 0) {
                    return;
                }
                this.detachAnalyticWorkspace(this.conn, string3, string4, false);
            }
        }
        String string11 = "declare b BOOLEAN; begin if :enable=1 then b:=true; end if; dbms_scheduler.create_job(:jobname, 'plsql_block', :buildcommands, 0, :starttime, null, null, 'DEFAULT_JOB_CLASS', b, b, :comments); end;";
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string11);
        oracleCallableStatement.setInt("enable", 1);
        oracleCallableStatement.setString("jobname", string8);
        oracleCallableStatement.setString("buildcommands", string10);
        oracleCallableStatement.setTimestamp("starttime", timestamp, (Calendar)gregorianCalendar);
        oracleCallableStatement.setString("comments", "OLAP Build");
        try {
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            oracleCallableStatement.close();
        }
        String string12 = MessageFormat.format(OLAPArb.get("BUILD_JOB_SUBMITTED_TO_QUEUE_MSG"), string8);
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string12, OLAPArb.get("BUILD_JOB_SUBMITTED_TO_QUEUE_TITLE"), 1);
    }

    private void generateSQLScript(String string, String string2, String string3) throws Exception {
        boolean bl = (Boolean)this.buildWizardData.get("ISATOMIC");
        boolean bl2 = (Boolean)this.buildWizardData.get("REFRESH_AFTER_ERROR");
        boolean bl3 = (Boolean)this.buildWizardData.get("AUTOORDER");
        boolean bl4 = (Boolean)this.buildWizardData.get("ADDDIM");
        int n = (Integer)this.buildWizardData.get("PARALLEL_PROC_NUM");
        String string4 = string3;
        String string5 = String.format("BEGIN%n  DBMS_CUBE.BUILD(%n    '%1$s',%n    '%2$s', -- refresh method%n    %3$b, -- refresh after errors%n    %4$s, -- parallelism%n    %5$b, -- atomic refresh%n    %6$b, -- automatic order%n    %7$b); -- add dimensions%nEND;%n/%n", string, string2, bl2, n, bl, bl3, bl4);
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string4);
            boolean bl5 = file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string5.getBytes());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void createBuildLogTables(Connection connection, String string, String string2, int n) throws Exception {
        BuildLog buildLog = this.getBuildLog(connection, string);
        buildLog.createAllBuildLogTables(string2, n);
        m_enableAllLogsScript = buildLog.getEnableAllLogsScript();
    }

    private BuildLog getBuildLog(Connection connection, String string) throws Exception {
        BuildLog112 buildLog112 = null;
        buildLog112 = new BuildLog112(connection);
        return buildLog112;
    }
}

