/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.log;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.build.log.BuildLog;
import oracle.olap.preferences.OLAPBuildLogPreferenceSettings;

public class BuildLog112
implements BuildLog {
    private static final String CUBE_BUILD_SEQUENCE_NAME = "CUBE_BUILD_ID";
    private static final String MAX_ERRORS = "1";
    public static final String OPERATIONS_LOG = "DBMS_CUBE_LOG.TYPE_OPERATIONS";
    public static final String REJECTED_RECORDS_LOG = "DBMS_CUBE_LOG.TYPE_REJECTED_RECORDS";
    public static final String DIMENSION_COMPILE_LOG = "DBMS_CUBE_LOG.TYPE_DIMENSION_COMPILE";
    public static final String BUILD_LOG = "DBMS_CUBE_LOG.TYPE_BUILD";
    public static final String ACTION = "DBMS_CUBE_LOG.LEVEL_LOWEST";
    public static final String NOTICE = "DBMS_CUBE_LOG.LEVEL_LOW";
    public static final String INFO = "DBMS_CUBE_LOG.LEVEL_MEDIUM";
    public static final String STATS = "DBMS_CUBE_LOG.LEVEL_HIGH";
    public static final String DEBUG = "DBMS_CUBE_LOG.LEVEL_HIGHEST";
    private String m_enableAllLogsScript = null;
    private Connection _conn;
    private static Preferences _p = Preferences.getPreferences();
    private OLAPBuildLogPreferenceSettings buildLogSettings = OLAPBuildLogPreferenceSettings.getInstance((PropertyStorage)_p);

    public BuildLog112(Connection connection) {
        this._conn = connection;
    }

    @Override
    public void createAllBuildLogTables() throws Exception {
        this.createBuildLogTable(BUILD_LOG);
        this.createBuildLogTable(OPERATIONS_LOG);
        this.createBuildLogTable(REJECTED_RECORDS_LOG);
        this.createBuildLogTable(DIMENSION_COMPILE_LOG);
        this.enableAllBuildLogs();
    }

    @Override
    public void createAllBuildLogTables(String string, int n) throws Exception {
        this.createBuildLogTable(BUILD_LOG);
        this.createBuildLogTable(OPERATIONS_LOG);
        this.createBuildLogTable(REJECTED_RECORDS_LOG);
        this.createBuildLogTable(DIMENSION_COMPILE_LOG);
        this.enableAllBuildLogs(string, n);
    }

    @Override
    public void createBuildLogTable(String string) throws Exception {
        Statement statement = null;
        statement = this._conn.createStatement();
        String string2 = "";
        try {
            string2 = "BEGIN dbms_cube_log.table_create(" + string + "); end;";
            int n = statement.executeUpdate(string2);
            if (string.equalsIgnoreCase(BUILD_LOG)) {
                String string3 = "ALTER SEQUENCE CUBE_BUILD_ID NOCACHE";
                DatabaseUtils.ExecuteSQL(this._conn, string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            statement.close();
        }
    }

    @Override
    public void deleteAllBuildLogEntries(int n) throws Exception {
        this.deleteBuildLogEntries(n, OPERATIONS_LOG);
        this.deleteBuildLogEntries(n, REJECTED_RECORDS_LOG);
        this.deleteBuildLogEntries(n, REJECTED_RECORDS_LOG);
        this.deleteBuildLogEntries(n, BUILD_LOG);
    }

    @Override
    public void deleteBuildLogEntries(int n, String string) throws Exception {
        String string2 = null;
        string2 = string.equalsIgnoreCase(OPERATIONS_LOG) ? String.format("delete from %s o where o.seq_number in (select seq_number from %s where build_id = ?)", this.getDefaultBuildLogTableName(OPERATIONS_LOG), this.getDefaultBuildLogTableName(BUILD_LOG)) : (string.equalsIgnoreCase(REJECTED_RECORDS_LOG) ? String.format("delete from %s o where o.seq_number in (select seq_number from %s where build_id = ?)", this.getDefaultBuildLogTableName(REJECTED_RECORDS_LOG), this.getDefaultBuildLogTableName(BUILD_LOG)) : (string.equalsIgnoreCase(REJECTED_RECORDS_LOG) ? String.format("delete from %s o where o.seq_number in (select seq_number from %s where build_id = ?)", this.getDefaultBuildLogTableName(DIMENSION_COMPILE_LOG), this.getDefaultBuildLogTableName(BUILD_LOG)) : String.format("delete from %s where  build_id = ?", this.getDefaultBuildLogTableName(BUILD_LOG))));
        Object[] objectArray = new Object[]{n};
        DatabaseUtils.ExecuteSQL(this._conn, string2, objectArray);
        DatabaseUtils.ExecuteSQL(this._conn, "commit");
    }

    @Override
    public void enableAllBuildLogs() throws SQLException {
        String string = this.buildLogSettings.getLogLevel();
        int n = this._getMaxErrors();
        this.enableAllBuildLogs(string, n);
    }

    @Override
    public void enableAllBuildLogs(String string, int n) throws SQLException {
        this.enableBuildLog(OPERATIONS_LOG, string);
        if (Integer.valueOf(n) > 0) {
            this.enableBuildLog(REJECTED_RECORDS_LOG, string);
            this.enableBuildLog(DIMENSION_COMPILE_LOG, string);
            this._setMaxErrors(REJECTED_RECORDS_LOG, n);
            this._setMaxErrors(DIMENSION_COMPILE_LOG, n);
        } else {
            this._disableBuildLog(REJECTED_RECORDS_LOG);
            this._disableBuildLog(DIMENSION_COMPILE_LOG);
        }
    }

    @Override
    public void enableBuildLog(String string, String string2) throws SQLException {
        Statement statement = null;
        String string3 = "";
        try {
            string2 = string2.equalsIgnoreCase("ACTION") || string2.equalsIgnoreCase(ACTION) ? ACTION : (string2.equalsIgnoreCase("NOTICE") || string2.equalsIgnoreCase(NOTICE) ? NOTICE : (string2.equalsIgnoreCase("INFO") || string2.equalsIgnoreCase(INFO) ? INFO : (string2.equalsIgnoreCase("STATS") || string2.equalsIgnoreCase(STATS) ? STATS : (string2.equalsIgnoreCase("DEBUG") || string2.equalsIgnoreCase(DEBUG) ? DEBUG : INFO))));
            statement = this._conn.createStatement();
            string3 = "BEGIN dbms_cube_log.enable(" + string + "," + "DBMS_CUBE_LOG.TARGET_TABLE," + string2 + "); end;";
            this.setEnableAllLogsScript(string3);
            int n = statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            statement.close();
        }
    }

    @Override
    public String getDefaultBuildLogTableName(String string) throws Exception {
        String string2 = "";
        String string3 = "dbms_cube_log.default_name";
        int n = string.equalsIgnoreCase(OPERATIONS_LOG) ? 1 : (string.equalsIgnoreCase(REJECTED_RECORDS_LOG) ? 2 : (string.equalsIgnoreCase(DIMENSION_COMPILE_LOG) ? 3 : (string.equalsIgnoreCase(BUILD_LOG) ? 4 : 1)));
        String string4 = null;
        String string5 = String.valueOf(n);
        string2 = string4 = DatabaseUtils.ExecuteStoredProc(this._conn, string3, string5);
        return string2;
    }

    @Override
    public String getEnableAllLogsScript() {
        return this.m_enableAllLogsScript;
    }

    private void setEnableAllLogsScript(String string) {
        this.m_enableAllLogsScript = this.m_enableAllLogsScript == null ? string : this.m_enableAllLogsScript + "\n" + string;
    }

    @Override
    public void disableAllBuildLogs() throws SQLException {
        this._disableBuildLog(OPERATIONS_LOG);
        this._disableBuildLog(REJECTED_RECORDS_LOG);
        this._disableBuildLog(DIMENSION_COMPILE_LOG);
    }

    private void _disableBuildLog(String string) throws SQLException {
        Statement statement = null;
        String string2 = "";
        try {
            statement = this._conn.createStatement();
            string2 = "BEGIN dbms_cube_log.disable(" + string + "," + "DBMS_CUBE_LOG.TARGET_TABLE); end;";
            this.setEnableAllLogsScript(string2);
            int n = statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            statement.close();
        }
    }

    private void _setMaxErrors(String string, int n) throws SQLException {
        Statement statement = null;
        String string2 = "";
        if (n == 0) {
            n = 100;
        }
        try {
            statement = this._conn.createStatement();
            string2 = "BEGIN dbms_cube_log.set_parameter(" + string + "," + MAX_ERRORS + "," + n + "); end;";
            this.setEnableAllLogsScript(string2);
            int n2 = statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            statement.close();
        }
    }

    private int _getMaxErrors() {
        int n = this.buildLogSettings.getMaxErrorsLogged();
        return n;
    }
}

