/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.db.DBUtil;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.build.BuildObject;

public class BuildObjectShuttlePanel
extends DefaultTraversablePanel {
    private DefaultListModel fromModel;
    private DefaultListModel toModel;
    private JList fromList;
    private JList toList;
    private ListSelectionListener toListListener;
    private ListPicker fromPicker;
    private ReorderableListPicker toPicker;
    private TraversableContext m_ctx;
    private JCheckBox isAutoOrderOn;
    private JCheckBox isAutoAddDimOn;

    public BuildObjectShuttlePanel() {
        this.setLayout(new BorderLayout());
        this.add(this.createInstructions(), "North");
        this.add((Component)this.createShuttle(), "Center");
        JPanel jPanel = this.createCheckBoxPanel();
        this.add(jPanel, "South");
        this.fromList.setCellRenderer(new DefaultListCellRenderer());
        this.toList.setCellRenderer(new DefaultListCellRenderer());
    }

    private JCheckBox createAutoOrderCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_AUTOMATIC_ORDER_LABEL"));
        return jCheckBox;
    }

    private JCheckBox createAutoAddCubeDimCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_ADD_DIMENSIONS_LABEL"));
        return jCheckBox;
    }

    private JPanel createCheckBoxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.isAutoOrderOn = this.createAutoOrderCheckBox();
        jPanel.add(this.isAutoOrderOn);
        this.isAutoAddDimOn = this.createAutoAddCubeDimCheckBox();
        jPanel.add(this.isAutoAddDimOn);
        return jPanel;
    }

    private JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(OLAPArb.get("BUILD_WIZARD_SEL_OBJ_INSTRUCTION_MSG"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    private Shuttle createShuttle() {
        Shuttle shuttle = new Shuttle();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.fromModel = new DefaultListModel();
        this.toModel = new DefaultListModel();
        this.fromList = new JList();
        this.toList = new JList();
        this.toListListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }
        };
        this.toList.addListSelectionListener(this.toListListener);
        this.fromPicker = new ListPicker(this.fromList);
        this.toPicker = new ReorderableListPicker(this.toList);
        shuttle.setToPicker((ItemPicker)this.toPicker);
        shuttle.setFromPicker((ItemPicker)this.fromPicker);
        this.fromList.setModel(this.fromModel);
        this.toList.setModel(this.toModel);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fromList, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_AVAILABLE_OBJ_LABEL"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.toList, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_SELECTED_OBJ_LABEL"));
        shuttle.addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }

            public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }

            public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
                BuildObjectShuttlePanel.this.fixButtons();
            }
        });
        shuttle.add((Component)jLabel, (Object)"FromHeader");
        shuttle.add((Component)jLabel2, (Object)"ToHeader");
        return shuttle;
    }

    private void fixButtons() {
        if (this.toModel.size() <= 0) {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        } else {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        }
    }

    public void populateShuttle(List<BuildObject> list, List<BuildObject> list2) {
        int n;
        this.toList.removeListSelectionListener(this.toListListener);
        this.fromModel.removeAllElements();
        this.toModel.removeAllElements();
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                this.fromModel.add(n, list.get(n));
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                this.toModel.add(n, list2.get(n));
            }
        }
        this.toList.addListSelectionListener(this.toListListener);
    }

    public List<BuildObject> getSelected() {
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        for (int i = 0; i < this.toModel.getSize(); ++i) {
            arrayList.add((BuildObject)this.toModel.get(i));
        }
        return arrayList;
    }

    public List<BuildObject> getSelectableBuildObjects() {
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        for (int i = 0; i < this.fromModel.getSize(); ++i) {
            arrayList.add((BuildObject)this.fromModel.get(i));
        }
        return arrayList;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this.populateShuttle((List)traversableContext.get("AVAIL_BUILD_OBJECTS"), (List)traversableContext.get("BUILD_OBJECTS"));
        boolean bl = (Boolean)traversableContext.get("AUTOORDER");
        this.isAutoOrderOn.setSelected(bl);
        boolean bl2 = (Boolean)traversableContext.get("ADDDIM");
        this.isAutoAddDimOn.setSelected(bl2);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        List<String> list;
        ArrayList<BuildObject> arrayList = new ArrayList();
        List<Object> list2 = new ArrayList();
        arrayList = this.getSelected();
        list2 = this.getSelectableBuildObjects();
        traversableContext.put("BUILD_OBJECTS", arrayList);
        traversableContext.put("AVAIL_BUILD_OBJECTS", list2);
        traversableContext.put("AUTOORDER", (Object)this.isAutoOrderOn.isSelected());
        traversableContext.put("ADDDIM", (Object)this.isAutoAddDimOn.isSelected());
        boolean bl = this.isAtomicRefreshEnabled(arrayList);
        traversableContext.put("ENABLE_ATOMIC", (Object)new Boolean(bl));
        if (!bl) {
            traversableContext.put("ISATOMIC", (Object)new Boolean(false));
        }
        if ((list = this.getUnmapped(arrayList)).size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (String string : list) {
                stringBuffer.append(string);
                if (n < list.size()) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            String string = OLAPArb.format("BUILD_WIZARD_MAPPINGERROR", stringBuffer.toString());
            throw new TraversalException(string);
        }
        List<String> list3 = this.getUnbuiltDimsRequired(arrayList);
        if (list3.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            for (String string : list3) {
                stringBuffer.append(string);
                if (n < list3.size()) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            String string = OLAPArb.format("BUILD_WIZARD_PAGE_SELECT_OBJECTS_DIM_REBUILD_REQUIRED_ERROR", stringBuffer.toString());
            throw new TraversalException(string);
        }
    }

    private boolean isAtomicRefreshEnabled(List<BuildObject> list) {
        boolean bl = false;
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        ArrayList<BuildObject> arrayList2 = new ArrayList<BuildObject>();
        for (BuildObject buildObject : list) {
            if (buildObject.getType().equalsIgnoreCase("CUBE") && buildObject.isMVOn()) {
                arrayList2.add(buildObject);
            }
            if (!buildObject.getType().equalsIgnoreCase("CUBE DIMENSION") || !buildObject.isMVOn()) continue;
            arrayList.add(buildObject);
        }
        if (arrayList2.isEmpty() && arrayList.isEmpty()) {
            bl = true;
        }
        if (arrayList.size() == list.size() || arrayList2.size() == list.size() && list.size() == 1 && !this.isAutoAddDimOn.isSelected()) {
            bl = true;
        }
        if (arrayList2.size() == list.size() && list.size() > 1) {
            String string;
            Object object2 = "in (";
            int n = 1;
            Connection connection = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (BuildObject object3 : arrayList2) {
                string = object3.getName();
                if (n == arrayList2.size()) {
                    object2 = (String)object2 + ":cubename" + n + ")";
                    connection = object3.getConnection();
                } else {
                    object2 = (String)object2 + ":cubename" + n + ",";
                }
                hashMap.put("cubename" + n, string);
                ++n;
            }
            String string2 = "select name from user_dependencies where type = 'CUBE' and referenced_type = 'CUBE' and name " + (String)object2 + " and referenced_name not " + (String)object2;
            ArrayList<String> arrayList3 = new ArrayList<String>();
            string = "";
            DBUtil dBUtil = DBUtil.getInstance(connection);
            List list2 = dBUtil.executeReturnList(string2, hashMap);
            for (Map map : list2) {
                string = (String)map.get("NAME");
                string = string.toUpperCase();
                arrayList3.add(string);
            }
            if (arrayList3.isEmpty()) {
                bl = true;
            }
        }
        return bl;
    }

    private List<String> getUnmapped(List<BuildObject> list) throws TraversalException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Connection connection = null;
        String string = null;
        try {
            Object object;
            List<String> list2;
            List<Object> list3;
            HashMap<List<Object>, BuildObject> hashMap = new HashMap<List<Object>, BuildObject>();
            for (BuildObject object22 : list) {
                list3 = object22.getName();
                if (string == null) {
                    string = object22.getOwner();
                }
                if (connection == null) {
                    connection = object22.getConnection();
                }
                if (object22.getType().equalsIgnoreCase("CUBE")) {
                    arrayList2.add((String)((Object)list3));
                    hashMap.put(list3, object22);
                }
                if (!object22.getType().equalsIgnoreCase("CUBE DIMENSION")) continue;
                arrayList3.add((String)((Object)list3));
                hashMap.put(list3, object22);
            }
            DBUtil dBUtil = DBUtil.getInstance(connection);
            String string2 = dBUtil.getConnectionResolver().getConnectionName(connection);
            Schema schema = OLAPMetadataCache.getUpdatedSchema(string2, string);
            if (this.isAutoAddDimOn.isSelected()) {
                for (String string3 : arrayList2) {
                    list2 = schema.findCube(string3);
                    Iterator iterator = ((Cube)((Object)list2)).getDimensions();
                    Iterator<Dimension> iterator2 = iterator.iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        String string4 = ((NamedObject)object).getName();
                        if (arrayList3.contains(string4)) continue;
                        arrayList3.add(string4);
                    }
                }
            }
            list3 = new ArrayList();
            list3 = OLAPMetadataReader.getFullyMappedDimensions(dBUtil, string, arrayList3);
            ArrayList arrayList4 = new ArrayList();
            list2 = new ArrayList();
            List<String> list4 = OLAPMetadataReader.getCubesWithMeasuresMapped(dBUtil, string, arrayList2);
            list2 = OLAPMetadataReader.getCubesWithDimensionalityMapped(dBUtil, string, arrayList2);
            for (String string5 : arrayList3) {
                if (list3.contains(string5)) continue;
                arrayList.add(string5);
            }
            for (String string6 : arrayList2) {
                object = (BuildObject)hashMap.get(string6);
                if (!list4.contains(string6) && ((BuildObject)object).isMVOn()) {
                    arrayList.add(string6);
                    continue;
                }
                if (!list2.contains(string6) && ((BuildObject)object).isMVOn()) {
                    arrayList.add(string6);
                    continue;
                }
                int n = 0;
                for (String string7 : list2) {
                    if (!string7.equalsIgnoreCase(string6)) continue;
                    ++n;
                }
                Cube cube = schema.findCube(string6);
                List<Dimension> list5 = cube.getDimensions();
                if (list5.size() == n || !((BuildObject)object).isMVOn()) continue;
                arrayList.add(string6);
            }
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getMessage());
        }
        return arrayList;
    }

    private List<String> getUnbuiltDimsRequired(List<BuildObject> list) throws TraversalException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        String string = null;
        Connection connection = null;
        try {
            if (!this.isAutoAddDimOn.isSelected()) {
                for (BuildObject object2 : list) {
                    String string2 = object2.getName();
                    if (string == null) {
                        string = object2.getOwner();
                    }
                    if (connection == null) {
                        connection = object2.getConnection();
                    }
                    if (object2.getType().equalsIgnoreCase("CUBE")) {
                        arrayList2.add(string2);
                    }
                    if (!object2.getType().equalsIgnoreCase("CUBE DIMENSION")) continue;
                    arrayList3.add(string2);
                }
                DBUtil dBUtil = DBUtil.getInstance(connection);
                String string3 = dBUtil.getConnectionResolver().getConnectionName(connection);
                Schema schema = OLAPMetadataCache.getUpdatedSchema(string3, string);
                for (String string4 : arrayList2) {
                    Cube cube = schema.findCube(string4);
                    List<Dimension> list2 = cube.getDimensions();
                    for (Dimension dimension : list2) {
                        String string5 = dimension.getName();
                        if (arrayList3.contains(string5) || !dimension.isEmpty()) continue;
                        arrayList.add(string5);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getMessage());
        }
        return arrayList;
    }

    public Object getExitTransition() {
        return "METHODS";
    }
}

