/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.controls.listtable.ListTablePanel;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildObjectListTableModel;

public class BuildObjectsPanel
extends DefaultTraversablePanel {
    private ListTablePanel<BuildObject> _buildObjectTablePanel;
    private BuildObjectListTableModel _buildObjectTableModel;
    private List<BuildObject> _buildObjects = new ArrayList<BuildObject>();
    private TraversableContext m_ctx;

    public BuildObjectsPanel() {
        this._buildObjectTableModel = new BuildObjectListTableModel();
        this._buildObjectTablePanel = new ListTablePanel<BuildObject>((ListTableModel)this._buildObjectTableModel){

            protected void initTablePanel() {
                this.setLayout(new BorderLayout());
                this.add(this.getTableScrollPane(), "Center");
            }

            protected JTable newTable() {
                JTable jTable = new JTable(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Dimension getPreferredScrollableViewportSize() {
                        return super.getPreferredScrollableViewportSize();
                    }

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        String string = null;
                        Point point = mouseEvent.getPoint();
                        int n = this.rowAtPoint(point);
                        int n2 = this.columnAtPoint(point);
                        if (n2 == 0 || n2 == 1 || n2 == 4) {
                            string = (String)this.getValueAt(n, n2);
                            if (string != null && string.length() == 0) {
                                string = null;
                            }
                        } else if (n2 == 5) {
                            List list = BuildObjectsPanel.this._buildObjectTableModel.getRowList();
                            BuildObject buildObject = (BuildObject)list.get(n);
                            string = buildObject.getBuildSpecification();
                            if (string != null && string.length() == 0) {
                                string = null;
                            }
                        } else {
                            String string2;
                            string = n2 == 2 ? ((string2 = (String)this.getValueAt(n, n2)).equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL")) ? OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADSYNCH_TOOLTIP") : (string2.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL")) ? OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_TOOLTIP") : (string2.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL")) ? OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_TOOLTIP") : string2))) : super.getToolTipText(mouseEvent);
                        }
                        return string;
                    }
                };
                jTable.setName("ListTable");
                return jTable;
            }
        };
        this._buildObjectTablePanel.setEditable(true);
        JTable jTable = this._buildObjectTablePanel.getTable();
        jTable.setAutoResizeMode(4);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(new myLoadOptionsCellEditor());
        TableColumn tableColumn2 = tableColumnModel.getColumn(4);
        tableColumn2.setCellEditor(new myRefreshMethodsCellEditor());
        TableColumn tableColumn3 = tableColumnModel.getColumn(5);
        tableColumn3.setCellEditor(new myCubeScriptsCellEditor());
        this.setLayout(new GridBagLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("BUILD_WIZARD_REF_METHODS_INSTRUCTION_MSG"));
        this.add((Component)multiLineLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._buildObjectTablePanel, new GridBagConstraints(0, 1, 1, 4, 1.0, 0.9, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onExit(TraversableContext traversableContext) {
        List list = this._buildObjectTableModel.getRowList();
        traversableContext.put("BUILD_OBJECTS", (Object)list);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this._buildObjects = (List)this.m_ctx.get("BUILD_OBJECTS");
        this._buildObjectTableModel.setRowList(this._buildObjects);
    }

    public Object getExitTransition() {
        return "OPTS";
    }

    class myCubeScriptsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboScripts = new JComboBox();
        private String strCurrentScript;

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 1);
            List list = ((BuildObjectListTableModel)((Object)jTable.getModel())).getRowList();
            BuildObject buildObject = (BuildObject)list.get(n);
            List<Object> list2 = new ArrayList();
            try {
                list2 = buildObject.getCubeScriptNames();
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)OLAPArb.get("BUILD_WIZARD_ERROR_DLG_TITLE"), null);
            }
            this.cboScripts = new JComboBox();
            if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_LABEL"))) {
                for (String string2 : list2) {
                    this.cboScripts.addItem(string2);
                }
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBEMV_LABEL"))) {
                if (buildObject.isFastRefreshable() || buildObject.isMVRewriteEnabled()) {
                    this.cboScripts.addItem(buildObject.getDefaultBuildSpecificationName());
                } else {
                    for (String string3 : list2) {
                        this.cboScripts.addItem(string3);
                    }
                }
            }
            if (this.cboScripts != null && object != null) {
                this.cboScripts.setSelectedItem(object);
            }
            return this.cboScripts;
        }

        @Override
        public Object getCellEditorValue() {
            this.strCurrentScript = (String)this.cboScripts.getSelectedItem();
            return this.strCurrentScript;
        }
    }

    class myRefreshMethodsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboMethods = new JComboBox();
        private String strCurrentMethod = OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL");

        public myRefreshMethodsCellEditor() {
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 1);
            List list = ((BuildObjectListTableModel)((Object)jTable.getModel())).getRowList();
            BuildObject buildObject = (BuildObject)list.get(n);
            if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIM_LABEL")) || string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIMMV_LABEL"))) {
                this.cboMethods = new JComboBox();
                this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_LABEL"))) {
                this.cboMethods = new JComboBox();
                this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
                this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL"));
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBEMV_LABEL"))) {
                this.cboMethods = new JComboBox();
                if (buildObject.isFastRefreshable()) {
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL"));
                } else {
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL"));
                }
            }
            if (this.cboMethods != null && object != null) {
                this.cboMethods.setSelectedItem(object);
            }
            return this.cboMethods;
        }

        @Override
        public Object getCellEditorValue() {
            this.strCurrentMethod = (String)this.cboMethods.getSelectedItem();
            return this.strCurrentMethod;
        }
    }

    class myLoadOptionsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboOptions = new JComboBox();
        private String strCurrentOption = OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL");

        public myLoadOptionsCellEditor() {
            this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"));
            this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL"));
            this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 1);
            if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIMMV_LABEL"))) {
                this.cboOptions = new JComboBox();
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"));
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIM_LABEL"))) {
                this.cboOptions = new JComboBox();
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"));
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL"));
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL"));
            }
            if (this.cboOptions != null && object != null) {
                this.cboOptions.setSelectedItem(object);
            }
            return this.cboOptions;
        }

        @Override
        public Object getCellEditorValue() {
            this.strCurrentOption = (String)this.cboOptions.getSelectedItem();
            return this.strCurrentOption;
        }
    }
}

