/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.olap.OLAPArb;

public class BuildSchedulingPanel
extends DefaultTraversablePanel {
    private TraversableContext m_ctx;
    private MultiLineLabel multiLineLabelTop = new MultiLineLabel();
    private JRadioButton m_generateJobInQ;
    private JRadioButton m_generateJobInSession;
    private TitledPane titledPane1 = new TitledPane();
    private JLabel titledPane1Label = new JLabel();
    private DateEditor m_jobSchedulerDateEditor = new DateEditor();
    private JRadioButton m_runForegroundJobInQ;
    private JRadioButton m_runBackgroundJobInQ;
    private myNumberTextField m_proctextField = new myNumberTextField(2);
    private JLabel m_procLabel = new JLabel();
    private JButton m_browseDirButton = new JButton();
    private JLabel m_dirChooseLabel = new JLabel();
    private JTextField m_dirName = new JTextField(1024);

    public BuildSchedulingPanel() {
        this.initUI();
    }

    private void createDateEditor() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy H:mm:ss ");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        this.m_jobSchedulerDateEditor = new DateEditor(gregorianCalendar.getTime(), (Calendar)gregorianCalendar, (DateFormat)simpleDateFormat);
        this.m_jobSchedulerDateEditor.setMinimumDate(gregorianCalendar.getTime());
    }

    private void setEnabledJobQUI(boolean bl) {
        this.m_runForegroundJobInQ.setEnabled(bl);
        this.m_runBackgroundJobInQ.setEnabled(bl);
        this.m_jobSchedulerDateEditor.setEnabled(bl);
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.titledPane1Label.setText(OLAPArb.get("BUILD_WIZARD_SCHED_INSTRUCTION_MSG"));
        this.createDateEditor();
        String string = OLAPArb.get("BUILD_WIZARD_SCHED_RUN_NOW_LABEL");
        this.m_generateJobInSession = new JRadioButton(StringUtils.stripMnemonic((String)string), true);
        int n = StringUtils.getMnemonicIndex((String)string);
        this.m_generateJobInSession.setDisplayedMnemonicIndex(n);
        this.m_generateJobInSession.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_generateJobInSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BuildSchedulingPanel.this.m_generateJobInSession.isSelected()) {
                    BuildSchedulingPanel.this.m_runForegroundJobInQ.setEnabled(false);
                    BuildSchedulingPanel.this.m_runBackgroundJobInQ.setEnabled(false);
                    BuildSchedulingPanel.this.m_proctextField.setEnabled(true);
                }
                BuildSchedulingPanel.this.fixButtons();
            }
        });
        string = OLAPArb.get("BUILD_WIZARD_SCHED_RUN_IN_JOBQ_LABEL");
        this.m_generateJobInQ = new JRadioButton(StringUtils.stripMnemonic((String)string), false);
        n = StringUtils.getMnemonicIndex((String)string);
        this.m_generateJobInQ.setDisplayedMnemonicIndex(n);
        this.m_generateJobInQ.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_generateJobInQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BuildSchedulingPanel.this.m_generateJobInQ.isSelected()) {
                    BuildSchedulingPanel.this.setEnabledJobQUI(true);
                    BuildSchedulingPanel.this.m_runForegroundJobInQ.setSelected(true);
                    BuildSchedulingPanel.this.m_jobSchedulerDateEditor.setEnabled(false);
                } else {
                    BuildSchedulingPanel.this.setEnabledJobQUI(false);
                }
                BuildSchedulingPanel.this.fixButtons();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_generateJobInSession);
        buttonGroup.add(this.m_generateJobInQ);
        string = OLAPArb.get("BUILD_WIZARD_SCHED_RUN_IN_JOBQ_NOW_LABEL");
        this.m_runForegroundJobInQ = new JRadioButton(StringUtils.stripMnemonic((String)string), false);
        n = StringUtils.getMnemonicIndex((String)string);
        this.m_runForegroundJobInQ.setDisplayedMnemonicIndex(n);
        this.m_runForegroundJobInQ.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_runForegroundJobInQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BuildSchedulingPanel.this.m_runForegroundJobInQ.isSelected()) {
                    BuildSchedulingPanel.this.m_jobSchedulerDateEditor.setEnabled(false);
                }
            }
        });
        string = OLAPArb.get("BUILD_WIZARD_SCHED_RUN_IN_JOBQ_LATER_LABEL");
        this.m_runBackgroundJobInQ = new JRadioButton(StringUtils.stripMnemonic((String)string), true);
        n = StringUtils.getMnemonicIndex((String)string);
        this.m_runBackgroundJobInQ.setDisplayedMnemonicIndex(n);
        this.m_runBackgroundJobInQ.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_runBackgroundJobInQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BuildSchedulingPanel.this.m_runBackgroundJobInQ.isSelected()) {
                    BuildSchedulingPanel.this.m_jobSchedulerDateEditor.setEnabled(true);
                }
            }
        });
        string = OLAPArb.get("BUILD_WIZARD_SCHED_MAX_PROC_NUM_LABEL");
        this.m_procLabel.setText(StringUtils.stripMnemonic((String)string));
        n = StringUtils.getMnemonicIndex((String)string);
        this.m_procLabel.setDisplayedMnemonicIndex(n);
        this.m_procLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_proctextField.setMaximumLength(2);
        this.m_procLabel.setLabelFor(this.m_proctextField);
        string = OLAPArb.get("BUILD_WIZARD_SCHED_FILE_NAME_LABEL");
        this.m_dirChooseLabel.setText(StringUtils.stripMnemonic((String)string));
        n = StringUtils.getMnemonicIndex((String)string);
        this.m_dirChooseLabel.setDisplayedMnemonicIndex(n);
        this.m_dirChooseLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_dirChooseLabel.setLabelFor(this.m_dirName);
        this.m_browseDirButton.setText("...");
        this.titledPane1.setTitle((Component)this.titledPane1Label);
        this.multiLineLabelTop.setTextWrapper(WordWrapper.getTextWrapper());
        this.multiLineLabelTop.setText(OLAPArb.get("BUILD_WIZARD_SCHED_INSTRUCTION_MSG"));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_runForegroundJobInQ);
        buttonGroup.add(this.m_runBackgroundJobInQ);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.multiLineLabelTop, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.m_generateJobInSession, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.m_generateJobInQ, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)this.m_runForegroundJobInQ, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)this.m_runBackgroundJobInQ, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        string = OLAPArb.get("BUILD_WIZARD_SCHED_DATE_TIME_LABEL");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        n = StringUtils.getMnemonicIndex((String)string);
        jLabel.setDisplayedMnemonicIndex(n);
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.m_jobSchedulerDateEditor.setMinimumSize(new Dimension(300, 20));
        jPanel.add((Component)this.m_jobSchedulerDateEditor, gridBagConstraints);
        jLabel.setLabelFor((Component)this.m_jobSchedulerDateEditor);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        jPanel.add((Component)this.m_procLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.m_proctextField, gridBagConstraints);
        this.m_proctextField.setMinimumSize(new Dimension(30, 20));
        this.initialSettings();
    }

    private void initialSettings() {
        this.m_generateJobInSession.setSelected(true);
        this.m_generateJobInQ.setSelected(false);
        this.m_runBackgroundJobInQ.setEnabled(false);
        this.m_runForegroundJobInQ.setEnabled(false);
        this.m_jobSchedulerDateEditor.setEnabled(false);
        this.m_proctextField.setEnabled(true);
        this.m_dirName.setEnabled(false);
        this.m_browseDirButton.setEnabled(false);
    }

    private void fixButtons() {
        if (!this.m_generateJobInSession.isSelected() && !this.m_generateJobInQ.isSelected()) {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        } else {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        }
    }

    public void setProcField(boolean bl) {
        if (this.m_generateJobInQ.isSelected() && bl) {
            this.m_proctextField.setEnabled(true);
        } else {
            this.m_proctextField.setText("1");
            this.m_proctextField.setEnabled(false);
        }
    }

    public int getNumberOfProcesses() {
        if (this.m_proctextField.getText().length() == 0) {
            return 0;
        }
        String string = this.m_proctextField.getText();
        return Integer.valueOf(string);
    }

    public String getSQLFileName() {
        String string = this.m_dirName.getText();
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        int n = (Integer)traversableContext.get("PARALLEL_PROC_NUM");
        boolean bl = (Boolean)traversableContext.get("RUNNOW");
        boolean bl2 = (Boolean)traversableContext.get("RUN_IN_JOBQ");
        boolean bl3 = (Boolean)traversableContext.get("RUN_IN_JOBQ_NOW");
        this.m_proctextField.setText(Integer.toString(n));
        if (bl) {
            this.m_generateJobInSession.setSelected(bl);
        } else {
            this.m_generateJobInQ.setSelected(bl2 || bl3);
            if (bl2) {
                this.m_runBackgroundJobInQ.setSelected(bl2);
            } else {
                this.m_runForegroundJobInQ.setSelected(true);
            }
        }
        this.fixButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Integer n = this.getNumberOfProcesses();
        Boolean bl = this.m_generateJobInSession.isSelected();
        Boolean bl2 = !this.m_generateJobInSession.isSelected() && this.m_runBackgroundJobInQ.isEnabled() && this.m_runBackgroundJobInQ.isSelected();
        Boolean bl3 = !this.m_generateJobInSession.isSelected() && this.m_runForegroundJobInQ.isEnabled() && this.m_runForegroundJobInQ.isSelected();
        traversableContext.put("PARALLEL_PROC_NUM", (Object)n);
        traversableContext.put("RUNNOW", (Object)bl);
        traversableContext.put("RUN_IN_JOBQ", (Object)bl2);
        traversableContext.put("RUN_IN_JOBQ_NOW", (Object)bl3);
        traversableContext.put("JOBQ_SCHED_TIME", (Object)this.m_jobSchedulerDateEditor.getCalendar());
        traversableContext.put("SQL_FILENAME", null);
    }

    public Object getExitTransition() {
        return "SUMMARY";
    }

    class myNumberTextField
    extends JTextField {
        private int m_maxlen;

        public myNumberTextField(int n) {
            super(n);
            this.m_maxlen = Integer.toString(Integer.MAX_VALUE).length();
        }

        public void setMaximumLength(int n) {
            this.m_maxlen = n;
        }

        @Override
        protected Document createDefaultModel() {
            return new RestrictedDocument();
        }

        class RestrictedDocument
        extends PlainDocument {
            RestrictedDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null) {
                    char[] cArray = new char[string.length()];
                    int n2 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        if (!Character.isDigit(string.charAt(i))) continue;
                        cArray[n2++] = string.charAt(i);
                    }
                    string = new String(cArray, 0, n2);
                    if (this.getLength() + string.length() <= myNumberTextField.this.m_maxlen) {
                        super.insertString(n, string, attributeSet);
                    }
                }
            }
        }
    }
}

