/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.build.BuildObject;
import oracle.olap.build.OLAPBuildRun;
import oracle.olap.build.wizard.BuildObjectShuttlePanel;
import oracle.olap.build.wizard.BuildObjectsPanel;
import oracle.olap.build.wizard.BuildOptionsPanel;
import oracle.olap.build.wizard.BuildSchedulingPanel;
import oracle.olap.build.wizard.BuildSummaryPanel;
import oracle.olap.preferences.OLAPBuildLogPreferenceSettings;

public class BuildWizMain {
    static final String STATE_SCHED = "StateSched";
    static final String TRANSITION_SCHED = "SCHED";
    static final String STATE_OPTS = "StateOpts";
    static final String TRANSITION_OPTS = "OPTS";
    static final String STATE_METHODS = "StateMethods";
    static final String TRANSITION_METHODS = "METHODS";
    static final String STATE_SUMMARY = "StateSummary";
    static final String TRANSITION_SUMMARY = "SUMMARY";
    public static final String KEY_BUILD_OBJECTS = "BUILD_OBJECTS";
    static final String KEY_AVAILABLE_BUILD_OBJECTS = "AVAIL_BUILD_OBJECTS";
    public static final String KEY_ENABLE_ATOMIC_REFRESH_OPTION = "ENABLE_ATOMIC";
    public static final String KEY_IS_ATOMIC_REFRESH = "ISATOMIC";
    public static final String KEY_AUTO_ADD_DIM_ON = "ADDDIM";
    public static final String KEY_AUTO_ORDER = "AUTOORDER";
    public static final String KEY_REFRESH_AFTER_ERROR = "REFRESH_AFTER_ERROR";
    public static final String KEY_RUN_IN_SESSION = "RUNNOW";
    public static final String KEY_RUN_IN_JOBQ = "RUN_IN_JOBQ";
    public static final String KEY_RUN_IN_JOBQ_NOW = "RUN_IN_JOBQ_NOW";
    public static final String KEY_JOBQ_SCHED_TIME = "JOBQ_SCHED_TIME";
    public static final String KEY_SQL_FILENAME = "SQL_FILENAME";
    public static final String KEY_PARALLEL_PROC_NUM = "PARALLEL_PROC_NUM";
    public static final String KEY_BUILD_LOG_LEVEL = "BUILD_LOG_LEVEL";
    public static final String KEY_BUILD_LOG_MAX_ERRORS = "BUILD_LOG_MAX_ERRORS";
    private static Preferences _p = Preferences.getPreferences();
    private OLAPBuildLogPreferenceSettings buildLogSettings = OLAPBuildLogPreferenceSettings.getInstance((PropertyStorage)_p);
    protected boolean isAutoAddDimOn = true;
    protected boolean isAutoOrderOn = true;
    private static BuildWizMain INSTANCE;
    private static final Logger LOGGER;
    private WizardDialog wizDialog = null;
    private Namespace initialData = null;
    private Schema schema;

    protected BuildWizMain() {
    }

    public static BuildWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BuildWizMain();
        }
        return INSTANCE;
    }

    public void launchWizard(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getSchemaName();
        final Connection connection2 = connection;
        final String string2 = string;
        final DBObject dBObject2 = dBObject;
        String string3 = OLAPArb.get("BUILD_WIZARD_DLG_TITLE");
        RaptorTask raptorTask = new RaptorTask(string3, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    String string;
                    Object object;
                    Object object2;
                    Object object3;
                    FSM fSM = BuildWizMain.this.getFSM();
                    BuildWizMain.this.initialData = new Namespace();
                    this.setMessage(OLAPArb.get("BUILD_WIZARD_LOADING_BUILD_OBJECTS_MSG"));
                    List list = BuildWizMain.this.getBuildObjects(dBObject2);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    String string22 = null;
                    if (!dBObject2.getObjectType().equalsIgnoreCase("OLAPAW")) {
                        Object object42;
                        object3 = BuildWizMain.this.schema.getCubes();
                        Object object5 = object3.iterator();
                        while (object5.hasNext()) {
                            object2 = object5.next();
                            object = ((NamedObject)object2).getName();
                            string = ((Cube)object2).getAWName();
                            boolean bl2 = false;
                            for (Object object42 : list) {
                                if (((BuildObject)object42).getName().equalsIgnoreCase((String)object)) {
                                    bl2 = true;
                                }
                                if (string22 != null) continue;
                                string22 = ((BuildObject)object42).getAWName();
                            }
                            if (bl2) continue;
                            Object object6 = "";
                            object6 = "CUBE";
                            if (string22 == null || string == null || !string.equalsIgnoreCase(string22)) continue;
                            object42 = new BuildObject(connection2, string2, (String)object, (String)object6);
                            ((BuildObject)object42).setAWName(string22);
                            arrayList.add(object42);
                        }
                        object5 = BuildWizMain.this.schema.getDimensions();
                        object2 = object5.iterator();
                        while (object2.hasNext()) {
                            BuildObject buildObject2;
                            object = (oracle.olap.app.olapmetadata.Dimension)object2.next();
                            string = ((NamedObject)object).getName();
                            String string3 = ((oracle.olap.app.olapmetadata.Dimension)object).getAWName();
                            boolean bl3 = false;
                            for (BuildObject buildObject2 : list) {
                                if (buildObject2.getName().equalsIgnoreCase(string)) {
                                    bl3 = true;
                                }
                                if (string22 != null) continue;
                                string22 = buildObject2.getAWName();
                            }
                            if (bl3) continue;
                            object42 = "";
                            object42 = "CUBE DIMENSION";
                            if (string22 == null || string3 == null || !string3.equalsIgnoreCase(string22)) continue;
                            buildObject2 = new BuildObject(connection2, string2, string, (String)object42);
                            buildObject2.setAWName(string22);
                            arrayList.add(buildObject2);
                        }
                    }
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_AVAILABLE_BUILD_OBJECTS, arrayList);
                    if (list == null) {
                        BuildWizMain.this.initialData.put(BuildWizMain.KEY_BUILD_OBJECTS, new ArrayList());
                    } else {
                        BuildWizMain.this.initialData.put(BuildWizMain.KEY_BUILD_OBJECTS, (Object)list);
                    }
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_AUTO_ADD_DIM_ON, (Object)BuildWizMain.this.isAutoAddDimOn);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_AUTO_ORDER, (Object)BuildWizMain.this.isAutoOrderOn);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_ENABLE_ATOMIC_REFRESH_OPTION, (Object)true);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_IS_ATOMIC_REFRESH, (Object)true);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_REFRESH_AFTER_ERROR, (Object)false);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_RUN_IN_SESSION, (Object)true);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_RUN_IN_JOBQ, (Object)false);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_RUN_IN_JOBQ_NOW, (Object)false);
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_PARALLEL_PROC_NUM, (Object)0);
                    object3 = BuildWizMain.this.buildLogSettings.getLogLevel();
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_BUILD_LOG_LEVEL, object3);
                    int n = BuildWizMain.this.buildLogSettings.getMaxErrorsLogged();
                    BuildWizMain.this.initialData.put(BuildWizMain.KEY_BUILD_LOG_MAX_ERRORS, (Object)n);
                    this.setMessage(OLAPArb.get("BUILD_WIZARD_INITIALIZING_MSG"));
                    object2 = new FSMWizard(fSM, BuildWizMain.this.initialData);
                    object = OLAPArb.get("BUILD_WIZARD_DLG_TITLE");
                    string = dBObject2.getObjectName();
                    object = MessageFormat.format(OLAPArb.get("BUILD_PROGRESSBAR_TITLE"), string);
                    object2.setWizardTitle((String)object);
                    object2.setRoadmapVisible(true);
                    BuildWizMain.this.wizDialog = object2.getDialog((Frame)Ide.getMainWindow());
                    Dimension dimension = object2.getPreferredSize();
                    int n2 = (int)dimension.getHeight() + 500;
                    int n3 = (int)dimension.getWidth() + 500;
                    BuildWizMain.this.wizDialog.setSize(n3, n2);
                    BuildWizMain.this.wizDialog.setPreferredSize(new Dimension(n3, n2));
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string3);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String string = RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable());
                        LOGGER.warning(string);
                        BuildWizMain.this.showErrorDialog(string);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (WizardLauncher.runDialog((JDialog)BuildWizMain.this.wizDialog)) {
                                OLAPBuildRun oLAPBuildRun = new OLAPBuildRun(connection2, string2, BuildWizMain.this.initialData);
                                oLAPBuildRun.runBuild();
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            String string = exception.getLocalizedMessage();
                            if (string == null || string.length() == 0) {
                                string = exception.getClass().toString();
                            }
                            BuildWizMain.this.showErrorDialog(string);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    protected FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(OLAPArb.get("BUILD_WIZARD_SEL_OBJ_STEP_TITLE"), BuildObjectShuttlePanel.class, "olap_build_select_objects");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_METHODS, (Object)STATE_METHODS);
        Step step2 = new Step(OLAPArb.get("BUILD_WIZARD_REF_METHODS_STEP_TITLE"), BuildObjectsPanel.class, "olap_build_data_refresh_methods");
        fSMBuilder.newState((Object)STATE_METHODS, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_OPTS, (Object)STATE_OPTS);
        Step step3 = new Step(OLAPArb.get("BUILD_WIZARD_PROC_OPTS_STEP_TITLE"), BuildOptionsPanel.class, "olap_build_processing_options");
        fSMBuilder.newState((Object)STATE_OPTS, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_SCHED, (Object)STATE_SCHED);
        Step step4 = new Step(OLAPArb.get("BUILD_WIZARD_SCHED_STEP_TITLE"), BuildSchedulingPanel.class, "olap_build_scheduling");
        fSMBuilder.newState((Object)STATE_SCHED, step4, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_SUMMARY, (Object)STATE_SUMMARY);
        Step step5 = new Step("Summary", BuildSummaryPanel.class, "olap_build_summary");
        fSMBuilder.newFinalState((Object)STATE_SUMMARY, step5);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private void showErrorDialog(String string) {
        String string2 = OLAPArb.get("BUILD_ERROR_DLG_TITLE");
        String string3 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
    }

    private List<BuildObject> getBuildObjects(DBObject dBObject) throws Exception {
        ArrayList<BuildObject> arrayList = new ArrayList<BuildObject>();
        BuildObject buildObject = null;
        Connection connection = dBObject.getConnection();
        String string = dBObject.getConnectionName();
        String string2 = dBObject.getSchemaName();
        String string3 = dBObject.getObjectName();
        String string4 = dBObject.getObjectType();
        this.schema = OLAPMetadataCache.getUpdatedSchema(string, string2);
        if (!string4.equalsIgnoreCase("OLAPAW")) {
            buildObject = new BuildObject(connection, string2, string3, string4);
            arrayList.add(buildObject);
        } else {
            Object object;
            List<Cube> list = this.schema.getCubes();
            for (Cube object22 : list) {
                if (!object22.getAWName().equalsIgnoreCase(string3)) continue;
                object = new BuildObject(connection, string2, object22.getName(), "CUBE");
                ((BuildObject)object).setAWName(string3);
                arrayList.add((BuildObject)object);
            }
            List<oracle.olap.app.olapmetadata.Dimension> list2 = this.schema.getDimensions();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (oracle.olap.app.olapmetadata.Dimension)iterator.next();
                if (!((oracle.olap.app.olapmetadata.Dimension)object).getAWName().equalsIgnoreCase(string3)) continue;
                BuildObject buildObject2 = new BuildObject(connection, string2, ((NamedObject)object).getName(), "CUBE DIMENSION");
                buildObject2.setAWName(string3);
                arrayList.add(buildObject2);
            }
        }
        return arrayList;
    }

    static {
        LOGGER = Logger.getLogger(BuildWizMain.class.getName());
    }
}

