/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildspec;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperFactoryImpl;
import oracle.olap.buildspec.BuildSpecInsertionHandlerHelper;
import oracle.olap.buildspec.BuildSpecSyntaxParser;
import oracle.olap.cube.model.Cube;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPSpec;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;

public class BuildSpecBuilder {
    private Cube cube;
    private SyntaxBuilderPanel builder;
    private Properties props;
    private boolean initialized;
    private TemplateHelperFactoryImpl thf;
    private BuildSpecSyntaxParser parser;
    private OLAPSpec specParser;
    private Schema schema = null;

    public SyntaxBuilderPanel createBuilder() throws SQLException, IOException {
        this.props = new Properties();
        this.props.setProperty("SHOW_LEAVES", Boolean.toString(false));
        this.props.setProperty("CONTEXT", "BUILDSPEC");
        this.props.setProperty("VISIBLE_SYNTAXSPEC", Boolean.toString(false));
        this.props.setProperty("VISIBLE_DOCS", Boolean.toString(false));
        this.props.setProperty("CENTER_DIVIDER_POSITION", "70");
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(BuildSpecBuilder.class.getResourceAsStream("buildspec.xml"), "UTF-8");
            this.parser = new BuildSpecSyntaxParser(null, this.props);
            OLAPResources oLAPResources = new OLAPResources("/oracle/olap/app/calcfactory/ui/calcs.xml");
            OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
            this.thf = new TemplateHelperFactoryImpl(this.props, null, null, this.parser, oLAPResources, oLAPFetchIcon);
            this.specParser = new OLAPSpec(this.props, inputStreamReader, this.parser, this.thf, new OLAPErrorDisplay(), oLAPResources, oLAPFetchIcon, null);
            BuildSpecInsertionHandlerHelper buildSpecInsertionHandlerHelper = new BuildSpecInsertionHandlerHelper();
            this.builder = SyntaxBuilderLauncher.createPanelForCube(this.props, null, null, null, null, this.parser, this.thf, this.specParser, null, buildSpecInsertionHandlerHelper);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            oLAPErrorDisplay.show(unsupportedEncodingException, OLAPArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), OLAPArb.getString("EXPRESSIONBUILDER_SPEC_ERROR_MESSAGE"), (Component)Ide.getMainWindow());
        }
        return this.builder;
    }

    public SyntaxBuilderPanel initialize(Connection connection, Cube cube, Object object) {
        if (this.initialized) {
            return this.builder;
        }
        this.cube = cube;
        if (cube != null) {
            Object object2;
            if (this.props.containsKey("CUBE") && this.schema != null && (object2 = this.schema.findCube(this.props.getProperty("CUBE"))) != null && !((NamedObject)object2).getName().equals(cube.getName())) {
                this.schema.getCubes().remove(object2);
            }
            this.props.setProperty("CUBE", cube.getName());
            this.props.setProperty("AW", cube.getAnalyticWorkspace());
            this.props.setProperty("SCHEMA", cube.getSchema().getName());
            object2 = new DatabaseImpl();
            object2.setConnection(connection);
            this.schema = SyntaxBuilderLauncher.populateCube(this.schema, this.props, cube, object);
            this.specParser.setConn(connection);
            this.parser.setSchema(this.schema);
            this.thf.setSchema(this.schema);
            this.thf.setProperty("CUBE", cube.getName());
            this.thf.setDatabase((Database)object2);
        }
        this.builder.initialize();
        return this.builder;
    }
}

