/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildspec;

import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseException;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxVisitor;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olapi.syntax.BuildSpecification;
import oracle.olapi.syntax.SyntaxObject;

public class BuildSpecSyntaxParser
extends OLAPISyntaxParser {
    private static final int DUMMY_OFFSET = 22;
    private static final String WRAPPER = "BUILD SPEC DUMMYNAME (%s)";
    private String unwrappedSyntax;

    public BuildSpecSyntaxParser(Schema schema, Properties properties) {
        super(schema, properties);
        this.visitor = new SyntaxVisitor(){

            @Override
            public void processToken(String string, String string2, int n) {
                super.processToken(string, string2, n + 22);
            }
        };
    }

    @Override
    public String formatSyntax(String string) {
        String string2 = null;
        string2 = string == null ? this.syntax : String.format(WRAPPER, string);
        try {
            BuildSpecification buildSpecification = (BuildSpecification)SyntaxObject.fromSyntax((String)string2, null);
            string2 = buildSpecification.toSyntax();
            Pattern pattern = Pattern.compile("^  ", 10);
            int n = string2.indexOf(40) + 2;
            int n2 = string2.lastIndexOf(41) - 1;
            string2 = string2.substring(n, n2);
            Matcher matcher = pattern.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "");
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    @Override
    public void setSyntax(String string) {
        if (string == null) {
            super.setSyntax("");
        } else {
            String string2 = string.toUpperCase();
            String string3 = String.format(WRAPPER, string2);
            super.setSyntax(string3);
            this.unwrappedSyntax = string;
        }
    }

    @Override
    public int[] getTokenBoundaries(int n) {
        int[] nArray = super.getTokenBoundaries(n + 22);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] - 22;
        }
        return nArray2;
    }

    @Override
    public ParseNode getParseNode(int n, int n2) {
        return super.getParseNode(n, n2, this.unwrappedSyntax);
    }

    @Override
    protected void notifyTokenCallback(SyntaxTokenListener syntaxTokenListener, String string, Type type, int n) {
        super.notifyTokenCallback(syntaxTokenListener, string, type, n - 22);
    }

    @Override
    public boolean parseSyntax(ParseNode parseNode) {
        boolean bl;
        if (parseNode == null) {
            parseNode = new ParseNode();
        }
        if (bl = super.parseSyntax(parseNode)) {
            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                ParseNode serializable = (ParseNode)enumeration.nextElement();
                serializable.setOffset(serializable.getOffset() - 22);
                serializable.setEnd(serializable.getEnd() - 22);
                serializable.setReplaceBounds(serializable.getReplaceOffset() - 22, serializable.getReplaceEnd() - 22, this.unwrappedSyntax);
            }
        }
        for (Throwable throwable : this.getExceptions()) {
            if (!(throwable instanceof ParseException)) continue;
            ParseException parseException = (ParseException)throwable;
            parseException.setOffset(parseException.getOffset() - 22);
        }
        return bl;
    }

    @Override
    public boolean parseSyntax(String string, ParseNode parseNode) {
        String string2 = this.unwrappedSyntax;
        this.unwrappedSyntax = string;
        boolean bl = super.parseSyntax(String.format(WRAPPER, string), parseNode);
        this.unwrappedSyntax = string2;
        return bl;
    }

    @Override
    public String getSyntax() {
        return this.unwrappedSyntax;
    }
}

