/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubexml.CubeXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.SyntaxObject;

public class CubeBuilder
extends AbstractOLAPDBObjectBuilder<Cube> {
    public CubeBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "CUBE");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public Cube createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Cube cube = new Cube();
        cube.setName(string);
        cube.setSchema(schema);
        cube.setID(dBObjectID);
        return cube;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "analyticWorkspace", "consistentSolveSpec"})
    public void buildProperties(final Cube cube) throws DBException {
        String string = "select aw_name, description, consistent_solve_spec  from all_cubes where cube_name = ? and owner = ?";
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), string, new Object[]{cube.getName(), cube.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString("aw_name");
                        String string2 = resultSet.getString("description");
                        String string3 = resultSet.getString("consistent_solve_spec");
                        cube.setDescription(string2);
                        cube.setAnalyticWorkspace(string);
                        if (string3 != null) {
                            ConsistentSolveSpecification consistentSolveSpecification = (ConsistentSolveSpecification)SyntaxObject.fromSyntax((String)string3, null);
                            string3 = consistentSolveSpecification.toSyntax(cube.getSchema().getName());
                            cube.setConsistentSolveSpec(string3);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"shortDescription", "longDescription", "defaultBuildSpecifications", "buildSpecifications", "measures", "calculatedMeasures", "dimensions", "dimensionNames", "partitionDimension", "partitionHierarchy", "partitionLevel"})
    public void buildDetails(Cube cube) throws DBException, SQLException, IOException, JAXBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.build(cube);
        String string = cube.getSchema().getName();
        String string2 = String.format("%s.%s", string, cube.getName());
        Object object = this.getObject(oracleDatabaseImpl.getConnection(), string2);
        MetadataContext metadataContext = new MetadataContext(this.getProvider());
        CubeXML cubeXML = new CubeXML(metadataContext, object, cube);
        cubeXML.loadModel();
        cube.setFullyLoaded(true);
    }

    public void build(final Cube cube) throws DBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        cube.removeAllDimensions();
        cube.removeAllMeasures();
        cube.removeAllCalculatedMeasures();
        cube.removeAllPartitions();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "SELECT dty.dimension_name, dimension_type\nFROM all_cube_dimensionality dty, all_cube_dimensions dims\nWHERE cube_name = ?\nAND dty.owner       = ?\nand dty.owner = dims.owner and dty.dimension_name = dims.dimension_name\nORDER BY order_num", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select measure_name, data_type  || DECODE(data_type, 'CHAR', '('  || data_length  ||')', 'VARCHAR', '('  || data_length  ||')', 'VARCHAR2', '('  || data_length  ||')', 'NCHAR', '('  || data_length  ||')', 'NVARCHAR', '('  || data_length  ||')', 'NVARCHAR2', '('  || data_length  ||')', 'NUMBER', '('  || NVL(data_precision,data_length)  || DECODE(data_scale,NULL,NULL, ','  ||data_scale)  ||')', NULL) data_type from all_cube_measures  where cube_name = ? and owner = ? and measure_type = 'BASE' order by measure_name", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select measure_name, to_char(expression) from all_cube_measures where cube_name = ? and owner = ? and measure_type = 'DERIVED' and nvl(length(expression), 0) < 2000 order by measure_name", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select measure_name, expression from all_cube_measures where cube_name = ? and owner = ? and measure_type = 'DERIVED' and nvl(length(expression), 0) >= 2000 order by measure_name", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select distinct mviews.owner, cube_name, rewrite_enabled, refresh_method, fast_refreshable, last_refresh_type  from all_cubes ch, all_mviews mviews  where ch.owner = ? and cube_name = ? and  (ch.rewrite_mview_name=mviews.mview_name or ch.refresh_mview_name = mviews.mview_name)", new Object[]{cube.getSchema(), cube.getName()});
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = CubeDimensionBuilder.getRootDataType(string2);
                        CubeMeasure cubeMeasure = new CubeMeasure(string);
                        cube.addMeasure(cubeMeasure);
                        cubeMeasure.setDataType(string3);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeCalculatedMeasure cubeCalculatedMeasure = new CubeCalculatedMeasure(string);
                        cube.addCalculatedMeasure(cubeCalculatedMeasure);
                        cubeCalculatedMeasure.setMeasureExpression(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper3.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeCalculatedMeasure cubeCalculatedMeasure = new CubeCalculatedMeasure(string);
                        cube.addCalculatedMeasure(cubeCalculatedMeasure);
                        cubeCalculatedMeasure.setMeasureExpression(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper4.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    int n = 1;
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeDimensionality cubeDimensionality = new CubeDimensionality();
                        cubeDimensionality.setName(string);
                        cubeDimensionality.setPhysicalOrder(n++);
                        cube.addDimensionality(cubeDimensionality);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        String string = "select partition_dimension_name, partition_hierarchy_name, partition_level_name, precompute_percent  from all_cubes where cube_name = ? and owner = ?";
        final QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), string, new Object[]{cube.getName(), cube.getSchema()});
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString("partition_dimension_name");
                        String string2 = resultSet.getString("partition_hierarchy_name");
                        String string3 = resultSet.getString("partition_level_name");
                        BigDecimal bigDecimal = resultSet.getBigDecimal("precompute_percent");
                        if (string != null && string.trim().length() > 0) {
                            CubePartition cubePartition = new CubePartition();
                            String string4 = String.format("%s_%s", string2, string3);
                            cubePartition.setName(string4);
                            cubePartition.setPartitionDimension(string);
                            cubePartition.setPartitionHierarchy(string2);
                            cubePartition.setPartitionLevel(string3);
                            if (bigDecimal != null) {
                                cubePartition.setPrecomputePercent(bigDecimal.intValue());
                            } else {
                                cubePartition.setPrecomputePercent(0);
                            }
                            cube.addPartition(cubePartition);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper6.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        cube.setCubeMVEnabled(true);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper5.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
    }
}

