/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube;

import java.util.ArrayList;
import java.util.Properties;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olapi.syntax.SyntaxObject;

public class CubeValidator
extends SchemaObjectValidator<Cube> {
    public CubeValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObjectProperty(Cube cube, Cube cube2, String string) throws ValidationException {
        if (cube2.isSkipValidation()) {
            return;
        }
        if (string.equalsIgnoreCase("analyticWorkspace")) {
            return;
        }
        if (string.equalsIgnoreCase("partitionDimension")) {
            return;
        }
        if (string.equalsIgnoreCase("partitionHierarchy")) {
            return;
        }
        if (string.equalsIgnoreCase("partitionLevel")) {
            return;
        }
        if (string.toLowerCase().indexOf("description") != -1) {
            return;
        }
        super.validateObjectProperty((DBObject)cube, (DBObject)cube2, string);
    }

    @DBObjectValidator.PropertyValidator(value={"calculatedMeasures"})
    public void validateCalculatedMeasures(Cube cube, Cube cube2) throws ValidationException {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        databaseImpl.setConnection(oracleDatabaseImpl.getConnection());
        Properties properties = new Properties();
    }

    @DBObjectValidator.PropertyValidator(value={"measures"})
    public void validateMeasures(Cube cube, Cube cube2) throws ValidationException {
        int n = cube2.getMeasures().length;
        if (n == 0) {
            throw new ValidationException((DBObject)cube2, OLAPArb.get("CUBE.VALIDATE.MEASURES.ERROR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"dimensions"})
    public void validateDimensions(Cube cube, Cube cube2) throws ValidationException {
        int n = cube2.getDimensions().length;
        if (n == 0) {
            throw new ValidationException((DBObject)cube2, OLAPArb.get("CUBE.VALIDATE.DIMENSIONS.ERROR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"buildSpecifications"})
    public void validateBuildSpecifications(Cube cube, Cube cube2) throws ValidationException {
        boolean bl = cube2.isMVOn();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CubeBuildSpecification cubeBuildSpecification : cube2.getBuildSpecifications()) {
            String string = cubeBuildSpecification.getName();
            boolean bl2 = cubeBuildSpecification.isDefault();
            DBObjectProvider dBObjectProvider = this.getProvider();
            try {
                dBObjectProvider.validateName("BUILDSPECIFICATION", string);
            }
            catch (InvalidNameException invalidNameException) {
                String string2 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NAME_ERROR", string);
                string2 = string2 + "  " + invalidNameException.getMessage();
                throw new ValidationException((DBObject)cube2, string2);
            }
            if (arrayList.contains(string)) {
                throw new ValidationException((DBObject)cube2, OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_DUPLICATE_NAME_ERROR", string));
            }
            arrayList.add(string);
            if (bl2 && bl && !string.equalsIgnoreCase("SYS_DEFAULT")) {
                throw new ValidationException((DBObject)cube2, OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_DEFAULT_NAME_ERROR", string));
            }
            CubeBuildCommand[] cubeBuildCommandArray = cubeBuildSpecification.getBuildCommands();
            int n = cubeBuildCommandArray.length;
            if (n == 0) {
                throw new ValidationException((DBObject)cube2, OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NO_COMMAND_ERROR", string));
            }
            for (int i = 0; i < n; ++i) {
                String string3;
                CubeBuildCommand cubeBuildCommand = cubeBuildCommandArray[i];
                String string4 = cubeBuildCommand.getType();
                if (!string4.equalsIgnoreCase("OLAP DML") && !string4.equalsIgnoreCase("PLSQL") || ((string3 = cubeBuildCommand.getExpression()) == null || string3.trim().length() != 0) && string3 != null) continue;
                if (string4.equalsIgnoreCase("OLAP DML")) {
                    throw new ValidationException((DBObject)cube2, OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_OLAPDML_COMMAND_ERROR", string));
                }
                throw new ValidationException((DBObject)cube2, OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_PLSQL_COMMAND_ERROR", string));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"mapWhereClause"})
    public void validateWhereClause(Cube cube, Cube cube2) throws ValidationException {
        String string = cube2.getMapWhereClause();
        if (string != null) {
            try {
                SyntaxObject.fromSyntax((String)string, null);
            }
            catch (Throwable throwable) {
                String string2 = throwable.getMessage();
                throw new ValidationException((DBObject)cube2, OLAPArb.format("VALIDATION_WHERE_MSG", string2));
            }
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        String string3 = "^\\p{L}[\\p{Alnum}_]*$";
        if (!string2.matches(string3)) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME"));
        }
        if (string2.length() > 30) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME_LENGTH"));
        }
    }

    public void validateName(Cube cube) throws InvalidNameException {
        String string = "^\\p{L}[\\p{Alnum}_]*$";
        if (!cube.getName().matches(string)) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME"));
        }
        if (cube.getName().length() > 30) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME_LENGTH"));
        }
    }
}

