/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.actions.model.CascadeDeleteCubePartition;
import oracle.olap.actions.model.CascadeDeleteDimensionWrapper;
import oracle.olap.actions.model.CascadeDeleteRemovedHierarchyLevel;
import oracle.olap.actions.model.DependentCubeCalculatedMeasure;
import oracle.olap.cube.CubeBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubexml.MultipleObjectDDL;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntax.CubePrecomputeDimension;
import oracle.olap.syntax.PrecomputeConditionSyntax;
import oracle.olap.syntax.SyntaxTree;
import oracle.olap.syntax.SyntaxVisitor;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SyntaxObject;

public class DependentTransactionalCubes {
    public static final String LEVEL_CASCADE_DELETE_OBJECT_TYPE = "LEVEL";
    public static final String HIERARCHY_CASCADE_DELETE_OBJECT_TYPE = "HIERARCHY";
    public static final String HIERARCHY_LEVEL_CASCADE_DELETE_OBJECT_TYPE = "HIERARCHY_LEVEL";
    private CubeDimension dimension;
    private static DependentTransactionalCubes instance;
    private List<Cube> originalCubes;
    private List<Cube> updatedCubes;
    private List<Cube> updatedCubesWithHierLevelEdits;
    private List<Cube> provisionalUpdatedCubes;
    private List<String> primaryPartitionCubeList = new ArrayList<String>();
    private List<String> secondaryPartitionCubeList = new ArrayList<String>();
    private OracleDatabaseImpl oracleDatabaseImpl;
    private List<MultipleObjectDDL> multipleCubeObjectDDLStatements;
    private boolean isDimElementReferenced;
    private String removedCubeMapDetail;
    private boolean warnedUserOnHierLevelDelete = false;

    private DependentTransactionalCubes() {
        this.originalCubes = new ArrayList<Cube>();
        this.updatedCubes = new ArrayList<Cube>();
        this.provisionalUpdatedCubes = new ArrayList<Cube>();
        this.updatedCubesWithHierLevelEdits = new ArrayList<Cube>();
    }

    public void reset() {
        this.originalCubes.clear();
        this.updatedCubes.clear();
        this.provisionalUpdatedCubes.clear();
        this.updatedCubesWithHierLevelEdits.clear();
        this.dimension = null;
        this.oracleDatabaseImpl = null;
        this.multipleCubeObjectDDLStatements = null;
        this.warnedUserOnHierLevelDelete = false;
    }

    public static DependentTransactionalCubes getInstance() {
        if (instance == null) {
            instance = new DependentTransactionalCubes();
        }
        return instance;
    }

    public void setDimension(CubeDimension cubeDimension) {
        this.dimension = cubeDimension;
    }

    public void setDatabaseProvider(OracleDatabaseImpl oracleDatabaseImpl) {
        this.oracleDatabaseImpl = oracleDatabaseImpl;
    }

    public boolean getWarnedUserOnHierLevelDelete() {
        return this.warnedUserOnHierLevelDelete;
    }

    public void setWarnedUserOnHierLevelDelete() {
        this.warnedUserOnHierLevelDelete = true;
    }

    public void loadMetadata() {
        if (this.dimension.getDimensionCubeNames() != null) {
            for (String string : this.dimension.getDimensionCubeNames()) {
                Cube cube = this.loadCube(string);
                this.originalCubes.add(cube);
                Cube cube2 = (Cube)DBUtil.makeTemporaryCopy((DBObject)cube);
                this.updatedCubes.add(cube2);
            }
        }
    }

    public Cube getOriginalCube(String string) {
        Cube cube = null;
        for (Cube cube2 : this.originalCubes) {
            if (!cube2.getName().equalsIgnoreCase(string)) continue;
            cube = cube2;
            break;
        }
        return cube;
    }

    public List<Cube> getOriginalCubes() {
        return this.originalCubes;
    }

    public List<Cube> getUpdatedCubes() {
        return this.updatedCubes;
    }

    public List<Cube> getUpdatedCubesWithHierLevelEdits() {
        return this.updatedCubesWithHierLevelEdits;
    }

    public Cube getUpdatedCube(String string) {
        Cube cube = null;
        for (Cube cube2 : this.updatedCubes) {
            if (!cube2.getName().equalsIgnoreCase(string)) continue;
            cube = cube2;
            break;
        }
        return cube;
    }

    public Cube getProvisionalUpdatedCube(String string) {
        Cube cube = null;
        for (Cube cube2 : this.provisionalUpdatedCubes) {
            if (!cube2.getName().equalsIgnoreCase(string)) continue;
            cube = cube2;
            break;
        }
        return cube;
    }

    private void initializeProvisionalCubes() {
        this.provisionalUpdatedCubes.clear();
        for (Cube cube : this.updatedCubes) {
            Cube cube2 = (Cube)DBUtil.makeTemporaryCopy((DBObject)cube);
            this.provisionalUpdatedCubes.add(cube2);
        }
    }

    private void synchUpdatedCubesUponConfirm() {
        this.updatedCubes.clear();
        for (Cube cube : this.provisionalUpdatedCubes) {
            Cube cube2 = (Cube)DBUtil.makeTemporaryCopy((DBObject)cube);
            this.updatedCubes.add(cube2);
        }
    }

    private void initializeUpdatedCubesWithHierLevelEdits() {
        this.updatedCubesWithHierLevelEdits.clear();
        for (Cube cube : this.updatedCubes) {
            Cube cube2 = (Cube)DBUtil.makeTemporaryCopy((DBObject)cube);
            this.updatedCubesWithHierLevelEdits.add(cube2);
        }
    }

    private Cube loadCube(String string) {
        Cube cube = new Cube();
        CubeBuilder cubeBuilder = new CubeBuilder(this.oracleDatabaseImpl);
        cube.setName(string);
        cube.setSchema(new Schema(this.dimension.getSchema().getName()));
        try {
            cubeBuilder.buildDetails(cube);
            cubeBuilder.buildProperties(cube);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return cube;
    }

    public CascadeDeleteDimensionWrapper handleLevelDelete(String string) {
        this.initializeProvisionalCubes();
        CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = new CascadeDeleteDimensionWrapper(this.dimension);
        cascadeDeleteDimensionWrapper.setObjectType(LEVEL_CASCADE_DELETE_OBJECT_TYPE);
        this.getCubePartitionDetails(string, null, LEVEL_CASCADE_DELETE_OBJECT_TYPE);
        for (Cube cube : this.provisionalUpdatedCubes) {
            boolean bl;
            String string2 = cube.getName();
            List<DependentCubeCalculatedMeasure> list = this.removeDependentDerivedMeasures(cube, string);
            cascadeDeleteDimensionWrapper.setDependentCalculatedMeasures(list);
            if (this.primaryPartitionCubeList.contains(cube.getName()) || this.secondaryPartitionCubeList.contains(cube.getName())) {
                CubePartition[] cubePartitionArray = cube.getPartitions();
                ArrayList<CubePartition> arrayList = new ArrayList<CubePartition>();
                for (int i = 0; i < cubePartitionArray.length; ++i) {
                    CubePartition cubePartition = cubePartitionArray[i];
                    String string3 = cubePartition.getPartitionLevel();
                    if (!string.equalsIgnoreCase(string3)) {
                        arrayList.add(cubePartition);
                        continue;
                    }
                    String string4 = cubePartition.getPartitionHierarchy();
                    CascadeDeleteCubePartition cascadeDeleteCubePartition = new CascadeDeleteCubePartition(string2, string4, string);
                    cascadeDeleteDimensionWrapper.addCubePartition(cascadeDeleteCubePartition);
                }
                if (arrayList.size() > 0) {
                    cubePartitionArray = arrayList.toArray(new CubePartition[0]);
                    cube.setPartitions(cubePartitionArray);
                } else {
                    cube.removeAllPartitions();
                }
            }
            if (bl = this.removeDimensionalityMapForLevel(cube, string)) {
                cascadeDeleteDimensionWrapper.addCubeDimensionMapping(string2, this.removedCubeMapDetail);
            }
            this.removeDependentPrecomputeCondition(cube, string);
        }
        return cascadeDeleteDimensionWrapper;
    }

    public CascadeDeleteDimensionWrapper handleHierarchyDelete(String string) {
        this.initializeProvisionalCubes();
        CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = new CascadeDeleteDimensionWrapper(this.dimension);
        cascadeDeleteDimensionWrapper.setObjectType(HIERARCHY_CASCADE_DELETE_OBJECT_TYPE);
        this.getCubePartitionDetails(string, null, HIERARCHY_CASCADE_DELETE_OBJECT_TYPE);
        for (Cube cube : this.provisionalUpdatedCubes) {
            boolean bl;
            String string2 = cube.getName();
            List<DependentCubeCalculatedMeasure> list = this.removeDependentDerivedMeasures(cube, string);
            cascadeDeleteDimensionWrapper.setDependentCalculatedMeasures(list);
            if (this.primaryPartitionCubeList.contains(cube.getName()) || this.secondaryPartitionCubeList.contains(cube.getName())) {
                CubePartition[] cubePartitionArray = cube.getPartitions();
                ArrayList<CubePartition> arrayList = new ArrayList<CubePartition>();
                for (int i = 0; i < cubePartitionArray.length; ++i) {
                    CubePartition cubePartition = cubePartitionArray[i];
                    String string3 = cubePartition.getPartitionHierarchy();
                    if (!string.equalsIgnoreCase(string3)) {
                        arrayList.add(cubePartition);
                        continue;
                    }
                    String string4 = cubePartition.getPartitionLevel();
                    CascadeDeleteCubePartition cascadeDeleteCubePartition = new CascadeDeleteCubePartition(string2, string, string4);
                    cascadeDeleteDimensionWrapper.addCubePartition(cascadeDeleteCubePartition);
                }
                if (arrayList.size() > 0) {
                    cubePartitionArray = arrayList.toArray(new CubePartition[0]);
                    cube.setPartitions(cubePartitionArray);
                } else {
                    cube.removeAllPartitions();
                }
            }
            if (!(bl = this.removeDimensionalityMapForHierarchy(cube, string))) continue;
            cascadeDeleteDimensionWrapper.addCubeDimensionMapping(string2, this.removedCubeMapDetail);
        }
        return cascadeDeleteDimensionWrapper;
    }

    public CascadeDeleteDimensionWrapper handleHierarchyLevelDelete(String string, String string2) {
        this.getCubePartitionDetails(string, string2, HIERARCHY_LEVEL_CASCADE_DELETE_OBJECT_TYPE);
        CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = new CascadeDeleteDimensionWrapper(this.dimension);
        for (Cube cube : this.updatedCubesWithHierLevelEdits) {
            boolean bl;
            String string3 = cube.getName();
            if (this.primaryPartitionCubeList.contains(cube.getName()) || this.secondaryPartitionCubeList.contains(cube.getName())) {
                CubePartition[] cubePartitionArray = cube.getPartitions();
                ArrayList<CubePartition> arrayList = new ArrayList<CubePartition>();
                for (int i = 0; i < cubePartitionArray.length; ++i) {
                    CubePartition cubePartition = cubePartitionArray[i];
                    String string4 = cubePartition.getPartitionHierarchy();
                    String string5 = cubePartition.getPartitionLevel();
                    boolean bl2 = false;
                    if (string.equalsIgnoreCase(string4) && string2.equalsIgnoreCase(string5)) {
                        bl2 = true;
                    }
                    if (!bl2) {
                        arrayList.add(cubePartition);
                        continue;
                    }
                    CascadeDeleteCubePartition cascadeDeleteCubePartition = new CascadeDeleteCubePartition(string3, string4, string5);
                    cascadeDeleteDimensionWrapper.addCubePartition(cascadeDeleteCubePartition);
                }
                if (arrayList.size() > 0) {
                    cubePartitionArray = arrayList.toArray(new CubePartition[0]);
                    cube.setPartitions(cubePartitionArray);
                } else {
                    cube.removeAllPartitions();
                }
            }
            if (!(bl = this.removeDimensionalityMapForHierarchyLevel(cube, string, string2))) continue;
            cascadeDeleteDimensionWrapper.addCubeDimensionMapping(string3, this.removedCubeMapDetail);
        }
        return cascadeDeleteDimensionWrapper;
    }

    public CascadeDeleteDimensionWrapper getAllRemovedHierarchyLevelDetails(List<CascadeDeleteRemovedHierarchyLevel> list) {
        CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = new CascadeDeleteDimensionWrapper(this.dimension);
        for (CascadeDeleteRemovedHierarchyLevel cascadeDeleteRemovedHierarchyLevel : list) {
            String string = cascadeDeleteRemovedHierarchyLevel.getHierarchyName();
            String string2 = cascadeDeleteRemovedHierarchyLevel.getLevelName();
            this.initializeUpdatedCubesWithHierLevelEdits();
            CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper2 = this.handleHierarchyLevelDelete(string, string2);
            cascadeDeleteDimensionWrapper.addCubeDimensionMappings(cascadeDeleteDimensionWrapper2.getCubeDimensionMappingList());
            cascadeDeleteDimensionWrapper.addCubePartitions(cascadeDeleteDimensionWrapper2.getCubePartitions());
            cascadeDeleteDimensionWrapper.addDependentCalculatedMeasures(cascadeDeleteDimensionWrapper2.getDependentCalculatedMeasures());
        }
        return cascadeDeleteDimensionWrapper;
    }

    public void confirmDelete() {
        this.synchUpdatedCubesUponConfirm();
    }

    public boolean areUpdatedCubes(SystemObject systemObject, SystemObject systemObject2) {
        boolean bl = false;
        if (this.originalCubes.size() > 0) {
            List<MultipleObjectDDL> list = this.getCubeDDLStatements(systemObject, systemObject2);
            for (MultipleObjectDDL multipleObjectDDL : list) {
                if (multipleObjectDDL.getStatements() == null || multipleObjectDDL.getStatements().size() <= 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public List<MultipleObjectDDL> getCubeDDLStatements(SystemObject systemObject, SystemObject systemObject2) {
        this.initializeUpdatedCubesWithHierLevelEdits();
        List<CascadeDeleteRemovedHierarchyLevel> list = this.getRemovedLevelsFromHierarchy(systemObject, systemObject2);
        if (list.size() > 0) {
            for (CascadeDeleteRemovedHierarchyLevel cascadeDeleteRemovedHierarchyLevel : list) {
                String string = cascadeDeleteRemovedHierarchyLevel.getHierarchyName();
                String string2 = cascadeDeleteRemovedHierarchyLevel.getLevelName();
                this.handleHierarchyLevelDelete(string, string2);
            }
        }
        this.multipleCubeObjectDDLStatements = this.generateDDLStatements();
        return this.multipleCubeObjectDDLStatements;
    }

    public List<MultipleObjectDDL> getCubeDDLStatementsNoHierLevel() {
        this.initializeUpdatedCubesWithHierLevelEdits();
        this.multipleCubeObjectDDLStatements = this.generateDDLStatements();
        return this.multipleCubeObjectDDLStatements;
    }

    private List<MultipleObjectDDL> generateDDLStatements() {
        int n = this.updatedCubes.size();
        DDLGenerator dDLGenerator = this.oracleDatabaseImpl.getDDLGenerator();
        this.multipleCubeObjectDDLStatements = new ArrayList<MultipleObjectDDL>();
        for (int i = 0; i < n; ++i) {
            Cube cube = this.originalCubes.get(i);
            Cube cube2 = this.updatedCubesWithHierLevelEdits.get(i);
            ResultSet resultSet = this.oracleDatabaseImpl.getDiffEngine().diff((Object)cube, (Object)cube2).getResult();
            DDL dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), (Difference)resultSet);
            Collection collection = dDL.getStatements();
            MultipleObjectDDL multipleObjectDDL = new MultipleObjectDDL((SystemObject)cube, (SystemObject)cube2, collection);
            this.multipleCubeObjectDDLStatements.add(multipleObjectDDL);
        }
        return this.multipleCubeObjectDDLStatements;
    }

    private void getCubePartitionDetails(String string, String string2, String string3) {
        this.primaryPartitionCubeList.clear();
        this.secondaryPartitionCubeList.clear();
        for (Cube cube : this.originalCubes) {
            if (cube.getPartitionDimensionName() == null || cube.getPartitionDimensionName().length() <= 0) continue;
            String string4 = cube.getPartitionDimensionName();
            if (!this.dimension.getName().equalsIgnoreCase(string4)) continue;
            CubePartition[] cubePartitionArray = cube.getPartitions();
            boolean bl = true;
            for (int i = 0; i < cubePartitionArray.length; ++i) {
                String string5;
                CubePartition cubePartition = cubePartitionArray[i];
                if (string3.equalsIgnoreCase(LEVEL_CASCADE_DELETE_OBJECT_TYPE)) {
                    string5 = cubePartition.getPartitionLevel();
                    if (string5.equalsIgnoreCase(string)) {
                        if (bl) {
                            this.primaryPartitionCubeList.add(cube.getName());
                        } else if (!this.secondaryPartitionCubeList.contains(cube.getName())) {
                            this.secondaryPartitionCubeList.add(cube.getName());
                        }
                    }
                    bl = false;
                    continue;
                }
                if (string3.equalsIgnoreCase(HIERARCHY_CASCADE_DELETE_OBJECT_TYPE)) {
                    string5 = cubePartition.getPartitionHierarchy();
                    if (string5.equalsIgnoreCase(string)) {
                        if (bl) {
                            this.primaryPartitionCubeList.add(cube.getName());
                        } else if (!this.secondaryPartitionCubeList.contains(cube.getName())) {
                            this.secondaryPartitionCubeList.add(cube.getName());
                        }
                    }
                    bl = false;
                    continue;
                }
                string5 = cubePartition.getPartitionHierarchy();
                String string6 = cubePartition.getPartitionLevel();
                if (string5.equalsIgnoreCase(string) && string6.equalsIgnoreCase(string2)) {
                    if (bl) {
                        this.primaryPartitionCubeList.add(cube.getName());
                    } else if (!this.secondaryPartitionCubeList.contains(cube.getName())) {
                        this.secondaryPartitionCubeList.add(cube.getName());
                    }
                }
                bl = false;
            }
        }
    }

    private List<DependentCubeCalculatedMeasure> removeDependentDerivedMeasures(Cube cube, String string) {
        CubeCalculatedMeasure[] cubeCalculatedMeasureArray = cube.getCalculatedMeasures();
        ArrayList<CubeCalculatedMeasure> arrayList = new ArrayList<CubeCalculatedMeasure>();
        ArrayList<DependentCubeCalculatedMeasure> arrayList2 = new ArrayList<DependentCubeCalculatedMeasure>();
        for (CubeCalculatedMeasure cubeCalculatedMeasure : cubeCalculatedMeasureArray) {
            String string2 = cubeCalculatedMeasure.getMeasureExpression();
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string2, null);
            if (!this.isDimReferenced(syntaxObject, this.dimension.getName(), string)) continue;
            arrayList.add(cubeCalculatedMeasure);
            DependentCubeCalculatedMeasure dependentCubeCalculatedMeasure = new DependentCubeCalculatedMeasure(cube.getName(), cubeCalculatedMeasure.getName(), cubeCalculatedMeasure.getMeasureExpression());
            arrayList2.add(dependentCubeCalculatedMeasure);
        }
        for (CubeCalculatedMeasure cubeCalculatedMeasure : arrayList) {
            cube.removeCalculatedMeasure(cubeCalculatedMeasure);
        }
        return arrayList2;
    }

    private boolean isDimReferenced(SyntaxObject syntaxObject, String string, String string2) {
        this.isDimElementReferenced = false;
        try {
            final String string3 = string;
            final String string4 = string2;
            SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

                @Override
                public void visit(SyntaxObject syntaxObject) throws SQLException {
                    if (syntaxObject instanceof DimensionArgument) {
                        String string = syntaxObject.toSyntax();
                        IdentifierElement identifierElement = new IdentifierElement(string);
                        if (identifierElement.getCount() == 3) {
                            String string2 = identifierElement.getSecond();
                            String string32 = identifierElement.getThird();
                            if (string3.equalsIgnoreCase(string2) && string4.equalsIgnoreCase(string32)) {
                                DependentTransactionalCubes.this.isDimElementReferenced = true;
                            }
                        } else if (identifierElement.getCount() == 2) {
                            String string42 = identifierElement.getFirst();
                            String string5 = identifierElement.getSecond();
                            if (string3.equalsIgnoreCase(string42) && string4.equalsIgnoreCase(string5)) {
                                DependentTransactionalCubes.this.isDimElementReferenced = true;
                            }
                        }
                    }
                }
            });
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.isDimElementReferenced;
    }

    private boolean removeDimensionalityMapForLevel(Cube cube, String string) {
        boolean bl = false;
        if (cube.getDimensions() != null) {
            for (CubeDimensionality cubeDimensionality : cube.getDimensions()) {
                String string2;
                String string3;
                String string4 = cubeDimensionality.getDimensionalityName();
                if (!this.dimension.getName().equalsIgnoreCase(string4) || (string3 = cubeDimensionality.getMappedDimension()) == null) continue;
                IdentifierElement identifierElement = new IdentifierElement(string3);
                if (identifierElement.getCount() == 3) {
                    string2 = identifierElement.getThird();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    cubeDimensionality.setMappedDimension(null);
                    cubeDimensionality.setMapExpression("");
                    cubeDimensionality.setMapJoinCondition(null);
                    bl = true;
                    this.removedCubeMapDetail = identifierElement.getSecond() + "." + identifierElement.getThird();
                    break;
                }
                if (identifierElement.getCount() != 4 || !string.equalsIgnoreCase(string2 = identifierElement.getFourth())) continue;
                cubeDimensionality.setMappedDimension(null);
                cubeDimensionality.setMapExpression("");
                cubeDimensionality.setMapJoinCondition(null);
                bl = true;
                this.removedCubeMapDetail = identifierElement.getThird() + "." + identifierElement.getFourth();
                break;
            }
        }
        return bl;
    }

    private boolean removeDimensionalityMapForHierarchy(Cube cube, String string) {
        boolean bl = false;
        if (cube.getDimensions() != null) {
            for (CubeDimensionality cubeDimensionality : cube.getDimensions()) {
                String string2;
                String string3;
                String string4 = cubeDimensionality.getDimensionalityName();
                if (!this.dimension.getName().equalsIgnoreCase(string4) || (string3 = cubeDimensionality.getMappedDimension()) == null) continue;
                IdentifierElement identifierElement = new IdentifierElement(string3);
                if (identifierElement.getCount() == 3) {
                    string2 = identifierElement.getSecond();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    cubeDimensionality.setMappedDimension(null);
                    cubeDimensionality.setMapExpression("");
                    cubeDimensionality.setMapJoinCondition(null);
                    bl = true;
                    this.removedCubeMapDetail = identifierElement.getSecond() + "." + identifierElement.getThird();
                    break;
                }
                if (identifierElement.getCount() != 4 || !string.equalsIgnoreCase(string2 = identifierElement.getThird())) continue;
                cubeDimensionality.setMappedDimension(null);
                cubeDimensionality.setMapExpression("");
                cubeDimensionality.setMapJoinCondition(null);
                bl = true;
                this.removedCubeMapDetail = identifierElement.getThird() + "." + identifierElement.getFourth();
                break;
            }
        }
        return bl;
    }

    private boolean removeDimensionalityMapForHierarchyLevel(Cube cube, String string, String string2) {
        boolean bl = false;
        if (cube.getDimensions() != null) {
            for (CubeDimensionality cubeDimensionality : cube.getDimensions()) {
                String string3;
                String string4;
                String string5;
                String string6 = cubeDimensionality.getDimensionalityName();
                if (!this.dimension.getName().equalsIgnoreCase(string6) || (string5 = cubeDimensionality.getMappedDimension()) == null) continue;
                IdentifierElement identifierElement = new IdentifierElement(string5);
                if (identifierElement.getCount() == 3) {
                    string4 = identifierElement.getSecond();
                    string3 = identifierElement.getThird();
                    if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string3)) continue;
                    cubeDimensionality.setMappedDimension(null);
                    cubeDimensionality.setMapExpression("");
                    cubeDimensionality.setMapJoinCondition(null);
                    bl = true;
                    this.removedCubeMapDetail = identifierElement.getSecond() + "." + identifierElement.getThird();
                    break;
                }
                if (identifierElement.getCount() != 4) continue;
                string4 = identifierElement.getThird();
                string3 = identifierElement.getFourth();
                if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string3)) continue;
                cubeDimensionality.setMappedDimension(null);
                cubeDimensionality.setMapExpression("");
                cubeDimensionality.setMapJoinCondition(null);
                bl = true;
                this.removedCubeMapDetail = identifierElement.getThird() + "." + identifierElement.getFourth();
                break;
            }
        }
        return bl;
    }

    private void removeDependentPrecomputeCondition(Cube cube, String string) {
        SyntaxObject syntaxObject;
        String string2 = cube.getPrecomputeCondition();
        if (string2 != null && (syntaxObject = SyntaxObject.fromSyntax((String)string2, null)) != null && syntaxObject instanceof SymmetricCondition) {
            Object object;
            Object object22;
            HashMap<String, CubeDimension> hashMap = new HashMap<String, CubeDimension>();
            CubeDimensionality[] cubeDimensionalityArray = cube.getDimensions();
            for (Object object22 : cubeDimensionalityArray) {
                object = object22.getName();
                Object object3 = null;
                object3 = ((String)object).equalsIgnoreCase(this.dimension.getName()) ? this.dimension : this.loadDimension(object22.getName());
                hashMap.put(object22.getName(), (CubeDimension)object3);
            }
            Map<String, Object> map = PrecomputeConditionSyntax.getInstance().fromSyntax(cube, hashMap, string2);
            List list = (List)map.get("CUBE_PRECOMPUTE_DIMENSIONS_KEY");
            String string3 = this.dimension.getName();
            object22 = string;
            for (Object object3 : list) {
                if (!((CubePrecomputeDimension)object3).getName().equalsIgnoreCase(string3)) continue;
                List<CubeDimensionLevel> list2 = ((CubePrecomputeDimension)object3).getPrecomputeLevels();
                ArrayList<CubeDimensionLevel> arrayList = new ArrayList<CubeDimensionLevel>();
                for (CubeDimensionLevel cubeDimensionLevel : list2) {
                    if (cubeDimensionLevel.getName().equalsIgnoreCase((String)object22)) continue;
                    arrayList.add(cubeDimensionLevel);
                }
                ((CubePrecomputeDimension)object3).setPrecomputeLevels(arrayList);
                break;
            }
            object = PrecomputeConditionSyntax.getInstance().toSyntax(cube, hashMap, map);
            cube.setPrecomputeCondition((String)object);
        }
    }

    private CubeDimension loadDimension(String string) {
        CubeDimension cubeDimension = new CubeDimension();
        CubeDimensionBuilder cubeDimensionBuilder = new CubeDimensionBuilder(this.oracleDatabaseImpl);
        cubeDimension.setName(string);
        cubeDimension.setSchema(new Schema(this.dimension.getSchema().getName()));
        try {
            cubeDimensionBuilder.buildProperties(cubeDimension);
            cubeDimensionBuilder.buildDetails(cubeDimension);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cubeDimension;
    }

    public List<CascadeDeleteRemovedHierarchyLevel> getRemovedLevelsFromHierarchy(SystemObject systemObject, SystemObject systemObject2) {
        ArrayList<CascadeDeleteRemovedHierarchyLevel> arrayList = new ArrayList<CascadeDeleteRemovedHierarchyLevel>();
        CubeDimension cubeDimension = (CubeDimension)systemObject;
        CubeDimension cubeDimension2 = (CubeDimension)systemObject2;
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray = cubeDimension.getHierarchies();
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray2 = cubeDimension2.getHierarchies();
        CubeDimensionLevel[] cubeDimensionLevelArray = cubeDimension2.getLevels();
        if (cubeDimensionHierarchyArray != null && cubeDimensionHierarchyArray.length > 0 && cubeDimensionHierarchyArray2 != null && cubeDimensionHierarchyArray2.length > 0) {
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray) {
                if (!cubeDimensionHierarchy.getHierarchyLevelType()) continue;
                String string = cubeDimensionHierarchy.getName();
                for (CubeDimensionHierarchy cubeDimensionHierarchy2 : cubeDimensionHierarchyArray2) {
                    String string2;
                    if (!cubeDimensionHierarchy2.getHierarchyLevelType() || !(string2 = cubeDimensionHierarchy2.getOriginalHierarchyName()).equalsIgnoreCase(string)) continue;
                    CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevels();
                    CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray2 = cubeDimensionHierarchy2.getHierarchyLevels();
                    for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchyLevelArray) {
                        String string3 = cubeDimensionHierarchyLevel.getLevelName();
                        if (!this.isLevelInUpdatedDimension(string3, cubeDimensionLevelArray)) continue;
                        boolean bl = false;
                        for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel2 : cubeDimensionHierarchyLevelArray2) {
                            String string4 = null;
                            CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevel2.getLevel();
                            string4 = cubeDimensionLevel != null ? cubeDimensionLevel.getOriginalLevelName() : cubeDimensionHierarchyLevel2.getLevelName();
                            if (!string4.equalsIgnoreCase(string3)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        CascadeDeleteRemovedHierarchyLevel cascadeDeleteRemovedHierarchyLevel = new CascadeDeleteRemovedHierarchyLevel(string2, string3);
                        arrayList.add(cascadeDeleteRemovedHierarchyLevel);
                    }
                }
            }
        }
        return arrayList;
    }

    private boolean isLevelInUpdatedDimension(String string, CubeDimensionLevel[] cubeDimensionLevelArray) {
        boolean bl = false;
        for (CubeDimensionLevel cubeDimensionLevel : cubeDimensionLevelArray) {
            String string2 = cubeDimensionLevel.getOriginalLevelName();
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

