/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.panels.aggregation.AggregationHierarchyPanel;
import oracle.olap.cube.panels.aggregation.AggregationOperatorPanel;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.db.view.DimensionTree;
import oracle.olap.syntax.AggregationOperatorMap;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;

public class CubeAggregationPanel
extends BaseEditorPanel<Cube> {
    protected AggregationOperatorPanel aggregationOperatorPanel;
    protected AggregationHierarchyPanel aggregationHierarchyPanel;
    protected List<CubeAggregationDimension> cubeAggregationDimensions = new ArrayList<CubeAggregationDimension>();

    public CubeAggregationPanel() {
        this.aggregationOperatorPanel = new AggregationOperatorPanel();
        this.aggregationOperatorPanel.setName("aggregationOperatorPanel");
        this.aggregationHierarchyPanel = new AggregationHierarchyPanel();
        this.aggregationHierarchyPanel.setName("aggregationHierarchyPanel");
        this.aggregationOperatorPanel.addPropertyChangeListener(this.aggregationOperatorPanel);
        this.aggregationOperatorPanel.addPropertyChangeListener(this.aggregationHierarchyPanel);
        this.aggregationHierarchyPanel.addPropertyChangeListener(this.aggregationOperatorPanel);
        this.layoutComponents();
    }

    protected void initialisePanel() {
        Object object;
        Cube cube = (Cube)this.getUpdatedObject();
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string = cube.getConsistentSolveSpec();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        AggregationOperatorMap aggregationOperatorMap = this.aggregationOperatorPanel.getAggregationOperatorMap();
        int n = 0;
        this.cubeAggregationDimensions = new ArrayList<CubeAggregationDimension>();
        if (string != null) {
            object = this.getDataContext().get("dimensions");
            this.cubeAggregationDimensions = SolveSyntax.getInstance().fromSyntax(cube, cube.getDimensionMap(object), dBObjectProvider, string);
        } else {
            object = this.getDataContext().get("dimensions");
            for (CubeDimension cubeDimension : cube.getDimensions(object)) {
                String string2 = cubeDimension.getName();
                CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, string2);
                cubeAggregationDimension.setAggregationOrder(++n);
                this.cubeAggregationDimensions.add(cubeAggregationDimension);
            }
        }
        object = this.getDataContext().get("dimensions");
        this.aggregationOperatorPanel.initialisePanel(oracleDatabaseImpl, (Cube)this.getUpdatedObject(), object, this.cubeAggregationDimensions);
        Object object2 = this.getDataContext().get("dimensions");
        this.aggregationHierarchyPanel.initialisePanel((Cube)this.getUpdatedObject(), object2, this.cubeAggregationDimensions);
    }

    protected void commitPanel() throws TraversalException {
        Cube cube = (Cube)this.getUpdatedObject();
        String string = null;
        string = this.getConsistentSolveSpec();
        cube.setConsistentSolveSpec(string);
    }

    protected String getConsistentSolveSpec() {
        Cube cube = (Cube)this.getUpdatedObject();
        String string = null;
        DBObjectProvider dBObjectProvider = this.getProvider();
        DimensionTree dimensionTree = this.aggregationHierarchyPanel.getDimensionHierarchyTree();
        this.cubeAggregationDimensions = this.aggregationOperatorPanel.getAggregationDimensions();
        Object object = this.getDataContext().get("dimensions");
        string = SolveSyntax.getInstance().toSyntax(cube, cube.getDimensionMap(object), dBObjectProvider, this.cubeAggregationDimensions);
        return string;
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(OLAPArb.get("AGGREGATION.RULES.DESC"));
        jLabel.setName("aggOperatorLabel");
        JLabel jLabel2 = new JLabel(OLAPArb.get("AGGREGATION.RULES.HIER.DESC"));
        jLabel2.setName("aggHierarchyLabel");
        int n = 0;
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.aggregationOperatorPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.aggregationHierarchyPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
    }
}

