/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.buildspec.BuildSpecBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.panels.CubeBuildSpecificationTablePanel;
import oracle.olap.db.view.ChildObjectEditorPanel2;
import oracle.olap.syntax.BuildSyntax;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;

public class CubeBuildSpecificationTableEditorPanel<T extends CubeBuildSpecification, P extends Cube>
extends ChildObjectEditorPanel2<T, P> {
    private static final Logger LOG = Logger.getLogger(CubeBuildSpecificationTableEditorPanel.class.getName());
    private JLabel lblName = new JLabel();
    private DBObjectProvider prov;
    private String analyticWorkspace;
    private String owner;
    private Connection conn;
    private Cube cube;
    private SyntaxBuilderPanel buildCommandExpressionEditorPanel;
    private String allstatDimCond;
    private transient BuildSpecBuilder builder;
    private CubeBuildSpecificationTablePanel parentPanel;

    public CubeBuildSpecificationTableEditorPanel(CubeBuildSpecificationTablePanel cubeBuildSpecificationTablePanel) {
        super("CubeBuildSpecificationEditorPanel", "BUILDSPECIFICATION");
        this.parentPanel = cubeBuildSpecificationTablePanel;
        this.layoutComponents();
    }

    private void initFromBuildSpecificationData() {
        this.enableFields(true);
        this.allstatDimCond = CubeBuildSpecification.getDefaultCubeDimensionCondition(this.cube);
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.buildCommandExpressionEditorPanel.setText("");
            this.enableFields(false);
        } else {
            String string = ((CubeBuildSpecification)this.getChildObject()).getName();
            CubeBuildCommand[] cubeBuildCommandArray = null;
            String string2 = "";
            cubeBuildCommandArray = ((CubeBuildSpecification)this.getChildObject()).getBuildCommands();
            string2 = ((CubeBuildSpecification)this.getChildObject()).getSyntax();
            this.initBuildCommands(cubeBuildCommandArray);
            String string3 = null;
            if (string2 == null) {
                string3 = " ";
            } else {
                int n;
                int n2 = string2.indexOf("(") + 1;
                string3 = string2.substring(n2, n = string2.lastIndexOf(")"));
                if (string3.startsWith("\n")) {
                    string3 = string3.substring(1);
                }
            }
            this.buildCommandExpressionEditorPanel.setText(string3);
            if (string != null && string.equalsIgnoreCase("SYS_DEFAULT")) {
                this.enableFields(false);
            } else {
                this.enableFields(true);
            }
        }
        this.validate();
        this.repaint();
    }

    private void initBuildCommands(CubeBuildCommand[] cubeBuildCommandArray) {
        Cube cube = (Cube)this.getOriginalObject();
        String string = CubeBuildSpecification.getDefaultCubeMeasureSelection(this.cube);
        String string2 = "";
        String string3 = "";
        if (cube != null) {
            string3 = CubeBuildSpecification.getDefaultCubeMeasureSelection(cube);
            string2 = CubeBuildSpecification.getDefaultCubeDimensionCondition(cube);
        }
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, cubeBuildCommandArray);
        for (CubeBuildCommand cubeBuildCommand : arrayList) {
            String string4;
            String string5;
            String string6 = cubeBuildCommand.getType();
            String string7 = cubeBuildCommand.getMeasureSelection();
            CubeMeasure[] cubeMeasureArray = this.cube.getMeasures();
            String string8 = this.cube.getName();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < cubeMeasureArray.length; ++i) {
                string5 = string8 + "." + cubeMeasureArray[i].getName();
                arrayList2.add(string5);
            }
            if (string7 == null || string7 != null && string7.trim().length() == 0) {
                if ((string6.equalsIgnoreCase("LOAD") || string6.equalsIgnoreCase("CLEAR") || string6.equalsIgnoreCase("OLAP DML") || string6.equalsIgnoreCase("SOLVE")) && !string.equals(string3)) {
                    string7 = string;
                    cubeBuildCommand.setMeasureSelection(string7);
                }
            } else {
                String[] stringArray = string7.split(",");
                string5 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    String string9 = stringArray[i];
                    if (!arrayList2.contains(string9)) continue;
                    string5 = string5.length() == 0 ? string5 + string9 : string5 + "," + string9;
                }
                if (string5.length() == 0) {
                    string5 = string;
                }
                if (!string5.equals(string3)) {
                    cubeBuildCommand.setMeasureSelection(string5);
                }
            }
            if ((string4 = cubeBuildCommand.getDimensionCondition()) != null && (string4 == null || string4.length() != 0) || !string6.equalsIgnoreCase("CLEAR") && !string6.equalsIgnoreCase("OLAP DML") && !string6.equalsIgnoreCase("SOLVE") || (string4 = this.allstatDimCond).equals(string2)) continue;
            cubeBuildCommand.setDimensionCondition(string4);
        }
    }

    private void enableFields(boolean bl) {
        this.lblName.setEnabled(bl);
        this.buildCommandExpressionEditorPanel.setEnabled(bl);
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
        this.cube = (Cube)this.getUpdatedObject();
        this.analyticWorkspace = this.cube.getAnalyticWorkspace();
        Schema schema = this.cube.getSchema();
        this.owner = schema.getName();
        this.conn = this.getConnection();
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        Object object = this.parentPanel.getAllDimensions();
        this.builder.initialize(this.getConnection(), (Cube)this.getUpdatedObject(), object);
        this.buildCommandExpressionEditorPanel.setText("");
        this.initFromBuildSpecification((CubeBuildSpecification)this.getChildObject());
    }

    private Connection getConnection() {
        Connection connection = null;
        if (this.prov instanceof OracleDatabaseImpl) {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.prov;
            connection = oracleDatabaseImpl.getConnection();
        }
        return connection;
    }

    public void commit(CubeBuildSpecification cubeBuildSpecification, Map<String, Object> map) {
        AbstractChildDBObject[] abstractChildDBObjectArray;
        Object object;
        CubeBuildSpecification cubeBuildSpecification2;
        String string = (String)map.get("CUBE_BUILD_SPECIFICATION_NAME_KEY");
        String string2 = (String)map.get("CUBE_BUILD_SPECIFICATION_SYNTAX_KEY");
        Cube cube = (Cube)this.getOriginalObject();
        if (cube != null && (cubeBuildSpecification2 = cube.getBuildSpecification(string)) != null) {
            object = SyntaxObject.fromSyntax((String)cubeBuildSpecification2.getSyntax(), null);
            abstractChildDBObjectArray = SyntaxObject.fromSyntax((String)string2, null);
            if (object.toSyntax().equals(abstractChildDBObjectArray.toSyntax())) {
                string2 = cubeBuildSpecification2.getSyntax();
            }
        }
        cubeBuildSpecification.setName(string);
        boolean bl = cubeBuildSpecification.isDefault();
        if (bl) {
            object = (Cube)this.getUpdatedObject();
            abstractChildDBObjectArray = ((Cube)object).getBuildSpecifications();
            for (int i = 0; i < abstractChildDBObjectArray.length; ++i) {
                if (abstractChildDBObjectArray[i].equals((Object)cubeBuildSpecification)) continue;
                abstractChildDBObjectArray[i].setIsDefault(!bl);
            }
        }
        object = (List)map.get("CUBE_BUILD_COMMANDS_KEY");
        abstractChildDBObjectArray = new CubeBuildCommand[]{};
        cubeBuildSpecification.setBuildCommands((CubeBuildCommand[])object.toArray(abstractChildDBObjectArray));
        cubeBuildSpecification.setSyntax(string2);
    }

    public void initFromBuildSpecification(CubeBuildSpecification cubeBuildSpecification) {
        this.initFromBuildSpecificationData();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        boolean bl;
        boolean bl2 = bl = !this.buildCommandExpressionEditorPanel.isEnabled();
        if (bl) {
            return;
        }
        CubeBuildSpecification cubeBuildSpecification = (CubeBuildSpecification)this.getChildObject();
        String string = cubeBuildSpecification.getName();
        boolean bl3 = cubeBuildSpecification.isDefault();
        Cube cube = (Cube)this.getUpdatedObject();
        boolean bl4 = cube.isMVOn();
        String string2 = this.buildCommandExpressionEditorPanel.getText();
        String string3 = String.format("BUILD SPEC %s (%s)", string, string2);
        Map<String, Object> map = null;
        String string4 = cube.getSchema().getName();
        try {
            map = BuildSyntax.getInstance().fromSyntax(string4, string3);
        }
        catch (SyntaxException syntaxException) {
            String string5 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_SYNTAX_ERROR", string);
            string5 = string5 + "  " + syntaxException.getLocalizedMessage();
            throw new TraversalException(string5);
        }
        catch (Exception exception) {
            String string6 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_SYNTAX_ERROR", string);
            string6 = string6 + "  " + exception.getLocalizedMessage();
            throw new TraversalException(string6);
        }
        String string7 = (String)map.get("CUBE_BUILD_SPECIFICATION_NAME_KEY");
        string = this.prov.getInternalName(string7);
        List list = (List)map.get("CUBE_BUILD_COMMANDS_KEY");
        try {
            this.prov.validateName("BUILDSPECIFICATION", string);
        }
        catch (InvalidNameException invalidNameException) {
            String string8 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NAME_ERROR", string);
            string8 = string8 + "  " + invalidNameException.getMessage();
            throw new TraversalException(string8);
        }
        if (string.equalsIgnoreCase("SYS_DEFAULT") && !bl) {
            throw new TraversalException(OLAPArb.get("CUBE_VALIDATE_BUILDSPECS_SYS_DEFAULT_NAME_ERROR"));
        }
        if (BuildSyntax.getInstance().isKeyword(string)) {
            String string9 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_RESERVED_WORD_NAME_ERROR", string);
            throw new TraversalException(string9);
        }
        if (bl3 && bl4 && !string.equalsIgnoreCase("SYS_DEFAULT")) {
            throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_DEFAULT_NAME_ERROR", string));
        }
        List list2 = list;
        int n = list2.size();
        if (n == 0) {
            throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NO_COMMAND_ERROR", string));
        }
        for (CubeBuildCommand cubeBuildCommand : list2) {
            String string10;
            String string11 = cubeBuildCommand.getType();
            if (!string11.equalsIgnoreCase("OLAP DML") && !string11.equalsIgnoreCase("PLSQL") || ((string10 = cubeBuildCommand.getExpression()) == null || string10.trim().length() != 0) && string10 != null) continue;
            if (string11.equalsIgnoreCase("OLAP DML")) {
                throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_OLAPDML_COMMAND_ERROR", string));
            }
            throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_PLSQL_COMMAND_ERROR", string));
        }
        super.commitPanel();
        this.commit(cubeBuildSpecification, map);
        Object object = cubeBuildSpecification.getName();
        if (object != null && ((String)(object = ((String)object).trim())).length() > 0 && cube.getBuildSpecification((String)object) == null) {
            cube.addBuildSpecification(cubeBuildSpecification);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        this.builder = new BuildSpecBuilder();
        try {
            this.buildCommandExpressionEditorPanel = this.builder.createBuilder();
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.get("BUILD.SPECIFICATION.PROPERTIES.LABEL")));
        int n = 0;
        this.add(this.getBuildCommandsPanel(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    private JPanel getBuildCommandsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("buildCommandPanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.buildCommandExpressionEditorPanel, gridBagConstraints);
        return jPanel;
    }

    protected void validateObject() throws TraversalException {
    }
}

