/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.db.model.StatefulDescriptions;
import oracle.olap.db.view.DescriptionPanel;

public class CubeDescriptionPanel
extends DescriptionPanel<Cube> {
    @Override
    protected String getDescriptionXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Cube>\n");
        stringBuffer.append("     " + this.getDescXML("CubeObject", ((Cube)this.getUpdatedObject()).getName(), (Descriptions)this.getUpdatedObject()));
        if (((Cube)this.getUpdatedObject()).getMeasures().length > 0) {
            stringBuffer.append("  <Measures type=\"\">\n");
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : ((Cube)this.getUpdatedObject()).getMeasures()) {
                stringBuffer.append("     " + this.getDescXML("Measure", abstractChildObjectWithDesc));
            }
            stringBuffer.append("  </Measures>\n");
        }
        if (((Cube)this.getUpdatedObject()).getCalculatedMeasures().length > 0) {
            stringBuffer.append("  <DerivedMeasures type=\"\">\n");
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : ((Cube)this.getUpdatedObject()).getCalculatedMeasures()) {
                stringBuffer.append("     " + this.getDescXML("DerivedMeasure", abstractChildObjectWithDesc));
            }
            stringBuffer.append("  </DerivedMeasures>\n");
        }
        stringBuffer.append("</Cube>\n");
        return stringBuffer.toString();
    }

    @Override
    protected String getDescriptionEditorXML() {
        return "cubedesceditor.xml";
    }

    @Override
    protected String[] getObjectXPaths() {
        return new String[]{"/Cube/CubeObject", "/Cube/Measures/*", "/Cube/DerivedMeasures/*"};
    }

    @Override
    protected StatefulDescriptions findDBObjectWithDesc(String string, String string2) {
        if (string.equals("CubeObject")) {
            return (StatefulDescriptions)this.getUpdatedObject();
        }
        if (string.equals("Measure")) {
            CubeMeasure cubeMeasure = ((Cube)this.getUpdatedObject()).findMeasure(string2);
            return cubeMeasure;
        }
        if (string.equals("DerivedMeasure")) {
            CubeCalculatedMeasure cubeCalculatedMeasure = ((Cube)this.getUpdatedObject()).findCalculatedMeasure(string2);
            return cubeCalculatedMeasure;
        }
        return null;
    }
}

