/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.panels.CubeAggregationPanel;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.syntax.AggregationOperatorMap;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;

public class CubeMeasureAggregationPanel
extends CubeAggregationPanel {
    private JComboBox measureComboBox;
    private DefaultComboBoxModel measureComboBoxModel;
    private JCheckBox useCubeAggChkBox;
    private CubeMeasure[] measures;
    private Map<String, String> mapMeasureCSS;
    private boolean isPanelEnabled;
    private String currentMeasureName;
    private ItemListener measureComboBoxItemListener;
    private OracleDatabaseImpl oraDb;

    @Override
    protected void initialisePanel() {
        Cube cube = (Cube)this.getUpdatedObject();
        String string = cube.getConsistentSolveSpec();
        this.oraDb = (OracleDatabaseImpl)this.getProvider();
        this.cubeAggregationDimensions = new ArrayList();
        this.mapMeasureCSS = new HashMap<String, String>();
        this.measureComboBoxModel.removeAllElements();
        this.measures = cube.getMeasures();
        this.measureComboBox.removeItemListener(this.measureComboBoxItemListener);
        if (this.measures.length > 0) {
            for (CubeMeasure cubeMeasure : this.measures) {
                this.mapMeasureCSS.put(cubeMeasure.getName(), cubeMeasure.getConsistentSolveSpec());
                this.measureComboBoxModel.addElement(cubeMeasure.getName());
            }
            this.measureComboBox.setSelectedIndex(0);
            CubeMeasure cubeMeasure = this.measures[0];
            String string2 = cubeMeasure.getConsistentSolveSpec();
            if (string2 != null && string2.length() > 0) {
                string = string2;
                this.useCubeAggChkBox.setSelected(false);
            }
            this.currentMeasureName = cubeMeasure.getName();
        }
        this.initAggPanels(string);
        this.measureComboBox.addItemListener(this.measureComboBoxItemListener);
    }

    private void initAggPanels(String string) {
        Object object;
        Cube cube = (Cube)this.getUpdatedObject();
        DBObjectProvider dBObjectProvider = this.getProvider();
        AggregationOperatorMap aggregationOperatorMap = this.aggregationOperatorPanel.getAggregationOperatorMap();
        int n = 0;
        CubeDimensionality[] cubeDimensionalityArray = cube.getDimensions();
        if (string != null) {
            object = this.getDataContext().get("dimensions");
            this.cubeAggregationDimensions = SolveSyntax.getInstance().fromSyntax(cube, cube.getDimensionMap(object), dBObjectProvider, string);
        } else if (this.isEditing()) {
            object = this.getDataContext().get("dimensions");
            for (CubeDimension cubeDimension : cube.getDimensions(object)) {
                String string2 = cubeDimension.getName();
                CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, string2);
                cubeAggregationDimension.setAggregationOrder(++n);
                String string3 = (String)aggregationOperatorMap.get("NOAGG");
                cubeAggregationDimension.setAggregationOperator(string3);
                this.cubeAggregationDimensions.add(cubeAggregationDimension);
            }
        }
        this.setEnablePanel(!cube.isCompress() && this.measures.length > 0);
        object = this.getDataContext().get("dimensions");
        this.aggregationOperatorPanel.initialisePanel(this.oraDb, cube, object, this.cubeAggregationDimensions);
        Object object2 = this.getDataContext().get("dimensions");
        this.aggregationHierarchyPanel.initialisePanel(cube, object2, (List<CubeAggregationDimension>)this.cubeAggregationDimensions);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.isPanelEnabled) {
            this.saveMeasureCSS(this.currentMeasureName);
            for (CubeMeasure cubeMeasure : this.measures) {
                String string = cubeMeasure.getName();
                String string2 = this.mapMeasureCSS.get(string);
                cubeMeasure.setConsistentSolveSpec(string2);
            }
        }
    }

    @Override
    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(OLAPArb.get("AGGREGATION.RULES.DESC"));
        jLabel.setName("aggOperatorLabel");
        JLabel jLabel2 = new JLabel(OLAPArb.get("MEASURE_AGGREGATION_RULES_HIER_DESC"));
        jLabel2.setName("aggHierarchyLabel");
        JLabel jLabel3 = new JLabel(OLAPArb.get("MEASURE_AGGREGATION_RULES_MEASURE_LABEL"));
        jLabel3.setName("measureLabel");
        this.measureComboBoxModel = new DefaultComboBoxModel();
        this.measureComboBox = new JComboBox(this.measureComboBoxModel);
        this.measureComboBox.setName("measureComboBox");
        this.measureComboBoxItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                Cube cube = (Cube)CubeMeasureAggregationPanel.this.getUpdatedObject();
                String string2 = (String)CubeMeasureAggregationPanel.this.measureComboBox.getSelectedItem();
                if (CubeMeasureAggregationPanel.this.currentMeasureName != null && string2 != null && !string2.equalsIgnoreCase(CubeMeasureAggregationPanel.this.currentMeasureName)) {
                    CubeMeasureAggregationPanel.this.saveMeasureCSS(CubeMeasureAggregationPanel.this.currentMeasureName);
                }
                if ((string = (String)CubeMeasureAggregationPanel.this.mapMeasureCSS.get(string2)) != null && string.length() > 0) {
                    CubeMeasureAggregationPanel.this.useCubeAggChkBox.setSelected(false);
                } else {
                    string = cube.getConsistentSolveSpec();
                    CubeMeasureAggregationPanel.this.useCubeAggChkBox.setSelected(true);
                }
                CubeMeasureAggregationPanel.this.currentMeasureName = string2;
                CubeMeasureAggregationPanel.this.initAggPanels(string);
            }
        };
        this.measureComboBox.addItemListener(this.measureComboBoxItemListener);
        this.useCubeAggChkBox = new JCheckBox(OLAPArb.get("MEASURE_AGGREGATION_RULES_USE_CUBE_AGG"), true);
        this.useCubeAggChkBox.setName("useCubeAggChkBox");
        this.useCubeAggChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CubeMeasureAggregationPanel.this.useCubeAggChkBox.isSelected();
                CubeMeasureAggregationPanel.this.aggregationOperatorPanel.setEnablePanel(!bl);
                CubeMeasureAggregationPanel.this.aggregationHierarchyPanel.setEnablePanel(!bl);
                if (bl) {
                    Cube cube = (Cube)CubeMeasureAggregationPanel.this.getUpdatedObject();
                    String string = cube.getConsistentSolveSpec();
                    CubeMeasureAggregationPanel.this.initAggPanels(string);
                }
            }
        });
        int n = 0;
        this.add(jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.measureComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.useCubeAggChkBox, new GridBagConstraints(0, ++n, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, ++n, 4, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.aggregationOperatorPanel, new GridBagConstraints(0, ++n, 4, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, ++n, 4, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.aggregationHierarchyPanel, new GridBagConstraints(0, ++n, 4, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void saveMeasureCSS(String string) {
        if (string != null) {
            String string2 = null;
            if (!this.useCubeAggChkBox.isSelected()) {
                string2 = this.getConsistentSolveSpec();
            }
            this.mapMeasureCSS.put(string, string2);
        }
    }

    private void setEnablePanel(boolean bl) {
        this.isPanelEnabled = bl;
        this.measureComboBox.setEnabled(bl);
        this.useCubeAggChkBox.setEnabled(bl);
        boolean bl2 = this.useCubeAggChkBox.isSelected();
        this.aggregationOperatorPanel.setEnablePanel(bl && !bl2);
        this.aggregationHierarchyPanel.setEnablePanel(bl && !bl2);
    }
}

