/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.metadata.CubePartitionSupport;
import oracle.olap.app.olapmetadata.DimensionAWObjects;
import oracle.olap.app.ui.MultiLineTextArea;
import oracle.olap.app.util.CursorUtil;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.cube.panels.CubePartitionPanel;
import oracle.olap.cube.partition.CubeHierarchyOrderDialog;
import oracle.olap.cube.partition.CubePartitionMemberAnalysisPanel;
import oracle.olap.cube.partition.CubePartitionOrderPanel;
import oracle.olap.cube.partition.CubePartitionPrecomputePanel;
import oracle.olap.cube.partition.DisplayPartitionMemberContents;
import oracle.olap.cube.partition.ManagePartitionSelectionPanel;
import oracle.olap.cube.partition.OrderedPanel;
import oracle.olap.cube.partition.PanelComponentUIHelper;
import oracle.olap.cube.partition.model.HierarchyLevelWrapper;
import oracle.olap.cube.partition.model.PartitionConstructModelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelMetadataHelper;
import oracle.olap.cube.partition.model.PrecomputeSelection;
import oracle.olap.statistics.cubedimension.HierarchyLevelDistinctCounts;

public class MainPartitionPanel
extends JPanel
implements OrderedPanel {
    private JTabbedPane partitionPanels;
    private CubePartitionPanel partitionPropertyPanel;
    private ManagePartitionSelectionPanel managePartitionSelectionPanel;
    private CubePartitionPrecomputePanel precomputePanel;
    private CubePartitionOrderPanel partitionOrderPanel;
    private CubePartitionMemberAnalysisPanel partitionMemberAnalysisPanel;
    private JCheckBox partitionCheckBox;
    private MultiLineTextArea m_partitionCubeMutliLineTextArea;
    private JLabel dimensionLabel;
    private JComboBox dimensionComboBox;
    private DefaultComboBoxModel dimensionComboBoxModel;
    private JButton hierarchyOrderButton;
    private JCheckBox autoManageCheckBox;
    private JButton clearPartitionsButton;
    private JSplitPane splitPane;
    private String currentDimensionName;
    private int maxPartitionSelections = 1;
    private boolean isInitialising = false;
    private boolean isEditInitializing = false;
    private boolean isSelecting = false;
    private int lastIndex;
    private Resources resources;
    private FetchIcon fetchIcon;
    private ErrorDisplay errorDisplay;
    private List<HierarchyLevelWrapper> lastPartitionAnalysisLevels;
    private String lastPartitionDimensionName;
    private RaptorTask raptorTask;
    private PartitionHierarchyLevelMetadataHelper partitionHierarchyLevelMetadataHelper;
    private PartitionHierarchyLevelHelper partitionHierarchyLevelHelper;
    private PartitionConstructModelHelper partitionConstructModelHelper;
    private DimensionAWObjects dimensionAWObjects;
    public static final int MAX_PARTITION_TIER_1 = 1;
    public static final int MAX_PARTITION_TIER_2 = 4;
    public static final int MAX_PARTITION_TIER_3 = 256;
    public static final int SELECT_PARTITIONS_TAB = 0;
    public static final int PARTITION_MEMBER_ANALYSIS_TAB = 1;
    public static final int UNDERSTANDING_PARTITION_TAB = 2;

    public MainPartitionPanel(CubePartitionPanel cubePartitionPanel, Resources resources, FetchIcon fetchIcon, ErrorDisplay errorDisplay) {
        this.partitionPropertyPanel = cubePartitionPanel;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.errorDisplay = errorDisplay;
        this.jbInit();
    }

    public void precomputePanelStopEditting() {
        this.precomputePanel.stopEditing();
    }

    public String getPartitionDimensionName() {
        return this.currentDimensionName;
    }

    public String getOwner() {
        return this.partitionPropertyPanel.getOwner();
    }

    public PartitionHierarchyLevelHelper getPartitionHierarchyLevelHelper() {
        return this.partitionHierarchyLevelHelper;
    }

    public PartitionConstructModelHelper getPartitionConstructModelHelper() {
        return this.partitionConstructModelHelper;
    }

    public DimensionAWObjects getDimensionAWObjects() {
        return this.dimensionAWObjects;
    }

    public Connection getConnection() {
        return this.partitionPropertyPanel.getConnection();
    }

    public boolean isCompressed() {
        return this.partitionPropertyPanel.isCompressed();
    }

    public boolean showAutoManagePartitioning() {
        return this.partitionPropertyPanel.showAutoManagePartitioning();
    }

    public boolean allowPrecomputePercentEdit() {
        return this.partitionPropertyPanel.allowPrecomputePercentEdit();
    }

    public int getCurrentPanelIndex() {
        return this.lastIndex;
    }

    public void attachAnalyticWorkspace() {
        String string = this.partitionPropertyPanel.getOwner();
        String string2 = this.partitionPropertyPanel.getAWName();
        String string3 = string + "." + string2;
        try {
            if (!this.isAnalyticWorkspaceAttached()) {
                DatabaseUtils.ExecuteSPL(this.getConnection(), "aw attach " + string3 + " first");
            }
        }
        catch (SQLException sQLException) {
            this.errorDisplay.show(sQLException, this.resources.getString("CUBE.PARTITION.ATTACH.AW.TITLE"), this.resources.getString("CUBE.PARTITION.ATTACH.AW.MSG", string3) + " " + sQLException, this);
        }
        catch (IOException iOException) {
            this.errorDisplay.show(iOException, this.resources.getString("CUBE.PARTITION.ATTACH.AW.TITLE"), this.resources.getString("CUBE.PARTITION.ATTACH.AW.MSG", string3) + " " + iOException, this);
        }
    }

    public void detachAnalyticWorkspace() {
        String string = this.partitionPropertyPanel.getOwner();
        String string2 = this.partitionPropertyPanel.getAWName();
        String string3 = string + "." + string2;
        try {
            if (this.isAnalyticWorkspaceAttached()) {
                DatabaseUtils.ExecuteSPL(this.getConnection(), "aw detach " + string3);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isAnalyticWorkspaceAttached() {
        boolean bl = false;
        String string = this.partitionPropertyPanel.getOwner();
        String string2 = this.partitionPropertyPanel.getAWName();
        String string3 = string + "." + string2;
        try {
            String string4 = DatabaseUtils.ExecuteSPL(this.getConnection(), "show aw (attached '" + string3 + "')");
            if (string4.toUpperCase().equals("YES")) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public void updatePanelsOnReEntry(List<String> list) {
        this.partitionCheckBox.setEnabled(true);
        this.isInitialising = true;
        this.dimensionComboBoxModel.removeAllElements();
        list = this.partitionPropertyPanel.filterDimensionList(list);
        for (String string : list) {
            this.dimensionComboBoxModel.addElement(string);
        }
        this.dimensionComboBoxModel.addElement(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
        this.isInitialising = false;
        if (!this.partitionCheckBox.isSelected()) {
            this.enableUI(false);
            this.dimensionComboBox.setSelectedItem(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
        } else if (list.contains(this.currentDimensionName)) {
            this.isEditInitializing = true;
            this.dimensionComboBox.setSelectedItem(this.currentDimensionName);
            this.isEditInitializing = false;
        } else if (this.dimensionComboBoxModel.getSize() > 0) {
            this.isEditInitializing = true;
            this.dimensionComboBox.setSelectedItem(list.get(0));
            this.isEditInitializing = false;
            if (!this.partitionCheckBox.isSelected()) {
                this.enableUI(false);
            }
        } else {
            this.currentDimensionName = null;
            this.dimensionComboBox.setSelectedItem(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
            ArrayList arrayList = new ArrayList();
            this.managePartitionSelectionPanel.initializePartitionSelections(null, arrayList);
            this.enableUI(true);
            this.precomputePanel.clearCache();
            this.managePartitionSelectionPanel.showSelectedDimension(null, false);
            this.precomputePanel.populateTable(arrayList);
            this.partitionCheckBox.setSelected(false);
            this.partitionCheckBox.setEnabled(false);
            this.enableUI(false);
        }
    }

    public void initialisePanels(CubePartitionSupport cubePartitionSupport) {
        this.lastIndex = -1;
        this.partitionCheckBox.setEnabled(true);
        this.hierarchyOrderButton.setEnabled(true);
        this.autoManageCheckBox.setSelected(true);
        this.lastPartitionAnalysisLevels = new ArrayList<HierarchyLevelWrapper>();
        this.lastPartitionDimensionName = null;
        this.partitionHierarchyLevelMetadataHelper = this.partitionPropertyPanel.getPartitionHierarchyLevelMetadataHelper();
        this.partitionHierarchyLevelHelper = this.partitionPropertyPanel.getPartitionHierarchyLevelHelper();
        this.partitionConstructModelHelper = this.partitionPropertyPanel.getPartitionConstructModelHelper();
        this.dimensionAWObjects = this.partitionPropertyPanel.getDimensionAWObjects();
        this.managePartitionSelectionPanel.setPartitionHierarchyLevelMetadataHelper(this.partitionHierarchyLevelMetadataHelper);
        this.managePartitionSelectionPanel.setPartitionHierarchyLevelHelper(this.partitionHierarchyLevelHelper);
        this.partitionMemberAnalysisPanel.setPartitionHierarchyLevelHelper(this.partitionHierarchyLevelHelper);
        if (this.showAutoManagePartitioning()) {
            this.autoManageCheckBox.setVisible(true);
        } else {
            this.autoManageCheckBox.setVisible(false);
        }
        this.partitionOrderPanel.setVisible(false);
        this.partitionPanels.setSelectedIndex(0);
        this.isInitialising = true;
        this.dimensionComboBoxModel.removeAllElements();
        List<String> list = this.partitionPropertyPanel.getDimensionNames();
        list = this.partitionPropertyPanel.filterDimensionList(list);
        for (String string : list) {
            this.dimensionComboBoxModel.addElement(string);
        }
        this.dimensionComboBoxModel.addElement(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
        this.isInitialising = false;
        this.maxPartitionSelections = this.partitionPropertyPanel.determineMaxNumberOfPartitions();
        if (this.maxPartitionSelections == 1) {
            this.m_partitionCubeMutliLineTextArea.setText(this.resources.getString("MODELER.CUBE.PARTITION.DIM.DESC_TIER_1"));
        } else if (this.maxPartitionSelections == 4) {
            this.m_partitionCubeMutliLineTextArea.setText(this.resources.getString("MODELER.CUBE.PARTITION.DIM.DESC_TIER_2"));
        } else {
            this.m_partitionCubeMutliLineTextArea.setText(this.resources.getString("MODELER.CUBE.PARTITION.DIM.DESC_TIER_3"));
        }
        if (this.partitionPropertyPanel.isCreate()) {
            this.initializeOnCreate(cubePartitionSupport, list);
        } else {
            this.initializeOnEdit(cubePartitionSupport, list);
        }
    }

    private void initializeOnCreate(CubePartitionSupport cubePartitionSupport, List<String> list) {
        if (list.size() > 0) {
            this.currentDimensionName = this.partitionPropertyPanel.getDefaultPartitionDimension();
            this.dimensionComboBox.setSelectedItem(this.currentDimensionName);
            List<HierarchyLevelWrapper> list2 = this.partitionPropertyPanel.getDefaultPartitions(this.currentDimensionName);
            this.managePartitionSelectionPanel.initializePartitionSelections(this.currentDimensionName, list2);
            this.managePartitionSelectionPanel.showSelectedDimension(this.currentDimensionName, true);
            this.precomputePanel.populateTable(list2);
            this.managePartitionSelectionPanel.refreshPartitionLevelNames();
            this.enableUI(true);
        } else {
            this.currentDimensionName = null;
            this.dimensionComboBox.setSelectedItem(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
            ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
            this.managePartitionSelectionPanel.initializePartitionSelections(null, arrayList);
            this.enableUI(true);
            this.precomputePanel.clearCache();
            this.managePartitionSelectionPanel.showSelectedDimension(null, false);
            this.precomputePanel.populateTable(arrayList);
            this.partitionCheckBox.setSelected(false);
            this.partitionCheckBox.setEnabled(false);
            this.enableUI(false);
        }
        this.splitPane.setDividerLocation(175);
    }

    private void initializeOnEdit(CubePartitionSupport cubePartitionSupport, List<String> list) {
        this.cleanup();
        this.splitPane.setDividerLocation(this.calculateDividerLocation());
        this.isEditInitializing = true;
        this.currentDimensionName = null;
        if (cubePartitionSupport.isPartitioned()) {
            this.partitionCheckBox.setSelected(true);
            this.enableUI(true);
            String string = null;
            for (String object2 : list) {
                if (!object2.equals(cubePartitionSupport.getPartitionDimensionName())) continue;
                string = object2;
            }
            List<HierarchyLevelWrapper> list2 = this.partitionPropertyPanel.getSelectedPartitionsOnEdit();
            this.managePartitionSelectionPanel.initializePartitionSelections(string, list2);
            List<PrecomputeSelection> list3 = cubePartitionSupport.getSecondaryLevelPrecomputeValues();
            if (string != null) {
                this.precomputePanel.initializeCache(string, list3);
                this.dimensionComboBox.setSelectedItem(string);
                if (this.managePartitionSelectionPanel.arePartitionSelectionsCustom()) {
                    this.autoManageCheckBox.setSelected(false);
                    this.partitionOrderPanel.setVisible(true);
                    this.hierarchyOrderButton.setEnabled(false);
                    this.managePartitionSelectionPanel.showAutomaticPartitionOrder();
                }
            }
        } else {
            ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
            this.managePartitionSelectionPanel.initializePartitionSelections(null, arrayList);
            this.enableUI(true);
            this.precomputePanel.clearCache();
            this.dimensionComboBox.setSelectedItem(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
            if (list.size() == 0) {
                this.managePartitionSelectionPanel.showSelectedDimension(null, false);
                this.precomputePanel.populateTable(arrayList);
                this.partitionCheckBox.setSelected(false);
                this.partitionCheckBox.setEnabled(false);
            }
            this.partitionCheckBox.setSelected(false);
            this.enableUI(false);
        }
        this.isEditInitializing = false;
    }

    public List<HierarchyLevelWrapper> getPartitionSelections() {
        return this.managePartitionSelectionPanel.getPartitionSelections();
    }

    public Object getSelectedDimension() {
        return this.dimensionComboBox.getSelectedItem();
    }

    public void populatePartitionTable(List<HierarchyLevelWrapper> list) {
        this.precomputePanel.populateTable(list);
    }

    public void refreshPartitionLevelNames(List<HierarchyLevelWrapper> list, List<String> list2) {
        this.precomputePanel.refreshPartitionLevelNames(list, list2);
    }

    public void reorderPartitionSelections(List<String> list) {
        this.managePartitionSelectionPanel.reorderPartitionSelections(list);
    }

    @Override
    public void upArrowSelected() {
        this.precomputePanel.upArrowSelected();
    }

    @Override
    public void downArrowSelected() {
        this.precomputePanel.downArrowSelected();
    }

    public boolean isPartitioned() {
        String string = (String)this.dimensionComboBoxModel.getSelectedItem();
        return !string.equalsIgnoreCase(this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"));
    }

    public void setPartitionCheckBox(boolean bl) {
        this.partitionCheckBox.setSelected(bl);
    }

    public boolean autoManagePartitionOrder() {
        return this.autoManageCheckBox.isSelected();
    }

    public void fieldValueChanged() {
        this.partitionPropertyPanel.fieldValueChanged();
    }

    public int getMaxNumberOfPartitions() {
        return this.maxPartitionSelections;
    }

    public void enableUI(boolean bl) {
        this.dimensionComboBox.setEnabled(true);
        this.partitionCheckBox.setSelected(bl);
        this.autoManageCheckBox.setEnabled(bl);
        this.managePartitionSelectionPanel.enableUI(bl);
        this.precomputePanel.enableUI(bl);
        this.clearPartitionsButton.setEnabled(bl);
        this.partitionPanels.setEnabledAt(1, bl);
        if (bl) {
            if (this.autoManageCheckBox.isSelected()) {
                this.hierarchyOrderButton.setEnabled(true);
            } else {
                this.hierarchyOrderButton.setEnabled(false);
            }
        } else {
            this.hierarchyOrderButton.setEnabled(false);
        }
    }

    public void setAutoCheckBoxSelected(boolean bl) {
        this.isSelecting = true;
        this.autoManageCheckBox.setSelected(bl);
        this.isSelecting = false;
        if (this.autoManageCheckBox.isSelected()) {
            this.partitionOrderPanel.setVisible(false);
            this.hierarchyOrderButton.setEnabled(true);
            if (!this.isEditInitializing && !this.isInitialising) {
                this.fieldValueChanged();
            }
        } else {
            this.partitionOrderPanel.setVisible(true);
            this.hierarchyOrderButton.setEnabled(false);
        }
    }

    private static Rectangle centerWindow(Component component, int n, int n2) {
        double d = component.getX();
        double d2 = component.getY();
        double d3 = component.getWidth();
        double d4 = component.getHeight();
        int n3 = (int)(d + (d3 - (double)n) / 2.0);
        int n4 = (int)(d2 + (d4 - (double)n2) / 2.0);
        if (n3 < 0) {
            n3 = 10;
        }
        if (n4 < 0) {
            n4 = 10;
        }
        return new Rectangle(n3, n4, n, n2);
    }

    private int calculateDividerLocation() {
        double d = 600.0;
        int n = (int)(d / 3.5);
        return n;
    }

    public void cleanup() {
        this.partitionPropertyPanel.cleanup();
    }

    public List<String> getAggregatedHierarchies(String string) {
        return this.partitionPropertyPanel.getAggregatedHierarchies(string);
    }

    public int getPrecomputeForHierarchyLevel(HierarchyLevelWrapper hierarchyLevelWrapper) {
        return this.precomputePanel.getPrecomputeForHierarchyLevel(hierarchyLevelWrapper);
    }

    public void showQueryCounts() {
        this.raptorTask = new RaptorTask(this.resources.getString("CUBE_PARTITION_GET_PARTITION_COUNT_MSG"), true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    MainPartitionPanel.this.showQueryCountsImpl();
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        this.raptorTask.setCancellable(false);
        this.raptorTask.setPausable(false);
        this.raptorTask.setMessage(this.resources.getString("CUBE_PARTITION_GET_PARTITION_COUNT_MSG"));
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(this.raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showQueryCountsImpl() {
        if (this.currentDimensionName != null) {
            HierarchyLevelDistinctCounts hierarchyLevelDistinctCounts = this.partitionPropertyPanel.getHierarchyLevelDistinctCounts();
            HashMap<String, Integer> hashMap = null;
            Integer[] integerArray = null;
            List<String> list = this.partitionPropertyPanel.getHierarchyNames(this.currentDimensionName);
            for (String string : list) {
                try {
                    CursorUtil.setBusyCursor(this);
                    this.raptorTask.setMessage(this.resources.getString("CUBE_PARTITION_GET_PARTITION_COUNT_FOR_HIERARCHY_MSG", string));
                    integerArray = this.managePartitionSelectionPanel.getQueryCounts(string);
                    if (integerArray == null) {
                        int n = this.partitionPropertyPanel.getNumberOfHierarchyLevels(this.currentDimensionName, string);
                        integerArray = new Integer[n];
                        hashMap = hierarchyLevelDistinctCounts.getHierarchyLevelDistinctCounts(this.partitionPropertyPanel.getOwner(), this.partitionPropertyPanel.getHierarchyViewName(this.currentDimensionName, string), this.partitionPropertyPanel.getHierarchyLevelNames(this.currentDimensionName, string));
                        int n2 = 0;
                        List<String> list2 = this.partitionPropertyPanel.getHierarchyLevelNames(this.currentDimensionName, string);
                        for (String string2 : list2) {
                            integerArray[n2] = hashMap.get(string2);
                            ++n2;
                        }
                    }
                    this.managePartitionSelectionPanel.showQueryCounts(string, integerArray);
                }
                catch (SQLException sQLException) {
                    this.errorDisplay.show(sQLException, this.resources.getString("CUBE.PARTITION.QUERY.DISTINCT.MEMBER.COUNT.ERROR.TITLE"), this.resources.getString("CUBE.PARTITION.QUERY.DISTINCT.MEMBER.COUNT.ERROR.MSG") + sQLException, this);
                }
                finally {
                    CursorUtil.setDefaultCursor(this);
                }
            }
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.fill = 2;
        this.partitionPanels = new JTabbedPane();
        PanelComponentUIHelper panelComponentUIHelper = new PanelComponentUIHelper(this.resources);
        ++gridBagConstraints.gridy;
        this.partitionCheckBox = panelComponentUIHelper.newJCheckBox("MODELER.CUBE.PARTITION.CHECK_BOX.PARTITION.LABEL");
        ++gridBagConstraints.gridy;
        JPanel jPanel = this.constructMainPartitionTabbedPanel();
        this.partitionMemberAnalysisPanel = new CubePartitionMemberAnalysisPanel(this, this.partitionHierarchyLevelHelper, this.resources, this.errorDisplay);
        this.partitionPanels.add(this.resources.getString("MODELER.CUBE.PARTITION.TAB.SELECT_PARTITIONS"), jPanel);
        this.partitionPanels.add(this.resources.getString("MODELER.CUBE.PARTITION.TAB.MEMBER_ANALYSIS"), this.partitionMemberAnalysisPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.partitionPanels, gridBagConstraints);
        this.partitionPanels.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = MainPartitionPanel.this.partitionPanels.getSelectedIndex();
                if (MainPartitionPanel.this.lastIndex == 1 && n != 1) {
                    MainPartitionPanel.this.cleanup();
                }
                if (n == 1) {
                    if (MainPartitionPanel.this.getPartitionSelections().size() == 0) {
                        if (MainPartitionPanel.this.lastIndex != -1) {
                            MainPartitionPanel.this.partitionPanels.setSelectedIndex(MainPartitionPanel.this.lastIndex);
                        } else {
                            MainPartitionPanel.this.partitionPanels.setSelectedIndex(0);
                        }
                        JOptionPane.showMessageDialog(MainPartitionPanel.this, MainPartitionPanel.this.resources.getString("MODELER.CUBE.PARTITION.NO_PARTITIONS_SELECTED.MSG"), MainPartitionPanel.this.resources.getString("MODELER.CUBE.PARTITION.NO_PARTITIONS_SELECTED.TITLE"), 1);
                        return;
                    }
                    MainPartitionPanel.this.attachAnalyticWorkspace();
                    if (!MainPartitionPanel.this.arePartitionLevelsEqual(MainPartitionPanel.this.lastPartitionAnalysisLevels, MainPartitionPanel.this.getPartitionSelections())) {
                        DisplayPartitionMemberContents displayPartitionMemberContents = new DisplayPartitionMemberContents(MainPartitionPanel.this.partitionPropertyPanel, MainPartitionPanel.this.partitionMemberAnalysisPanel, MainPartitionPanel.this.resources, MainPartitionPanel.this.errorDisplay, MainPartitionPanel.this.getOwner(), MainPartitionPanel.this.currentDimensionName, MainPartitionPanel.this.getPartitionSelections(), MainPartitionPanel.this.partitionConstructModelHelper);
                        displayPartitionMemberContents.displayPartitionMemberDetails();
                        MainPartitionPanel.this.lastPartitionAnalysisLevels = MainPartitionPanel.this.getPartitionSelections();
                        MainPartitionPanel.this.lastPartitionDimensionName = MainPartitionPanel.this.currentDimensionName;
                    }
                }
                MainPartitionPanel.this.lastIndex = n;
            }
        });
    }

    private boolean arePartitionLevelsEqual(List<HierarchyLevelWrapper> list, List<HierarchyLevelWrapper> list2) {
        boolean bl = true;
        if (this.currentDimensionName == null || !this.currentDimensionName.equalsIgnoreCase(this.lastPartitionDimensionName)) {
            bl = false;
        } else if (list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                HierarchyLevelWrapper hierarchyLevelWrapper = list.get(i);
                HierarchyLevelWrapper hierarchyLevelWrapper2 = list2.get(i);
                if (hierarchyLevelWrapper.getHierarchyName().equalsIgnoreCase(hierarchyLevelWrapper2.getHierarchyName()) && hierarchyLevelWrapper.getLevelName().equalsIgnoreCase(hierarchyLevelWrapper2.getLevelName())) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private JPanel constructMainPartitionTabbedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        this.m_partitionCubeMutliLineTextArea = new MultiLineTextArea(this.resources.getString("MODELER.CUBE.PARTITION.DIM.DESC"), 2, 60);
        PanelComponentUIHelper panelComponentUIHelper = new PanelComponentUIHelper(this.resources);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.m_partitionCubeMutliLineTextArea);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        String string = "MODELER.CUBE.PARTITION.SELECTION_DIMENSION_LABEL";
        this.dimensionLabel = panelComponentUIHelper.newJLabel(string);
        jPanel3.add((Component)this.dimensionLabel, gridBagConstraints2);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.dimensionComboBoxModel = new DefaultComboBoxModel();
        this.dimensionComboBox = new JComboBox(this.dimensionComboBoxModel);
        this.dimensionLabel.setLabelFor(this.dimensionComboBox);
        jPanel3.add((Component)this.dimensionComboBox, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.managePartitionSelectionPanel = new ManagePartitionSelectionPanel(this, this.partitionHierarchyLevelMetadataHelper, this.partitionHierarchyLevelHelper, this.resources);
        this.precomputePanel = new CubePartitionPrecomputePanel(this, this.resources);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        JLabel jLabel = panelComponentUIHelper.newJLabel("MODELER.CUBE.PARTITION.SELECTION_HIERARCHY_LABEL");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.hierarchyOrderButton = panelComponentUIHelper.newJButton("MODELER.CUBE.PARTITION.ORDER_HIERARCHIES_LABEL");
        this.clearPartitionsButton = panelComponentUIHelper.newJButton("MODELER.CUBE.PARTITION.CLEAR_SELETIONS_LABEL");
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)this.hierarchyOrderButton);
        buttonBar.add((Component)this.clearPartitionsButton);
        jPanel.add((Component)buttonBar, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.managePartitionSelectionPanel);
        this.partitionOrderPanel = new CubePartitionOrderPanel(this, this.fetchIcon);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBackground(Color.WHITE);
        jPanel4.add((Component)this.precomputePanel, "Center");
        jPanel4.add((Component)this.partitionOrderPanel, "East");
        this.partitionOrderPanel.setVisible(false);
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(0);
        this.splitPane.setTopComponent(jScrollPane);
        this.splitPane.setBottomComponent(jPanel4);
        this.splitPane.setDividerLocation(175);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.splitPane, gridBagConstraints);
        this.autoManageCheckBox = panelComponentUIHelper.newJCheckBox("MODELER.CUBE.PARTITION.AUTOMATICALLY_MANAGE_ORDER_LABEL");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        jPanel.add((Component)this.autoManageCheckBox, gridBagConstraints);
        this.dimensionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPartitionPanel.this.isInitialising) {
                    return;
                }
                String string = (String)MainPartitionPanel.this.dimensionComboBox.getSelectedItem();
                if (!MainPartitionPanel.this.isEditInitializing) {
                    MainPartitionPanel.this.fieldValueChanged();
                }
                if (string.equalsIgnoreCase(MainPartitionPanel.this.resources.getString("MODELER.CUBE.PARTITION.NONE.SELECTION"))) {
                    MainPartitionPanel.this.precomputePanel.populateTable(new ArrayList<HierarchyLevelWrapper>());
                    MainPartitionPanel.this.enableUI(false);
                    return;
                }
                MainPartitionPanel.this.enableUI(true);
                if (MainPartitionPanel.this.currentDimensionName != null) {
                    MainPartitionPanel.this.precomputePanel.cacheCurrentSelections(MainPartitionPanel.this.currentDimensionName);
                }
                MainPartitionPanel.this.managePartitionSelectionPanel.showSelectedDimension(string, MainPartitionPanel.this.isEditInitializing);
                List<HierarchyLevelWrapper> list = MainPartitionPanel.this.managePartitionSelectionPanel.getPartitionSelections();
                MainPartitionPanel.this.precomputePanel.populateTable(list);
                MainPartitionPanel.this.precomputePanel.restoreCachedSelections(string);
                MainPartitionPanel.this.managePartitionSelectionPanel.refreshPartitionLevelNames();
                MainPartitionPanel.this.currentDimensionName = string;
                MainPartitionPanel.this.showQueryCounts();
            }
        });
        this.autoManageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainPartitionPanel.this.isSelecting) {
                    MainPartitionPanel.this.managePartitionSelectionPanel.showAutomaticPartitionOrder();
                    MainPartitionPanel.this.setAutoCheckBoxSelected(MainPartitionPanel.this.autoManageCheckBox.isSelected());
                }
            }
        });
        this.hierarchyOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPartitionPanel.this.currentDimensionName != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    List<String> list = MainPartitionPanel.this.getAggregatedHierarchies(MainPartitionPanel.this.currentDimensionName);
                    for (String object2 : MainPartitionPanel.this.managePartitionSelectionPanel.getOrderedHierarchies()) {
                        if (!list.contains(object2)) continue;
                        arrayList.add(object2);
                    }
                    CubeHierarchyOrderDialog cubeHierarchyOrderDialog = new CubeHierarchyOrderDialog(MainPartitionPanel.this.partitionPropertyPanel.getFrame(), MainPartitionPanel.this.resources.getString("MODELER.CUBE.PARTITION.ORDER_HIERARCHIES.TITLE"), arrayList, MainPartitionPanel.this.managePartitionSelectionPanel, MainPartitionPanel.this.resources, MainPartitionPanel.this.fetchIcon);
                    Rectangle rectangle = MainPartitionPanel.centerWindow(MainPartitionPanel.this.partitionPropertyPanel.getFrame(), 350, 400);
                    cubeHierarchyOrderDialog.setBounds(rectangle);
                    cubeHierarchyOrderDialog.setVisible(true);
                    MainPartitionPanel.this.grabFocus();
                }
            }
        });
        this.clearPartitionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPartitionPanel.this.managePartitionSelectionPanel.clearSelections()) {
                    MainPartitionPanel.this.fieldValueChanged();
                }
            }
        });
        return jPanel;
    }
}

