/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubexml.CubeDimensionXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;

public class CubeDimensionBuilder
extends AbstractOLAPDBObjectBuilder<CubeDimension> {
    public CubeDimensionBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "CUBE DIMENSION");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public CubeDimension createObject(String string, Schema schema, DBObjectID dBObjectID) {
        CubeDimension cubeDimension = new CubeDimension();
        cubeDimension.setName(string);
        cubeDimension.setSchema(schema);
        cubeDimension.setID(dBObjectID);
        return cubeDimension;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "analyticWorkspace"})
    public void buildProperties(final CubeDimension cubeDimension) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select aw_name, dimension_type, default_hierarchy_name, description from all_cube_dimensions  where dimension_name = ? and owner = ?", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        try {
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            String string = resultSet.getString(1);
                            String string2 = resultSet.getString(2);
                            String string3 = resultSet.getString(3);
                            String string4 = resultSet.getString(4);
                            cubeDimension.setDescription(string4);
                            cubeDimension.setAnalyticWorkspace(string);
                            cubeDimension.setDimensionDefaultHierarchyName(string3);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                    }
                }
            });
        }
        catch (DBException dBException) {
            System.out.println(dBException.toString());
            throw dBException;
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"shortDescription", "longDescription", "dimensionType", "levels", "hierarchies", "attributes", "hierarchyDefault"})
    public void buildDetails(CubeDimension cubeDimension) throws DBException, SQLException, IOException, JAXBException {
        Database database = (Database)this.getProvider();
        cubeDimension.removeAllAttributes();
        cubeDimension.removeAllHierarchies();
        cubeDimension.removeAllLevels();
        try {
            this.build(cubeDimension);
            String string = cubeDimension.getSchema().getName();
            String string2 = String.format("%s.%s", string, cubeDimension.getName());
            Object object = this.getObject(database.getConnection(), string2);
            MetadataContext metadataContext = new MetadataContext(this.getProvider());
            CubeDimensionXML cubeDimensionXML = new CubeDimensionXML(metadataContext, object, cubeDimension);
            cubeDimensionXML.loadModel();
            cubeDimension.setFullyLoaded(true);
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
            throw dBException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void build(final CubeDimension cubeDimension) throws DBException, SQLException {
        Database database = (Database)this.getProvider();
        cubeDimension.removeAllAttributes();
        cubeDimension.removeAllHierarchies();
        cubeDimension.removeAllLevels();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select level_name from all_cube_dim_levels  where dimension_name = ? and owner = ? order by level_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select hierarchy_name, hierarchy_type from all_cube_hierarchies  where dimension_name = ? and owner = ? order by hierarchy_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select all_cube_hierarchies.hierarchy_name, all_cube_hierarchies.hierarchy_type, \nall_cube_hierarchies.is_ragged, all_cube_hierarchies.is_skip_level, all_cube_hier_views.view_name \nfrom all_cube_hierarchies, all_cube_hier_views \nwhere all_cube_hierarchies.dimension_name = ? and all_cube_hierarchies.owner = ? \nand all_cube_hierarchies.owner = all_cube_hier_views.owner \nand all_cube_hierarchies.dimension_name = all_cube_hier_views.dimension_name\nand all_cube_hierarchies.hierarchy_name = all_cube_hier_views.hierarchy_name\norder by all_cube_hierarchies.owner, all_cube_hierarchies.dimension_name, all_cube_hierarchies.hierarchy_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select hierarchy_name, level_name from all_cube_hier_levels  where dimension_name = ? and owner = ? order by hierarchy_name, order_num desc", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select attribute_name,  data_type  || DECODE(data_type, 'CHAR', '('  || data_length  ||')', 'VARCHAR', '('  || data_length  ||')', 'VARCHAR2', '('  || data_length  ||')', 'NCHAR', '('  || data_length  ||')', 'NVARCHAR', '('  || data_length  ||')', 'NVARCHAR2', '('  || data_length  ||')', 'NUMBER', '('  || NVL(data_precision,data_length)  || DECODE(data_scale,NULL,NULL, ','  ||data_scale)  ||')', NULL) DATATYPE,   attribute_role from all_cube_attributes  where dimension_name = ? and owner = ? order by attribute_name", new Object[]{cubeDimension.getName(), cubeDimension.getSchema()});
        final QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), "select distinct mviews.owner, dimension_name, rewrite_enabled, refresh_method,  fast_refreshable, last_refresh_type  from all_cube_hierarchies ch, all_mviews mviews  where ch.owner = ? and dimension_name = ? and ch.refresh_mview_name = mviews.mview_name", new Object[]{cubeDimension.getSchema(), cubeDimension.getName()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        CubeDimensionLevel cubeDimensionLevel = new CubeDimensionLevel(string);
                        cubeDimension.addLevel(cubeDimensionLevel);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        BigDecimal bigDecimal = resultSet.getBigDecimal(3);
                        BigDecimal bigDecimal2 = resultSet.getBigDecimal(4);
                        String string3 = resultSet.getString(5);
                        CubeDimensionHierarchy cubeDimensionHierarchy = new CubeDimensionHierarchy(string);
                        if (string2.equals("LEVEL")) {
                            cubeDimensionHierarchy.setHierarchyLevelType(true);
                        } else {
                            cubeDimensionHierarchy.setHierarchyValueType(true);
                        }
                        if (bigDecimal.intValue() == 0) {
                            cubeDimensionHierarchy.setNotRagged(true);
                        } else {
                            cubeDimensionHierarchy.setNotRagged(false);
                        }
                        if (bigDecimal2.intValue() == 0) {
                            cubeDimensionHierarchy.setNotSkipLevel(true);
                        } else {
                            cubeDimensionHierarchy.setNotSkipLevel(false);
                        }
                        cubeDimensionHierarchy.setViewName(string3);
                        String string4 = cubeDimension.getDimensionDefaultHierarchyName();
                        if (string4 != null && string4.equals(string)) {
                            cubeDimensionHierarchy.setHierarchyDefault(true);
                        }
                        cubeDimension.addHierarchy(cubeDimensionHierarchy);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeDimensionHierarchy cubeDimensionHierarchy = cubeDimension.findHierarchy(string);
                        CubeDimensionLevel cubeDimensionLevel = cubeDimension.findLevel(string2);
                        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = new CubeDimensionHierarchyLevel(cubeDimensionHierarchy, cubeDimensionLevel);
                        cubeDimensionHierarchy.addHierarchyLevel(cubeDimensionHierarchyLevel);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = CubeDimensionBuilder.getRootDataType(string2);
                        String string4 = resultSet.getString(3);
                        CubeDimensionAttribute cubeDimensionAttribute = new CubeDimensionAttribute(string);
                        cubeDimensionAttribute.setDataType(string3);
                        cubeDimensionAttribute.setRole(string4);
                        cubeDimensionAttribute.setPersistedOrSpecial(true);
                        cubeDimensionAttribute.setOriginalAttributeName(string);
                        cubeDimension.addAttribute(cubeDimensionAttribute);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("dimension_name");
                        cubeDimension.setDimensionMVEnabled(true);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper6.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
    }

    public void buildDependentCubes(final CubeDimension cubeDimension) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select cdy.cube_name cube_name from all_cube_dimensionality cdy  where cdy.owner = ? and cdy.dimension_name = ? order by cube_name", new Object[]{cubeDimension.getSchema(), cubeDimension.getName()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    cubeDimension.setDimensionUsedInCube("FALSE");
                    while (resultSet.next()) {
                        cubeDimension.setDimensionUsedInCube("TRUE");
                        arrayList.add(resultSet.getString(1));
                    }
                    cubeDimension.setDimensionCubeNames(arrayList);
                    DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
                    dependentTransactionalCubes.reset();
                    dependentTransactionalCubes.setDimension(cubeDimension);
                    dependentTransactionalCubes.setDatabaseProvider((OracleDatabaseImpl)CubeDimensionBuilder.this.getProvider());
                    dependentTransactionalCubes.loadMetadata();
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeDimension, sQLException);
                }
            }
        });
    }

    public static String getRootDataType(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL")) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isLetter(c) && !Character.isSpaceChar(c)) continue;
                stringBuffer.append(c);
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        return stringBuffer.toString();
    }
}

