/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.CubeDimensionTypeAndAWPanel;
import oracle.olap.cubedimension.CubeDimensionVerifier;
import oracle.olap.cubedimension.panels.CubeDimensionAttributeTablePanel;
import oracle.olap.cubedimension.panels.CubeDimensionGeneralPanel;
import oracle.olap.cubedimension.panels.CubeDimensionHierarchyTablePanel;
import oracle.olap.cubedimension.panels.CubeDimensionLevelTablePanel;
import oracle.olap.cubedimension.panels.CubeDimensionMapPanel;
import oracle.olap.cubedimension.panels.CubeDimensionStoragePanel;
import oracle.olap.cubedimension.panels.OLAPDimensionDDLPanel;
import oracle.olap.cubexml.MultipleObjectDDL;
import oracle.olap.db.BasePanelLibrary;
import oracle.olap.db.CubeSQL;

public class CubeDimensionPanelLibrary
extends BasePanelLibrary {
    private static final String GENERAL = OLAPArb.get("GENERAL.TITLE");
    private static final String LEVELS = OLAPArb.get("LEVELS.TITLE");
    private static final String HIERARCHIES = OLAPArb.get("HIERARCHIES_TITLE");
    private static final String ATTRIBUTES = OLAPArb.get("ATTRIBUTES_TITLE");
    private static final String STORAGE = OLAPArb.get("STORAGE.TITLE");
    private static final String DESCRIPTION = OLAPArb.get("DESCRIPTIONS.TITLE");
    private static final String MAP = OLAPArb.get("MAP.TITLE");

    public CubeDimensionPanelLibrary() {
        super("CUBE DIMENSION");
        this.addPanel(GENERAL, CubeDimensionGeneralPanel.class, "olap_create_cube_dimension_general", new String[0]);
        Navigable navigable = this.addPanel(LEVELS, CubeDimensionLevelTablePanel.class, "olap_create_cube_dimension_levels", new String[0]);
        navigable.addChildNavigable(null);
        navigable = this.addPanel(HIERARCHIES, CubeDimensionHierarchyTablePanel.class, "olap_create_cube_dimension_hierarchies", new String[0]);
        navigable = this.addPanel(ATTRIBUTES, CubeDimensionAttributeTablePanel.class, "olap_create_cube_dimension_attributes", new String[0]);
        navigable = this.addPanel(STORAGE, CubeDimensionStoragePanel.class, "olap_create_cube_dimension_storage", new String[0]);
        navigable = this.addPanel(MAP, CubeDimensionMapPanel.class, "olap_create_cube_dimension_map", new String[0]);
    }

    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(LEVELS);
        arrayList.add(HIERARCHIES);
        arrayList.add(ATTRIBUTES);
        arrayList.add(STORAGE);
        arrayList.add(MAP);
        return arrayList;
    }

    protected List<String> getSimpleTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(LEVELS);
        arrayList.add(HIERARCHIES);
        arrayList.add(ATTRIBUTES);
        arrayList.add(STORAGE);
        arrayList.add(MAP);
        return arrayList;
    }

    public String getCreateTitle() {
        return OLAPArb.get("CUBE_DIMENSION_CREATE_TITLE");
    }

    public String getEditTitle() {
        return OLAPArb.get("CUBE_DIMENSION_EDIT_TITLE");
    }

    public boolean canEditObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return true;
    }

    @Override
    protected void alterOLAPObject(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2) throws DBException {
        DDL dDL = null;
        DDLGenerator dDLGenerator = dDLDatabase.getDDLGenerator();
        Object var7_7 = null;
        DDLDatabase dDLDatabase2 = dDLDatabase;
        ResultSet resultSet = dDLDatabase2.getDiffEngine().diff((Object)systemObject, (Object)systemObject2).getResult();
        try {
            dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), (Difference)resultSet);
        }
        catch (UnsupportedDDLException unsupportedDDLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).severe(unsupportedDDLException.getLocalizedMessage());
            return;
        }
        DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
        if (dependentTransactionalCubes.areUpdatedCubes(systemObject, systemObject2)) {
            List<MultipleObjectDDL> list = dependentTransactionalCubes.getCubeDDLStatements(systemObject, systemObject2);
            MultipleObjectDDL multipleObjectDDL = new MultipleObjectDDL(systemObject, systemObject2, dDL.getStatements());
            list.add(0, multipleObjectDDL);
            this.executeMany(dDLDatabase, bl, list);
            List<Cube> list2 = dependentTransactionalCubes.getOriginalCubes();
            List<Cube> list3 = dependentTransactionalCubes.getUpdatedCubesWithHierLevelEdits();
            this.finishCubeUpdates(dDLDatabase, list2, list3);
        } else {
            this.execute(dDL, dDLDatabase, bl, systemObject, systemObject2);
        }
    }

    private void execute(DDL dDL, DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2) throws DBException {
        Collection collection = dDL.getStatements();
        CubeSQL cubeSQL = new CubeSQL(dDLDatabase, bl, systemObject, systemObject2, collection, true);
        Map<String, Object> map = this.getProperties();
        cubeSQL.setProperties(map);
        if (collection.size() > 0) {
            cubeSQL.execute();
        }
    }

    private void executeMany(DDLDatabase dDLDatabase, boolean bl, List<MultipleObjectDDL> list) throws DBException {
        CubeSQL cubeSQL = new CubeSQL(dDLDatabase, bl, list, true);
        Map<String, Object> map = this.getProperties();
        cubeSQL.setProperties(map);
        cubeSQL.execute();
    }

    private void finishCubeUpdates(DDLDatabase dDLDatabase, List<Cube> list, List<Cube> list2) throws DBException {
        if (list.size() > 0 && dDLDatabase instanceof AbstractDatabase) {
            DDLDatabase dDLDatabase2 = dDLDatabase;
            SystemObject[] systemObjectArray = list.toArray(new SystemObject[0]);
            SystemObject[] systemObjectArray2 = list2.toArray(new SystemObject[0]);
            Difference difference = dDLDatabase2.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            dDLDatabase2.finishUpdates(difference);
        }
    }

    protected Map<String, Class> getVerifiers(boolean bl) {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("BaseCubeVerifier", CubeDimensionVerifier.class);
        return hashMap;
    }

    public Class<? extends Traversable> getHeader() {
        return CubeDimensionTypeAndAWPanel.class;
    }

    public Dimension getSize(boolean bl) {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    public Navigable getDDLNavigable() {
        Navigable navigable = super.getDDLNavigable();
        navigable.setHelpID("olap_create_cube_dimension_ddl");
        return navigable;
    }

    @Override
    protected Class<? extends Traversable> getDDLPanel() {
        return OLAPDimensionDDLPanel.class;
    }
}

