/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Ide;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropCascadeAction;
import oracle.olap.actions.DropCascadeConfirmDialog;
import oracle.olap.actions.model.CascadeDeleteDimensionWrapper;
import oracle.olap.actions.model.CascadeDeleteRemovedHierarchyLevel;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.cubexml.MultipleObjectDDL;
import oracle.olap.util.UIUtilities;
import oracle.olapi.syntax.SyntaxObject;

public class CubeDimensionValidator
extends SchemaObjectValidator<CubeDimension>
implements DropCascadeAction {
    private int doCascadeDelete;

    public CubeDimensionValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    public void setUserDeleteChoice(int n) {
        this.doCascadeDelete = n;
    }

    public void validateObjectProperty(CubeDimension cubeDimension, CubeDimension cubeDimension2, String string) throws ValidationException {
        if (cubeDimension2.isSkipValidation()) {
            return;
        }
        if (string.equalsIgnoreCase("analyticWorkspace")) {
            return;
        }
        if (string.toLowerCase().indexOf("description") != -1) {
            return;
        }
        if (string.toLowerCase().indexOf("mapWhereClause") != -1) {
            this.validateWhereClause(cubeDimension, cubeDimension2);
        } else {
            super.validateObjectProperty((DBObject)cubeDimension, (DBObject)cubeDimension2, string);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"attributes"})
    public void validateAttributes(CubeDimension cubeDimension, CubeDimension cubeDimension2) throws ValidationException {
        String string;
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
            if (hashMap.containsKey(cubeDimensionAttribute.getName())) {
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.format("VALIDATION_ERROR_DUPLICATE_ATTRIBUTE_NAME_MSG", cubeDimensionAttribute.getName()));
            }
            hashMap.put(cubeDimensionAttribute.getName(), cubeDimensionAttribute.getName());
        }
        if (cubeDimension2.getDimensionType() != null) {
            boolean bl = false;
            n = 0;
            CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeDimension2.getAttributes();
            int n2 = cubeDimensionAttributeArray.length;
            for (int i = 0; i < n2; ++i) {
                CubeDimensionAttribute cubeDimensionAttribute = cubeDimensionAttributeArray[i];
                string = cubeDimensionAttribute.getRole();
                if (string == null) continue;
                if (string.equalsIgnoreCase("END_DATE")) {
                    if (bl) {
                        throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATE_ATTRIBUTE_ERROR_TOO_MANY_END_DATES"));
                    }
                    bl = true;
                    continue;
                }
                if (!string.equalsIgnoreCase("TIME_SPAN")) continue;
                if (n == 1) {
                    throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATE_ATTRIBUTE_ERROR_TOO_MANY_TIME_SPANS"));
                }
                n = 1;
            }
            if (!bl) {
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATE_ATTRIBUTE_ERROR_MISSING_END_DATE"));
            }
            if (n == 0) {
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATE_ATTRIBUTE_ERROR_MISSING_TIME_SPAN"));
            }
        }
        boolean bl = false;
        n = 0;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension2.getAttributes()) {
            string = cubeDimensionAttribute.getRole();
            if (string == null) continue;
            if (string.equalsIgnoreCase("LONG_DESCRIPTION")) {
                if (bl) {
                    throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATE_ATTRIBUTE_ERROR_TOO_MANY_LONG_DESC"));
                }
                bl = true;
                continue;
            }
            if (!string.equalsIgnoreCase("SHORT_DESCRIPTION")) continue;
            if (n == 1) {
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATE_ATTRIBUTE_ERROR_TOO_MANY_SHORT_DESC"));
            }
            n = 1;
        }
    }

    @DBObjectValidator.PropertyValidator(value={"levels"})
    public void validateLevels(CubeDimension cubeDimension, CubeDimension cubeDimension2) throws ValidationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (CubeDimensionLevel cubeDimensionLevel : cubeDimension2.getLevels()) {
            if (hashMap.containsKey(cubeDimensionLevel.getName())) {
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.format("VALIDATION_ERROR_DUPLICATE_LEVEL_NAME_MSG", cubeDimensionLevel.getName()));
            }
            hashMap.put(cubeDimensionLevel.getName(), cubeDimensionLevel.getName());
        }
    }

    @DBObjectValidator.PropertyValidator(value={"hierarchies"})
    public void validateHierarchies(CubeDimension cubeDimension, CubeDimension cubeDimension2) throws ValidationException {
        for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension2.getHierarchies()) {
            if (!cubeDimensionHierarchy.getHierarchyLevelType() || cubeDimensionHierarchy.getHierarchyLevels().length != 0) continue;
            throw new ValidationException((DBObject)cubeDimension2, OLAPArb.format("VALIDATION_ERROR.NO.LEVELS.IN.HIERARCHY.MSG", cubeDimensionHierarchy.getName()));
        }
        HashMap hashMap = new HashMap();
        for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension2.getHierarchies()) {
            if (hashMap.containsKey(cubeDimensionHierarchy.getName())) {
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.format("VALIDATION_ERROR_DUPLICATE_HIERARCHY_NAME_MSG", cubeDimensionHierarchy.getName()));
            }
            hashMap.put(cubeDimensionHierarchy.getName(), cubeDimensionHierarchy.getName());
        }
        CubeSubDimension[] cubeSubDimensionArray = cubeDimension2.getSortedLevels();
        if (cubeSubDimensionArray == null) {
            throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("VALIDATION_ERROR_LEVELS_CYCLE_HIERARCHY_MSG"));
        }
        if (cubeDimension != null && cubeDimension2 != null) {
            CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray = cubeDimension2.getHierarchies()) {
                CubeDimensionHierarchy cubeDimensionHierarchy2 = cubeDimension.findHierarchy(cubeDimensionHierarchy.getName());
                if (cubeDimensionHierarchy2 == null || cubeDimensionHierarchy2.getHierarchyLevelType() == cubeDimensionHierarchy.getHierarchyLevelType()) continue;
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.format("VALIDATE_HIERARCHY_ERROR_CHANGING_TYPE", cubeDimensionHierarchy.getName()));
            }
        }
        if (cubeDimension != null && cubeDimension2 != null) {
            DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
            if (dependentTransactionalCubes.getWarnedUserOnHierLevelDelete()) {
                return;
            }
            List<CascadeDeleteRemovedHierarchyLevel> list = dependentTransactionalCubes.getRemovedLevelsFromHierarchy((SystemObject)cubeDimension, (SystemObject)cubeDimension2);
            if (list.size() > 0) {
                List<MultipleObjectDDL> list2 = dependentTransactionalCubes.getCubeDDLStatementsNoHierLevel();
                List<MultipleObjectDDL> list3 = dependentTransactionalCubes.getCubeDDLStatements((SystemObject)cubeDimension, (SystemObject)cubeDimension2);
                boolean bl = false;
                if (list2.size() == list3.size()) {
                    Object object;
                    Object object2;
                    Object object3;
                    for (int i = 0; i < list3.size(); ++i) {
                        object3 = list2.get(i);
                        object2 = list3.get(i);
                        object = ((MultipleObjectDDL)object3).getStatements();
                        Collection<String> collection = ((MultipleObjectDDL)object2).getStatements();
                        if (collection.size() <= object.size()) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = dependentTransactionalCubes.getAllRemovedHierarchyLevelDetails(list);
                        object3 = this.getHierarchyLevelsList(list);
                        object2 = new DropCascadeConfirmDialog(this, cascadeDeleteDimensionWrapper, (String)object3, OLAPArb.getString("REMOVE_LEVEL_FROM_HIERARCHY_TITLE"), false, null);
                        object = UIUtilities.centerWindow((Component)Ide.getMainWindow(), 650, 400);
                        ((Window)object2).setBounds((Rectangle)object);
                        ((Dialog)object2).setVisible(true);
                        if (this.doCascadeDelete != 0) {
                            throw new ValidationException((DBObject)cubeDimension2, OLAPArb.getString("USER_DECLINED_HIER_LEVEL_REMOVAL_MSG"));
                        }
                        dependentTransactionalCubes.setWarnedUserOnHierLevelDelete();
                    }
                }
            }
        }
    }

    private String getHierarchyLevelsList(List<CascadeDeleteRemovedHierarchyLevel> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (CascadeDeleteRemovedHierarchyLevel cascadeDeleteRemovedHierarchyLevel : list) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(cascadeDeleteRemovedHierarchyLevel.getHierarchyName() + "." + cascadeDeleteRemovedHierarchyLevel.getLevelName());
            bl = false;
        }
        return stringBuffer.toString();
    }

    @DBObjectValidator.PropertyValidator(value={"mapWhereClause"})
    public void validateWhereClause(CubeDimension cubeDimension, CubeDimension cubeDimension2) throws ValidationException {
        String string = cubeDimension2.getWhereClause();
        if (string != null) {
            try {
                SyntaxObject.fromSyntax((String)string, null);
            }
            catch (Throwable throwable) {
                String string2 = throwable.getMessage();
                throw new ValidationException((DBObject)cubeDimension2, OLAPArb.format("VALIDATION_WHERE_MSG", string2));
            }
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        String string3 = "^\\p{L}[\\p{Alnum}_]*$";
        if (!string2.matches(string3)) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME"));
        }
        if (string2.length() > 30) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME_LENGTH"));
        }
    }

    public void validateName(CubeDimension cubeDimension) throws InvalidNameException {
        String string = "^\\p{L}[\\p{Alnum}_]*$";
        if (!cubeDimension.getName().matches(string)) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME"));
        }
        if (cubeDimension.getName().length() > 30) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME_LENGTH"));
        }
    }
}

