/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cubedimension.CubeDimensionRemoveChildDispatcher;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.ChildObjectEditorPanel2;
import oracle.olap.db.view.DimensionTree;

public class CubeDimensionAttributeEditorPanel
extends ChildObjectEditorPanel2<CubeDimensionAttribute, CubeDimension> {
    private JLabel lblName;
    private DimensionTree visibilityTree;
    private DBObjectProvider prov;
    private DataTypeUI dataTypeUI;
    private JCheckBox indexCheckBox;
    private JCheckBox starCheckBox;
    private JLabel roleLabel;
    private JComboBox roleComboBox;
    private DefaultComboBoxModel roleComboBoxModel;
    private boolean isInitializing = false;
    private boolean initialValueForVisibleToAll = false;
    private TreeSet<CubeDimensionAttribute> invalidAttributes = new TreeSet(new DBObjectComparator());

    public CubeDimensionAttributeEditorPanel() {
        super(CubeDimensionAttributeEditorPanel.class.getName(), "ATTRIBUTE");
        this.layoutComponents();
        CubeDimensionRemoveChildDispatcher cubeDimensionRemoveChildDispatcher = CubeDimensionRemoveChildDispatcher.getInstance();
        cubeDimensionRemoveChildDispatcher.registerObserver(this);
    }

    private void initFromAttributeData(CubeDimensionAttribute cubeDimensionAttribute) {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
        } else {
            CubeDimension cubeDimension = cubeDimensionAttribute.getCubeDimension();
            String string = ((CubeDimensionAttribute)this.getChildObject()).getName();
            if (!this.invalidAttributes.contains(this.getChildObject())) {
                // empty if block
            }
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            childNameObjectEditorContext.setEditingState(0);
            this.isInitializing = true;
            this.loadRoleComboBox(cubeDimension);
            this.isInitializing = false;
            String string2 = cubeDimensionAttribute.getRole();
            String string3 = this.getRoleComboBoxSelection(string2);
            if (cubeDimensionAttribute.getPersistedOrSpecial()) {
                this.enableRoleComboBox(false);
            } else {
                this.enableRoleComboBox(true);
            }
            this.roleComboBox.setSelectedItem(string3);
            String string4 = ((CubeDimensionAttribute)this.getChildObject()).getDataType();
            this.dataTypeUI.setSQLDataType(string4);
            this.visibilityTree.init(cubeDimension);
            this.initialValueForVisibleToAll = cubeDimensionAttribute.isAttributeVisibleForAll();
            if (cubeDimensionAttribute.isAttributeVisibleForAll()) {
                this.visibilityTree.setSelectedAll(true);
            } else {
                for (CubeDimensionLevel cubeSubDimension : cubeDimension.getLevels()) {
                    for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeSubDimension.getVisibleAttributes()) {
                        if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute2.getOriginalAttributeName())) continue;
                        this.visibilityTree.setSelected(cubeSubDimension, true);
                    }
                }
                for (CubeSubDimension cubeSubDimension : cubeDimension.getHierarchies()) {
                    if (((CubeDimensionHierarchy)cubeSubDimension).getHierarchyValueType()) {
                        for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : cubeSubDimension.getVisibleAttributes()) {
                            if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(((CubeDimensionAttribute)abstractChildObjectWithDesc).getOriginalAttributeName())) continue;
                            this.visibilityTree.setSelected(cubeSubDimension, true);
                        }
                        continue;
                    }
                    for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                        for (CubeDimensionAttribute cubeDimensionAttribute3 : ((CubeSubDimension)abstractChildObjectWithDesc).getVisibleAttributes()) {
                            if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute3.getOriginalAttributeName())) continue;
                            this.visibilityTree.setSelected(abstractChildObjectWithDesc, true);
                        }
                    }
                }
            }
            this.visibilityTree.setExpandAll();
            this.indexCheckBox.setSelected(cubeDimensionAttribute.isIndex());
            this.starCheckBox.setSelected(cubeDimensionAttribute.isStar());
            this.dataTypeUI.refreshDataTypeUI();
        }
        this.validate();
        this.repaint();
    }

    private void loadRoleComboBox(CubeDimension cubeDimension) {
        this.roleComboBoxModel.removeAllElements();
        this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_USER"));
        this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG"));
        this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT"));
        if (cubeDimension.getDimensionType() != null && cubeDimension.getDimensionType().equalsIgnoreCase("TIME")) {
            this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE"));
            this.roleComboBoxModel.addElement(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN"));
        }
    }

    private String getRoleComboBoxSelection(String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string = "USER";
        }
        string2 = string.equalsIgnoreCase("LONG_DESCRIPTION") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG") : (string.equalsIgnoreCase("SHORT_DESCRIPTION") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT") : (string.equalsIgnoreCase("END_DATE") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE") : (string.equalsIgnoreCase("TIME_SPAN") ? OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN") : OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_USER"))));
        return string2;
    }

    private String getRoleComboBoxInternalSelection() {
        String string = null;
        String string2 = (String)this.roleComboBox.getSelectedItem();
        string = string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG")) ? "LONG_DESCRIPTION" : (string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT")) ? "SHORT_DESCRIPTION" : (string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE")) ? "END_DATE" : (string2.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN")) ? "TIME_SPAN" : "USER")));
        return string;
    }

    private void enableRoleComboBox(boolean bl) {
        this.roleLabel.setEnabled(bl);
        this.roleComboBox.setEnabled(bl);
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.initFromAttribute((CubeDimensionAttribute)this.getChildObject());
    }

    public void commit(CubeDimensionAttribute cubeDimensionAttribute) throws TraversalException {
        try {
            this.prov.validateName("ATTRIBUTE", this.getNameField().getText());
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidAttributes.add(cubeDimensionAttribute);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidAttributes.contains(cubeDimensionAttribute)) {
            this.invalidAttributes.remove(cubeDimensionAttribute);
        }
        String string = this.prov.getInternalName(this.getNameField().getText());
        cubeDimensionAttribute.rename((CubeDimension)this.getOriginalObject(), string);
        if (!this.isEditing()) {
            cubeDimensionAttribute.setOriginalAttributeName(string);
        } else if (cubeDimensionAttribute.getNewObject()) {
            cubeDimensionAttribute.setOriginalAttributeName(string);
        }
        cubeDimensionAttribute.setShortDescription(this.getShortDescriptionFld().getText());
        cubeDimensionAttribute.setLongDescription(this.getLongDescriptionFld().getText());
        cubeDimensionAttribute.setDescription(this.getDescriptionFld().getText());
        String string2 = this.dataTypeUI.getSQLDataType();
        cubeDimensionAttribute.setDataType(string2);
        boolean bl = this.indexCheckBox.isSelected();
        cubeDimensionAttribute.setIndex(bl);
        if (bl && cubeDimensionAttribute.isNls()) {
            cubeDimensionAttribute.setNls(false);
        }
        cubeDimensionAttribute.setRole(this.getRoleComboBoxInternalSelection());
        cubeDimensionAttribute.setStar(this.starCheckBox.isSelected());
        if (this.visibilityTree.isFullySelected()) {
            cubeDimensionAttribute.setAttributeVisibleForAll(true);
            if (!this.initialValueForVisibleToAll) {
                this.processAttributeVisibility(cubeDimensionAttribute);
            }
        } else {
            cubeDimensionAttribute.setAttributeVisibleForAll(false);
            if (this.initialValueForVisibleToAll) {
                this.toggleOffAllVisibleAttributes(cubeDimensionAttribute);
            }
            this.processAttributeVisibility(cubeDimensionAttribute);
        }
    }

    private void processAttributeVisibility(CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute cubeDimensionAttribute2 = null;
        for (CubeDimensionLevel cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getLevels()) {
            boolean bl = this.visibilityTree.isSelected(cubeSubDimension);
            if (bl) {
                if (this.isAttributeVisibleAtLevel(cubeSubDimension, cubeDimensionAttribute)) continue;
                cubeSubDimension.addVisibleAttribute(cubeDimensionAttribute);
                continue;
            }
            CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeSubDimension.getVisibleAttributes();
            cubeDimensionAttribute2 = this.getChildVisibleStoredAttribute(cubeDimensionAttributeArray, cubeDimensionAttribute);
            if (cubeDimensionAttribute2 == null) {
                cubeDimensionAttribute2 = cubeDimensionAttribute;
            }
            cubeSubDimension.removeVisibleAttribute(cubeDimensionAttribute2);
        }
        for (CubeSubDimension cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getHierarchies()) {
            if (!((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevelType()) {
                boolean bl = this.visibilityTree.isSelected(cubeSubDimension);
                if (bl) {
                    cubeSubDimension.addVisibleAttribute(cubeDimensionAttribute);
                    continue;
                }
                CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeSubDimension.getVisibleAttributes();
                cubeDimensionAttribute2 = this.getChildVisibleStoredAttribute(cubeDimensionAttributeArray, cubeDimensionAttribute);
                if (cubeDimensionAttribute2 == null) {
                    cubeDimensionAttribute2 = cubeDimensionAttribute;
                }
                cubeSubDimension.removeVisibleAttribute(cubeDimensionAttribute2);
                continue;
            }
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                boolean bl = this.visibilityTree.isSelected(cubeDimensionHierarchyLevel);
                if (bl) {
                    if (this.isAttributeVisibleAtHierLevel(cubeDimensionHierarchyLevel, cubeDimensionAttribute)) continue;
                    cubeDimensionHierarchyLevel.addVisibleAttribute(cubeDimensionAttribute);
                    continue;
                }
                CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeDimensionHierarchyLevel.getVisibleAttributes();
                cubeDimensionAttribute2 = this.getChildVisibleStoredAttribute(cubeDimensionAttributeArray, cubeDimensionAttribute);
                if (cubeDimensionAttribute2 == null) {
                    cubeDimensionAttribute2 = cubeDimensionAttribute;
                }
                cubeDimensionHierarchyLevel.removeVisibleAttribute(cubeDimensionAttribute2);
            }
        }
    }

    private void toggleOffAllVisibleAttributes(CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionLevel cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getLevels()) {
            AbstractChildObjectWithDesc[] abstractChildObjectWithDescArray = cubeSubDimension.getVisibleAttributes();
            CubeDimensionAttribute[] cubeDimensionAttributeArray2 = abstractChildObjectWithDescArray;
            int n = cubeDimensionAttributeArray2.length;
            for (int abstractChildObjectWithDesc = 0; abstractChildObjectWithDesc < n; ++abstractChildObjectWithDesc) {
                cubeDimensionAttributeArray = cubeDimensionAttributeArray2[abstractChildObjectWithDesc];
                if (!cubeDimensionAttributeArray.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                cubeSubDimension.removeVisibleAttribute((CubeDimensionAttribute)cubeDimensionAttributeArray);
            }
        }
        for (CubeSubDimension cubeSubDimension : ((CubeDimension)this.getUpdatedObject()).getHierarchies()) {
            if (((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevelType()) continue;
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = ((CubeSubDimension)abstractChildObjectWithDesc).getVisibleAttributes()) {
                    if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                    ((CubeSubDimension)abstractChildObjectWithDesc).removeVisibleAttribute(cubeDimensionAttribute2);
                }
            }
        }
    }

    private CubeDimensionAttribute getChildVisibleStoredAttribute(CubeDimensionAttribute[] cubeDimensionAttributeArray, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute cubeDimensionAttribute2 = null;
        if (cubeDimensionAttributeArray != null && cubeDimensionAttributeArray.length > 0) {
            for (CubeDimensionAttribute cubeDimensionAttribute3 : cubeDimensionAttributeArray) {
                if (!cubeDimensionAttribute3.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
                cubeDimensionAttribute2 = cubeDimensionAttribute3;
                break;
            }
        }
        return cubeDimensionAttribute2;
    }

    private boolean isAttributeVisibleAtLevel(CubeDimensionLevel cubeDimensionLevel, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        boolean bl = false;
        for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = cubeDimensionLevel.getVisibleAttributes()) {
            if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAttributeVisibleAtHierLevel(CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel, CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        boolean bl = false;
        for (CubeDimensionAttribute cubeDimensionAttribute2 : cubeDimensionAttributeArray = cubeDimensionHierarchyLevel.getVisibleAttributes()) {
            if (!cubeDimensionAttribute2.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute.getOriginalAttributeName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void initFromAttribute(CubeDimensionAttribute cubeDimensionAttribute) {
        this.initFromAttributeData(cubeDimensionAttribute);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)this.getChildObject();
        this.commit(cubeDimensionAttribute);
        CubeDimension cubeDimension = cubeDimensionAttribute.getCubeDimension();
        if (cubeDimension.findAttribute(cubeDimensionAttribute.getName()) == null) {
            cubeDimension.addAttribute(cubeDimensionAttribute);
        }
    }

    private void layoutComponents() {
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"attributes"});
        JLabel jLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_APPLY_TO_LABEL"));
        jLabel.setName("visibilityLabel");
        this.lblName = new JLabel();
        this.lblName.setName("lblName");
        componentFactory.registerComponent(this.lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "name", "name");
        this.roleLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_LABEL"));
        this.roleLabel.setName("roleLabel");
        this.roleComboBoxModel = new DefaultComboBoxModel();
        this.roleComboBox = new JComboBox(this.roleComboBoxModel);
        this.roleComboBox.setName("roleComboBox");
        this.registerDescriptionFields();
        this.indexCheckBox = new JCheckBox();
        this.indexCheckBox.setName("indexCheckBox");
        componentFactory.registerComponent((AbstractButton)this.indexCheckBox, OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_INDEX_LABEL"), "index");
        this.starCheckBox = new JCheckBox();
        this.starCheckBox.setName("starCheckBox");
        componentFactory.registerComponent((AbstractButton)this.starCheckBox, OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_CREATE_COLUMNS_LABEL"), "star");
        this.getNameField().setColumns(30);
        this.dataTypeUI = new DataTypeUI(componentFactory);
        this.dataTypeUI.removeDataTypel("DATETIME");
        this.dataTypeUI.getDataTypeComboBox().setSelectedItem("VARCHAR2");
        this.visibilityTree = new DimensionTree();
        this.roleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CubeDimensionAttributeEditorPanel.this.isInitializing) {
                    CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)CubeDimensionAttributeEditorPanel.this.getChildObject();
                    String string = (String)CubeDimensionAttributeEditorPanel.this.roleComboBox.getSelectedItem();
                    String string2 = "USER";
                    if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG"))) {
                        string2 = "LONG_DESCRIPTION";
                    } else if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT"))) {
                        string2 = "SHORT_DESCRIPTION";
                    } else if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_END_DATE"))) {
                        string2 = "END_DATE";
                    } else if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN"))) {
                        string2 = "TIME_SPAN";
                    }
                    cubeDimensionAttribute.setRole(string2);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_PROPERTIES_BORDER_LABEL")));
        this.add(this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.getNameField(), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.roleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.roleComboBox, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        int n = this.layoutDescriptionFields(2);
        this.add(this.dataTypeUI.getDataTypeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeComboBox(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.starCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.indexCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.visibilityTree);
        jScrollPane.setName("scrollPane");
        this.add(jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
    }

    @Override
    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        CubeDimension cubeDimension;
        if (abstractSchemaObjectWithDesc instanceof CubeDimension && (cubeDimension = (CubeDimension)abstractSchemaObjectWithDesc).getAttributes().length == 0) {
            this.enableDescriptions(false);
        }
    }
}

