/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cubedimension.CubeDimensionRemoveChildDispatcher;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.ChildObjectEditorPanel2;

public class CubeDimensionLevelEditorPanel
extends ChildObjectEditorPanel2<CubeDimensionLevel, CubeDimension> {
    private JLabel m_lblName;
    private DBObjectProvider m_prov;
    private DataTypeUI m_dataTypeUI;
    private TreeSet<CubeDimensionLevel> m_invalidLevels = new TreeSet(new DBObjectComparator());
    private String origLevelName;

    public CubeDimensionLevelEditorPanel() {
        super("CubeDimensionLevelEditorPanel", "LEVEL");
        this.layoutComponents();
        CubeDimensionRemoveChildDispatcher cubeDimensionRemoveChildDispatcher = CubeDimensionRemoveChildDispatcher.getInstance();
        cubeDimensionRemoveChildDispatcher.registerObserver(this);
    }

    private void updateLevelData() {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.m_lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
        } else {
            String string = ((CubeDimensionLevel)this.getChildObject()).getName();
            if (!this.m_invalidLevels.contains(this.getChildObject())) {
                // empty if block
            }
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            childNameObjectEditorContext.setEditingState(0);
            String string2 = ((CubeDimensionLevel)this.getChildObject()).getDataType();
            if (string2 != null) {
                this.m_dataTypeUI.setSQLDataType(string2);
            }
        }
        this.validate();
        this.repaint();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.m_prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.setLevel((CubeDimensionLevel)this.getChildObject());
        this.origLevelName = null;
        if (this.getChildObject() != null) {
            this.origLevelName = ((CubeDimensionLevel)this.getChildObject()).getName();
        }
    }

    public void commit(CubeDimensionLevel cubeDimensionLevel) throws TraversalException {
        Object object;
        CubeDimensionLevel cubeDimensionLevel2 = (CubeDimensionLevel)cubeDimensionLevel.copyTo(null);
        try {
            this.m_prov.validateName("LEVEL", this.getNameField().getText());
        }
        catch (InvalidNameException invalidNameException) {
            this.m_invalidLevels.add(cubeDimensionLevel);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.m_invalidLevels.contains(cubeDimensionLevel)) {
            this.m_invalidLevels.remove(cubeDimensionLevel);
        }
        String string = this.m_prov.getInternalName(this.getNameField().getText());
        cubeDimensionLevel2.setName(string);
        if (!this.isEditing()) {
            cubeDimensionLevel.setOriginalLevelName(string);
            cubeDimensionLevel2.setOriginalLevelName(string);
        } else if (!cubeDimensionLevel.getNewObject()) {
            cubeDimensionLevel2.setOriginalLevelName(cubeDimensionLevel.getOriginalLevelName());
        } else {
            cubeDimensionLevel.setOriginalLevelName(string);
            cubeDimensionLevel2.setOriginalLevelName(string);
        }
        cubeDimensionLevel2.setShortDescription(this.getShortDescriptionFld().getText());
        cubeDimensionLevel2.setLongDescription(this.getLongDescriptionFld().getText());
        cubeDimensionLevel2.setDescription(this.getDescriptionFld().getText());
        if (this.m_dataTypeUI.isVisible()) {
            object = this.m_dataTypeUI.getSQLDataType();
            cubeDimensionLevel2.setDataType((String)object);
        }
        cubeDimensionLevel2.copyTo(cubeDimensionLevel);
        if (this.isEditing() && !this.origLevelName.equalsIgnoreCase(string)) {
            object = (CubeDimension)this.getUpdatedObject();
            ((CubeDimension)object).renameSpreadedAttributesForLevelRename(this.origLevelName, string);
        }
    }

    public void setLevel(CubeDimensionLevel cubeDimensionLevel) {
        this.updateLevelData();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)this.getChildObject();
        this.commit(cubeDimensionLevel);
        CubeDimension cubeDimension = cubeDimensionLevel.getCubeDimension();
        if (cubeDimension.findLevel(cubeDimensionLevel.getName()) == null) {
            cubeDimension.addLevel(cubeDimensionLevel);
        }
    }

    private void layoutComponents() {
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"levels"});
        this.m_lblName = new JLabel();
        this.m_lblName.setName("m_lblName");
        componentFactory.registerComponent(this.m_lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "Name", "name");
        this.registerDescriptionFields();
        this.getNameField().setColumns(30);
        this.m_dataTypeUI = new DataTypeUI(componentFactory);
        this.m_dataTypeUI.removeDataTypel("DATETIME");
        this.m_dataTypeUI.getDataTypeComboBox().setSelectedItem("VARCHAR2");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.getString("CUBE_DIMENSION_LEVEL_PROPERTIES")));
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.getNameField(), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        int n = 1;
        n = this.layoutDescriptionFields(1);
        this.add(this.m_dataTypeUI.getDataTypeLabel(), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.m_dataTypeUI.getDataTypeComboBox(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_dataTypeUI.getDataTypeSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.m_dataTypeUI.getDataTypeSizeTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_dataTypeUI.getDataTypeScaleLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.m_dataTypeUI.getDataTypeScaleTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
    }

    @Override
    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        CubeDimension cubeDimension;
        if (abstractSchemaObjectWithDesc instanceof CubeDimension && (cubeDimension = (CubeDimension)abstractSchemaObjectWithDesc).getLevels().length == 0) {
            this.enableDescriptions(false);
        }
    }
}

