/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Preferences;
import oracle.olap.app.Resources;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.cubetemplate.CubeTemplate;
import oracle.olap.cubetemplate.CubeTemplateManager;
import oracle.olap.cubetemplate.DetailsPanel;
import oracle.olap.cubetemplate.ExportImportHandler;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.ReadTemplAccessoryPanel;
import oracle.olap.cubetemplate.SaveTemplAccessoryPanel;
import oracle.olap.cubetemplate.TemplateSelector;
import oracle.olap.cubetemplate.TreeModelHelper;
import oracle.olap.db.view.TransactionWaitCursorManager;

public class CubeCatalogDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final int DIALOG_WIDTH = 900;
    private static final int DIALOG_HEIGHT = 450;
    private static final int TABLE_WIDTH = 550;
    private static final String OK_BUTTON = "OK";
    private static final String CANCEL_BUTTON = "CANCEL";
    private static final String DELETE_SELECTION = "DELETE_SELECTION";
    private static final String HELP = "HELP";
    private static final String SAVEHELP = "olap_save_to_template";
    private static final String SAVEXMLPLSQLHELP = "olap_save_xml_plsql_to_file";
    private static final String CREATEHELP = "olap_create_from_template";
    private static final String DB_TABLE_NAME = "CUBE_TEMPLATES";
    private final String selectionName;
    private final String selectionDescription;
    private final Mode mode;
    private final String ownerCube;
    private ObjectType objectType;
    private final String wkspName;
    private final SaveTemplAccessoryPanel saveTable;
    private final SaveTemplAccessoryPanel saveFile;
    private final ReadTemplAccessoryPanel readTable;
    private final ReadTemplAccessoryPanel readFile;
    private final ExportImportHandler handler;
    private final JPanel cardHolder;
    private final JFileChooser fileCard;
    private TemplateSelector selector;
    private JButton okButton;
    private JTextField uiFilter;
    private DetailsPanel details;
    private JRadioButton uiToFile;
    private JRadioButton uiToTable;
    private String schema = "";
    private final ErrorDisplay errorDisplay;
    private final Resources resources;
    private boolean needsRefresh;
    private final boolean is11g;
    private final HelpProvider helpProvider;
    private static File saveDirectory;
    private final Destination destination;
    private JPanel mainPanel;
    private final CubeTemplateManager.OutputFormat format;

    public CubeCatalogDialog(Frame frame, Resources resources, Preferences preferences, ErrorDisplay errorDisplay, HelpProvider helpProvider, CubeTemplateManager cubeTemplateManager, TreeModelHelper treeModelHelper, Connection connection, Mode mode, Destination destination, CubeTemplateManager.OutputFormat outputFormat, List<Object> list, String string, String string2, String string3, boolean bl, String string4, String string5, String string6, ObjectType objectType, boolean bl2) {
        super(frame, true);
        this.setName("CubeCatalogDialog");
        this.resources = resources;
        this.errorDisplay = errorDisplay;
        this.mode = mode;
        this.wkspName = string3;
        this.selectionName = string;
        this.selectionDescription = string2;
        this.is11g = bl2;
        this.helpProvider = helpProvider;
        this.destination = destination;
        this.format = outputFormat;
        this.ownerCube = string6;
        this.setDefaultCloseOperation(2);
        this.setSize(900, 450);
        this.setResizable(true);
        this.setLocationRelativeTo(frame);
        this.objectType = objectType;
        this.handler = new ExportImportHandler(connection, cubeTemplateManager, this, list, this.wkspName, string5, errorDisplay, resources);
        if (mode == Mode.EXPORT) {
            if (destination == Destination.TO_FILE) {
                if (outputFormat == CubeTemplateManager.OutputFormat.XML) {
                    this.setTitle(resources.getString("EXPORT_TO_TABLE.DIALOG.TITLE.EXPORT_XML", this.objectType.getDisplayName(), string));
                } else {
                    this.setTitle(resources.getString("EXPORT_TO_TABLE.DIALOG.TITLE.EXPORT_PLSQL", this.objectType.getDisplayName(), string));
                }
            } else {
                this.setTitle(resources.getString("EXPORT_TO_TABLE.DIALOG.TITLE.EXPORT", this.objectType.getDisplayName(), string));
            }
            this.saveFile = new SaveTemplAccessoryPanel(bl, string5, string4, false, outputFormat, treeModelHelper, resources);
            this.saveTable = new SaveTemplAccessoryPanel(bl, string5, string4, false, outputFormat, treeModelHelper, resources);
            this.readTable = null;
            this.readFile = null;
        } else {
            this.saveFile = null;
            this.saveTable = null;
            this.setTitle(resources.getString("EXPORT_TO_TABLE.DIALOG.TITLE.IMPORT", this.objectType.getDisplayName()));
            this.readTable = new ReadTemplAccessoryPanel(this.objectType, this.wkspName, string6, resources);
            this.readFile = new ReadTemplAccessoryPanel(this.objectType, this.wkspName, string6, resources);
        }
        this.cardHolder = new JPanel(new CardLayout());
        this.cardHolder.setName("cardHolder");
        if (destination == Destination.TO_FILE || destination == Destination.TO_BOTH) {
            this.fileCard = this.createFileChooser(preferences);
            this.cardHolder.add((Component)this.fileCard, Destination.TO_FILE.toString());
        } else {
            this.fileCard = null;
        }
        if (Destination.TO_TABLE == destination || Destination.TO_BOTH == destination) {
            this.cardHolder.add((Component)this.createTableCard(connection), Destination.TO_TABLE.toString());
        }
        if (Destination.TO_FILE == destination || Destination.TO_TABLE == destination) {
            ((CardLayout)this.cardHolder.getLayout()).show(this.cardHolder, destination.toString());
        }
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(5);
        this.mainPanel = new JPanel(borderLayout);
        this.mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mainPanel.setName("mainPanel");
        if (Destination.TO_BOTH == destination) {
            this.mainPanel.add((Component)this.createRadioButtons(), "North");
        }
        this.mainPanel.add((Component)this.cardHolder, "Center");
        this.mainPanel.add((Component)this.createButtonsPanel(), "South");
        this.add(this.mainPanel);
        this.registerKeyboardActions();
    }

    public void setOptionsEnabled(boolean bl) {
        if (this.mode == Mode.IMPORT) {
            this.readFile.setEnabled(bl);
            this.readTable.setEnabled(bl);
        } else {
            this.saveFile.setEnabled(bl);
            this.saveTable.setEnabled(bl);
        }
    }

    private JPanel createRadioButtons() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setName("radioButtons");
        if (this.mode == Mode.IMPORT) {
            this.uiToFile = new JRadioButton();
            this.uiToFile.setName("uiToFile");
            this.setMnemonic(this.uiToFile, "EXPORT_TO_TABLE.DIALOG.RADIO.FROM_FILE");
            this.uiToTable = new JRadioButton();
            this.uiToTable.setName("uiToTable");
            this.setMnemonic(this.uiToTable, "EXPORT_TO_TABLE.DIALOG.RADIO.FROM_TABLE");
        } else {
            this.uiToFile = new JRadioButton();
            this.uiToFile.setName("uiToFile");
            this.setMnemonic(this.uiToFile, "EXPORT_TO_TABLE.DIALOG.RADIO.TO_FILE");
            this.uiToTable = new JRadioButton();
            this.uiToTable.setName("uiToTable");
            this.setMnemonic(this.uiToTable, "EXPORT_TO_TABLE.DIALOG.RADIO.TO_TABLE");
        }
        this.uiToFile.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.uiToFile);
        buttonGroup.add(this.uiToTable);
        this.uiToTable.addActionListener(this);
        this.uiToFile.addActionListener(this);
        this.uiToTable.setActionCommand(Destination.TO_TABLE.toString());
        this.uiToFile.setActionCommand(Destination.TO_FILE.toString());
        jPanel.add(this.uiToFile);
        jPanel.add(this.uiToTable);
        return jPanel;
    }

    private JPanel createTableCard(Connection connection) {
        this.selector = new TemplateSelector(connection, this.objectType, this.mode, this, this.resources, this.errorDisplay);
        this.selector.addSelectionListener(this);
        this.selector.addMouseListener(this);
        JSplitPane jSplitPane = new JSplitPane(1, this.selector, this.readTable == null ? this.saveTable : this.readTable);
        jSplitPane.setName("split");
        jSplitPane.setResizeWeight(1.0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("tableCard");
        JComboBox jComboBox = this.initializeSchema(connection);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setName("north");
        JLabel jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.SCHEMAS.LABEL");
        jLabel.setLabelFor(jComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 10);
        jPanel2.add((Component)jComboBox, gridBagConstraints);
        JTextField jTextField = new JTextField(40);
        jTextField.setText(DB_TABLE_NAME);
        jTextField.setEnabled(false);
        jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.DB_TABLE_NAME.LABEL");
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        jPanel2.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.FILTER.LABEL");
        this.uiFilter = new JTextField(20);
        this.uiFilter.setName("uiFilter");
        this.uiFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CubeCatalogDialog.this.selector.setFilter(CubeCatalogDialog.this.uiFilter.getText());
                    CubeCatalogDialog.this.selector.refresh();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jLabel.setLabelFor(this.uiFilter);
        this.uiFilter.setMinimumSize(this.uiFilter.getPreferredSize());
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.uiFilter, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(Box.createHorizontalStrut(10), "West");
        jPanel.add(Box.createHorizontalStrut(10), "East");
        jPanel.add((Component)jSplitPane, "Center");
        this.details = new DetailsPanel(this.mode, this.selector, this.selectionName, this.selectionDescription, this.objectType, this.resources);
        this.details.setName("details");
        jPanel.add((Component)this.details, "South");
        jSplitPane.setDividerLocation(550);
        return jPanel;
    }

    private JFileChooser createFileChooser(Preferences preferences) {
        JFileChooser jFileChooser = new JFileChooser();
        if (saveDirectory == null) {
            if (preferences.get("AWM.TEMPLATE_DIRNAME") != null && !(saveDirectory = new File(preferences.get("AWM.TEMPLATE_DIRNAME"))).exists()) {
                saveDirectory = null;
            }
            if (saveDirectory == null) {
                saveDirectory = jFileChooser.getCurrentDirectory();
            }
        }
        if (this.mode == Mode.EXPORT) {
            if (this.selectionName.equals("")) {
                jFileChooser.setCurrentDirectory(saveDirectory);
            } else {
                jFileChooser.setSelectedFile(new File(saveDirectory, this.selectionName));
            }
        }
        if (this.readFile != null) {
            jFileChooser.setCurrentDirectory(saveDirectory);
            jFileChooser.setAccessory(this.readFile);
        } else {
            jFileChooser.setAccessory(this.saveFile);
        }
        jFileChooser.setFileFilter(new FileFilter(){
            Pattern pat = null;

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                this.pat = CubeCatalogDialog.this.format == CubeTemplateManager.OutputFormat.XML ? Pattern.compile("\\.xml$", 2) : Pattern.compile("\\.sql$", 2);
                Matcher matcher = this.pat.matcher(file.getName());
                return matcher.find();
            }

            @Override
            public String getDescription() {
                if (CubeCatalogDialog.this.format == CubeTemplateManager.OutputFormat.XML) {
                    return CubeCatalogDialog.this.resources.getString("SAVE_TO_TEMPLATE_DLG.TEMPLATE_FILE_FILTER_DESC");
                }
                return CubeCatalogDialog.this.resources.getString("SAVE_TO_TEMPLATE_DLG.SQL_FILE_FILTER_DESC");
            }
        });
        jFileChooser.setMultiSelectionEnabled(this.mode == Mode.IMPORT);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setControlButtonsAreShown(false);
        jFileChooser.addPropertyChangeListener("SelectedFilesChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof File[] && CubeCatalogDialog.this.mode == Mode.IMPORT) {
                    File[] fileArray = (File[])propertyChangeEvent.getNewValue();
                    if (fileArray != null) {
                        CubeCatalogDialog.this.okButton.setEnabled(CubeCatalogDialog.this.readFile.loadXML(fileArray) && CubeCatalogDialog.this.validTemplateVersion(CubeCatalogDialog.this.getReadAcc().getPreprocessor().is11g()));
                        CubeCatalogDialog.this.updateObjectType();
                    } else {
                        CubeCatalogDialog.this.okButton.setEnabled(false);
                    }
                }
            }
        });
        jFileChooser.registerKeyboardAction(this, CANCEL_BUTTON, KeyStroke.getKeyStroke(27, 0), 1);
        return jFileChooser;
    }

    private DialogButtonBar createButtonsPanel() {
        this.okButton = new JButton();
        this.okButton.setName("okButton");
        this.setMnemonic(this.okButton, "EXPORT_TO_TABLE.DIALOG.FORM.OK");
        this.okButton.setActionCommand(OK_BUTTON);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(this.mode == Mode.EXPORT);
        JButton jButton = new JButton();
        jButton.setName("cancel");
        this.setMnemonic(jButton, "EXPORT_TO_TABLE.DIALOG.FORM.CANCEL");
        jButton.setActionCommand(CANCEL_BUTTON);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton();
        jButton2.setName("help");
        this.setMnemonic(jButton2, "APP.MENU.HELP.NAME");
        jButton2.setActionCommand(HELP);
        jButton2.addActionListener(this);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_HELP);
        return dialogButtonBar;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, CANCEL_BUTTON, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, HELP, KeyStroke.getKeyStroke(112, 0), 1);
    }

    public JLabel newJLabel(String string) {
        String string2 = this.resources.getString(string);
        int n = string2.indexOf("&");
        JLabel jLabel = new JLabel(string2.replaceFirst("&", ""));
        if (n != -1) {
            jLabel.setDisplayedMnemonicIndex(n);
            jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n));
        }
        return jLabel;
    }

    private void setMnemonic(AbstractButton abstractButton, String string) {
        String string2 = this.resources.getString(string);
        abstractButton.setText(string2.replaceFirst("&", ""));
        int n = string2.indexOf("&");
        if (n != -1) {
            abstractButton.setMnemonic(abstractButton.getText().charAt(n));
        }
    }

    private JComboBox initializeSchema(Connection connection) {
        JComboBox<Object> jComboBox = null;
        try {
            this.schema = connection.getMetaData().getUserName();
            jComboBox = new JComboBox<Object>(DatabaseUtils.GetSchemas(connection).toArray());
            jComboBox.setName("uiSchema");
        }
        catch (SQLException sQLException) {
            jComboBox = new JComboBox<Object>(new Object[]{this.schema});
            jComboBox.setName("uiSchema");
            this.errorDisplay.show(sQLException, this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.FETCH_SCHEMAS"), this);
        }
        Dimension dimension = new Dimension(500, (int)jComboBox.getPreferredSize().getHeight());
        jComboBox.setPreferredSize(dimension);
        jComboBox.setSelectedItem(this.schema);
        if (this.handler.createTableifNotExists(this.schema)) {
            this.selector.refresh(this.schema);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof String) {
                    if (!CubeCatalogDialog.this.schema.equals(itemEvent.getItem()) && CubeCatalogDialog.this.handler.createTableifNotExists((String)itemEvent.getItem())) {
                        CubeCatalogDialog.this.selector.refresh((String)itemEvent.getItem());
                        CubeCatalogDialog.this.schema = (String)itemEvent.getItem();
                    } else if (!CubeCatalogDialog.this.schema.equals(itemEvent.getItem())) {
                        ((JComboBox)itemEvent.getSource()).setSelectedItem(CubeCatalogDialog.this.schema);
                    }
                }
            }
        });
        return jComboBox;
    }

    private ReadTemplAccessoryPanel getReadAcc() {
        if (this.toFile()) {
            return this.readFile;
        }
        return this.readTable;
    }

    private SaveTemplAccessoryPanel getSaveAcc() {
        if (this.toFile()) {
            return this.saveFile;
        }
        return this.saveTable;
    }

    private boolean toFile() {
        if (this.uiToFile != null) {
            return this.uiToFile.isSelected();
        }
        return this.destination == Destination.TO_FILE;
    }

    private void persistXML() {
        if (this.toFile()) {
            saveDirectory = this.fileCard.getCurrentDirectory();
            TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
            transactionWaitCursorManager.setDialog(this);
            transactionWaitCursorManager.showWaitCursor();
            this.handler.persistXML(this.fileCard.getSelectedFile(), this.getSaveAcc().includeSchemaNameInMappedObjects(), this.getSaveAcc().getFileFormatVersion(), this.getSaveAcc().includeSchemaNameInOLAPObjects(), this.getSaveAcc().getOutputFormat());
            transactionWaitCursorManager.showDefaultCursor();
            transactionWaitCursorManager.reset();
        } else {
            String string = null;
            switch (this.objectType) {
                case MEASURE_FOLDER: 
                case CUBE: 
                case DIMENSION: {
                    string = this.wkspName;
                    break;
                }
                case DERIVED_MEASURE: 
                case MEASURE: {
                    string = this.ownerCube;
                    break;
                }
                default: {
                    string = null;
                }
            }
            CubeTemplate cubeTemplate = new CubeTemplate();
            cubeTemplate.setTemplateName(this.details.getTemplateName());
            cubeTemplate.setPreviousName(this.selector.getString(2));
            cubeTemplate.setInSchemaMapping(this.getSaveAcc().includeSchemaNameInMappedObjects());
            cubeTemplate.setIncludeOlapObjectSchema(this.getSaveAcc().includeSchemaNameInOLAPObjects());
            cubeTemplate.setParent(string);
            if (this.is11g) {
                cubeTemplate.setVersion(this.getSaveAcc().getFileFormatVersion());
            } else {
                cubeTemplate.setVersion("10.2");
            }
            cubeTemplate.setDescription(this.details.getDescription());
            cubeTemplate.setComments(this.details.getComments());
            cubeTemplate.setModified((Timestamp)this.selector.getValue(0));
            cubeTemplate.setUsername(this.selector.getString(1));
            if (this.objectType == ObjectType.ALL) {
                cubeTemplate.setType(null);
            } else {
                cubeTemplate.setType(this.objectType.getFilterString());
            }
            TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
            transactionWaitCursorManager.setDialog(this);
            transactionWaitCursorManager.showWaitCursor();
            this.handler.persistXML(cubeTemplate);
            transactionWaitCursorManager.showDefaultCursor();
            transactionWaitCursorManager.reset();
        }
    }

    private boolean processTemplate() {
        String string = null;
        if (this.toFile()) {
            string = this.fileCard.getSelectedFile().toString();
            saveDirectory = this.fileCard.getCurrentDirectory();
        } else {
            string = null;
        }
        if (!this.getReadAcc().isMeasuresInserted() || this.getReadAcc().isMeasuresInserted() && 0 == JOptionPane.showConfirmDialog(this.getParent(), this.resources.getString("EXPORT_TO_TABLE.DIALOG.MEASURE_INSERT.MESSAGE"), this.resources.getString("EXPORT_TO_TABLE.DIALOG.MEASURE_INSERT.TITLE"), 2)) {
            this.handler.processTemplate(string, this.getReadAcc().getPreprocessor(), this.getReadAcc().includeOLAPDML(), this.getReadAcc().modifyIfExists());
            this.needsRefresh = true;
            return true;
        }
        return false;
    }

    public boolean isNeedsRefresh() {
        return this.needsRefresh;
    }

    private boolean templateCollision() {
        if (this.toFile()) {
            ((BasicFileChooserUI)this.fileCard.getUI()).getApproveSelectionAction().actionPerformed(null);
            String string = this.fileCard.getSelectedFile().toString();
            String string2 = string.substring(string.length() - this.getSaveAcc().getOutputFormat().getExtension().length(), string.length());
            if (!string2.equalsIgnoreCase(this.getSaveAcc().getOutputFormat().getExtension())) {
                string = string + this.getSaveAcc().getOutputFormat().getExtension();
            }
            this.fileCard.setSelectedFile(new File(string));
            return this.fileCard.getSelectedFile().exists();
        }
        if (this.selector.isRowSelected()) {
            String string = this.selector.getString(2);
            return this.details.getTemplateName().equals(string);
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_BUTTON)) {
            if (this.mode == Mode.EXPORT) {
                if (this.isSelectionValid()) {
                    boolean bl = true;
                    boolean bl2 = this.templateCollision();
                    if (bl2) {
                        boolean bl3 = bl = 0 == JOptionPane.showConfirmDialog(this.getParent(), this.resources.getString("EXPORT_TO_TABLE.DIALOG.OVERWRITE.MESSAGE"), this.resources.getString("EXPORT_TO_TABLE.DIALOG.OVERWRITE.TITLE"), 2);
                    }
                    if (bl) {
                        this.persistXML();
                        this.setVisible(false);
                    }
                }
            } else {
                this.setVisible(!this.processTemplate());
            }
        } else if (string.equals(CANCEL_BUTTON)) {
            if (this.fileCard.getCurrentDirectory() != null) {
                saveDirectory = this.fileCard.getCurrentDirectory();
            }
            this.setVisible(false);
        } else if (string.equals(DELETE_SELECTION)) {
            if (0 == JOptionPane.showConfirmDialog(this.getParent(), this.resources.getString("EXPORT_TO_TABLE.DIALOG.DELETE.MESSAGE"), this.resources.getString("EXPORT_TO_TABLE.DIALOG.DELETE.TITLE"), 2)) {
                CubeTemplate cubeTemplate = new CubeTemplate();
                cubeTemplate.setUsername(this.selector.getString(1));
                cubeTemplate.setTemplateName(this.selector.getString(2));
                cubeTemplate.setModified((Timestamp)this.selector.getValue(0));
                if (this.handler.deleteSelected(cubeTemplate)) {
                    this.selector.refresh();
                }
            }
        } else if (string.equals(Destination.TO_TABLE.toString()) || string.equals(Destination.TO_FILE.toString())) {
            ((CardLayout)this.cardHolder.getLayout()).show(this.cardHolder, actionEvent.getActionCommand());
            if (this.mode == Mode.IMPORT) {
                this.selector.selectFirst();
            }
        } else if (string.equals(HELP)) {
            if (this.mode == Mode.IMPORT) {
                this.helpProvider.showHelp(this.mainPanel, CREATEHELP);
            } else if (this.destination == Destination.TO_FILE) {
                this.helpProvider.showHelp(this.mainPanel, SAVEXMLPLSQLHELP);
            } else {
                this.helpProvider.showHelp(this.mainPanel, SAVEHELP);
            }
        }
    }

    private boolean isSelectionValid() {
        if (this.toFile()) {
            ((BasicFileChooserUI)this.fileCard.getUI()).getApproveSelectionAction().actionPerformed(null);
            return this.fileCard.getSelectedFile() != null;
        }
        return this.details.isSelectionValid();
    }

    private void updateObjectType() {
        this.objectType = this.getReadAcc().getPreprocessor().getTemplateType();
        if (this.mode == Mode.EXPORT) {
            this.setTitle(this.resources.getString("EXPORT_TO_TABLE.DIALOG.TITLE.EXPORT", this.objectType.getDisplayName() == null ? "" : this.objectType.getDisplayName(), this.selectionName));
        } else {
            this.setTitle(this.resources.getString("EXPORT_TO_TABLE.DIALOG.TITLE.IMPORT", this.objectType.getDisplayName() == null ? "" : this.objectType.getDisplayName()));
            this.getReadAcc().setObjectType(this.objectType);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.selector.isRowSelected()) {
                try {
                    Timestamp timestamp = (Timestamp)this.selector.getValue(0);
                    String string = this.selector.getString(2);
                    String string2 = this.selector.getString(5);
                    this.details.setTemplateName(string);
                    this.details.setDescription(string2);
                    String string3 = this.handler.fetchComments(timestamp, string);
                    this.details.setComments(string3);
                    if (this.mode == Mode.IMPORT) {
                        Object[] objectArray = this.selector.getValues(0);
                        Object[] objectArray2 = this.selector.getValues(2);
                        String[] stringArray = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null || objectArray2[i] == null) {
                                return;
                            }
                            stringArray[i] = this.handler.fetchXML((Timestamp)objectArray[i], (String)objectArray2[i]);
                        }
                        this.okButton.setEnabled(this.readTable.loadXml(stringArray) && this.validTemplateVersion(this.readTable.getPreprocessor().is11g()));
                        this.updateObjectType();
                    }
                }
                catch (Exception exception) {
                    this.errorDisplay.show(exception, this);
                }
            } else if (this.mode == Mode.IMPORT) {
                this.okButton.setEnabled(false);
            }
        }
    }

    private boolean validTemplateVersion(boolean bl) {
        boolean bl2 = false;
        if (bl != this.is11g) {
            if (this.is11g) {
                this.errorDisplay.show(null, this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.TEMPLATEVERSION"), this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.NOT10G"), this);
            } else {
                this.errorDisplay.show(null, this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.TEMPLATEVERSION"), this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.NOT11G"), this);
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setName("menu");
            JMenuItem jMenuItem = new JMenuItem(this.resources.getString("EXPORT_TO_TABLE_DIALOG.DELETE.POPUP"));
            jMenuItem.setName("mi");
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand(DELETE_SELECTION);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static enum Destination {
        TO_FILE,
        TO_TABLE,
        TO_BOTH;

    }

    public static enum Mode {
        IMPORT,
        EXPORT;

    }
}

