/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olap.cubetemplate.CubeTemplate;
import oracle.sql.CLOB;

public class CubeCatalogManager {
    private Queries queries;
    private final Connection conn;
    private static final String XMLFILE = "templatequery.xml";
    private static final String CREATE = "create";
    private static final String READ = "read";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String CHECK = "check";
    private static final String TABLE = "table";
    private static final String CHECKTYPE = "checktype";
    private static final String COUNT = "count";
    private static final String READBATCH = "readbatch";
    private static final String[] TABLEMOD = new String[]{"tempcol", "xmltoclob", "drop", "rename"};

    public CubeCatalogManager(Connection connection) {
        this.conn = connection;
        try {
            String string = "oracle.olap.app.table";
            String string2 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr(string2, string, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    public void persist(CubeTemplate cubeTemplate) throws SQLException, IOException {
        Statement statement = null;
        CLOB cLOB = null;
        try {
            String string = this.conn.getMetaData().getUserName();
            cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)true, (int)10);
            cLOB.open(1);
            cLOB.setString(1L, cubeTemplate.getXmlTemplate());
            if (cubeTemplate.getTemplateName().equals(cubeTemplate.getPreviousName())) {
                String string2 = String.format(this.queries.getSQL(UPDATE), cubeTemplate.getTableSchema());
                statement = this.conn.prepareStatement(string2);
                int n = 1;
                statement.setString(n++, string);
                statement.setString(n++, cubeTemplate.getTemplateName());
                statement.setString(n++, cubeTemplate.getType());
                statement.setString(n++, cubeTemplate.getVersion());
                statement.setString(n++, cubeTemplate.getParent());
                statement.setString(n++, cubeTemplate.getDescription());
                statement.setString(n++, cubeTemplate.getComment());
                statement.setClob(n++, (Clob)cLOB);
                statement.setTimestamp(n++, cubeTemplate.getModified());
                statement.setString(n++, cubeTemplate.getPreviousName());
            } else {
                String string3 = this.queries.getSQL(CREATE);
                string3 = String.format(string3, cubeTemplate.getTableSchema());
                statement = this.conn.prepareStatement(string3);
                int n = 1;
                statement.setString(n++, string);
                statement.setString(n++, cubeTemplate.getTemplateName());
                statement.setString(n++, cubeTemplate.getType());
                statement.setString(n++, cubeTemplate.getVersion());
                statement.setString(n++, cubeTemplate.getParent());
                statement.setString(n++, cubeTemplate.getDescription());
                statement.setString(n++, cubeTemplate.getComment());
                statement.setClob(n++, (Clob)cLOB);
            }
            int n = statement.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (cLOB != null) {
                cLOB.close();
                cLOB.freeTemporary();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public CubeTemplate read(CubeTemplate cubeTemplate, String string) throws SQLException, IOException {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            String string2 = String.format(this.queries.getSQL(READ), string);
            statement = this.conn.prepareStatement(string2);
            statement.setTimestamp(1, cubeTemplate.getModified());
            statement.setString(2, cubeTemplate.getTemplateName());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                cubeTemplate.setModified(resultSet.getTimestamp("MODIFIED"));
                cubeTemplate.setUsername(resultSet.getString("USERNAME"));
                cubeTemplate.setTemplateName(resultSet.getString("NAME"));
                cubeTemplate.setVersion(resultSet.getString("VERSION"));
                cubeTemplate.setParent(resultSet.getString("PARENT_OBJECT"));
                cubeTemplate.setDescription(resultSet.getString("DESCRIPTION"));
                cubeTemplate.setType(resultSet.getString("TYPE"));
                cubeTemplate.setComments(resultSet.getString("COMMENTS"));
                Clob clob = resultSet.getClob("TEMPLATE");
                cubeTemplate.setXmlTemplate(clob.getSubString(1L, (int)clob.length()));
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            statement.close();
        }
        return cubeTemplate;
    }

    public boolean delete(CubeTemplate cubeTemplate) throws SQLException {
        boolean bl = false;
        Statement statement = null;
        try {
            String string = String.format(this.queries.getSQL(DELETE), cubeTemplate.getTableSchema());
            statement = this.conn.prepareStatement(string);
            statement.setTimestamp(1, cubeTemplate.getModified());
            statement.setString(2, cubeTemplate.getTemplateName());
            bl = statement.executeUpdate() == 1;
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return bl;
    }

    public boolean createTableifNotExists(String string) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.queries.getSQL(CHECK));
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string2;
            String string3;
            if (resultSet.getInt(1) == 0) {
                string3 = String.format(this.queries.getSQL(TABLE), string);
                this.conn.createStatement().executeUpdate(string3);
                continue;
            }
            string3 = this.queries.getSQL(CHECKTYPE);
            PreparedStatement preparedStatement2 = this.conn.prepareStatement(string3);
            preparedStatement2.setString(1, string);
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            if (resultSet2.next() && (string2 = resultSet2.getString("DATA_TYPE")).equals("XMLTYPE")) {
                Statement statement = this.conn.createStatement();
                for (String string4 : TABLEMOD) {
                    string4 = String.format(this.queries.getSQL(string4), string);
                    statement.executeUpdate(string4);
                }
                statement.close();
            }
            preparedStatement2.close();
        }
        preparedStatement.close();
        return true;
    }

    public int countBatch(String string, String string2, String string3) throws SQLException {
        String string4 = String.format(this.queries.getSQL(COUNT), string, string2);
        PreparedStatement preparedStatement = this.conn.prepareStatement(string4);
        preparedStatement.setString(1, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        preparedStatement.close();
        return n;
    }

    public PreparedStatement readBatch(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = String.format(this.queries.getSQL(READBATCH), string, string2, string4);
        PreparedStatement preparedStatement = this.conn.prepareStatement(string5);
        preparedStatement.setString(1, string3);
        return preparedStatement;
    }
}

