/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import oracle.ide.dialogs.ProgressBar;
import oracle.olap.actions.BaseRunnable;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.Resources;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.metadata.ErrorLocalizer;
import oracle.olap.app.metadata.OLAPPersistence;
import oracle.olap.app.metadata.OLAPXML;
import oracle.olap.app.metadata.OLAPXMLExportOptions;
import oracle.olap.app.table.Queries;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.DMLTemplate;
import oracle.olap.cubetemplate.ExportPreprocessor;
import oracle.olap.cubetemplate.ImportNameConflictResolver;
import oracle.olap.cubetemplate.NamespaceValidator;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.PLSQLForXMLGenerator;
import oracle.olap.cubetemplate.TemplatePreprocessor;
import oracle.olap.cubetemplate.TreeNode;
import oracle.olap.dml.DMLObject;

public class CubeTemplateManager {
    public static final String CUBE_BIND_VARIABLE = "CUBE_NAME";
    public static final String AW_BIND_VARIABLE = "AW_NAME";
    public static final String CUBE_RENAME_VARIABLE = "__CUBE_NAME__";
    public static final String AW_RENAME_VARIABLE = "__AW_NAME__";
    private static final String XMLFILE = "cubetemplatemanager.xml";
    private static final String TEMPLATE_HEAD = "TEMPLATE_HEAD";
    private static final String APPEND_XML = "APPEND_XML";
    private static final String APPEND_XML_END = "APPEND_XML_END";
    private static final String IMPORT = "IMPORT";
    private static final String START_DML = "START_DML";
    private static final String APPEND_DML = "APPEND_DML";
    private static final String APPEND_DML_END = "APPEND_DML_END";
    private static final String DML_PROGRAM = "DML_PROGRAM";
    private static final String TEMPLATE_END = "TEMPLATE_END";
    private static final String ATTACH = "ATTACH";
    private static final String DETACH = "DETACH";
    private final OLAPPersistence olapPersistence;
    private final Resources resources;
    private final ErrorDisplay errorDisplay;
    private final OLAPXML olapXML;
    private final Connection conn;
    private final ExportPreprocessor dta;
    private final JFrame parentFrame;
    private final HelpProvider helpProvider;
    private Queries queries;

    public CubeTemplateManager(ErrorDisplay errorDisplay, Resources resources, HelpProvider helpProvider, JFrame jFrame, OLAPPersistence oLAPPersistence, OLAPXML oLAPXML, ExportPreprocessor exportPreprocessor, Connection connection) {
        this.olapPersistence = oLAPPersistence;
        this.errorDisplay = errorDisplay;
        this.resources = resources;
        this.helpProvider = helpProvider;
        this.olapXML = oLAPXML;
        this.conn = connection;
        this.dta = exportPreprocessor;
        this.parentFrame = jFrame;
        try {
            String string = "oracle.olap.app.table";
            String string2 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr(string2, string, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasCollisions(String string, TemplatePreprocessor templatePreprocessor, boolean bl) throws XPathExpressionException, TransformerConfigurationException, TransformerException, SQLException {
        Object object;
        Object object2;
        NamespaceValidator namespaceValidator = new NamespaceValidator(this.conn, string);
        boolean bl2 = false;
        if (!bl) {
            try {
                object2 = templatePreprocessor.getTemplateType();
                if (object2 == ObjectType.DERIVED_MEASURE || object2 == ObjectType.MEASURE) {
                    bl2 = namespaceValidator.checkForCollisions(templatePreprocessor.getObjects(ObjectType.DERIVED_MEASURE, null)) || namespaceValidator.checkForCollisions(templatePreprocessor.getObjects(ObjectType.MEASURE, null));
                } else {
                    object = templatePreprocessor.getObjects(ObjectType.ALL, null);
                    object.removeAll(templatePreprocessor.getPartialCubes());
                    bl2 = namespaceValidator.checkForCollisions((List<TreeNode>)object);
                }
            }
            catch (Exception exception) {
                bl2 = true;
            }
        }
        if (bl2) {
            object2 = new ImportNameConflictResolver(namespaceValidator, templatePreprocessor, this.parentFrame, this.resources, this.helpProvider);
            object = ((ImportNameConflictResolver)object2).resolveConflict(bl);
            if (object == null) {
                bl2 = true;
            } else {
                templatePreprocessor.setRenameMap((ConflictRenameMap)object);
                bl2 = false;
            }
        }
        return bl2;
    }

    private String getAsociatedDMLFile(String string, boolean bl) {
        DMLTemplate dMLTemplate = new DMLTemplate(this.errorDisplay, this.resources);
        List<String> list = bl ? DMLTemplate.getDMLFileNames(new String[]{string}) : new ArrayList<String>();
        boolean bl2 = dMLTemplate.createDMLAskUser(list, this.parentFrame);
        if (bl2 && list.size() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    private void processErrors(Object object) throws Exception {
        if (object != null && object instanceof ErrorLocalizer) {
            ErrorLocalizer errorLocalizer = (ErrorLocalizer)object;
            if (errorLocalizer.hasError()) {
                if (errorLocalizer.isFatal()) {
                    try {
                        this.errorDisplay.show(errorLocalizer.getException(), errorLocalizer.getLocalizedMessage(), this.parentFrame);
                        this.olapPersistence.rollback();
                    }
                    catch (Exception exception) {}
                } else {
                    JOptionPane.showMessageDialog(this.parentFrame, errorLocalizer.getLocalizedMessage(), errorLocalizer.getLocalizedTitle(), 1);
                }
            }
        } else if (object != null && object instanceof Exception) {
            throw (Exception)object;
        }
    }

    private String getNewAwName(TemplatePreprocessor templatePreprocessor, String string) throws XPathExpressionException {
        ConflictRenameMap conflictRenameMap = templatePreprocessor.getRenameMap();
        if (conflictRenameMap != null) {
            conflictRenameMap.resetIterator();
            while (conflictRenameMap.getNextObjectName() != null) {
                if (conflictRenameMap.getType() != 3) continue;
                string = conflictRenameMap.getRenameEntry(3, conflictRenameMap.getCurrentObjectName());
            }
        }
        if (string == null) {
            List<TreeNode> list = templatePreprocessor.getObjects(ObjectType.WORKSPACE, null);
            string = String.valueOf(list.get(0).getUserObject());
        }
        return string;
    }

    public void createFromXML(final String string, final String string2, final TemplatePreprocessor templatePreprocessor, final boolean bl, final boolean bl2, String string3) {
        if (templatePreprocessor == null) {
            return;
        }
        final String string4 = this.getAsociatedDMLFile(string3, string3 != null && bl2);
        ArrayList arrayList = new ArrayList(1);
        this.olapPersistence.clearCache();
        try {
            BaseRunnable baseRunnable = new BaseRunnable(){

                @Override
                public void run() {
                    ErrorLocalizer errorLocalizer = null;
                    try {
                        ConflictRenameMap conflictRenameMap = null;
                        if (!CubeTemplateManager.this.hasCollisions(string, templatePreprocessor, bl)) {
                            conflictRenameMap = templatePreprocessor.getRenameMap();
                            errorLocalizer = CubeTemplateManager.this.processXMLTemplate(string, templatePreprocessor, CubeTemplateManager.this.getNewAwName(templatePreprocessor, string2), string4, bl, bl2, conflictRenameMap);
                        }
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                    }
                    this.getProgressBar().setDoneStatus();
                }
            };
            ProgressBar progressBar = new ProgressBar((Component)this.parentFrame, this.resources.getString("EXPORT_TO_TABLE.DIALOG.BAR.TITLE"), (Runnable)baseRunnable, true);
            progressBar.setCancelable(false);
            baseRunnable.setProgressBar(progressBar);
            progressBar.start(this.resources.getString("EXPORT_TO_TABLE.DIALOG.BAR.MESSAGE"), null);
            if (baseRunnable.getException() != null) {
                this.processErrors(baseRunnable.getException());
            } else if (arrayList.size() > 0) {
                this.processErrors(arrayList.get(0));
            }
        }
        catch (Exception exception) {
            String string5 = string3 != null ? this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.UNABLE_TO_CREATE_FILE", string3) : this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.UNABLE_TO_CREATE");
            this.errorDisplay.show(exception, string5, this.parentFrame);
            try {
                this.olapPersistence.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ErrorLocalizer processXMLTemplate(String string, TemplatePreprocessor templatePreprocessor, String string2, String string3, boolean bl, boolean bl2, ConflictRenameMap conflictRenameMap) throws Exception {
        ErrorLocalizer errorLocalizer = null;
        try {
            block14: {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String string4 = string + "." + string2;
                List list = null;
                list = this.createTemplateOjects(string, bl, templatePreprocessor, conflictRenameMap);
                if (bl2) {
                    hashMap.putAll(templatePreprocessor.getDMLObjects());
                }
                this.olapPersistence.commit();
                if (!hashMap.isEmpty() && bl2) {
                    DMLTemplate dMLTemplate = new DMLTemplate(this.errorDisplay, this.resources);
                    dMLTemplate.executeCreateDML(this.conn, string4, hashMap, bl);
                }
                boolean bl3 = false;
                if (string3 != null && bl2) {
                    try {
                        String string5 = DMLObject.getAWAttachModeInSession(this.conn, this.dta.getQualifiedWorkspace());
                        if (string5 != null) {
                            if (!string5.equalsIgnoreCase("RW")) {
                                DMLObject.runDML(this.conn, "DETACH_AW", string4);
                                DMLObject.runDML(this.conn, "ATTACH_AW", string4);
                                bl3 = true;
                            }
                        } else {
                            DMLObject.runDML(this.conn, "ATTACH_AW", string4);
                            bl3 = true;
                        }
                        String string6 = DMLTemplate.readFile(string3);
                        DatabaseUtils.ExecuteSPL(this.conn, string6);
                        DMLObject.runDML(this.conn, "UPDATE_AW", string4);
                        this.conn.commit();
                        if (!bl3) break block14;
                    }
                    catch (SQLException sQLException) {
                        try {
                            throw sQLException;
                        }
                        catch (Throwable throwable) {
                            if (!bl3) throw throwable;
                            DMLObject.runDML(this.conn, "DETACH_AW", string4);
                            throw throwable;
                        }
                    }
                    DMLObject.runDML(this.conn, "DETACH_AW", string4);
                }
            }
            this.olapXML.cleanup();
            return errorLocalizer;
        }
        catch (Exception exception) {
            ErrorLocalizer errorLocalizer2;
            if (this.olapPersistence instanceof ErrorLocalizer && (errorLocalizer2 = (ErrorLocalizer)((Object)this.olapPersistence)).hasError()) {
                errorLocalizer = errorLocalizer2;
            }
            if (this.olapXML instanceof ErrorLocalizer && (errorLocalizer2 = (ErrorLocalizer)((Object)this.olapXML)).hasError() && errorLocalizer2.isFatal()) {
                errorLocalizer = errorLocalizer2;
            }
            if (errorLocalizer != null) return errorLocalizer;
            throw exception;
        }
    }

    public List createTemplateOjects(String string, boolean bl, TemplatePreprocessor templatePreprocessor, ConflictRenameMap conflictRenameMap) throws Exception {
        return this.olapXML.importXml(new StringReader(templatePreprocessor.getDocument()), string, bl, templatePreprocessor.getBindMap(), conflictRenameMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveToXML(List<Object> list, boolean bl, String string, boolean bl2, String string2, Writer writer) throws IOException, SQLException, Exception {
        this.dta.processObjects(list);
        this.olapXML.exportXml(writer, this.dta.getOLAPObjects(), this.dta.getBindMap(), this.createOptions(bl, string, string2));
        List<DMLObject> list2 = this.dta.getDMLObjects();
        boolean bl3 = false;
        if (!bl2) return;
        if (list2.isEmpty()) return;
        try {
            String string3 = DMLObject.getAWAttachModeInSession(this.conn, this.dta.getQualifiedWorkspace());
            if (string3 != null) {
                bl3 = true;
            } else {
                DMLObject.runDML(this.conn, "ATTACH_AW_RO_FIRST", this.dta.getQualifiedWorkspace());
            }
            writer.write("\n<!--Generated by the Oracle SQL Developer OLAP Extension-->");
            DMLTemplate.saveDMLObjects(writer, this.dta.getDMLObjects(), true);
            if (bl3) return;
        }
        catch (Throwable throwable) {
            if (bl3) throw throwable;
            DMLObject.runDML(this.conn, "DETACH_AW", this.dta.getQualifiedWorkspace());
            throw throwable;
        }
        DMLObject.runDML(this.conn, "DETACH_AW", this.dta.getQualifiedWorkspace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToPLSQL(List<Object> list, boolean bl, String string, boolean bl2, String string2, Writer writer) throws IOException, SQLException, Exception {
        block7: {
            this.dta.processObjects(list);
            writer.write(this.queries.getSQL(TEMPLATE_HEAD));
            writer.append('\n');
            StringWriter stringWriter = new StringWriter();
            this.olapXML.exportXml(stringWriter, this.dta.getOLAPObjects(), null, this.createOptions(bl, string, string2));
            writer.append(this.resources.getString("EXPORT_TO_PLSQL_OLAP_OBJECT", this.dta.getQualifiedWorkspace()));
            writer.append('\n');
            PLSQLForXMLGenerator.writePLSQLPieces(stringWriter.toString(), writer, this.queries.getSQL(APPEND_XML), this.queries.getSQL(APPEND_XML_END), true);
            writer.append('\n');
            writer.append(this.queries.getSQL(IMPORT));
            writer.append('\n');
            boolean bl3 = false;
            if (bl2) {
                try {
                    String string3 = DMLObject.getAWAttachModeInSession(this.conn, this.dta.getQualifiedWorkspace());
                    if (string3 != null) {
                        bl3 = true;
                    } else {
                        DMLObject.runDML(this.conn, "ATTACH_AW_RO_FIRST", this.dta.getQualifiedWorkspace());
                    }
                    List<DMLObject> list2 = this.dta.getDMLObjects();
                    String string4 = this.queries.getSQL(APPEND_DML);
                    String string5 = this.queries.getSQL(APPEND_DML_END);
                    writer.append(this.resources.getString("EXPORT_TO_PLSQL_DML"));
                    writer.append("\n");
                    writer.append(String.format(this.queries.getSQL(ATTACH), this.dta.getQualifiedWorkspace()));
                    for (DMLObject dMLObject : list2) {
                        writer.append(this.queries.getSQL(START_DML));
                        writer.append('\n');
                        PLSQLForXMLGenerator.writePLSQLPieces(dMLObject.fetchDefinition(), writer, string4, string5, false);
                        writer.append(String.format(this.queries.getSQL(DML_PROGRAM), this.dta.getQualifiedWorkspace()));
                        writer.append('\n');
                    }
                    writer.append(String.format(this.queries.getSQL(DETACH), this.dta.getQualifiedWorkspace()));
                    writer.append('\n');
                    if (bl3) break block7;
                }
                catch (Throwable throwable) {
                    if (!bl3) {
                        DMLObject.runDML(this.conn, "DETACH_AW", this.dta.getQualifiedWorkspace());
                    }
                    throw throwable;
                }
                DMLObject.runDML(this.conn, "DETACH_AW", this.dta.getQualifiedWorkspace());
            }
        }
        writer.append(this.queries.getSQL(TEMPLATE_END));
    }

    private OLAPXMLExportOptions createOptions(boolean bl, String string, String string2) {
        OLAPXMLExportOptions oLAPXMLExportOptions = new OLAPXMLExportOptions(bl, string, string2);
        oLAPXMLExportOptions.addSuppressAttribute("ETAttrPrefix");
        oLAPXMLExportOptions.addSuppressAttribute("TablespaceName");
        return oLAPXMLExportOptions;
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    public static enum OutputFormat {
        XML("XML", ".xml"),
        PLSQL("PL/SQL", ".sql");

        private String name;
        private String extension;

        private OutputFormat(String string2, String string3) {
            this.name = string2;
            this.extension = string3;
        }

        public String toString() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

