/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.olap.app.Resources;
import oracle.olap.app.Version;
import oracle.olap.cubetemplate.CubeTemplateManager;

public class ExportOptionsPanel
extends JPanel {
    private JCheckBox includeSchemaNameOLAPObjCheckBox;
    private JRadioButton inclSchemaInNonOwnerMapObjButton;
    private JRadioButton inclSchemaInAllMapObjButton;
    private JRadioButton notInclSchemaInAllMapObjButton;
    private final DefaultComboBoxModel fileFormatVersions = new DefaultComboBoxModel();
    private final JComboBox outputFormat = new JComboBox<CubeTemplateManager.OutputFormat>(CubeTemplateManager.OutputFormat.values());
    private final boolean outputFormatsupported;
    private final JComboBox fileFormatVersion = new JComboBox(this.fileFormatVersions);
    private final JPanel fileFormatPanel = new JPanel();
    private JLabel fileFormatOptionsLabel = new JLabel();
    private final JPanel inclSchemaPanel = new JPanel();
    private JLabel mappedOptionsLabel = new JLabel();
    private JLabel olapOptionsLabel = new JLabel();
    private final boolean exportVersionSupported;
    private final String dbVersion;
    private final String dbUser;
    private final transient Resources resources;
    private boolean m_includeSchemaNameInOLAPObjects = false;
    private static final String FILE_VERSION_12_1 = "12.1.0.0";
    private static final String FILE_VERSION_11_2_0_2 = "11.2.0.2";
    private static final String FILE_VERSION_11_2 = "11.2";
    private static final String FILE_VERSION_11_1 = "11.1.0.7";

    public ExportOptionsPanel(boolean bl, String string, String string2, Resources resources, boolean bl2, CubeTemplateManager.OutputFormat outputFormat) {
        this.outputFormat.setName("outputFormat");
        this.fileFormatVersion.setName("fileFormatVersion");
        this.fileFormatPanel.setName("fileFormatPanel");
        this.fileFormatOptionsLabel.setName("fileFormatOptionsLabel");
        this.inclSchemaPanel.setName("inclSchemaPanel");
        this.mappedOptionsLabel.setName("mappedOptionsLabel");
        this.olapOptionsLabel.setName("olapOptionsLabel");
        this.exportVersionSupported = bl;
        this.dbUser = string;
        this.dbVersion = string2;
        this.resources = resources;
        this.outputFormatsupported = bl2;
        this.outputFormat.setSelectedItem((Object)outputFormat);
        this.jbInit();
    }

    public boolean includeSchemaNameInOLAPObjects() {
        return this.m_includeSchemaNameInOLAPObjects;
    }

    public String includeSchemaNameInMappedObjects() {
        if (this.inclSchemaInNonOwnerMapObjButton.getModel().isSelected()) {
            return "NON_OWNER_MAPPED_QUALIFIED";
        }
        if (this.inclSchemaInAllMapObjButton.getModel().isSelected()) {
            return "ALL_MAPPED_QUALIFIED";
        }
        if (this.notInclSchemaInAllMapObjButton.getModel().isSelected()) {
            return "NONE_MAPPED_QUALIFIED";
        }
        return "NON_OWNER_MAPPED_QUALIFIED";
    }

    public String getFileFormatVersion() {
        if (this.exportVersionSupported) {
            String string = (String)this.fileFormatVersion.getSelectedItem();
            if (string.equalsIgnoreCase("12.1")) {
                return FILE_VERSION_12_1;
            }
            if (string.equalsIgnoreCase(FILE_VERSION_11_2_0_2)) {
                return FILE_VERSION_11_2_0_2;
            }
            if (string.equalsIgnoreCase(FILE_VERSION_11_2)) {
                return FILE_VERSION_11_2;
            }
            if (string.equalsIgnoreCase("11.1")) {
                return FILE_VERSION_11_1;
            }
            return FILE_VERSION_12_1;
        }
        return null;
    }

    public CubeTemplateManager.OutputFormat getOutputFormat() {
        return (CubeTemplateManager.OutputFormat)((Object)this.outputFormat.getSelectedItem());
    }

    private void jbInit() {
        String string = "SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_OLAPSCHEMA_OPTION";
        this.includeSchemaNameOLAPObjCheckBox = new JCheckBox();
        this.includeSchemaNameOLAPObjCheckBox.setName("includeSchemaNameOLAPObjCheckBox");
        this.setMnemonic(this.includeSchemaNameOLAPObjCheckBox, string);
        this.includeSchemaNameOLAPObjCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExportOptionsPanel.this.includeSchemaNameOLAPObjCheckBox.isSelected()) {
                    ExportOptionsPanel.this.m_includeSchemaNameInOLAPObjects = true;
                } else {
                    ExportOptionsPanel.this.m_includeSchemaNameInOLAPObjects = false;
                }
            }
        });
        string = this.resources.getString("SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_MAPPEDSCHEMA_OPTION_SOME", this.dbUser);
        this.inclSchemaInNonOwnerMapObjButton = new JRadioButton(string);
        this.inclSchemaInNonOwnerMapObjButton.setName("inclSchemaInNonOwnerMapObjButton");
        string = "SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_MAPPEDSCHEMA_OPTION_ALL";
        this.inclSchemaInAllMapObjButton = new JRadioButton();
        this.inclSchemaInAllMapObjButton.setName("inclSchemaInAllMapObjButton");
        this.setMnemonic(this.inclSchemaInAllMapObjButton, string);
        string = "SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_MAPPEDSCHEMA_OPTION_NONE";
        this.notInclSchemaInAllMapObjButton = new JRadioButton();
        this.notInclSchemaInAllMapObjButton.setName("notInclSchemaInAllMapObjButton");
        this.setMnemonic(this.notInclSchemaInAllMapObjButton, string);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.inclSchemaInAllMapObjButton);
        buttonGroup.add(this.inclSchemaInNonOwnerMapObjButton);
        buttonGroup.add(this.notInclSchemaInAllMapObjButton);
        string = "SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_MAPPEDSCHEMA_OPTIONS";
        this.mappedOptionsLabel = this.newJLabel(string);
        this.mappedOptionsLabel.setName("mappedOptionsLabel");
        string = "SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_OLAPSCHEMA_OPTIONS";
        this.olapOptionsLabel = this.newJLabel(string);
        this.olapOptionsLabel.setName("olapOptionsLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        string = "SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_FILEFORMAT_OPTIONS";
        this.fileFormatOptionsLabel = this.newJLabel(string);
        this.fileFormatOptionsLabel.setName("fileFormatOptionsLabel");
        this.fileFormatVersions.removeAllElements();
        this.fileFormatVersions.addElement("12.1");
        this.fileFormatVersions.addElement(FILE_VERSION_11_2_0_2);
        this.fileFormatVersions.addElement(FILE_VERSION_11_2);
        this.fileFormatVersions.addElement("11.1");
        this.setFileFormatDefault();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.inclSchemaPanel.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.inclSchemaPanel.add((Component)this.olapOptionsLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.inclSchemaPanel.add((Component)this.includeSchemaNameOLAPObjCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.inclSchemaPanel.add((Component)this.mappedOptionsLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.inclSchemaPanel.add((Component)this.inclSchemaInAllMapObjButton, gridBagConstraints);
        this.inclSchemaPanel.add((Component)this.inclSchemaInNonOwnerMapObjButton, gridBagConstraints);
        this.inclSchemaPanel.add((Component)this.notInclSchemaInAllMapObjButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.fileFormatPanel.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.fileFormatPanel.add((Component)this.fileFormatOptionsLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.fileFormatPanel.add((Component)this.fileFormatVersion, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("outputFormatPanel");
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)this.newJLabel("SAVE_TO_TEMPLATE_DLG.OUTPUT_FORMAT"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        jPanel.add((Component)this.outputFormat, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.inclSchemaPanel, gridBagConstraints);
        if (this.exportVersionSupported) {
            this.add((Component)this.fileFormatPanel, gridBagConstraints);
        }
        if (this.outputFormatsupported) {
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.includeSchemaNameOLAPObjCheckBox.setSelected(false);
        this.inclSchemaInNonOwnerMapObjButton.getModel().setSelected(true);
    }

    public JLabel newJLabel(String string) {
        String string2 = this.resources.getString(string);
        int n = string2.indexOf("&");
        JLabel jLabel = new JLabel(string2.replaceFirst("&", ""));
        jLabel.setName("label");
        if (n != -1) {
            jLabel.setDisplayedMnemonicIndex(n);
            jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n));
        }
        return jLabel;
    }

    private void setMnemonic(AbstractButton abstractButton, String string) {
        String string2 = this.resources.getString(string);
        abstractButton.setText(string2.replaceFirst("&", ""));
        int n = string2.indexOf("&");
        if (n != -1) {
            abstractButton.setMnemonic(string2.charAt(n));
        }
    }

    private void setFileFormatDefault() {
        if (this.exportVersionSupported) {
            Version version = new Version(this.dbVersion);
            Version version2 = new Version("11.2.0.2.0");
            Version version3 = new Version("12.1.0.0.0");
            if (version.compareTo(version3) >= 0) {
                this.fileFormatVersions.setSelectedItem("12.1");
            } else if (version.compareTo(version2) >= 0) {
                this.fileFormatVersions.setSelectedItem(FILE_VERSION_11_2_0_2);
            } else {
                this.fileFormatVersions.setSelectedItem(FILE_VERSION_11_2);
            }
        }
    }
}

