/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.Frame;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.ImportConflictDialog;
import oracle.olap.cubetemplate.NamespaceValidator;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TemplatePreprocessor;
import oracle.olap.cubetemplate.TreeNode;

public class ImportNameConflictResolver {
    private final Frame parentFrame;
    private final Resources resources;
    private final NamespaceValidator checker;
    private final TemplatePreprocessor preprocessor;
    private final HelpProvider helpProvider;

    public ImportNameConflictResolver(NamespaceValidator namespaceValidator, TemplatePreprocessor templatePreprocessor, Frame frame, Resources resources, HelpProvider helpProvider) {
        this.parentFrame = frame;
        this.resources = resources;
        this.checker = namespaceValidator;
        this.preprocessor = templatePreprocessor;
        this.helpProvider = helpProvider;
    }

    private void addToConflictMap(ConflictRenameMap conflictRenameMap, ObjectType objectType, List<TreeNode> list, String string) throws XPathExpressionException {
        for (TreeNode treeNode : this.preprocessor.getObjects(objectType, string)) {
            if (list.contains(treeNode)) continue;
            conflictRenameMap.addEntry(treeNode.getType(), (String)treeNode.getUserObject(), treeNode.getParentName());
        }
    }

    public ConflictRenameMap resolveConflict(boolean bl) throws XPathExpressionException, SQLException {
        ConflictRenameMap conflictRenameMap = new ConflictRenameMap();
        ObjectType[] objectTypeArray = new ObjectType[]{ObjectType.WORKSPACE, ObjectType.CUBE, ObjectType.DIMENSION, ObjectType.MEASURE_FOLDER};
        boolean bl2 = false;
        List<TreeNode> list = this.preprocessor.getPartialCubes();
        switch (this.preprocessor.getTemplateType()) {
            case MEASURE: 
            case DERIVED_MEASURE: {
                objectTypeArray = new ObjectType[]{ObjectType.MEASURE, ObjectType.DERIVED_MEASURE};
                bl2 = true;
                break;
            }
            case ALL: {
                TreeNode serializable2;
                Iterator<TreeNode> iterator = list.iterator();
                while (iterator.hasNext() && !(bl2 = this.checker.checkForCollisions(this.preprocessor.getObjects(ObjectType.ALL, (String)(serializable2 = iterator.next()).getUserObject())))) {
                }
            }
            case WORKSPACE: 
            case CUBE: 
            case DIMENSION: 
            case MEASURE_FOLDER: {
                objectTypeArray = new ObjectType[]{ObjectType.WORKSPACE, ObjectType.CUBE, ObjectType.DIMENSION, ObjectType.MEASURE_FOLDER};
            }
        }
        for (int i = 0; i < objectTypeArray.length; ++i) {
            this.addToConflictMap(conflictRenameMap, objectTypeArray[i], list, null);
        }
        if (bl2 && list != null) {
            for (TreeNode treeNode : list) {
                this.addToConflictMap(conflictRenameMap, ObjectType.ALL, list, (String)treeNode.getUserObject());
            }
        }
        String string = "";
        string = this.preprocessor.getTemplateType() == ObjectType.DIMENSION ? this.resources.getString("NAMESPACE_CONFLICT_DIALOG_RESOLVE_DIM_TEMPLATE_TITLE") : this.resources.getString("NAMESPACE_CONFLICT_DIALOG_RESOLVE_AW_TEMPLATE_TITLE");
        ImportConflictDialog importConflictDialog = new ImportConflictDialog(this.parentFrame, string, this.resources, this.helpProvider, conflictRenameMap, this.checker, bl2, bl);
        importConflictDialog.setVisible(true);
        if (importConflictDialog.isSuccesful()) {
            return conflictRenameMap;
        }
        return null;
    }
}

