/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import javax.swing.Icon;
import oracle.olap.app.Resources;
import oracle.olap.app.util.FetchIcon;

public enum ObjectType {
    WORKSPACE("WORKSPACE"),
    DIMENSION("DIMENSION"),
    CUBE("CUBE"),
    DERIVED_MEASURE("CALCULATED MEASURE"),
    MEASURE("MEASURE"),
    MEASURE_FOLDER("MEASURE FOLDER"),
    ALL("%");

    private final String filterString;
    private ObjectType[] children = null;
    private static Resources resources;
    private static Icon workspaceIcon;
    private static Icon workspaceFIcon;
    private static Icon cubeIcon;
    private static Icon cubeFIcon;
    private static Icon measureIcon;
    private static Icon measureFIcon;
    private static Icon dMeasureIcon;
    private static Icon dMeasureFIcon;
    private static Icon dimIcon;
    private static Icon dimFIcon;

    private ObjectType(String string2) {
        this.filterString = string2;
    }

    public Icon getIcon(boolean bl) {
        if (!bl) {
            switch (this) {
                case WORKSPACE: {
                    return workspaceIcon;
                }
                case DIMENSION: {
                    return dimIcon;
                }
                case CUBE: {
                    return cubeIcon;
                }
                case DERIVED_MEASURE: {
                    return dMeasureIcon;
                }
                case MEASURE_FOLDER: 
                case MEASURE: {
                    return measureIcon;
                }
            }
            return null;
        }
        switch (this) {
            case WORKSPACE: {
                return workspaceFIcon;
            }
            case DIMENSION: {
                return dimFIcon;
            }
            case CUBE: {
                return cubeFIcon;
            }
            case DERIVED_MEASURE: {
                return dMeasureFIcon;
            }
            case MEASURE_FOLDER: 
            case MEASURE: {
                return measureFIcon;
            }
        }
        return null;
    }

    public static void setUpIcons(FetchIcon fetchIcon) {
        workspaceIcon = fetchIcon.getIcon("OLAPAW_ICON");
        workspaceFIcon = fetchIcon.getIcon("OLAPAW_FOLDER_ICON");
        cubeIcon = fetchIcon.getIcon("OLAPCUBE_ICON");
        cubeFIcon = fetchIcon.getIcon("OLAPCUBE_FOLDER_ICON");
        measureIcon = fetchIcon.getIcon("OLAPMEASURE_ICON");
        measureFIcon = fetchIcon.getIcon("OLAPMEASURE_FOLDER_ICON");
        dMeasureIcon = fetchIcon.getIcon("OLAPCALCMEASURE_ICON");
        dMeasureFIcon = fetchIcon.getIcon("OLAPCALCMEASURE_FOLDER_ICON");
        dimIcon = fetchIcon.getIcon("OLAPDIMENSION_ICON");
        dimFIcon = fetchIcon.getIcon("OLAPDIMENSION_FOLDER_ICON");
    }

    public ObjectType[] getChildTypes() {
        if (this.children == null) {
            switch (this) {
                case WORKSPACE: {
                    this.children = new ObjectType[]{CUBE, DIMENSION, MEASURE_FOLDER};
                    break;
                }
                case CUBE: {
                    this.children = new ObjectType[]{MEASURE, DERIVED_MEASURE};
                    break;
                }
                case ALL: {
                    this.children = new ObjectType[]{WORKSPACE};
                    break;
                }
                default: {
                    this.children = new ObjectType[0];
                }
            }
        }
        return this.children;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getDisplayName() {
        switch (this) {
            case WORKSPACE: {
                return resources.getString("OLAPAW_LABEL");
            }
            case DIMENSION: {
                return resources.getString("OLAPDIMENSION_LABEL");
            }
            case CUBE: {
                return resources.getString("OLAPCUBE_LABEL");
            }
            case DERIVED_MEASURE: {
                return resources.getString("OLAPCALCMEASURE_LABEL");
            }
            case MEASURE_FOLDER: {
                return resources.getString("OLAPMEASUREFOLDER_LABEL");
            }
            case MEASURE: {
                return resources.getString("OLAPMEASURE_LABEL");
            }
        }
        return "";
    }

    public String toString() {
        if (resources != null) {
            if (this == ALL) {
                return resources.getString("EXPORT_TO_TABLE.DIALOG.FORM.OBJECT_TYPE.ALL");
            }
            return this.getDisplayName();
        }
        return super.toString();
    }

    public static ObjectType fromNodeType(String string) {
        if (string.equals("OLAPAW") || string.equals("OLAPAW_FOLDER")) {
            return WORKSPACE;
        }
        if (string.equals("CUBE") || string.equals("CUBE_FOLDER")) {
            return CUBE;
        }
        if (string.equals("CUBE DIMENSION") || string.equals("CUBE DIMENSION_FOLDER")) {
            return DIMENSION;
        }
        if (string.equals("CUBEMEASURE")) {
            return MEASURE;
        }
        if (string.equals("CALCMEASURE")) {
            return DERIVED_MEASURE;
        }
        if (string.equals("MEASURE FOLDER") || string.equals("MEASURE FOLDER_FOLDER") || string.equals("MEASURE_FOLDER")) {
            return MEASURE_FOLDER;
        }
        return ALL;
    }

    public static void setResources(Resources resources) {
        ObjectType.resources = resources;
    }
}

