/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import oracle.olap.cubetemplate.CubeCatalogManager;
import oracle.olap.cubetemplate.ObjectType;

public class SelectorModel
extends DefaultTableModel {
    public static final int MODIFIED = 0;
    public static final int USERNAME = 1;
    public static final int TEMPLATE_NAME = 2;
    public static final int TEMPLATE_VERSION = 3;
    public static final int PARENT_OBJECT = 4;
    public static final int DESCRIPTION = 5;
    public static final int TYPE = 6;
    private boolean desc = false;
    private String lastSchema = "";
    private String filter = "";
    private int sortColumn = 0;
    private transient SwingWorker worker = null;
    private final transient CubeCatalogManager ccm;
    private final transient Connection conn;
    private ObjectType objectType = null;

    public SelectorModel(Connection connection) {
        super(new Object[]{"MODIFIED", "USERNAME", "NAME", "VERSION", "PARENT_OBJECT", "DESCRIPTION", "TYPE"}, 0);
        this.conn = connection;
        this.setSortColumn(2);
        try {
            this.lastSchema = this.conn.getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.ccm = new CubeCatalogManager(connection);
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public void loadData(String string) throws SQLException {
        int n = 0;
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        if (string != null) {
            this.lastSchema = string;
        }
        this.setRowCount(0);
        n = this.ccm.countBatch(this.lastSchema, this.getCleanFilter(), this.objectType.getFilterString());
        this.setRowCount(n);
        final PreparedStatement preparedStatement = this.ccm.readBatch(this.lastSchema, this.getCleanFilter(), this.objectType.getFilterString(), this.getCleanSort());
        preparedStatement.setFetchSize(30);
        final ResultSet resultSet = preparedStatement.executeQuery();
        this.worker = new SwingWorker(){
            boolean running = true;

            private synchronized void setRunning(boolean bl) {
                this.running = bl;
            }

            private synchronized boolean isRunning() {
                return this.running;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() {
                try {
                    int n = 0;
                    while (resultSet.next() && this.isRunning()) {
                        Vector<Object> vector = new Vector<Object>(7);
                        vector.add(resultSet.getTimestamp("MODIFIED"));
                        vector.add(resultSet.getString("USERNAME"));
                        vector.add(resultSet.getString("NAME"));
                        vector.add(resultSet.getString("VERSION"));
                        vector.add(resultSet.getString("PARENT_OBJECT"));
                        vector.add(resultSet.getString("DESCRIPTION"));
                        vector.add(resultSet.getString("TYPE"));
                        SelectorModel.this.addRow(n, vector);
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                finally {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                SelectorModel.this.worker = null;
                this.setRunning(false);
                System.out.format("done(). isCanceled? %s%n", this.isCancelled());
            }
        };
        this.worker.execute();
    }

    private void addRow(final int n, final Vector vector) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SelectorModel.this.dataVector.setElementAt(vector, n);
                    SelectorModel.this.fireTableRowsUpdated(n, n);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSortColumn(int n) {
        this.desc = this.sortColumn == n && !this.desc;
        this.sortColumn = n;
    }

    public void setFilter(String string) {
        this.filter = string.trim();
    }

    private String getCleanFilter() {
        return this.filter.equals("") ? "" : " AND " + this.filter;
    }

    private String getCleanSort() {
        return this.getColumnName(this.sortColumn) + (this.desc ? " DESC" : " ASC");
    }

    public boolean isSortedBy(int n) {
        return n == this.sortColumn;
    }

    public void setSchema(String string) {
        this.lastSchema = string;
    }

    public boolean isDesc() {
        return this.desc;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

