/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.DMLTemplate;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TreeModelHelper;
import oracle.olap.cubetemplate.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplatePreprocessor
implements TreeModelHelper {
    private static final Logger LOG = Logger.getLogger(TemplatePreprocessor.class.getName());
    private static final String BIND_ENTITY_PUBLIC_ID = "OLAP BIND VALUES";
    private static final String ENTITY_SYSTEM_ID = "OLAP METADATA";
    static final String TEMPLATE_DML_OBJECT = "OLAP DML OBJECT:";
    static final String TEMPLATE_DML_CODE = "OLAP DML CODE";
    private static final String[] regex = new String[]{"\\b(%s)([\\s.,_\")])", "\\b(%s)([\\s.,\")])"};
    private static final int UNDERSCORE = 0;
    private static final int DOT = 1;
    private static final int SIMPLE = 2;
    final XPath xp = XPathFactory.newInstance().newXPath();
    final Map<String, String> bindMap;
    private ConflictRenameMap renameMap;
    private boolean is11g = true;
    private Document doc;
    private Map<String, String> dmlObjects = new HashMap<String, String>();
    private String xmlTemplate;

    public TemplatePreprocessor(Map<String, String> map, ConflictRenameMap conflictRenameMap) {
        this.bindMap = map;
        this.renameMap = conflictRenameMap;
    }

    public String preprocessDocument(Reader reader) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        Object object;
        String string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (this.bindMap != null) {
            documentBuilder.setEntityResolver(this.getEntityResolver());
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        String string2 = this.xmlTemplate = stringBuffer.toString();
        int n = this.xmlTemplate.indexOf("<!-- OLAP DML OBJECT:");
        if (n >= 0) {
            string2 = this.xmlTemplate.substring(0, n);
        }
        this.dmlObjects = DMLTemplate.getDMLFromXML(this.xmlTemplate);
        StringReader stringReader = new StringReader(string2);
        this.doc = documentBuilder.parse(new InputSource(stringReader));
        try {
            this.processDimensionality();
            this.removeXPath("//@ETViewName");
            this.removeXPath("//@ETKeyColumnName");
            object = (NodeList)this.xp.evaluate("/AWXML", this.doc, XPathConstants.NODESET);
            this.is11g = object.getLength() == 0;
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.is11g = true;
        }
        if (this.renameMap != null) {
            this.renameDocument(this.renameMap);
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(this.getDocument());
        if (n >= 0) {
            ((StringBuffer)object).append("\n");
            ((StringBuffer)object).append(this.xmlTemplate.substring(n));
        }
        return ((StringBuffer)object).toString();
    }

    public int removeXPath(String string) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.xp.evaluate(string, this.doc, XPathConstants.NODESET);
        int n = 0;
        Node node = nodeList.item(n);
        while (node != null) {
            String string2 = node.getNodeName();
            Node node2 = (Node)this.xp.evaluate("../.", node, XPathConstants.NODE);
            if (node.getNodeType() == 2) {
                node2.getAttributes().removeNamedItem(string2);
            } else {
                node2.removeChild(node);
            }
            this.doc.normalizeDocument();
            node = nodeList.item(++n);
        }
        return n;
    }

    public void processDimensionality() throws XPathExpressionException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Node node;
        Node node2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = "//Cube/Dimensionality";
        NodeList nodeList = (NodeList)this.xp.evaluate(string2, this.doc, XPathConstants.NODESET);
        int n = 0;
        Node node3 = nodeList.item(n);
        while (node3 != null) {
            node2 = (Node)this.xp.evaluate("../.", node3, XPathConstants.NODE);
            node = node2.getAttributes().getNamedItem("Name");
            string = node.getNodeValue();
            object3 = null;
            object2 = node3.getAttributes().getNamedItem("Dimension");
            if (object2 != null) {
                object3 = object2.getNodeValue();
            }
            if (object3 != null) {
                object = node3.getChildNodes();
                int n2 = 0;
                Node node4 = object.item(n2);
                while (node4 != null) {
                    if (node4.getNodeName().equals("Dimension")) {
                        object2 = node4.getAttributes().getNamedItem("Name");
                        object3 = object2.getNodeValue();
                    }
                    node4 = object.item(++n2);
                }
            }
            if (object3 != null) {
                object = node3.getAttributes().getNamedItem("Name");
                String string3 = object.getNodeValue();
                hashMap.put(string + "." + string3, (String)object3);
                object.setNodeValue((String)object3);
                this.doc.normalizeDocument();
            }
            node3 = nodeList.item(++n);
        }
        string2 = "//Cube/CubeMap/CubeDimensionalityMap/@Dimensionality";
        nodeList = (NodeList)this.xp.evaluate(string2, this.doc, XPathConstants.NODESET);
        n = 0;
        node3 = nodeList.item(n);
        while (node3 != null) {
            node2 = (Node)this.xp.evaluate("../../../.", node3, XPathConstants.NODE);
            node = node2.getAttributes().getNamedItem("Name");
            string = node.getNodeValue();
            object3 = node3.getNodeValue();
            if (!((String)object3).equals(object2 = (String)hashMap.get(string + "." + (String)object3)) && object2 != null) {
                node3.setNodeValue((String)object2);
            }
            this.doc.normalizeDocument();
            node3 = nodeList.item(++n);
        }
        string2 = "//Cube/Organization/AWCubeOrganization/SparseDimension";
        nodeList = (NodeList)this.xp.evaluate(string2, this.doc, XPathConstants.NODESET);
        n = 0;
        node3 = nodeList.item(n);
        while (node3 != null) {
            node2 = (Node)this.xp.evaluate("../../../.", node3, XPathConstants.NODE);
            node = node2.getAttributes().getNamedItem("Name");
            string = node.getNodeValue();
            object3 = node3.getAttributes().getNamedItem("Name");
            object2 = object3.getNodeValue();
            object = (String)hashMap.get(string + "." + (String)object2);
            if (object != null) {
                object3.setNodeValue((String)object);
                this.doc.normalizeDocument();
            }
            node3 = nodeList.item(++n);
        }
    }

    public void addTemplate(TemplatePreprocessor templatePreprocessor) throws XPathExpressionException {
        this.addTemplate(templatePreprocessor, templatePreprocessor.getTemplateType());
    }

    public void addTemplate(TemplatePreprocessor templatePreprocessor, ObjectType objectType) throws XPathExpressionException {
        if (!this.isLoaded()) {
            this.xmlTemplate = templatePreprocessor.xmlTemplate;
            this.doc = templatePreprocessor.doc;
            this.dmlObjects = templatePreprocessor.dmlObjects;
            this.is11g = templatePreprocessor.is11g;
            return;
        }
        int n = 0;
        Node node = null;
        Node node2 = null;
        NodeList nodeList = null;
        List<TreeNode> list = null;
        switch (objectType) {
            case MEASURE: 
            case DERIVED_MEASURE: {
                node = (Node)this.xp.evaluate("/Metadata/Cube[1]", this.doc, XPathConstants.NODE);
                list = this.getObjects(ObjectType.ALL, node.getAttributes().getNamedItem("Name").getTextContent());
                nodeList = templatePreprocessor.getXPath("/Metadata/Cube/*[name()='Measure']");
                break;
            }
            case DIMENSION: {
                node2 = this.getXPath("/Metadata/*[1]").item(0);
            }
            case CUBE: 
            case MEASURE_FOLDER: 
            case ALL: {
                list = this.getObjects(ObjectType.ALL, null);
                node = (Node)this.xp.evaluate("/Metadata", this.doc, XPathConstants.NODE);
                nodeList = templatePreprocessor.getXPath("/Metadata/*");
                break;
            }
        }
        try {
            templatePreprocessor.fixDuplicates(list);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
        if (nodeList != null) {
            n = 0;
            Node node3 = nodeList.item(n);
            while (node3 != null) {
                node.insertBefore(this.doc.adoptNode(node3), node2);
                node3 = nodeList.item(++n);
            }
            n = 0;
            nodeList = templatePreprocessor.getXPath("/comment()");
            node3 = nodeList.item(n);
            while (node3 != null) {
                this.doc.appendChild(this.doc.adoptNode(node3));
                node3 = nodeList.item(++n);
            }
        }
    }

    private void fixDuplicates(List<TreeNode> list) throws TransformerConfigurationException, TransformerException, XPathExpressionException {
        List<TreeNode> list2 = null;
        ObjectType objectType = this.getTemplateType();
        if (objectType == ObjectType.DERIVED_MEASURE || objectType == ObjectType.MEASURE) {
            list2 = this.getObjects(ObjectType.MEASURE, null);
            list2.addAll(this.getObjects(ObjectType.DERIVED_MEASURE, null));
        } else {
            list2 = this.getObjects(ObjectType.ALL, null);
        }
        int n = 1;
        int n2 = 0;
        ConflictRenameMap conflictRenameMap = new ConflictRenameMap();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        for (TreeNode treeNode : list2) {
            n = 1;
            string = (String)treeNode.getUserObject();
            bl2 = false;
            bl = false;
            block1: while (!bl) {
                bl = true;
                for (TreeNode treeNode2 : list) {
                    if (!treeNode2.getUserObject().equals(string)) continue;
                    string = (String)treeNode.getUserObject();
                    n2 = string.length() + 1 + (int)Math.log10(n) + 1 - 30;
                    string = n2 > 0 ? string.substring(0, string.length() - n2) + "_" + n++ : string + "_" + n++;
                    bl2 = true;
                    bl = false;
                    continue block1;
                }
            }
            if (!bl2) continue;
            conflictRenameMap.addEntry(treeNode.getType(), (String)treeNode.getUserObject(), treeNode.getParentName(), string);
        }
        this.renameDocument(conflictRenameMap);
    }

    public NodeList getXPath(String string) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.xp.evaluate(string, this.doc, XPathConstants.NODESET);
        return nodeList;
    }

    public int setXPathValue(String string, String string2) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.xp.evaluate(string, this.doc, XPathConstants.NODESET);
        int n = 0;
        Node node = nodeList.item(n);
        while (node != null) {
            node.setTextContent(string2);
            node = nodeList.item(++n);
        }
        return n;
    }

    public String getRawXMLTemplate() {
        return this.xmlTemplate;
    }

    public String getDocument() throws TransformerConfigurationException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource dOMSource = new DOMSource(this.doc);
        StringWriter stringWriter = new StringWriter();
        transformer.transform(dOMSource, new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public Map<String, String> getDMLObjects() throws XPathExpressionException {
        return this.dmlObjects;
    }

    @Override
    public List<TreeNode> getObjects(ObjectType objectType, String string) throws XPathExpressionException {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (objectType == ObjectType.ALL) {
            ObjectType[] objectTypeArray = new ObjectType[]{ObjectType.WORKSPACE, ObjectType.CUBE, ObjectType.DIMENSION, ObjectType.MEASURE_FOLDER, ObjectType.MEASURE, ObjectType.DERIVED_MEASURE};
            for (int i = 0; i < objectTypeArray.length; ++i) {
                arrayList.addAll(this.getObjects(objectTypeArray[i], string));
            }
            return arrayList;
        }
        NodeList nodeList = (NodeList)this.xp.evaluate(this.getXPath(objectType, string), this.doc, XPathConstants.NODESET);
        int n = 0;
        String string2 = string;
        TreeNode treeNode = null;
        Node node = nodeList.item(n);
        while (node != null) {
            switch (objectType) {
                case MEASURE: 
                case DERIVED_MEASURE: {
                    if (string == null) {
                        string2 = this.xp.evaluate("../../../@Name", node);
                    }
                    treeNode = new TreeNode(node.getNodeValue(), string2, objectType, false, false);
                    break;
                }
                default: {
                    treeNode = new TreeNode(node.getNodeValue(), objectType, false);
                }
            }
            if (!arrayList.contains(treeNode)) {
                arrayList.add(treeNode);
            }
            node = nodeList.item(++n);
        }
        return arrayList;
    }

    public ObjectType getTemplateType() {
        ObjectType objectType = ObjectType.ALL;
        int n = 0;
        try {
            if (this.getObjects(ObjectType.WORKSPACE, null).size() > 0) {
                objectType = ObjectType.WORKSPACE;
            } else {
                int n2 = this.getObjects(ObjectType.CUBE, null).size();
                int n3 = this.getPartialCubes().size();
                if (n3 > 0 && this.is11g) {
                    if (this.getObjects(ObjectType.MEASURE, null).size() > 0) {
                        objectType = ObjectType.MEASURE;
                        ++n;
                    }
                    if (this.getObjects(ObjectType.DERIVED_MEASURE, null).size() > 0) {
                        objectType = ObjectType.DERIVED_MEASURE;
                        ++n;
                    }
                    if (n == 2) {
                        n = 1;
                    }
                }
                if (n2 > n3) {
                    objectType = ObjectType.CUBE;
                    ++n;
                }
                if (this.getObjects(ObjectType.DIMENSION, null).size() > 0) {
                    objectType = ObjectType.DIMENSION;
                    ++n;
                }
                if (this.getObjects(ObjectType.MEASURE_FOLDER, null).size() > 0) {
                    objectType = ObjectType.MEASURE_FOLDER;
                    ++n;
                }
                if (n > 1) {
                    objectType = ObjectType.ALL;
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            objectType = ObjectType.ALL;
        }
        return objectType;
    }

    public List<TreeNode> getPartialCubes() throws XPathExpressionException {
        if (this.is11g) {
            NodeList nodeList = (NodeList)this.xp.evaluate("/Metadata/Cube[count(./*[name()!='Measure'])=0]/@Name", this.doc, XPathConstants.NODESET);
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(nodeList.getLength());
            int n = 0;
            TreeNode treeNode = null;
            Node node = nodeList.item(n);
            while (node != null) {
                treeNode = new TreeNode(node.getNodeValue(), ObjectType.CUBE, false);
                if (!arrayList.contains(treeNode)) {
                    arrayList.add(treeNode);
                }
                node = nodeList.item(++n);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private String getXPath(ObjectType objectType, String string) {
        String string2 = null;
        if (!this.is11g) {
            return this.get10gxpath(objectType, string);
        }
        if (string != null) {
            switch (objectType) {
                case WORKSPACE: {
                    string2 = "/Metadata/AW/@Name";
                    break;
                }
                case CUBE: {
                    string2 = String.format("/Metadata/Cube[.//@AW='%1$s']/@Name", string);
                    break;
                }
                case DIMENSION: {
                    string2 = String.format("/Metadata/StandardDimension[.//@AW='%1$s']/@Name|/Metadata/TimeDimension[.//@AW='%1$s']/@Name", string);
                    break;
                }
                case MEASURE: {
                    string2 = String.format("/Metadata/Cube[@Name='%1$s']/Measure/BaseMeasure/@Name", string);
                    break;
                }
                case DERIVED_MEASURE: {
                    string2 = String.format("/Metadata/Cube[@Name='%1$s']/Measure/DerivedMeasure/@Name", string);
                    break;
                }
                case MEASURE_FOLDER: {
                    string2 = "/Metadata/OrganizationalSchema/@Name";
                }
            }
        } else {
            switch (objectType) {
                case WORKSPACE: {
                    string2 = "/Metadata/AW/@Name";
                    break;
                }
                case CUBE: {
                    string2 = "/Metadata/Cube/@Name";
                    break;
                }
                case DIMENSION: {
                    string2 = "/Metadata/StandardDimension/@Name|/Metadata/TimeDimension/@Name";
                    break;
                }
                case MEASURE: {
                    string2 = "/Metadata/Cube/Measure/BaseMeasure/@Name";
                    break;
                }
                case DERIVED_MEASURE: {
                    string2 = "/Metadata/Cube/Measure/DerivedMeasure/@Name";
                    break;
                }
                case MEASURE_FOLDER: {
                    string2 = "/Metadata/OrganizationalSchema/@Name";
                }
            }
        }
        return string2;
    }

    private String[] getXPath(int n, String string, String string2) {
        String[] stringArray = new String[]{null, null, null};
        switch (n) {
            case 3: {
                stringArray[2] = String.format("//@AW[.='%1$s']|//AW/@Name[.='%1$s']", string);
                break;
            }
            case 2: {
                stringArray[2] = String.format("/Metadata/Cube[@Name='%1$s']/@Name", string);
                stringArray[0] = String.format("/Metadata/Cube[@Name='%1$s']/@ETViewName", string);
                stringArray[1] = "/Metadata/Cube/Measure/DerivedMeasure/@MeasureExpression|/Metadata/Cube/Measure/DerivedMeasure/MeasureExpression|/Metadata/OrganizationalSchema/Measure/@Name|/Metadata/Cube/ConsistentSolve|/Metadata/Cube/Organization/AWCubeOrganization/BuildSpecifications|/Metadata/Cube/Organization/AWCubeOrganization/DefaultBuild";
                break;
            }
            case 1: {
                stringArray[2] = String.format("/Metadata/StandardDimension[@Name='%1$s']/@Name|/Metadata/TimeDimension[@Name='%1$s']/@Name|/Metadata/Cube/Dimensionality[@Dimension='%1$s']/@*[name()='Name' or name()='Dimension']|/Metadata/Cube/Dimensionality[@Name='%1$s']/@Name|/Metadata/Cube/CubeMap/CubeDimensionalityMap[@Dimensionality='%1$s']/@*[name()='Name' or name()='Dimensionality']|/Metadata/Cube/CubeMap/CubeDimensionalityMap[@Name='%1$s']/@Name|/Metadata/Cube/CubeMap/CubeDimensionalityMap/Dimensionality[@Name='%1$s']/@Name|/Metadata/Cube/Dimensionality/Dimension[@Name='%1$s']/@Name", string);
                stringArray[0] = String.format("/Metadata/StandardDimension[@Name='%1$s']//@ETViewName|/Metadata/TimeDimension[@Name='%1$s']//@ETViewName", string);
                stringArray[1] = String.format("/Metadata/TimeDimension[@Name='%1$s']/Hierarchy/LevelHierarchy/CustomOrder|/Metadata/StandardDimension[@Name='%1$s']/Hierarchy/LevelHierarchy/CustomOrder|/Metadata/TimeDimension[@Name='%1$s']/CustomOrder|/Metadata/StandardDimension[@Name='%1$s']/CustomOrder|/Metadata/Cube/Measure/DerivedMeasure/@MeasureExpression|/Metadata/Cube/Measure/DerivedMeasure/MeasureExpression|/Metadata/Cube/CubeMap/CubeDimensionalityMap/@MappedDimension|/Metadata/Cube/CubeMap/CubeDimensionalityMap/MappedDimension/@Name|/Metadata/Cube/Organization/AWCubeOrganization/@PartitionLevel|/Metadata/Cube/Organization/AWCubeOrganization/PartitionLevel/@Name|/Metadata/Cube/Organization/AWCubeOrganization/SecondaryPartitionLevel/@Level|/Metadata/Cube/Organization/AWCubeOrganization/SparseDimension[@Name='%1$s']/@Name|/Metadata/Cube/ConsistentSolve|/Metadata/Cube/Organization/AWCubeOrganization/PrecomputeCondition|/Metadata/StandardDimension/Attribute/BaseAttribute/@NVLExpression|/Metadata/Cube/Organization/AWCubeOrganization/BuildSpecifications|/Metadata/Cube/Organization/AWCubeOrganization/DefaultBuild", string);
                break;
            }
            case 4: {
                stringArray[2] = String.format("/Metadata/OrganizationalSchema[@Name='%1$s']/@Name", string);
                break;
            }
            case 5: {
                stringArray[2] = string2 == null ? String.format("/Metadata/Cube/Measure/BaseMeasure[@Name='%1$s']/@Name|/Metadata/Cube/Measure/BaseMeasure[@Name='%1$s']/@ETMeasureColumnName", string) : String.format("/Metadata/Cube[@Name='%1$s']/Measure/BaseMeasure[@Name='%2$s']/@Name|/Metadata/Cube[@Name='%1$s']/Measure/BaseMeasure[@Name='%2$s']/@ETMeasureColumnName", string2, string);
                stringArray[1] = "/Metadata/Cube/Measure/DerivedMeasure/@MeasureExpression|/Metadata/Cube/Measure/DerivedMeasure/MeasureExpression";
                break;
            }
            case 6: {
                stringArray[2] = string2 == null ? String.format("/Metadata/Cube/Measure/DerivedMeasure[@Name='%1$s']/@Name|/Metadata/Cube/Measure/DerivedMeasure[@Name='%1$s']/@ETMeasureColumnName", string) : String.format("/Metadata/Cube[@Name='%1$s']/Measure/DerivedMeasure[@Name='%2$s']/@Name|/Metadata/Cube[@Name='%1$s']/Measure/DerivedMeasure[@Name='%2$s']/@ETMeasureColumnName", string2, string);
                stringArray[1] = "/Metadata/Cube/Measure/DerivedMeasure/@MeasureExpression|/Metadata/Cube/Measure/DerivedMeasure/MeasureExpression";
            }
        }
        return stringArray;
    }

    public void renameDocument(ConflictRenameMap conflictRenameMap) throws TransformerConfigurationException, TransformerException {
        this.renameMap = conflictRenameMap;
        this.renameMap.resetIterator();
        while (this.renameMap.getNextObjectName() != null) {
            String[] stringArray = this.getXPath(this.renameMap.getType(), this.renameMap.getCurrentObjectName(), this.renameMap.getParent());
            String string = this.renameMap.getRenameEntry(this.renameMap.getType(), this.renameMap.getParent(), this.renameMap.getCurrentObjectName());
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    Pattern pattern = null;
                    if (i < 2) {
                        pattern = Pattern.compile(String.format(regex[i], this.renameMap.getCurrentObjectName()), 0);
                    }
                    NodeList nodeList = (NodeList)this.xp.evaluate(stringArray[i], this.doc, XPathConstants.NODESET);
                    block9: for (int j = 0; j < nodeList.getLength(); ++j) {
                        switch (i) {
                            case 2: {
                                nodeList.item(j).setTextContent(string);
                                continue block9;
                            }
                            case 0: {
                                continue block9;
                            }
                            case 1: {
                                String string2 = nodeList.item(j).getTextContent().trim();
                                if (this.renameMap.getCurrentObjectName().equals(string2)) {
                                    nodeList.item(j).setTextContent(string);
                                    continue block9;
                                }
                                StringBuffer stringBuffer = new StringBuffer();
                                Matcher matcher = pattern.matcher(string2);
                                while (matcher.find()) {
                                    matcher.appendReplacement(stringBuffer, string);
                                    stringBuffer.append(matcher.group(2));
                                }
                                matcher.appendTail(stringBuffer);
                                nodeList.item(j).setTextContent(stringBuffer.toString());
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        this.doc.normalizeDocument();
    }

    public void setRenameMap(ConflictRenameMap conflictRenameMap) {
        this.renameMap = conflictRenameMap;
    }

    private void printDocument(Document document) {
        System.out.println("##################################");
        String string = null;
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            stringWriter.flush();
            string = stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        System.out.println(string);
    }

    private EntityResolver getEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string, String string2) {
                if (TemplatePreprocessor.BIND_ENTITY_PUBLIC_ID.equals(string) && TemplatePreprocessor.ENTITY_SYSTEM_ID.equals(string2)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (null != TemplatePreprocessor.this.bindMap) {
                        for (String string3 : TemplatePreprocessor.this.bindMap.keySet()) {
                            stringBuilder.append("<!ENTITY ");
                            stringBuilder.append(string3);
                            stringBuilder.append(' ');
                            stringBuilder.append('\"');
                            stringBuilder.append(TemplatePreprocessor.this.bindMap.get(string3));
                            stringBuilder.append('\"');
                            stringBuilder.append('>');
                        }
                    }
                    StringReader stringReader = new StringReader(stringBuilder.toString());
                    return new InputSource(stringReader);
                }
                return null;
            }
        };
    }

    public ConflictRenameMap getRenameMap() {
        return this.renameMap;
    }

    private String get10gxpath(ObjectType objectType, String string) {
        String string2 = null;
        if (string != null) {
            switch (objectType) {
                case WORKSPACE: {
                    string2 = "/AWXML/AWXML.content/Create/ActiveObject/AW/@Name";
                    break;
                }
                case CUBE: {
                    string2 = String.format("/AWXML/AWXML.content/Create/ActiveObject/Cube/@Name|/AWXML/AWXML.content/Create/ActiveObject/AW[@Name='%1$s']/Cube/@Name", string);
                    break;
                }
                case DIMENSION: {
                    string2 = String.format("/AWXML/AWXML.content/Create/ActiveObject/Dimension/@Name|/AWXML/AWXML.content/Create/ActiveObject/AW[@Name='%1$s']/Dimension/@Name", string);
                    break;
                }
                case MEASURE: {
                    string2 = String.format("//Cube[@Name='%1$s']/Measure/@Name", string);
                    break;
                }
                case DERIVED_MEASURE: {
                    string2 = String.format("//Cube[@Name='%1$s']/DerivedMeasure/@Name", string);
                    break;
                }
                case MEASURE_FOLDER: {
                    string2 = "//MeasureFolder/@Name";
                }
            }
        } else {
            switch (objectType) {
                case WORKSPACE: {
                    string2 = "//AW/@Name";
                    break;
                }
                case CUBE: {
                    string2 = "//Cube/@Name";
                    break;
                }
                case DIMENSION: {
                    string2 = "//Dimension/@Name";
                    break;
                }
                case MEASURE: {
                    string2 = "//Measure/@Name";
                    break;
                }
                case DERIVED_MEASURE: {
                    string2 = "//DerivedMeasure/@Name";
                    break;
                }
                case MEASURE_FOLDER: {
                    string2 = "//MeasureFolder/@Name";
                }
            }
        }
        return string2;
    }

    public Map<String, String> getBindMap() {
        return this.bindMap;
    }

    public boolean is11g() {
        return this.is11g;
    }

    public void clear() {
        this.doc = null;
    }

    public boolean isLoaded() {
        return this.doc != null;
    }

    public static void main(String[] stringArray) {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        String string = "c:\\glob22.xml";
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            TemplatePreprocessor templatePreprocessor = new TemplatePreprocessor(null, null);
            templatePreprocessor.preprocessDocument(inputStreamReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

