/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplateimpl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.table.Queries;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TreeModelHelper;
import oracle.olap.cubetemplate.TreeNode;
import oracle.olap.cubetemplateimpl.ExportPreprocessorImpl;

public class TreeModelHelperImpl
implements TreeModelHelper {
    private final List<DBObject> selection = new ArrayList<DBObject>();
    private static final String XMLFILE = "treemodelhelper.xml";
    private static final String DIM = "DIM";
    private static final String CUBE = "CUBE";
    private static final String BASEMEAS = "BASEMEAS";
    private static final String CALCMEAS = "CALCMEAS";
    private static final String MEASFOLDER = "MEASFOLDER";
    private Queries queries;
    private final Connection conn;
    private final String awName;
    private final String owner;
    private final ExportPreprocessorImpl sde;

    public TreeModelHelperImpl(List<Object> list, String string) {
        for (Object object : list) {
            this.selection.add((DBObject)object);
        }
        this.awName = string;
        if (this.selection.size() > 0) {
            this.conn = this.selection.get(0).getConnection();
            this.owner = this.selection.get(0).getSchemaName();
            this.sde = new ExportPreprocessorImpl(this.conn);
        } else {
            this.conn = null;
            this.owner = null;
            this.sde = null;
        }
        try {
            Object object;
            String string2 = "oracle.olap.app.table";
            object = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr((String)object, string2, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    @Override
    public List<TreeNode> getObjects(ObjectType objectType, String string) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        String string2 = null;
        Object[] objectArray = null;
        try {
            List list = null;
            switch (objectType) {
                case WORKSPACE: {
                    arrayList.add(new TreeNode(this.awName == null ? "" : this.awName, objectType, this.isInSelection(this.awName, this.owner), false));
                    break;
                }
                case CUBE: {
                    objectArray = new Object[]{this.owner, string};
                    string2 = this.queries.getSQL(CUBE);
                    break;
                }
                case DIMENSION: {
                    string2 = this.queries.getSQL(DIM);
                    objectArray = new Object[]{this.owner, string};
                    break;
                }
                case MEASURE: {
                    string2 = this.queries.getSQL(BASEMEAS);
                    objectArray = new Object[]{this.owner, string};
                    break;
                }
                case DERIVED_MEASURE: {
                    string2 = this.queries.getSQL(CALCMEAS);
                    objectArray = new Object[]{this.owner, string};
                    break;
                }
                case MEASURE_FOLDER: {
                    string2 = this.queries.getSQL(MEASFOLDER);
                    objectArray = new Object[]{this.owner, string};
                }
            }
            if (string2 != null) {
                list = DatabaseUtils.ExecuteSQL(this.conn, string2, objectArray);
                for (Object e : list) {
                    List list2 = (List)e;
                    arrayList.add(new TreeNode((String)list2.get(0), string, objectType, this.isInSelection((String)list2.get(0), string), false));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private boolean isInSelection(String string, String string2) {
        for (DBObject dBObject : this.selection) {
            if (!dBObject.getObjectName().equals(string) || string2 != null && !string2.equals(this.getDBObjectParent(dBObject))) continue;
            return true;
        }
        return false;
    }

    private String getDBObjectParent(DBObject dBObject) {
        String string = null;
        ObjectType objectType = ObjectType.fromNodeType(dBObject.getObjectType());
        try {
            switch (objectType) {
                case WORKSPACE: 
                case MEASURE_FOLDER: {
                    string = this.sde.getAWName(dBObject);
                    break;
                }
                case MEASURE: 
                case DERIVED_MEASURE: {
                    string = this.sde.getOwnerCube(dBObject);
                    break;
                }
                case CUBE: 
                case DIMENSION: {
                    string = this.sde.getAWName(dBObject);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

