/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.cubeviewer.CubeDataViewerPanel;
import oracle.olap.data.CubeDataViewer;
import oracle.olap.data.CubeMetadataContext;

public class CubeDataViewerDialog
extends JDialog
implements CubeDataViewer {
    private CubeMetadataContext cubeMetadataContext;
    private String language;
    private JFrame parent;
    private final HelpProvider helpProvider;
    private JPanel panel;
    private CubeDataViewerPanel dataPanel;
    private Action closeAction;
    private Action helpAction;

    public CubeDataViewerDialog(JFrame jFrame, HelpProvider helpProvider, CubeMetadataContext cubeMetadataContext, String string) throws SQLException, IOException {
        this(jFrame, helpProvider, cubeMetadataContext, string, Collections.EMPTY_LIST);
    }

    public CubeDataViewerDialog(JFrame jFrame, HelpProvider helpProvider, CubeMetadataContext cubeMetadataContext, String string, List<DimensionHierarchy> list) throws SQLException, IOException {
        super(jFrame);
        this.parent = jFrame;
        this.helpProvider = helpProvider;
        this.cubeMetadataContext = cubeMetadataContext;
        this.language = string;
        Cube cube = cubeMetadataContext.getCube();
        String string2 = cube.getSchema().getName();
        String string3 = cube.getName();
        this.setTitle(OLAPArb.format("CUBE_DATA_VIEWER_TITLE", string2, string3));
        this.panel = new JPanel();
        this.dataPanel = new CubeDataViewerPanel(this, helpProvider, cubeMetadataContext, list);
        this.dataPanel.setName("dataPanel");
        Dimension dimension = Ide.getMainWindow().getSize();
        dimension.setSize(dimension.getWidth() * 0.8, dimension.getHeight() * 0.8);
        if (dimension.getWidth() < 700.0 || dimension.getHeight() < 500.0) {
            this.setSize(700, 500);
        } else {
            this.setSize(dimension);
        }
        this.setLocationRelativeTo(jFrame);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeDataViewerDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeDataViewerDialog.this.helpProvider.showHelp(CubeDataViewerDialog.this.panel, "olap_cube_viewer_dialog");
            }
        };
        this.layoutComponents();
        this.registerKeyboardActions();
    }

    @Override
    public void showViewer() {
        this.setVisible(true);
        this.cubeMetadataContext.getCube().setSelected(false);
    }

    @Override
    public void init(CubeMetadataContext cubeMetadataContext) {
        this.cubeMetadataContext = cubeMetadataContext;
    }

    @Override
    public void cleanup() {
    }

    private void layoutComponents() {
        JButton jButton = new JButton(this.closeAction);
        jButton.setName("closeButton");
        jButton.setText(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CLOSE_BUTTON_TEXT")));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CLOSE_BUTTON_TEXT")));
        JButton jButton2 = new JButton(this.helpAction);
        jButton2.setName("helpButton");
        jButton2.setText(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        jButton2.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.setName("bb");
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.panel.setName("panel");
        this.setContentPane(this.panel);
        this.panel.setLayout(new GridBagLayout());
        int n = 0;
        this.panel.add((Component)this.dataPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 5));
        this.panel.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.closeAction, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
    }
}

