/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubexml;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.db.RowSetCallBack;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeDimensionSpreadedAttribute;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.cubexml.BaseCubeXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.model.Descriptions;
import oracle.olap.xmlbind.AWPrimaryDimensionOrganization;
import oracle.olap.xmlbind.Attribute;
import oracle.olap.xmlbind.AttributeMap;
import oracle.olap.xmlbind.AttributeOrganization;
import oracle.olap.xmlbind.BaseAttribute;
import oracle.olap.xmlbind.Classification;
import oracle.olap.xmlbind.Description;
import oracle.olap.xmlbind.DimensionLevel;
import oracle.olap.xmlbind.Hierarchy;
import oracle.olap.xmlbind.HierarchyLevel;
import oracle.olap.xmlbind.HierarchyLevelMap;
import oracle.olap.xmlbind.LevelHierarchy;
import oracle.olap.xmlbind.MemberListMap;
import oracle.olap.xmlbind.Metadata;
import oracle.olap.xmlbind.Organization;
import oracle.olap.xmlbind.SolvedValueHierarchyMap;
import oracle.olap.xmlbind.StandardDimension;
import oracle.olap.xmlbind.TimeDimension;
import oracle.olap.xmlbind.UniqueKeyAttribute;
import oracle.olap.xmlbind.ValueHierarchy;
import oracle.olap.xmlbind.VisibleAttribute;
import oracle.olapi.syntax.OrderByClause;
import oracle.olapi.syntax.OrderByElement;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

public class CubeDimensionXML
extends BaseCubeXML {
    private static final String TRUE = "True";
    private static final String FALSE = "False";
    private static final String STAR = "STAR";
    private static final String MEASURE_TYPE = "DimensionType=MEASURE";
    private StandardDimension xmldim;
    private CubeDimension dim;
    private List marshalObjs;
    private int numOfBytes;

    public CubeDimensionXML(MetadataContext metadataContext, Object object, CubeDimension cubeDimension) {
        super(metadataContext);
        this.dim = cubeDimension;
        if (object instanceof StandardDimension) {
            this.xmldim = (StandardDimension)object;
        }
        if (object instanceof Metadata) {
            Metadata metadata = (Metadata)object;
            List<Object> list = metadata.getStandardDimensionOrTimeDimensionOrCube();
            for (Object object2 : list) {
                if (!(object2 instanceof StandardDimension)) continue;
                this.xmldim = (StandardDimension)object2;
            }
        }
    }

    public CubeDimensionXML(MetadataContext metadataContext, StandardDimension standardDimension, List list, CubeDimension cubeDimension) {
        super(metadataContext);
        this.dim = cubeDimension;
        this.xmldim = standardDimension;
        this.marshalObjs = list;
    }

    public void loadModel() {
        this.loadDescriptions();
        this.loadProperties();
        this.loadAttributes();
        this.loadMappings();
        this.loadDimensionClassType();
    }

    public void loadDimensionClassType() {
        boolean bl = false;
        List<Classification> list = this.xmldim.getClassification();
        for (Classification classification : list) {
            if (classification == null || !classification.getValueToFixError2().equals(MEASURE_TYPE)) continue;
            this.dim.setDimensionClassType("MEASURE");
            bl = true;
        }
        if (!bl) {
            this.dim.setDimensionClassType("NONE");
        }
    }

    private void loadDescriptions() {
        Object object;
        for (Description object3 : this.xmldim.getDescription()) {
            this.loadDescription(this.dim, object3);
        }
        for (DimensionLevel dimensionLevel : this.xmldim.getDimensionLevel()) {
            for (Object object2 : dimensionLevel.getContent()) {
                if (!(object2 instanceof Description)) continue;
                object = this.findLevel(dimensionLevel);
                Description description = (Description)object2;
                this.loadDescription((Descriptions)object, description);
            }
        }
        for (Attribute attribute : this.xmldim.getAttribute()) {
            for (Object object2 : attribute.getContent()) {
                if (!(object2 instanceof BaseAttribute)) continue;
                object = (BaseAttribute)object2;
                for (Object object3 : ((BaseAttribute)object).getContent()) {
                    if (!(object3 instanceof Description)) continue;
                    CubeDimensionAttribute cubeDimensionAttribute = this.findAttribute((BaseAttribute)object);
                    Description description = (Description)object3;
                    this.loadDescription(cubeDimensionAttribute, description);
                }
            }
        }
        for (Hierarchy hierarchy : this.xmldim.getHierarchy()) {
            Object object2;
            LevelHierarchy levelHierarchy = hierarchy.getLevelHierarchy();
            if (levelHierarchy != null) {
                object2 = levelHierarchy.getDescription().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    CubeDimensionHierarchy cubeDimensionHierarchy = this.findHierarchy(levelHierarchy);
                    this.loadDescription(cubeDimensionHierarchy, (Description)object);
                }
            }
            if ((object2 = hierarchy.getValueHierarchy()) == null) continue;
            for (Description description : ((ValueHierarchy)object2).getDescription()) {
                CubeDimensionHierarchy cubeDimensionHierarchy = this.findHierarchy((ValueHierarchy)object2);
                this.loadDescription(cubeDimensionHierarchy, description);
            }
        }
    }

    private void loadProperties() {
        if (this.xmldim instanceof TimeDimension) {
            this.dim.setDimensionType("TIME");
        }
        Organization organization = this.xmldim.getOrganization();
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = organization.getAWPrimaryDimensionOrganization();
        this.dim.setAddUniqueKeys(true);
        if (aWPrimaryDimensionOrganization.getAddUniqueKeyPrefix().equalsIgnoreCase(FALSE)) {
            this.dim.setAddUniqueKeys(false);
        }
        String string = aWPrimaryDimensionOrganization.getHierarchyConsistencyRule();
        this.dim.setHierarchyConsistencyRule(string);
        if (this.xmldim.getCustomOrder() != null) {
            this.initializeCustomSortOrderBy();
        }
    }

    private void initializeCustomSortOrderBy() {
        IdentifierElement identifierElement;
        Object object;
        String string = this.xmldim.getCustomOrder();
        OrderByClause orderByClause = (OrderByClause)SyntaxObject.fromSyntax((String)string, null);
        OrderByElement orderByElement = orderByClause.getElements()[0];
        boolean bl = orderByElement.isAscending();
        boolean bl2 = orderByElement.isNullsFirst();
        String[] stringArray = null;
        String string2 = null;
        TypedExpression typedExpression = orderByElement.getExpression();
        if (typedExpression != null && (object = typedExpression.toSyntax()) != null && (string2 = (identifierElement = new IdentifierElement((String)object)).getSecond()).indexOf("\"") >= 0) {
            stringArray = string2.split("\"");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.length() == 0) continue;
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
        }
        if ((object = this.dim.findAttribute(string2)) != null) {
            this.dim.setDimensionSortAttributeName(((CubeDimensionAttribute)object).getOriginalAttributeName());
        }
        if (bl) {
            this.dim.setDimensionSortOrder("ASC");
        } else {
            this.dim.setDimensionSortOrder("DESC");
        }
        if (bl2) {
            this.dim.setDimensionNullSortOrder("FIRST");
        } else {
            this.dim.setDimensionNullSortOrder("LAST");
        }
    }

    private void loadAttributes() {
        CubeDimensionAttribute cubeDimensionAttribute;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object72;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Attribute object102 : this.xmldim.getAttribute()) {
            for (Object object8 : object102.getContent()) {
                if (!(object8 instanceof BaseAttribute) || (object72 = this.findAttribute((BaseAttribute)(object6 = (BaseAttribute)object8))) == null) continue;
                String string = ((BaseAttribute)object6).getAttributeGroupName();
                if (string != null && string.length() > 0) {
                    arrayList.add(((BaseAttribute)object6).getName());
                }
                if ((object5 = ((BaseAttribute)object6).getAllowAutoDataTypeChange()) != null) {
                    if (((String)object5).equalsIgnoreCase(TRUE)) {
                        ((CubeDimensionAttribute)object72).setAttributeAllowAutoDataTypeChange(true);
                    } else {
                        ((CubeDimensionAttribute)object72).setAttributeAllowAutoDataTypeChange(false);
                    }
                } else {
                    ((CubeDimensionAttribute)object72).setAttributeAllowAutoDataTypeChange(false);
                }
                if (((BaseAttribute)object6).getIsMultiLingual().equalsIgnoreCase(TRUE)) {
                    ((CubeDimensionAttribute)object72).setNls(true);
                } else {
                    ((CubeDimensionAttribute)object72).setNls(false);
                }
                if (((BaseAttribute)object6).getIsVisibleForAll().equalsIgnoreCase(TRUE)) {
                    ((CubeDimensionAttribute)object72).setAttributeVisibleForAll(true);
                } else {
                    ((CubeDimensionAttribute)object72).setAttributeVisibleForAll(false);
                }
                ((CubeDimensionAttribute)object72).setStar(false);
                object4 = ((BaseAttribute)object6).getContent().iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    if (!(object3 instanceof Classification) || !((Classification)(object2 = (Classification)object3)).getValueToFixError2().equalsIgnoreCase(STAR)) continue;
                    ((CubeDimensionAttribute)object72).setStar(true);
                    hashMap.put(object72.getName(), object72);
                }
            }
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (DimensionLevel dimensionLevel : this.xmldim.getDimensionLevel()) {
            for (Object object72 : dimensionLevel.getContent()) {
                if (object72 instanceof VisibleAttribute) {
                    VisibleAttribute visibleAttribute = (VisibleAttribute)object72;
                    object5 = visibleAttribute.getName();
                    object4 = this.findLevel(dimensionLevel.getName());
                    object3 = this.findAttribute((String)object5);
                    object2 = this.findBaseAttribute((CubeDimensionAttribute)object3);
                    object = ((BaseAttribute)object2).getAttributeGroupName();
                    if (object != null && ((String)object).length() > 0) {
                        arrayList2.add(object2);
                        ((CubeDimensionAttribute)object3).setGroupName((String)object);
                        cubeDimensionAttribute = (CubeDimensionAttribute)hashMap.get(((BaseAttribute)object2).getAttributeGroupName());
                        if (cubeDimensionAttribute != null) {
                            CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute = new CubeDimensionSpreadedAttribute(cubeDimensionAttribute, dimensionLevel.getName(), ((BaseAttribute)object2).getName());
                            cubeDimensionAttribute.addSpreadedAttribute(cubeDimensionSpreadedAttribute);
                        }
                    } else if (object3 != null && object4 != null) {
                        ((CubeSubDimension)object4).addVisibleAttribute((CubeDimensionAttribute)object3);
                    }
                }
                if (!(object72 instanceof UniqueKeyAttribute)) continue;
                UniqueKeyAttribute uniqueKeyAttribute = (UniqueKeyAttribute)object72;
                arrayList3.add(uniqueKeyAttribute.getName());
            }
        }
        for (Hierarchy hierarchy : this.xmldim.getHierarchy()) {
            CubeDimensionHierarchy cubeDimensionHierarchy;
            object6 = hierarchy.getLevelHierarchy();
            if (object6 != null) {
                for (HierarchyLevel hierarchyLevel : ((LevelHierarchy)object6).getHierarchyLevel()) {
                    object5 = hierarchyLevel.getContent().iterator();
                    while (object5.hasNext()) {
                        object4 = object5.next();
                        if (!(object4 instanceof VisibleAttribute)) continue;
                        object3 = (VisibleAttribute)object4;
                        object2 = ((VisibleAttribute)object3).getName();
                        object = this.findHierarchyLevel((LevelHierarchy)object6, hierarchyLevel);
                        cubeDimensionAttribute = this.findAttribute((String)object2);
                        if (object == null || cubeDimensionAttribute == null) continue;
                        ((CubeSubDimension)object).addVisibleAttribute(cubeDimensionAttribute);
                    }
                }
                continue;
            }
            object72 = hierarchy.getValueHierarchy();
            if (object72 == null || (cubeDimensionHierarchy = this.findHierarchy(((ValueHierarchy)object72).getName())) == null) continue;
            object5 = ((ValueHierarchy)object72).getVisibleAttribute().iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                object3 = ((VisibleAttribute)object4).getName();
                object2 = this.findAttribute((String)object3);
                if (cubeDimensionHierarchy == null || object2 == null) continue;
                cubeDimensionHierarchy.addVisibleAttribute((CubeDimensionAttribute)object2);
            }
        }
        Object object9 = arrayList2.iterator();
        while (object9.hasNext()) {
            BaseAttribute baseAttribute = (BaseAttribute)object9.next();
            object6 = baseAttribute.getName();
            object72 = this.dim.findAttribute((String)object6);
            this.dim.removeAttribute((CubeDimensionAttribute)object72);
        }
        for (String string : arrayList) {
            object6 = this.dim.findAttribute(string);
            if (object6 == null) continue;
            this.dim.removeAttribute((CubeDimensionAttribute)object6);
        }
        for (String string : arrayList3) {
            object6 = this.dim.findAttribute(string);
            this.dim.removeAttribute((CubeDimensionAttribute)object6);
        }
        object9 = this.xmldim.getOrganization();
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = ((Organization)object9).getAWPrimaryDimensionOrganization();
        for (Object object72 : aWPrimaryDimensionOrganization.getContent()) {
            AttributeOrganization attributeOrganization;
            if (!(object72 instanceof AttributeOrganization) || (object4 = this.findAttribute((String)(object5 = (attributeOrganization = (AttributeOrganization)object72).getAttribute()))) == null) continue;
            if (attributeOrganization.getCreateIndex().equalsIgnoreCase(TRUE)) {
                ((CubeDimensionAttribute)object4).setIndex(true);
            }
            if (!attributeOrganization.getCreateIndex().equalsIgnoreCase(FALSE)) continue;
            ((CubeDimensionAttribute)object4).setIndex(false);
        }
    }

    public void saveModel() {
        this.generateSpreadedAttributeMappings();
    }

    public void saveMappingsOld() {
        CubeDimensionLevel[] cubeDimensionLevelArray = this.dim.getLevels();
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.dim.getHierarchies()) {
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                Object object;
                CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevel.getLevel();
                CubeDimensionMap cubeDimensionMap = cubeDimensionLevel.getMap();
                if (cubeDimensionMap == null) {
                    cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                }
                if (cubeDimensionMap == null) continue;
                String string = cubeDimensionMap.getKeyExpression();
                String string2 = cubeDimensionMap.getMapQuery();
                boolean bl = false;
                LevelHierarchy levelHierarchy = this.findLevelHierarchyForMapping(cubeDimensionHierarchy.getName());
                if (levelHierarchy == null) {
                    object = new Hierarchy();
                    levelHierarchy = new LevelHierarchy();
                    levelHierarchy.setName(cubeDimensionHierarchy.getName());
                    ((Hierarchy)object).setLevelHierarchy(levelHierarchy);
                    this.xmldim.getHierarchy().add((Hierarchy)object);
                }
                if ((object = this.findHierarchyLevel(levelHierarchy, cubeDimensionLevel.getName())) == null) {
                    object = new HierarchyLevel();
                    ((HierarchyLevel)object).setDimensionLevel(cubeDimensionLevel.getName());
                    levelHierarchy.getHierarchyLevel().add((HierarchyLevel)object);
                }
                HierarchyLevelMap hierarchyLevelMap = new HierarchyLevelMap();
                hierarchyLevelMap.setKeyExpression(string);
                hierarchyLevelMap.setQuery(string2);
                ((HierarchyLevel)object).getContent().add(hierarchyLevelMap);
                bl = true;
                this.setAttributeMap(hierarchyLevelMap, cubeDimensionMap, cubeDimensionLevel);
            }
        }
    }

    public void generateSpreadedAttributeMappings() {
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.dim.getHierarchies()) {
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                String string;
                HierarchyLevel hierarchyLevel;
                CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevel.getLevel();
                CubeDimensionMap cubeDimensionMap = cubeDimensionLevel.getMap();
                if (cubeDimensionMap == null) {
                    cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                }
                if (cubeDimensionMap == null) continue;
                String string2 = cubeDimensionMap.getKeyExpression();
                String string3 = cubeDimensionHierarchy.getName();
                LevelHierarchy levelHierarchy = this.findLevelHierarchyForMapping(string3);
                if (levelHierarchy == null || (hierarchyLevel = this.findHierarchyLevel(levelHierarchy, string = cubeDimensionLevel.getOriginalLevelName())) == null) continue;
                for (Object object : hierarchyLevel.getContent()) {
                    if (!(object instanceof HierarchyLevelMap)) continue;
                    HierarchyLevelMap hierarchyLevelMap = (HierarchyLevelMap)object;
                    this.generateSpreadedAttributeMap(hierarchyLevelMap, cubeDimensionMap, cubeDimensionLevel);
                }
            }
        }
    }

    private void generateSpreadedAttributeMap(Object object, CubeDimensionMap cubeDimensionMap, CubeDimensionLevel cubeDimensionLevel) {
        if (object instanceof HierarchyLevelMap) {
            CubeDimensionAttributeMap[] cubeDimensionAttributeMapArray = (CubeDimensionAttributeMap[])object;
            if (cubeDimensionAttributeMapArray.getAction() != null && cubeDimensionAttributeMapArray.getAction().equals("REMOVE")) {
                return;
            }
            for (Object object2 : cubeDimensionAttributeMapArray.getContent()) {
                AttributeMap object3;
                if (!(object2 instanceof AttributeMap) || (object3 = (AttributeMap)object2).getNewName() == null) continue;
                return;
            }
        }
        for (CubeDimensionAttributeMap cubeDimensionAttributeMap : cubeDimensionMap.getAttributeMaps()) {
            Object object2;
            CubeDimensionAttribute cubeDimensionAttribute = cubeDimensionAttributeMap.getAttribute();
            if (cubeDimensionLevel == null) continue;
            String string = cubeDimensionLevel.getOriginalLevelName();
            String string2 = cubeDimensionLevel.getName();
            String string3 = cubeDimensionAttribute.getName();
            String string4 = null;
            CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute = cubeDimensionAttribute.getSpreadedAttributeUsingOriginal(string);
            if (cubeDimensionSpreadedAttribute != null) {
                string4 = cubeDimensionSpreadedAttribute.getName();
            } else {
                object2 = this.findSpreadedAttribute(cubeDimensionLevel, string3);
                if (object2 != null) {
                    string4 = ((BaseAttribute)object2).getName();
                }
            }
            if (string4 == null) continue;
            object2 = new AttributeMap();
            ((AttributeMap)object2).setName(string4);
            ((AttributeMap)object2).setAttribute(string4);
            String string5 = cubeDimensionAttributeMap.getMapExpression();
            ((AttributeMap)object2).setExpression(string5);
            if (this.getMetadataContext().getOriginalObject() == null && cubeDimensionAttributeMap.getMapExpression().isEmpty()) continue;
            this.addAttributeMap(object, (AttributeMap)object2);
        }
    }

    private void setAttributeMap(Object object, CubeDimensionMap cubeDimensionMap, CubeDimensionLevel cubeDimensionLevel) {
        for (CubeDimensionAttributeMap cubeDimensionAttributeMap : cubeDimensionMap.getAttributeMaps()) {
            CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute;
            AttributeMap attributeMap = new AttributeMap();
            this.addAttributeMap(object, attributeMap);
            CubeDimensionAttribute cubeDimensionAttribute = cubeDimensionAttributeMap.getAttribute();
            attributeMap.setName(cubeDimensionAttribute.getName());
            attributeMap.setAttribute(cubeDimensionAttribute.getName());
            attributeMap.setExpression(cubeDimensionAttributeMap.getMapExpression());
            if (cubeDimensionAttributeMap.getLanguage() != null) {
                attributeMap.setLanguage(cubeDimensionAttributeMap.getLanguage());
            }
            if (cubeDimensionLevel == null || (cubeDimensionSpreadedAttribute = cubeDimensionAttribute.getSpreadedAttribute(cubeDimensionLevel.getName())) == null) continue;
            attributeMap = new AttributeMap();
            this.addAttributeMap(object, attributeMap);
            attributeMap.setName(cubeDimensionSpreadedAttribute.getName());
            attributeMap.setAttribute(cubeDimensionSpreadedAttribute.getName());
            attributeMap.setExpression(cubeDimensionAttributeMap.getMapExpression());
        }
    }

    private void addAttributeMap(Object object, AttributeMap attributeMap) {
        if (object instanceof MemberListMap) {
            ((MemberListMap)object).getContent().add(attributeMap);
        }
        if (object instanceof HierarchyLevelMap) {
            ((HierarchyLevelMap)object).getContent().add(attributeMap);
        }
    }

    public void loadMappings() {
        CubeDimensionMap cubeDimensionMap;
        Object object;
        Object object22;
        if (this.xmldim == null) {
            return;
        }
        CubeDimensionLevel[] cubeDimensionLevelArray = this.dim.getLevels();
        for (CubeDimensionLevel cubeDimensionLevel : cubeDimensionLevelArray) {
            for (Object object22 : this.xmldim.getDimensionLevel()) {
                if (!((DimensionLevel)object22).getName().equals(cubeDimensionLevel.getName()) || (object = this.getExpression((DimensionLevel)object22)) == null) continue;
                cubeDimensionMap = new CubeDimensionMap(this.dim);
                cubeDimensionMap.setKeyExpression((String)object);
                cubeDimensionLevel.setMap(cubeDimensionMap);
            }
        }
        CubeSubDimension[] cubeSubDimensionArray = this.dim.getHierarchies();
        for (CubeSubDimension cubeSubDimension : cubeSubDimensionArray) {
            Object object32;
            if (((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevelType()) {
                object22 = this.findLevelHierarchy((CubeDimensionHierarchy)cubeSubDimension);
                if (object22 == null) continue;
                object = ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevelsReverse();
                cubeDimensionMap = null;
                for (Object object32 : object) {
                    CubeDimensionLevel cubeDimensionLevel = ((CubeDimensionHierarchyLevel)object32).getLevel();
                    HierarchyLevelMap hierarchyLevelMap = this.getHierarchyLevelMap((LevelHierarchy)object22, cubeDimensionLevel);
                    String string = null;
                    if (hierarchyLevelMap != null) {
                        string = CubeDimensionXML.processExpression(hierarchyLevelMap.getKeyExpression());
                        String string2 = hierarchyLevelMap.getWhereClause();
                        String string3 = hierarchyLevelMap.getJoinCondition();
                        String string4 = this.processQuery(hierarchyLevelMap.getQuery());
                        if (string != null) {
                            SyntaxObject syntaxObject;
                            CubeDimensionMap cubeDimensionMap2 = new CubeDimensionMap(this.dim);
                            ((CubeDimensionHierarchyLevel)object32).setMap(cubeDimensionMap2);
                            cubeDimensionMap2.setMapQuery(string4);
                            cubeDimensionMap2.setKeyExpression(string);
                            if (string3 != null && string3.length() > 0 && (syntaxObject = SyntaxObject.fromSyntax((String)string3, null)) instanceof ValueComparisonCondition) {
                                ValueComparisonCondition valueComparisonCondition = (ValueComparisonCondition)syntaxObject;
                                TypedExpression typedExpression = valueComparisonCondition.getLhsArgument();
                                TypedExpression typedExpression2 = valueComparisonCondition.getRhsArgument();
                                String string5 = typedExpression.toSyntax();
                                String string6 = typedExpression2.toSyntax();
                                if (valueComparisonCondition.getOperator().equals("=")) {
                                    if (string5.equals((Object)cubeDimensionMap)) {
                                        cubeDimensionMap2.setParentKeyExpression((String)((Object)cubeDimensionMap));
                                    }
                                    if (string6.equals((Object)cubeDimensionMap)) {
                                        cubeDimensionMap2.setParentKeyExpression((String)((Object)cubeDimensionMap));
                                    }
                                }
                            }
                            if (string2 != null) {
                                cubeDimensionMap2.setMapWhereClause(string2);
                            }
                            this.loadAttributeMaps(cubeDimensionMap2, hierarchyLevelMap.getContent());
                        }
                    }
                    cubeDimensionMap = string;
                }
                continue;
            }
            object22 = this.findValueHierarchy((CubeDimensionHierarchy)cubeSubDimension);
            object = ((ValueHierarchy)object22).getSolvedValueHierarchyMap();
            if (object == null) continue;
            cubeDimensionMap = new CubeDimensionMap(this.dim);
            ((CubeDimensionHierarchy)cubeSubDimension).setMap(cubeDimensionMap);
            String string = ((SolvedValueHierarchyMap)object).getKeyExpression();
            String string7 = ((SolvedValueHierarchyMap)object).getWhereClause();
            String string8 = this.processQuery(((SolvedValueHierarchyMap)object).getQuery());
            if (string != null) {
                cubeDimensionMap.setKeyExpression(string);
                cubeDimensionMap.setMapQuery(string8);
            }
            if (string7 != null) {
                cubeDimensionMap.setMapWhereClause(string7);
            }
            object32 = ((SolvedValueHierarchyMap)object).getParentKeyExpression();
            if (string != null) {
                cubeDimensionMap.setParentKeyExpression((String)object32);
            }
            this.loadAttributeMaps(cubeDimensionMap, ((SolvedValueHierarchyMap)object).getAttributeMap());
        }
        MemberListMap memberListMap = this.xmldim.getMemberListMap();
        if (memberListMap != null) {
            CubeDimensionMap cubeDimensionMap3 = new CubeDimensionMap(this.dim);
            String string = memberListMap.getKeyExpression();
            String string9 = memberListMap.getWhereClause();
            object22 = this.processQuery(memberListMap.getQuery());
            if (string != null) {
                cubeDimensionMap3.setKeyExpression(string);
            }
            if (string9 != null) {
                cubeDimensionMap3.setMapWhereClause(string9);
            }
            cubeDimensionMap3.setMapQuery((String)object22);
            this.dim.setMap(cubeDimensionMap3);
            object = memberListMap.getContent();
            this.loadAttributeMaps(cubeDimensionMap3, (List)object);
        }
    }

    private List<CubeDimensionAttributeMap> loadAttributeMaps(CubeDimensionMap cubeDimensionMap, List list) {
        ArrayList<CubeDimensionAttributeMap> arrayList = new ArrayList<CubeDimensionAttributeMap>();
        for (Object e : list) {
            if (!(e instanceof AttributeMap)) continue;
            AttributeMap attributeMap = (AttributeMap)e;
            String string = attributeMap.getAttribute();
            String string2 = attributeMap.getExpression();
            String string3 = CubeDimensionXML.processExpression(string2);
            CubeDimensionAttribute cubeDimensionAttribute = this.dim.findAttribute(string);
            if (cubeDimensionAttribute == null) continue;
            CubeDimensionAttributeMap cubeDimensionAttributeMap = new CubeDimensionAttributeMap(cubeDimensionAttribute, string3);
            cubeDimensionMap.addAttributeMap(cubeDimensionAttributeMap);
            arrayList.add(cubeDimensionAttributeMap);
        }
        return arrayList;
    }

    private DimensionLevel findLevel(CubeDimensionLevel cubeDimensionLevel) {
        DimensionLevel dimensionLevel;
        block1: {
            dimensionLevel = this.findLevel(this.xmldim, cubeDimensionLevel);
            if (dimensionLevel != null) break block1;
            for (Object e : this.marshalObjs) {
                StandardDimension standardDimension;
                if (e instanceof StandardDimension && (dimensionLevel = this.findLevel(standardDimension = (StandardDimension)e, cubeDimensionLevel)) != null) break;
            }
        }
        return dimensionLevel;
    }

    private DimensionLevel findLevel(StandardDimension standardDimension, CubeDimensionLevel cubeDimensionLevel) {
        List<DimensionLevel> list = standardDimension.getDimensionLevel();
        String string = cubeDimensionLevel.getName();
        for (DimensionLevel dimensionLevel : list) {
            if (dimensionLevel.getAction() != null && dimensionLevel.getAction().equals("REMOVE") || !dimensionLevel.getName().equals(string)) continue;
            return dimensionLevel;
        }
        return null;
    }

    private LevelHierarchy findLevelHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        List<Hierarchy> list = this.xmldim.getHierarchy();
        String string = cubeDimensionHierarchy.getName();
        for (Hierarchy hierarchy : list) {
            LevelHierarchy levelHierarchy = hierarchy.getLevelHierarchy();
            if (levelHierarchy == null || !levelHierarchy.getName().equals(string)) continue;
            return levelHierarchy;
        }
        return null;
    }

    private ValueHierarchy findValueHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        List<Hierarchy> list = this.xmldim.getHierarchy();
        for (Hierarchy hierarchy : list) {
            ValueHierarchy valueHierarchy = hierarchy.getValueHierarchy();
            if (valueHierarchy == null || !valueHierarchy.getName().equals(cubeDimensionHierarchy.getName())) continue;
            return valueHierarchy;
        }
        return null;
    }

    private Attribute findAttribute(CubeDimensionAttribute cubeDimensionAttribute) {
        for (Attribute attribute : this.xmldim.getAttribute()) {
            for (Object object : attribute.getContent()) {
                BaseAttribute baseAttribute;
                if (!(object instanceof BaseAttribute) || !(baseAttribute = (BaseAttribute)object).getName().equals(cubeDimensionAttribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    private BaseAttribute findSpreadedAttribute(CubeDimensionLevel cubeDimensionLevel, String string) {
        BaseAttribute baseAttribute;
        block1: {
            baseAttribute = this.findSpreadedAttribute(this.xmldim, cubeDimensionLevel, string);
            if (baseAttribute != null) break block1;
            for (Object e : this.marshalObjs) {
                StandardDimension standardDimension;
                if (e instanceof StandardDimension && (baseAttribute = this.findSpreadedAttribute(standardDimension = (StandardDimension)e, cubeDimensionLevel, string)) != null) break;
            }
        }
        return baseAttribute;
    }

    private BaseAttribute findSpreadedAttribute(StandardDimension standardDimension, CubeDimensionLevel cubeDimensionLevel, String string) {
        for (Attribute attribute : standardDimension.getAttribute()) {
            for (Object object : attribute.getContent()) {
                DimensionLevel dimensionLevel;
                if (!(object instanceof BaseAttribute)) continue;
                BaseAttribute baseAttribute = (BaseAttribute)object;
                String string2 = baseAttribute.getName();
                String string3 = baseAttribute.getAttributeGroupName();
                if (string3 == null || !string3.equals(string) || (dimensionLevel = this.findLevel(cubeDimensionLevel)) == null) continue;
                for (Object object2 : dimensionLevel.getContent()) {
                    VisibleAttribute visibleAttribute;
                    String string4;
                    if (!(object2 instanceof VisibleAttribute) || !(string4 = (visibleAttribute = (VisibleAttribute)object2).getName()).equals(string2)) continue;
                    return baseAttribute;
                }
            }
        }
        return null;
    }

    private BaseAttribute findBaseAttribute(CubeDimensionAttribute cubeDimensionAttribute) {
        for (Attribute attribute : this.xmldim.getAttribute()) {
            for (Object object : attribute.getContent()) {
                BaseAttribute baseAttribute;
                if (!(object instanceof BaseAttribute) || !(baseAttribute = (BaseAttribute)object).getName().equals(cubeDimensionAttribute.getName())) continue;
                return baseAttribute;
            }
        }
        return null;
    }

    private CubeDimensionAttribute findAttribute(BaseAttribute baseAttribute) {
        return this.findAttribute(baseAttribute.getName());
    }

    private CubeDimensionAttribute findAttribute(String string) {
        return this.dim.findAttribute(string);
    }

    private CubeDimensionLevel findLevel(DimensionLevel dimensionLevel) {
        return this.findLevel(dimensionLevel.getName());
    }

    private CubeDimensionLevel findLevel(String string) {
        return this.dim.findLevel(string);
    }

    private CubeDimensionHierarchy findHierarchy(LevelHierarchy levelHierarchy) {
        return this.findHierarchy(levelHierarchy.getName());
    }

    private CubeDimensionHierarchy findHierarchy(ValueHierarchy valueHierarchy) {
        return this.findHierarchy(valueHierarchy.getName());
    }

    private CubeDimensionHierarchy findHierarchy(String string) {
        return this.dim.findHierarchy(string);
    }

    private LevelHierarchy findLevelHierarchyForMapping(String string) {
        List<Hierarchy> list = this.xmldim.getHierarchy();
        for (Hierarchy hierarchy : list) {
            LevelHierarchy levelHierarchy = hierarchy.getLevelHierarchy();
            if (levelHierarchy == null || !string.equals(levelHierarchy.getName())) continue;
            boolean bl = true;
            for (HierarchyLevel hierarchyLevel : levelHierarchy.getHierarchyLevel()) {
                if (hierarchyLevel.getAction() != null && hierarchyLevel.getAction().equals("REMOVE")) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            return levelHierarchy;
        }
        return null;
    }

    private HierarchyLevel findHierarchyLevel(LevelHierarchy levelHierarchy, String string) {
        if (levelHierarchy != null) {
            for (HierarchyLevel hierarchyLevel : levelHierarchy.getHierarchyLevel()) {
                String string2 = hierarchyLevel.getDimensionLevel();
                if (!string2.equals(string)) continue;
                return hierarchyLevel;
            }
        }
        return null;
    }

    private CubeDimensionHierarchyLevel findHierarchyLevel(LevelHierarchy levelHierarchy, HierarchyLevel hierarchyLevel) {
        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = null;
        block0: for (CubeDimensionHierarchy cubeDimensionHierarchy : this.dim.getHierarchies()) {
            if (!cubeDimensionHierarchy.getName().equals(levelHierarchy.getName())) continue;
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel2 : cubeDimensionHierarchy.getHierarchyLevels()) {
                if (!cubeDimensionHierarchyLevel2.getLevel().getName().equals(hierarchyLevel.getDimensionLevel())) continue;
                cubeDimensionHierarchyLevel = cubeDimensionHierarchyLevel2;
                continue block0;
            }
        }
        return cubeDimensionHierarchyLevel;
    }

    private HierarchyLevelMap getHierarchyLevelMap(LevelHierarchy levelHierarchy, CubeDimensionLevel cubeDimensionLevel) {
        String string = cubeDimensionLevel.getName();
        List<HierarchyLevel> list = levelHierarchy.getHierarchyLevel();
        for (HierarchyLevel hierarchyLevel : list) {
            String string2 = hierarchyLevel.getDimensionLevel();
            if (!string2.equals(string)) continue;
            List<Object> list2 = hierarchyLevel.getContent();
            for (Object object : list2) {
                if (!(object instanceof HierarchyLevelMap)) continue;
                HierarchyLevelMap hierarchyLevelMap = (HierarchyLevelMap)object;
                return hierarchyLevelMap;
            }
        }
        return null;
    }

    private String getExpression(DimensionLevel dimensionLevel) {
        List<Object> list = dimensionLevel.getContent();
        for (Object object : list) {
            if (!(object instanceof MemberListMap)) continue;
            MemberListMap memberListMap = (MemberListMap)object;
            String string = memberListMap.getKeyExpression();
            string = CubeDimensionXML.stripQuotes(string);
            return string;
        }
        return null;
    }

    private AWPrimaryDimensionOrganization findOrCreateAWPrimaryDimensionOrganization() {
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = null;
        Organization organization = this.xmldim.getOrganization();
        if (organization == null) {
            aWPrimaryDimensionOrganization = new AWPrimaryDimensionOrganization();
            organization.setAWPrimaryDimensionOrganization(aWPrimaryDimensionOrganization);
        } else {
            aWPrimaryDimensionOrganization = organization.getAWPrimaryDimensionOrganization();
        }
        return aWPrimaryDimensionOrganization;
    }

    private String generateLevelAttrName(String string, String string2) {
        String string3 = string + "_" + string2;
        int n = string3.getBytes().length;
        if (this.getMetadataContext().getDatabase() != null && (n = this.getLengthInBytes(this.getMetadataContext().getDatabase().getConnection(), string3)) > 28) {
            string3 = string3.substring(0, 28);
        }
        String string4 = string3;
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            bl = false;
            block1: for (Attribute attribute : this.xmldim.getAttribute()) {
                for (Object object : attribute.getContent()) {
                    BaseAttribute baseAttribute;
                    if (!(object instanceof BaseAttribute) || !(baseAttribute = (BaseAttribute)object).getName().equalsIgnoreCase(string4)) continue;
                    bl = true;
                    continue block1;
                }
            }
            if (!bl) {
                bl2 = true;
                break;
            }
            string4 = string3 + Integer.toString(n2++);
        }
        return string4;
    }

    private int getLengthInBytes(Connection connection, String string) {
        this.numOfBytes = 0;
        String string2 = "select lengthb('" + string + "') from dual";
        try {
            DatabaseUtils.ExecuteSQL(connection, string2, new RowSetCallBack(){

                @Override
                public void processRowSet(ResultSet resultSet) throws SQLException {
                    if (resultSet != null) {
                        CubeDimensionXML.this.numOfBytes = resultSet.getInt(1);
                    }
                }
            }, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.numOfBytes;
    }
}

