/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubexml;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.olap.app.db.OracleSQLDataType;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cubexml.BaseCubeXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olap.syntax.SyntaxTree;
import oracle.olap.syntax.SyntaxVisitor;
import oracle.olap.xmlbind.AWCubeOrganization;
import oracle.olap.xmlbind.BaseMeasure;
import oracle.olap.xmlbind.BuildSpecifications;
import oracle.olap.xmlbind.Classification;
import oracle.olap.xmlbind.CubeDimensionalityMap;
import oracle.olap.xmlbind.CubeMap;
import oracle.olap.xmlbind.DerivedMeasure;
import oracle.olap.xmlbind.Description;
import oracle.olap.xmlbind.Dimensionality;
import oracle.olap.xmlbind.Measure;
import oracle.olap.xmlbind.MeasureMap;
import oracle.olap.xmlbind.Metadata;
import oracle.olap.xmlbind.Organization;
import oracle.olap.xmlbind.SecondaryPartitionLevel;
import oracle.olap.xmlbind.SparseDimension;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.SyntaxObject;

public class CubeXML
extends BaseCubeXML {
    private static final Logger LOG = Logger.getLogger(CubeXML.class.getName());
    private oracle.olap.xmlbind.Cube xmlcube;
    private Cube cube;
    private static final String TRUE = "True";
    private Map<String, String> exprSubMap;

    public CubeXML(MetadataContext metadataContext, Object object, Cube cube) {
        super(metadataContext);
        this.cube = cube;
        if (object instanceof oracle.olap.xmlbind.Cube) {
            this.xmlcube = (oracle.olap.xmlbind.Cube)object;
        }
        if (object instanceof Metadata) {
            Metadata metadata = (Metadata)object;
            List<Object> list = metadata.getStandardDimensionOrTimeDimensionOrCube();
            for (Object object2 : list) {
                if (!(object2 instanceof oracle.olap.xmlbind.Cube)) continue;
                this.xmlcube = (oracle.olap.xmlbind.Cube)object2;
            }
        }
    }

    private BaseMeasure findBaseMeasure(CubeMeasure cubeMeasure) {
        for (Measure measure : this.xmlcube.getMeasure()) {
            for (Object object : measure.getContent()) {
                BaseMeasure baseMeasure;
                if (!(object instanceof BaseMeasure) || !(baseMeasure = (BaseMeasure)object).getName().equals(cubeMeasure.getName())) continue;
                return baseMeasure;
            }
        }
        return null;
    }

    private CubeMeasure findMeasure(BaseMeasure baseMeasure) {
        return this.cube.findMeasure(baseMeasure.getName());
    }

    private DerivedMeasure findCalculatedMeasure(CubeCalculatedMeasure cubeCalculatedMeasure) {
        for (Measure measure : this.xmlcube.getMeasure()) {
            for (Object object : measure.getContent()) {
                DerivedMeasure derivedMeasure;
                if (!(object instanceof DerivedMeasure) || !(derivedMeasure = (DerivedMeasure)object).getName().equals(cubeCalculatedMeasure.getName())) continue;
                return derivedMeasure;
            }
        }
        return null;
    }

    private CubeCalculatedMeasure findCalculatedMeasure(DerivedMeasure derivedMeasure) {
        return this.cube.findCalculatedMeasure(derivedMeasure.getName());
    }

    public void loadModel() {
        this.loadProperties();
        this.loadDimensionalityNames();
        this.loadDescriptions();
        this.loadMeasureProperties();
        this.loadMappings();
    }

    private void loadConsistentSolve() {
        String string = this.xmlcube.getConsistentSolve();
        if (string != null) {
            ConsistentSolveSpecification consistentSolveSpecification = (ConsistentSolveSpecification)SyntaxObject.fromSyntax((String)string, null);
            string = consistentSolveSpecification.toSyntax();
            this.cube.setConsistentSolveSpec(string);
        }
    }

    private void loadDescriptions() {
        for (Description object : this.xmlcube.getDescription()) {
            this.loadDescription(this.cube, object);
        }
        for (Measure measure : this.xmlcube.getMeasure()) {
            for (Object object : measure.getContent()) {
                Description description;
                AbstractChildObjectWithDesc abstractChildObjectWithDesc;
                Object object2;
                if (object instanceof DerivedMeasure) {
                    object2 = (DerivedMeasure)object;
                    for (Object object3 : ((DerivedMeasure)object2).getDescription()) {
                        if (!(object3 instanceof Description)) continue;
                        abstractChildObjectWithDesc = this.findCalculatedMeasure((DerivedMeasure)object2);
                        description = (Description)object3;
                        this.loadDescription(abstractChildObjectWithDesc, description);
                    }
                    continue;
                }
                if (!(object instanceof BaseMeasure)) continue;
                object2 = (BaseMeasure)object;
                for (Object object4 : ((BaseMeasure)object2).getContent()) {
                    if (!(object4 instanceof Description)) continue;
                    abstractChildObjectWithDesc = this.findMeasure((BaseMeasure)object2);
                    description = (Description)object4;
                    this.loadDescription(abstractChildObjectWithDesc, description);
                }
            }
        }
    }

    private void loadMeasureProperties() {
        String string = this.xmlcube.getDefaultMeasure();
        for (Measure measure : this.xmlcube.getMeasure()) {
            for (Object object : measure.getContent()) {
                String string2;
                BaseMeasure baseMeasure;
                CubeMeasure cubeMeasure;
                if (!(object instanceof BaseMeasure) || (cubeMeasure = this.findMeasure(baseMeasure = (BaseMeasure)object)) == null) continue;
                cubeMeasure.setDefault(false);
                if (string != null && cubeMeasure.getName().equals(string)) {
                    cubeMeasure.setDefault(true);
                }
                if ((string2 = baseMeasure.getAllowAutoDataTypeChange()) != null) {
                    if (string2.equalsIgnoreCase(TRUE)) {
                        cubeMeasure.setMeasureAllowAutoDataTypeChange(true);
                    } else {
                        cubeMeasure.setMeasureAllowAutoDataTypeChange(false);
                    }
                } else {
                    cubeMeasure.setMeasureAllowAutoDataTypeChange(false);
                }
                for (Object object2 : baseMeasure.getContent()) {
                    Object object3;
                    JAXBElement jAXBElement;
                    String string3;
                    if (!(object2 instanceof JAXBElement) || !(string3 = (jAXBElement = (JAXBElement)object2).getName().getLocalPart()).equals("ConsistentSolve") || !((object3 = jAXBElement.getValue()) instanceof String)) continue;
                    String string4 = (String)object3;
                    string4 = string4.trim();
                    cubeMeasure.setConsistentSolveSpec(string4);
                }
            }
        }
    }

    private void loadDimensionalityNames() {
        CubeDimensionality[] cubeDimensionalityArray;
        for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray = this.cube.getDimensions()) {
            String string = cubeDimensionality.getName();
            for (Dimensionality dimensionality : this.xmlcube.getDimensionality()) {
                if (!dimensionality.getDimension().equals(string)) continue;
                cubeDimensionality.setDimensionalityName(dimensionality.getName());
            }
        }
    }

    private void loadMappings() {
        CubeDimensionality[] cubeDimensionalityArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.xmlcube == null) {
            return;
        }
        String string = this.cube.getSchema().getName();
        String string2 = this.cube.getConsistentSolveSpec();
        List<CubeAggregationDimension> list = SolveSyntax.getInstance().fromSyntax(this.cube, string2);
        List<CubeMap> list2 = this.xmlcube.getCubeMap();
        CubeMeasure[] cubeMeasureArray = list2.iterator();
        while (cubeMeasureArray.hasNext()) {
            CubeMap abstractChildDBObjectArray2 = cubeMeasureArray.next();
            String string3 = abstractChildDBObjectArray2.getName();
            this.cube.setMapName(string3);
            String string4 = abstractChildDBObjectArray2.getAggregationMethod();
            if (string4 == null) {
                string4 = "SUM";
            }
            this.cube.setAggregationMethod(string4);
            Object object5 = this.processQuery(abstractChildDBObjectArray2.getQuery());
            this.cube.setMapQuery((String)object5);
            String string5 = abstractChildDBObjectArray2.getWhereClause();
            if (string5 == null) continue;
            this.cube.setMapWhereClause(string5);
        }
        for (Object object5 : cubeMeasureArray = this.cube.getMeasures()) {
            for (Object object6 : list2) {
                object4 = ((CubeMap)object6).getContent();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    Iterator<CubeMap> iterator = object3.next();
                    if (!(iterator instanceof MeasureMap)) continue;
                    MeasureMap measureMap = (MeasureMap)((Object)iterator);
                    object2 = measureMap.getMeasure();
                    if (!object5.getName().equals(object2)) continue;
                    object = CubeXML.processExpression(measureMap.getExpression());
                    ((CubeMeasure)object5).setMapExpression((String)object);
                }
            }
        }
        for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray = this.cube.getDimensions()) {
            Object object6;
            object6 = cubeDimensionality.getName();
            object4 = String.format("%s.%s", string, object6);
            object3 = cubeDimensionality.getDimensionalityName();
            for (CubeMap cubeMap : list2) {
                object2 = cubeMap.getContent();
                object = object2.iterator();
                while (object.hasNext()) {
                    String string6;
                    Object e = object.next();
                    if (!(e instanceof CubeDimensionalityMap)) continue;
                    CubeDimensionalityMap cubeDimensionalityMap = (CubeDimensionalityMap)e;
                    String string7 = cubeDimensionalityMap.getDimensionality();
                    Object object7 = object6;
                    if (object3 != null) {
                        object7 = object3;
                    }
                    if (!((String)object7).equals(string7)) continue;
                    String string8 = CubeXML.processExpression(cubeDimensionalityMap.getExpression());
                    cubeDimensionality.setMapExpression(string8);
                    String string9 = cubeDimensionalityMap.getJoinCondition();
                    if (string9 != null) {
                        string6 = this.processCondition(string9);
                        cubeDimensionality.setMapJoinCondition(string6);
                    }
                    if ((string6 = cubeDimensionalityMap.getMappedDimension()) != null) {
                        String string10 = null;
                        for (CubeAggregationDimension cubeAggregationDimension : list) {
                            String string11 = cubeAggregationDimension.getName();
                            if (!string11.equals(object6)) continue;
                            string10 = cubeAggregationDimension.getAggregationFromLevel();
                            break;
                        }
                        if (string10 != null) {
                            cubeDimensionality.setMappedDimension((String)object6);
                            continue;
                        }
                        cubeDimensionality.setMappedDimension(string6);
                        continue;
                    }
                    cubeDimensionality.setMappedDimension((String)object6);
                }
            }
        }
    }

    protected String processCondition(String string) {
        this.exprSubMap = new HashMap<String, String>();
        SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null, null);
        try {
            SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

                @Override
                public void visit(SyntaxObject syntaxObject) throws SQLException {
                    String string;
                    ColumnExpression columnExpression;
                    String string2;
                    if (syntaxObject instanceof ColumnExpression && !(string2 = (columnExpression = (ColumnExpression)syntaxObject).toSyntax()).equals(string = BaseCubeXML.processExpression(string2))) {
                        CubeXML.this.exprSubMap.put(string2, string);
                    }
                }
            });
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
        String string2 = string;
        for (String string3 : this.exprSubMap.keySet()) {
            String string4 = this.exprSubMap.get(string3);
            string2 = string2.replaceAll(string3, string4);
        }
        return string2;
    }

    private void loadProperties() {
        Object object;
        Object object2;
        Object object3;
        Organization organization = this.xmlcube.getOrganization();
        AWCubeOrganization aWCubeOrganization = organization.getAWCubeOrganization();
        this.cube.setSparseType(aWCubeOrganization.getSparseType());
        this.cube.setMeasureStorage(aWCubeOrganization.getMeasureStorage());
        String string = aWCubeOrganization.getCubeStorageType();
        this.cube.setCubeStorageType(string);
        String string2 = aWCubeOrganization.getSQLCubeStorageType();
        if (string2 == null) {
            string2 = this.getSQLCubeStorageDataType(string);
        }
        this.cube.setSqlCubeStorageType(string2);
        this.cube.setMVOption(aWCubeOrganization.getMVOption());
        this.cube.setPrecomputePercent((int)aWCubeOrganization.getPrecomputePercent());
        this.cube.setPrecomputePercentTop((int)aWCubeOrganization.getPrecomputePercentTop());
        this.cube.setPrecomputeCondition(aWCubeOrganization.getPrecomputeCondition());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object iterator2 : aWCubeOrganization.getContent()) {
            Object object4;
            String string3;
            if (iterator2 instanceof JAXBElement) {
                object3 = (JAXBElement)iterator2;
                object2 = object3.getName().getLocalPart();
                if (((String)object2).equalsIgnoreCase("DefaultBuild") && (object = object3.getValue()) instanceof String) {
                    string3 = (String)object;
                    object4 = string3.trim();
                    CubeBuildSpecification cubeBuildSpecification = new CubeBuildSpecification(this.cube, null, (String)object4);
                    String string4 = cubeBuildSpecification.getName();
                    CubeBuildSpecification cubeBuildSpecification2 = this.cube.findBuildSpecification(string4);
                    if (cubeBuildSpecification2 == null) {
                        cubeBuildSpecification.setIsDefault(true);
                        this.cube.addBuildSpecification(cubeBuildSpecification);
                    } else {
                        cubeBuildSpecification2.setIsDefault(true);
                    }
                    if (!string4.equalsIgnoreCase("SYS_DEFAULT") && (cubeBuildSpecification = this.cube.findBuildSpecification("SYS_DEFAULT")) == null) {
                        object4 = String.format("BUILD SPEC %s(CLEAR, LOAD, SOLVE)", "SYS_DEFAULT");
                        cubeBuildSpecification = new CubeBuildSpecification(this.cube, null, (String)object4);
                        this.cube.addBuildSpecification(cubeBuildSpecification);
                    }
                }
                if (((String)object2).equalsIgnoreCase("PrecomputeCondition") && (object = object3.getValue()) instanceof String) {
                    string3 = (String)object;
                    this.cube.setPrecomputeCondition(string3.trim());
                }
            }
            if (iterator2 instanceof SparseDimension) {
                object3 = (SparseDimension)iterator2;
                arrayList.add(((SparseDimension)object3).getName());
            }
            if (iterator2 instanceof BuildSpecifications) {
                object3 = (BuildSpecifications)iterator2;
                object2 = ((BuildSpecifications)object3).getValue().trim();
                object = new CubeBuildSpecification(this.cube, null, (String)object2);
                ((CubeBuildSpecification)object).setIsDefault(false);
                string3 = object.getName();
                object4 = this.cube.findBuildSpecification(string3);
                if (object4 == null) {
                    this.cube.addBuildSpecification((CubeBuildSpecification)object);
                }
            }
            if (!(iterator2 instanceof SecondaryPartitionLevel) || ((CubePartition)((Object)(object2 = this.getPartition(((SecondaryPartitionLevel)(object3 = (SecondaryPartitionLevel)iterator2)).getName(), ((SecondaryPartitionLevel)object3).getLevel(), ((SecondaryPartitionLevel)object3).getPrecomputePercent())))).getPartitionDimension() == null) continue;
            this.cube.addPartition((CubePartition)((Object)object2));
        }
        for (Dimensionality dimensionality : this.xmlcube.getDimensionality()) {
            object3 = dimensionality.getName();
            object2 = dimensionality.getDimension();
            if (arrayList.contains(object3) || arrayList.contains(object2) || (object = this.cube.findDimensionality((String)object2)) == null) continue;
            ((CubeDimensionality)((Object)object)).setSparse(false);
        }
        List<Classification> list = this.xmlcube.getClassification();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (Classification)iterator.next();
            object2 = ((Classification)object3).getValueToFixError2();
            if (!((String)object2).startsWith("SQLExpression")) continue;
            this.cube.setSQLExpressions(Boolean.valueOf(((String)object2).substring(((String)object2).indexOf("=") + 1)));
        }
    }

    private String getSQLCubeStorageDataType(String string) {
        OracleSQLDataType oracleSQLDataType = null;
        String string2 = string;
        if (string != null) {
            if (string.equalsIgnoreCase("TEXT")) {
                string2 = "VARCHAR2";
            }
            if (string.equalsIgnoreCase("NTEXT")) {
                string2 = "NVARCHAR2";
            }
            if (string.equalsIgnoreCase("DATETIME")) {
                string2 = "DATE";
            }
            oracleSQLDataType = new OracleSQLDataType(string2);
        }
        if (oracleSQLDataType != null) {
            return oracleSQLDataType.getSQLDataType();
        }
        return "";
    }

    private CubePartition getPartition(String string, String string2, Byte by) {
        CubePartition cubePartition = new CubePartition(string);
        cubePartition.setCube(this.cube);
        String string3 = string2;
        String[] stringArray = string3.split("\\.");
        if (stringArray.length == 3) {
            cubePartition.setPartitionDimension(CubeXML.stripQuotes(stringArray[0]));
            cubePartition.setPartitionHierarchy(CubeXML.stripQuotes(stringArray[1]));
            cubePartition.setPartitionLevel(CubeXML.stripQuotes(stringArray[2]));
            Byte by2 = by;
            cubePartition.setPrecomputePercent(by2.intValue());
        }
        return cubePartition;
    }

    public void saveModel() {
        this.saveProperties();
    }

    private void saveDescriptions() {
        Object object;
        List<Description> list = this.saveDescriptions(this.cube);
        this.xmlcube.getDescription().addAll(list);
        for (CubeMeasure abstractChildObjectWithDesc : this.cube.getMeasures()) {
            list = this.saveDescriptions(abstractChildObjectWithDesc);
            object = this.findBaseMeasure(abstractChildObjectWithDesc);
            if (object == null) continue;
            ((BaseMeasure)object).getContent().addAll(list);
        }
        for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : this.cube.getCalculatedMeasures()) {
            list = this.saveDescriptions(abstractChildObjectWithDesc);
            object = this.findCalculatedMeasure((CubeCalculatedMeasure)abstractChildObjectWithDesc);
            if (object == null) continue;
            ((DerivedMeasure)object).getDescription().addAll(list);
        }
    }

    public void saveMappingsOld() {
        Object object;
        String string;
        String string2 = this.cube.getMapQuery();
        if (string2 == null) {
            return;
        }
        List<CubeMap> list = this.xmlcube.getCubeMap();
        CubeMap cubeMap = null;
        if (list.size() == 0) {
            cubeMap = new CubeMap();
            cubeMap.setName("MAP1");
            list.add(cubeMap);
        } else {
            cubeMap = list.get(0);
        }
        cubeMap.setQuery(string2);
        CubeMeasure[] cubeMeasureArray = this.cube.getMeasures();
        AbstractChildDBObject[] abstractChildDBObjectArray = cubeMeasureArray;
        int n = abstractChildDBObjectArray.length;
        for (int i = 0; i < n; ++i) {
            CubeMeasure cubeMeasure = abstractChildDBObjectArray[i];
            String string3 = cubeMeasure.getMapExpression();
            if (string3 == null) continue;
            string = cubeMeasure.getName();
            object = this.findMeasureMap(cubeMap.getContent(), string);
            if (object == null) {
                object = new MeasureMap();
                cubeMap.getContent().add(object);
            }
            ((MeasureMap)object).setName(string);
            ((MeasureMap)object).setMeasure(string);
            ((MeasureMap)object).setExpression(string3);
        }
        for (AbstractChildDBObject abstractChildDBObject : abstractChildDBObjectArray = this.cube.getDimensions()) {
            string = abstractChildDBObject.getMapExpression();
            if (string == null) continue;
            object = abstractChildDBObject.getName();
            CubeDimensionalityMap cubeDimensionalityMap = this.findDimensionalityMap(cubeMap.getContent(), (String)object);
            if (cubeDimensionalityMap == null) {
                cubeDimensionalityMap = new CubeDimensionalityMap();
                cubeMap.getContent().add(cubeDimensionalityMap);
            }
            cubeDimensionalityMap.setName((String)object);
            cubeDimensionalityMap.setDimensionality((String)object);
            cubeDimensionalityMap.setExpression(string);
            String string3 = abstractChildDBObject.getMappedDimension();
            cubeDimensionalityMap.setMappedDimension(string3);
        }
    }

    private void saveProperties() {
    }

    private MeasureMap findMeasureMap(List list, String string) {
        for (Object e : list) {
            MeasureMap measureMap;
            if (!(e instanceof MeasureMap) || !(measureMap = (MeasureMap)e).getMeasure().equals(string)) continue;
            return measureMap;
        }
        return null;
    }

    private CubeDimensionalityMap findDimensionalityMap(List list, String string) {
        for (Object e : list) {
            CubeDimensionalityMap cubeDimensionalityMap;
            if (!(e instanceof CubeDimensionalityMap) || !(cubeDimensionalityMap = (CubeDimensionalityMap)e).getName().equals(string)) continue;
            return cubeDimensionalityMap;
        }
        return null;
    }

    private AWCubeOrganization getAWCubeOrganization() {
        AWCubeOrganization aWCubeOrganization = null;
        Organization organization = this.xmlcube.getOrganization();
        if (organization == null) {
            aWCubeOrganization = new AWCubeOrganization();
            organization.setAWCubeOrganization(aWCubeOrganization);
        } else {
            aWCubeOrganization = organization.getAWCubeOrganization();
        }
        return aWCubeOrganization;
    }
}

