/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubexml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubexml.DiffUtil;
import oracle.olap.cubexml.MultipleObjectDDL;

public class MetadataContext {
    private Database db;
    private AbstractDBObjectProvider pro;
    private SystemObject originalObject;
    private SystemObject updatedObject;
    private Schema schema;
    private Difference diffrs;
    private Map<String, Object> properties;
    private List<MultipleObjectDDL> multipleObjectDDLList;
    private boolean isMultiObject;

    public MetadataContext(oracle.javatools.db.Database database) {
        this.pro = (AbstractDBObjectProvider)database;
        this.properties = new HashMap<String, Object>();
    }

    public MetadataContext(AbstractDBObjectProvider abstractDBObjectProvider) {
        this.pro = abstractDBObjectProvider;
        this.properties = new HashMap<String, Object>();
    }

    public MetadataContext(oracle.javatools.db.Database database, SystemObject systemObject, SystemObject systemObject2) {
        this.pro = (AbstractDBObjectProvider)database;
        this.originalObject = systemObject;
        this.updatedObject = systemObject2;
        this.properties = new HashMap<String, Object>();
    }

    public MetadataContext(Database database, SystemObject systemObject, SystemObject systemObject2) {
        this.db = database;
        this.originalObject = systemObject;
        this.updatedObject = systemObject2;
        this.properties = new HashMap<String, Object>();
    }

    public MetadataContext(AbstractDBObjectProvider abstractDBObjectProvider, SystemObject systemObject, SystemObject systemObject2) {
        this.pro = abstractDBObjectProvider;
        this.originalObject = systemObject;
        this.updatedObject = systemObject2;
        this.properties = new HashMap<String, Object>();
    }

    public MetadataContext(oracle.javatools.db.Database database, List<MultipleObjectDDL> list) {
        this.pro = (AbstractDBObjectProvider)database;
        this.multipleObjectDDLList = list;
        this.properties = new HashMap<String, Object>();
        this.isMultiObject = true;
    }

    public AbstractDBObjectProvider getProvider() {
        return this.pro;
    }

    public SystemObject getOriginalObject() {
        return this.originalObject;
    }

    public SystemObject getUpdatedObject() {
        return this.updatedObject;
    }

    public SystemObject getSystemObject() {
        return this.updatedObject;
    }

    public List<MultipleObjectDDL> getMultipleObjectDDLList() {
        return this.multipleObjectDDLList;
    }

    public boolean isSpecialMultiObject() {
        return this.isMultiObject;
    }

    public Difference getDiff() {
        if (this.diffrs == null && this.pro != null) {
            this.diffrs = this.pro.getDiffEngine().diff((Object)this.originalObject, (Object)this.updatedObject).getResult();
        }
        return this.diffrs;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setDatabase(Database database) {
        this.db = database;
    }

    public Database getDatabase() {
        return this.db;
    }

    public boolean isModified(String string) {
        DiffUtil diffUtil = new DiffUtil(this.getDiff());
        return diffUtil.isPropertyModified(string);
    }

    public void put(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object get(String string) {
        return this.properties.get(string);
    }
}

