/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubedimension.model.CubeDimension;

public class CubeDimensionList {
    private OracleDatabaseImpl db;
    private Schema schema;
    private String awName;
    private List<CubeDimension> dimensions;
    private CubeDimensionBuilder cubeDimBuilder = null;

    public CubeDimensionList(OracleDatabaseImpl oracleDatabaseImpl, Schema schema, String string) {
        this.db = oracleDatabaseImpl;
        this.schema = schema;
        this.awName = string;
        this.dimensions = new ArrayList<CubeDimension>();
        this.cubeDimBuilder = new CubeDimensionBuilder(oracleDatabaseImpl);
    }

    private void addCubeDimension(String string, String string2, String string3, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (this.cubeDimBuilder != null) {
            NameBasedID nameBasedID = new NameBasedID("CUBE DIMENSION", this.schema.getName(), string2, (AbstractDBObjectProvider)this.db);
            CubeDimension cubeDimension = this.cubeDimBuilder.createObject(string2, this.schema, (DBObjectID)nameBasedID);
            cubeDimension.setAnalyticWorkspace(string);
            cubeDimension.setDimensionType(string3);
            if (bl) {
                this.cubeDimBuilder.buildDetails(cubeDimension);
            } else {
                this.cubeDimBuilder.build(cubeDimension);
            }
            this.dimensions.add(cubeDimension);
        }
    }

    public void build(CubeDimension cubeDimension, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (bl) {
            this.cubeDimBuilder.buildDetails(cubeDimension);
        } else {
            this.cubeDimBuilder.build(cubeDimension);
        }
    }

    public List<CubeDimension> getCubeDimensions() throws DBException, SQLException, IOException, JAXBException {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        this.dimensions = new ArrayList<CubeDimension>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.schema.getName());
        String string = "select dimension_name, aw_name, dimension_type from all_cube_dimensions where owner = :owner order by dimension_type desc, aw_name, dimension_name";
        if (this.awName != null) {
            hashMap.put("awname", this.awName);
            string = "select dimension_name, aw_name, dimension_type from all_cube_dimensions where owner = :owner and aw_name = :awname order by dimension_type desc, aw_name, dimension_name";
        }
        List list = dBUtil.executeReturnList(string, hashMap);
        boolean bl = false;
        for (Map map : list) {
            String string2 = (String)map.get("DIMENSION_NAME");
            String string3 = (String)map.get("AW_NAME");
            String string4 = (String)map.get("DIMENSION_TYPE");
            this.addCubeDimension(string3, string2, string4, bl);
        }
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCubeDimensionsOld(DBUtil dBUtil) {
        this.dimensions = new ArrayList<CubeDimension>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.schema.getName());
        String string = "select dimension_name, aw_name from all_cube_dimensions where owner = ? order by aw_name, dimension_name";
        ResultSetWrapper resultSetWrapper = null;
        try {
            resultSetWrapper = dBUtil.executeQuery(string, arrayList);
            if (resultSetWrapper != null) {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    this.addCubeDimension(string3, string2, null, true);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
                Connections.getInstance().getLock(this.db.getConnectionName()).unlock();
            }
        }
    }

    public void getCubeDimensions(Connection connection) throws IOException, SQLException, DBException, JAXBException {
        String string = "select dimension_name, aw_name from all_cube_dimensions where owner = ? order by aw_name, dimension_name";
        this.dimensions = new ArrayList<CubeDimension>();
        List list = DatabaseUtils.ExecuteSQL(connection, string, new Object[]{this.schema.getName()});
        for (List list2 : list) {
            String string2 = (String)list2.get(0);
            String string3 = (String)list2.get(1);
            this.addCubeDimension(string3, string2, null, false);
        }
    }
}

