/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.olap.app.cubeddl.ParseException;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.cubexml.MultipleObjectDDL;
import org.xml.sax.SAXException;

public class CubeSQL {
    private DDLDatabase db;
    private boolean is12Compatible;
    private SystemObject originalObject;
    private SystemObject updatedObject;
    private Collection<String> statements;
    private List<MultipleObjectDDL> allObjects;
    private boolean execute;
    private MetadataContext metadataContext;

    public CubeSQL(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2, Collection<String> collection, boolean bl2) {
        this.db = dDLDatabase;
        this.is12Compatible = bl;
        this.originalObject = systemObject;
        this.updatedObject = systemObject2;
        this.statements = collection;
        this.execute = bl2;
        DatabaseImpl databaseImpl = new DatabaseImpl();
        Connection connection = dDLDatabase.getConnection();
        databaseImpl.setConnection(connection);
        Schema schema = new Schema(dDLDatabase.getUserName());
        this.metadataContext = new MetadataContext((oracle.javatools.db.Database)dDLDatabase, systemObject, systemObject2);
        this.metadataContext.setSchema(schema);
        this.metadataContext.setDatabase(databaseImpl);
    }

    public CubeSQL(DDLDatabase dDLDatabase, boolean bl, List<MultipleObjectDDL> list, boolean bl2) {
        this.db = dDLDatabase;
        this.is12Compatible = bl;
        this.allObjects = list;
        this.execute = bl2;
        DatabaseImpl databaseImpl = new DatabaseImpl();
        Connection connection = dDLDatabase.getConnection();
        databaseImpl.setConnection(connection);
        Schema schema = new Schema(dDLDatabase.getUserName());
        this.metadataContext = new MetadataContext((oracle.javatools.db.Database)dDLDatabase, list);
        this.metadataContext.setSchema(schema);
        this.metadataContext.setDatabase(databaseImpl);
    }

    public String execute() throws DBException {
        String string = null;
        try {
            MetadataXML metadataXML = new MetadataXML(this.metadataContext);
            string = this.execute(metadataXML);
            Connection connection = this.metadataContext.getDatabase().getConnection();
            String string2 = Connections.getInstance().getConnectionName(connection);
            String string3 = this.metadataContext.getSchema().getName();
            if (OLAPMetadataCache.hasForConnection(string2, string3)) {
                OLAPMetadataCache.removeSchema(string2, string3);
            }
            return string;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DBException((DBObject)this.updatedObject, throwable);
        }
    }

    private String execute(MetadataXML metadataXML) throws DBException {
        MetadataContext metadataContext = metadataXML.getMetadataContext();
        String string = null;
        String string2 = null;
        try {
            boolean bl = true;
            if (bl) {
                metadataXML.parse(this.statements);
                string = this.execute ? metadataXML.executeSQL() : metadataXML.getSQLXML();
            } else {
                Iterator<String> iterator = this.statements.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    string2 = string3 = iterator.next();
                    this.execute(metadataContext.getDatabase(), metadataContext.getSchema(), string2);
                }
            }
            return string;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DBException((DBObject)this.updatedObject, throwable);
        }
    }

    private void execute(Database database, Schema schema, String string) throws Exception {
        if (this.is12Compatible) {
            if (!string.startsWith("COMMENT") && string.toLowerCase().startsWith("begin")) {
                string = string + ";";
            }
            database.executeSQL(string);
        } else {
            this.execute11g(database, schema, this.originalObject, this.updatedObject, string);
        }
    }

    private void execute11g(Database database, Schema schema, SystemObject systemObject, SystemObject systemObject2, String string) throws Exception {
        MetadataContext metadataContext = new MetadataContext(database, systemObject, systemObject2);
        metadataContext.setSchema(schema);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        metadataXML.parse(string);
        metadataXML.executeSQL();
    }

    private String get11gXML(Database database, Schema schema, SystemObject systemObject, SystemObject systemObject2, String string) throws ParseException, SQLException, IOException, JAXBException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
        MetadataContext metadataContext = new MetadataContext(database, systemObject, systemObject2);
        metadataContext.setSchema(schema);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        metadataXML.parse(string);
        boolean bl = false;
        return metadataXML.generateXML(bl);
    }

    public Object get(String string) {
        return this.metadataContext.get(string);
    }

    public void put(String string, Object object) {
        this.metadataContext.put(string, object);
    }

    public void setProperties(Map<String, Object> map) {
        for (String string : map.keySet()) {
            this.metadataContext.put(string, map.get(string));
        }
    }
}

