/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.olap.app.tree.loader.TreeLoaderXML;
import oracle.olap.app.tree.model.TreeTable;
import oracle.olap.app.tree.view.JTreeTable;
import oracle.olap.app.tree.view.JTreeTableToolTipManager;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.db.model.StatefulDescriptions;
import oracle.olap.db.view.MyTableCellEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class DescriptionPanel<T extends AbstractSchemaObjectWithDesc>
extends BaseEditorPanel<T>
implements JTreeTableToolTipManager {
    private TreeLoaderXML treeLoaderXML;
    private JTreeTable namingTreeTable;
    private String rootXMLNodeName;
    private int operationResult;
    private String editDescriptionText;

    public DescriptionPanel() {
        this.layoutComponents();
    }

    protected void initialisePanel() {
        String string = this.getDescriptionXML();
        try {
            String string2 = this.getDescriptionEditorXML();
            this.treeLoaderXML = new TreeLoaderXML(string, this.getClass(), string2);
            NodeList nodeList = this.treeLoaderXML.getDocument().getChildNodes();
            int n = 0;
            if (n < nodeList.getLength()) {
                this.rootXMLNodeName = nodeList.item(n).getNodeName();
            }
            TreeTable treeTable = (TreeTable)this.treeLoaderXML.getTree();
            this.namingTreeTable.setModel(treeTable);
            this.namingTreeTable.expandAll(true);
            this.namingTreeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
            this.namingTreeTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract String[] getObjectXPaths();

    protected abstract String getDescriptionXML();

    protected abstract String getDescriptionEditorXML();

    protected String getDescXML(String string, AbstractChildObjectWithDesc abstractChildObjectWithDesc) {
        return this.getDescXML(string, abstractChildObjectWithDesc.getName(), abstractChildObjectWithDesc);
    }

    protected String getDescXML(String string, String string2, Descriptions descriptions) {
        String string3;
        String string4;
        String string5 = descriptions.getDescription();
        if (string5 == null) {
            string5 = "";
        }
        if ((string4 = descriptions.getShortDescription()) == null) {
            string4 = "";
        }
        if ((string3 = descriptions.getLongDescription()) == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string6 = String.format("  <%s name=\"%s\">\n", string, string2);
        stringBuffer.append(string6);
        string6 = String.format("    <%sDescription description=\"%s\" shortDescription=\"%s\" longDescription=\"%s\"/>\n", string, string5, string4, string3);
        stringBuffer.append(string6);
        string6 = String.format("  </%s>\n", string);
        stringBuffer.append(string6);
        return stringBuffer.toString();
    }

    protected void commitPanel() {
        String string = this.treeLoaderXML.generateXML();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            Document document = documentBuilder.parse(new InputSource(stringReader));
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (String string2 : this.getObjectXPaths()) {
                XPathExpression xPathExpression = xPath.compile(string2);
                Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
                NodeList nodeList = (NodeList)object;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.commitFromXMLNode(xPath, nodeList.item(i));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void commitFromXMLNode(XPath xPath, Node node) throws XPathExpressionException {
        StatefulDescriptions statefulDescriptions = this.findDBObjectWithDesc(node);
        if (statefulDescriptions != null) {
            XPathExpression xPathExpression = xPath.compile("*/@description");
            String string = xPathExpression.evaluate(node);
            if (!(string = string.trim()).equalsIgnoreCase(statefulDescriptions.getDescription()) && !this.isEditing()) {
                statefulDescriptions.markDescriptionDirty(true);
            }
            statefulDescriptions.setDescription(string);
            xPathExpression = xPath.compile("*/@shortDescription");
            String string2 = xPathExpression.evaluate(node);
            string2 = string2.trim();
            if (!string2.equalsIgnoreCase(statefulDescriptions.getShortDescription()) && !this.isEditing()) {
                statefulDescriptions.markShortDescriptionDirty(true);
            }
            statefulDescriptions.setShortDescription(string2);
            xPathExpression = xPath.compile("*/@longDescription");
            String string3 = xPathExpression.evaluate(node);
            string3 = string3.trim();
            if (!string3.equalsIgnoreCase(statefulDescriptions.getLongDescription()) && !this.isEditing()) {
                statefulDescriptions.markLongDescriptionDirty(true);
            }
            statefulDescriptions.setLongDescription(string3);
        }
    }

    private StatefulDescriptions findDBObjectWithDesc(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile("@name");
        String string = xPathExpression.evaluate(node);
        String string2 = node.getNodeName();
        return this.findDBObjectWithDesc(string2, string);
    }

    protected abstract StatefulDescriptions findDBObjectWithDesc(String var1, String var2);

    private void layoutComponents() {
        this.namingTreeTable = new JTreeTable();
        this.namingTreeTable.setToolTipManager(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.namingTreeTable, 30, 20);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jScrollPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 15), 0, 0));
        this.namingTreeTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                Object object2;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1 && (object2 = jTable.getModel().getValueAt(n, 0)) instanceof String && (string = (String)object2).toLowerCase().endsWith("/name")) {
                    Font font = component.getFont();
                    component.setFont(font.deriveFont(1));
                }
                return component;
            }
        });
        this.namingTreeTable.setDefaultEditor(Object.class, new MyTableCellEditor(this));
    }

    @Override
    public String getCellToolTipValue(JTreeTable jTreeTable, int n, int n2) {
        if (n > 0) {
            Object object = jTreeTable.getValueAt(n2, n);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        return null;
    }

    protected void setEditOperationResult(int n) {
        this.operationResult = n;
    }

    protected int getEditOperationResult() {
        return this.operationResult;
    }

    protected void setEditDescriptionText(String string) {
        this.editDescriptionText = string;
    }

    protected String getEditDescriptionText() {
        return this.editDescriptionText;
    }

    protected String getJTreeTableCellValue(int n) {
        Object object = this.namingTreeTable.getValueAt(n, 0);
        return object.toString();
    }
}

