/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.tree.view.CheckTreeManager;
import oracle.olap.app.tree.view.JTree2;
import oracle.olap.app.tree.view.NodeIcon;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.db.view.DimensionDisplay;
import oracle.olap.db.view.DimensionNode;
import oracle.olap.db.view.HierarchyLevelNode;
import oracle.olap.db.view.HierarchyNode;
import oracle.olap.db.view.LevelNode;

public class DimensionTree
extends JTree2 {
    private CheckTreeManager checkTreeManager;
    private List<DimensionDisplay> dimDisplay = new ArrayList<DimensionDisplay>();

    public DimensionTree() {
        this.dimDisplay.add(DimensionDisplay.LEVELS);
        this.dimDisplay.add(DimensionDisplay.HIERARCHIES);
        this.dimDisplay.add(DimensionDisplay.HIERARCHY_LEVELS);
        this.initUI();
    }

    public void remove(DimensionDisplay dimensionDisplay) {
        this.dimDisplay.remove((Object)dimensionDisplay);
    }

    public void setSelectedAll(boolean bl) {
        this.checkTreeManager.setSelectedAll(bl);
    }

    public void setSelected(Object object, boolean bl) {
        TreeNode treeNode = this.findNodeForObject(object);
        if (treeNode != null) {
            TreePath treePath = DimensionTree.getPath(treeNode);
            this.checkTreeManager.setSelected(treePath, bl);
        }
    }

    private TreeNode findNodeForObject(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            return this.findNodeForObject(defaultMutableTreeNode, object);
        }
        return null;
    }

    private DefaultMutableTreeNode findNodeForObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            DefaultMutableTreeNode defaultMutableTreeNode3;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || (defaultMutableTreeNode3 = this.findNodeForObject(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public boolean isSelected(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            boolean bl = this.isNodeSelected(defaultMutableTreeNode, object);
            return bl;
        }
        return false;
    }

    private boolean isNodeSelected(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            TreePath treePath = DimensionTree.getPath(defaultMutableTreeNode);
            boolean bl = true;
            boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
            return bl2;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || !this.isNodeSelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullySelected() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            boolean bl = this.isNodeFullySelected(defaultMutableTreeNode);
            return bl;
        }
        return true;
    }

    private boolean isNodeFullySelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = DimensionTree.getPath(defaultMutableTreeNode);
        boolean bl = true;
        boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
        if (!bl2) {
            return false;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || this.isNodeFullySelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode)) continue;
            return false;
        }
        return true;
    }

    public void init(CubeDimension[] cubeDimensionArray) {
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            for (CubeDimension cubeDimension : cubeDimensionArray) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.getDimensionTree(cubeDimension);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            defaultTreeModel.setRoot(defaultMutableTreeNode);
        }
    }

    public void init(CubeDimension cubeDimension) {
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getDimensionTree(cubeDimension);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultTreeModel.setRoot(defaultMutableTreeNode);
        }
    }

    private DefaultMutableTreeNode getDimensionTree(CubeDimension cubeDimension) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n;
        CubeSubDimension[] cubeSubDimensionArray;
        DimensionNode dimensionNode = new DimensionNode(cubeDimension);
        if (this.dimDisplay.contains((Object)DimensionDisplay.LEVELS)) {
            cubeSubDimensionArray = cubeDimension.getLevels();
            for (n = 0; n < cubeSubDimensionArray.length; ++n) {
                defaultMutableTreeNode = new LevelNode((CubeDimensionLevel)cubeSubDimensionArray[n]);
                dimensionNode.add(defaultMutableTreeNode);
            }
        }
        if (this.dimDisplay.contains((Object)DimensionDisplay.HIERARCHIES)) {
            cubeSubDimensionArray = cubeDimension.getHierarchies();
            for (n = 0; n < cubeSubDimensionArray.length; ++n) {
                defaultMutableTreeNode = new HierarchyNode((CubeDimensionHierarchy)cubeSubDimensionArray[n]);
                dimensionNode.add(defaultMutableTreeNode);
                CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = ((CubeDimensionHierarchy)cubeSubDimensionArray[n]).getHierarchyLevels();
                if (!this.dimDisplay.contains((Object)DimensionDisplay.HIERARCHY_LEVELS)) continue;
                for (int i = cubeDimensionHierarchyLevelArray.length - 1; i >= 0; --i) {
                    HierarchyLevelNode hierarchyLevelNode = new HierarchyLevelNode(cubeDimensionHierarchyLevelArray[i]);
                    defaultMutableTreeNode.add(hierarchyLevelNode);
                }
            }
        }
        return dimensionNode;
    }

    private void initUI() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        NodeIcon nodeIcon = new NodeIcon(){

            @Override
            public Icon getIcon(Object object) {
                if (object instanceof DimensionNode) {
                    return OLAPImagesArb.getIcon("DIMENSION_ICON");
                }
                if (object instanceof LevelNode) {
                    return OLAPImagesArb.getIcon("LEVEL_ICON");
                }
                if (object instanceof HierarchyNode) {
                    return OLAPImagesArb.getIcon("HIERARCHY_ICON");
                }
                if (object instanceof HierarchyLevelNode) {
                    return OLAPImagesArb.getIcon("LEVEL_ICON");
                }
                return null;
            }

            @Override
            public Icon getDisabledIcon(Object object) {
                if (object instanceof DimensionNode) {
                    return OLAPImagesArb.getIcon("DIMENSION_ICON");
                }
                if (object instanceof LevelNode) {
                    return OLAPImagesArb.getIcon("LEVEL_ICON");
                }
                if (object instanceof HierarchyNode) {
                    return OLAPImagesArb.getIcon("HIERARCHY_ICON");
                }
                if (object instanceof HierarchyLevelNode) {
                    return OLAPImagesArb.getIcon("LEVEL_ICON");
                }
                return null;
            }
        };
        this.checkTreeManager = new CheckTreeManager(this, nodeIcon);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.checkTreeManager != null) {
            this.checkTreeManager.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.checkTreeManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeAllPropertyChangeListeners() {
        this.checkTreeManager.removeAllPropertyChangeListeners();
    }

    public void enablePropertyChangeListeners(boolean bl) {
        this.checkTreeManager.enablePropertyChangeListeners(bl);
    }
}

