/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.ddl;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.syntax.SyntaxTree;
import oracle.olap.syntax.SyntaxVisitor;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.SyntaxObject;

public class SQLExpressionTokenGenerator
extends TokenGenerator {
    private static final Logger LOG = Logger.getLogger(SQLExpressionTokenGenerator.class.getName());
    private String token;
    private static final String DOUBLE_QUOTE = "\"";
    private static String expr2;
    private boolean isCubeSQLReserved;

    public SQLExpressionTokenGenerator(String string) {
        this.token = string;
    }

    public void generateToken(TokenContext tokenContext) {
        Object object = tokenContext.getObject();
        if (object instanceof DBObject) {
            Object object2;
            DBObject dBObject;
            Schema schema = null;
            String string = null;
            DBObject dBObject2 = (DBObject)object;
            if (dBObject2 instanceof AbstractChildDBObject && (dBObject = (object2 = (AbstractChildDBObject)dBObject2).getParent()) != null) {
                schema = (Schema)dBObject.getProperty("schema");
            }
            if (schema != null) {
                string = schema.getName();
            }
            object2 = (String)tokenContext.getPropertyValue(this.token);
            object2 = this.processExpression(string, (String)object2);
            tokenContext.append(object2);
        } else {
            tokenContext.append(object);
        }
    }

    private String processExpression(final String string, String string2) {
        this.isCubeSQLReserved = false;
        expr2 = string2;
        if (string2 == null || string2.isEmpty()) {
            return "\"\"";
        }
        final HashSet hashSet = new HashSet();
        if (this.token.endsWith("mapQuery")) {
            boolean bl = false;
            if (ReservedWordsSyntaxHandler.IsOLAPIReservedWord(string, string2) || ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string2)) {
                bl = true;
            }
            if (!string2.startsWith(DOUBLE_QUOTE)) {
                if (!string2.toUpperCase().equals(string2) || string2.indexOf(".") != -1) {
                    bl = true;
                }
                if (bl) {
                    expr2 = String.format("\"%s\"", string2);
                }
            }
        } else {
            try {
                SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string2, null, null);
                try {
                    SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

                        @Override
                        public void visit(SyntaxObject syntaxObject) throws SQLException {
                            if (syntaxObject instanceof ColumnExpression) {
                                String string3;
                                ColumnExpression columnExpression = (ColumnExpression)syntaxObject;
                                String string2 = columnExpression.getQuery().getName();
                                if (string2.startsWith(string + ".")) {
                                    string3 = string2.substring(string.length() + 1, string2.length());
                                    if (string3.startsWith(SQLExpressionTokenGenerator.DOUBLE_QUOTE) && string3.indexOf(" ") != -1) {
                                        hashSet.add(string3);
                                    }
                                    if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string3)) {
                                        SQLExpressionTokenGenerator.this.isCubeSQLReserved = true;
                                    }
                                } else if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string2)) {
                                    SQLExpressionTokenGenerator.this.isCubeSQLReserved = true;
                                }
                                string3 = columnExpression.getColumnName();
                                if (string3.startsWith(SQLExpressionTokenGenerator.DOUBLE_QUOTE) && string3.indexOf(" ") != -1) {
                                    hashSet.add(string3);
                                }
                                if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string3)) {
                                    SQLExpressionTokenGenerator.this.isCubeSQLReserved = true;
                                }
                            }
                        }
                    });
                }
                catch (SQLException sQLException) {
                    LOG.log(Level.WARNING, sQLException.getMessage(), sQLException);
                }
                for (String string3 : hashSet) {
                    expr2 = expr2.replaceAll(string3, DOUBLE_QUOTE + string3 + DOUBLE_QUOTE);
                }
                if (this.isCubeSQLReserved || !(syntaxObject instanceof ColumnExpression)) {
                    expr2 = String.format("\"%s\"", string2);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return expr2;
    }

    public Object evaluateToken(TokenContext tokenContext) {
        return true;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"MEASURE", "\"MEASURE\"", "\"MY UNITS FACTS\".SALES", "\"\"MY UNITS FACTS\"\".SALES", "UNITS_FACT.SALES+1", "\"UNITS_FACT.SALES+1\"", "TIME.MEASURE > 1", "\"\"TIME\".\"MEASURE\" > 1\""};
        for (int i = 0; i < stringArray2.length; i += 2) {
            SQLExpressionTokenGenerator sQLExpressionTokenGenerator = new SQLExpressionTokenGenerator("");
            String string = sQLExpressionTokenGenerator.processExpression("GLOBAL", stringArray2[i]);
            System.out.print(String.format("%s=%s", stringArray2[i], string));
            if (!string.equals(stringArray2[i + 1])) {
                System.out.print("  *** Failed");
            }
            System.out.println();
        }
    }
}

