/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.dml.DMLProgram;
import oracle.olap.dml.NewDMLProgramDialog;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class NewDMLProgram {
    private static NewDMLProgram INSTANCE;

    private NewDMLProgram() {
    }

    public static NewDMLProgram getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NewDMLProgram();
        }
        return INSTANCE;
    }

    public void launchDialog(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getConnectionName();
        String string2 = dBObject.getSchemaName();
        String string3 = CubeAWUtil.getAnalyticWorkspaceName(dBObject);
        NewDMLProgramDialog newDMLProgramDialog = new NewDMLProgramDialog((Frame)Ide.getMainWindow(), connection, string2, string3);
        newDMLProgramDialog.setMinimumSize(new Dimension(400, 300));
        newDMLProgramDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        newDMLProgramDialog.setVisible(true);
        if (newDMLProgramDialog.isOKSelected()) {
            DMLProgram dMLProgram = newDMLProgramDialog.getProgram();
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"OLAPAW");
            uRL = DBURLFormatHelper.getURL((URL)uRL, (String)string3);
            uRL = DBURLFormatHelper.getURL((URL)uRL, (String)"OLAPDMLPROGRAM");
            uRL = DBURLFormatHelper.getURL((URL)uRL, (String)dMLProgram.getName());
            final OLAPDMLNode oLAPDMLNode = new OLAPDMLNode();
            oLAPDMLNode.setURL(uRL);
            oLAPDMLNode.setNewProgram(dMLProgram);
            Context context = Context.newIdeContext((Node)oLAPDMLNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            boolean bl = PlSqlFeatures.isSupportedBreadcrumbs();
            boolean bl2 = PlSqlFeatures.isSupportedGutterNavigation();
            if (bl) {
                PlSqlFeatures.setSupportedBreadcrumbs((boolean)false);
            }
            if (bl2) {
                PlSqlFeatures.setSupportedGutterNavigation((boolean)false);
            }
            editorManager.openEditor(openEditorOptions);
            PlSqlFeatures.setSupportedBreadcrumbs((boolean)bl);
            PlSqlFeatures.setSupportedGutterNavigation((boolean)bl2);
            oLAPDMLNode.markDirty(true);
            final DBObject dBObject2 = dBObject;
            oLAPDMLNode.addNodeListener(new NodeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nodeSaved(NodeEvent nodeEvent) {
                    try {
                        ObjectAction objectAction = new ObjectAction();
                        objectAction.setReload(true);
                        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject2);
                        objectActionPostProcess.run();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        oLAPDMLNode.removeNodeListener(this);
                    }
                }

                public void nodeClosed(NodeEvent nodeEvent) {
                    oLAPDMLNode.removeNodeListener(this);
                }
            });
        }
    }
}

