/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor.structure;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.olap.dml.parser.OLAPDMLBackgroundParser;
import oracle.olap.dml.parser.OLAPDMLLexerToken;
import oracle.olap.dml.parser.OLAPDMLParserEventListener;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLOutlinePanel
extends OutlinePanel
implements TreeSelectionListener,
OLAPDMLParserEventListener {
    private Editor editor = null;

    public void buildNewOutlineTree(View view) {
        this.editor = view instanceof Editor ? (Editor)view : null;
        this.setModel(new DefaultMutableTreeNode(""));
        Context context = view.getContext();
        Node node = context.getNode();
        if (node instanceof OLAPDMLNode) {
            OLAPDMLNode oLAPDMLNode = (OLAPDMLNode)node;
            oLAPDMLNode.getParser().replaceOutlineListener(this);
            String string = oLAPDMLNode.getObjectType();
            String string2 = oLAPDMLNode.getObjectName();
            if (string == null || string2 == null) {
                string2 = oLAPDMLNode.getName();
                string = oLAPDMLNode.getType();
            }
            if ("BLOCK".equals(string)) {
                string2 = "ANONYMOUS BLOCK";
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new Member(string2, string, 0, string + " " + string2));
            ArrayList<Member> arrayList = new ArrayList<Member>();
            oLAPDMLNode.addMembersTo(arrayList);
            for (Member member : arrayList) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(member));
            }
            this.setModel(defaultMutableTreeNode);
        } else if (node instanceof TextNode) {
            if (view instanceof EquippedWithParser) {
                ((EquippedWithParser)view).getParser().replaceOutlineListener((OutlinePanel)this);
            }
            TextBuffer textBuffer = ((TextNode)node).acquireTextBuffer();
            String string = textBuffer.getString(0, textBuffer.getLength());
            ((TextNode)node).releaseTextBuffer();
            List<LexerToken> list = OLAPDMLLexerToken.parse(string, false);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
            this.setModel(defaultMutableTreeNode);
        }
    }

    @Override
    public void stateChanged(OLAPDMLBackgroundParser oLAPDMLBackgroundParser) {
    }
}

