/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.util.Pair;
import oracle.olap.graph.DirectedGraph;
import oracle.olap.graph.Vertex;

class DirectedGraphTest {
    private static final String GRAPH_HAS_CYCLES_MSG = "ERROR: Graph has cycles";

    DirectedGraphTest() {
    }

    private static String topologicalSort(DirectedGraph directedGraph) {
        StringBuffer stringBuffer = new StringBuffer();
        Vertex<T>[] vertexArray = directedGraph.topologicalSort();
        if (vertexArray == null) {
            stringBuffer.append(GRAPH_HAS_CYCLES_MSG);
        } else {
            for (int i = 0; i < directedGraph.getSize(); ++i) {
                stringBuffer.append(vertexArray[i].getData() + "->");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            }
        }
        return stringBuffer.toString();
    }

    private static void test() {
        Pair[] pairArray = new Pair[]{new Pair((Object)new String[]{"LEVEL1,LEVEL2,LEVEL3", "LEVEL1,LEVEL3", "LEVEL1,LEVEL5", "LEVEL3,LEVEL5", "LEVEL5,LEVEL1"}, (Object)GRAPH_HAS_CYCLES_MSG), new Pair((Object)new String[]{"LEVEL1,LEVEL2,LEVEL3", "LEVEL1,LEVEL3", "LEVEL1,LEVEL5", "LEVEL3,LEVEL5"}, (Object)"LEVEL1->LEVEL2->LEVEL3->LEVEL5")};
        boolean bl = true;
        for (Pair pair : pairArray) {
            Object object;
            ArrayList arrayList = new ArrayList();
            String[] stringArray = (String[])pair.getFirst();
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i].split(",");
                List<String> list = Arrays.asList(object);
                arrayList.add(list);
            }
            DirectedGraph directedGraph = new DirectedGraph(arrayList);
            object = DirectedGraphTest.topologicalSort(directedGraph);
            if (((String)object).equals(pair.getSecond())) continue;
            System.out.println("Failed on Test below");
            System.out.println(String.format("%s=%s", arrayList, object));
            bl = false;
            break;
        }
        if (bl) {
            System.out.println("All the tests ran successfully!");
        }
    }

    public static void test1() {
        DirectedGraph<String> directedGraph = new DirectedGraph<String>();
        directedGraph.addVertex("A");
        directedGraph.addVertex("B");
        directedGraph.addVertex("C");
        directedGraph.addVertex("D");
        directedGraph.addVertex("E");
        directedGraph.addVertex("F");
        directedGraph.addVertex("G");
        directedGraph.addVertex("H");
        directedGraph.addEdge(0, 3);
        directedGraph.addEdge(0, 4);
        directedGraph.addEdge(1, 4);
        directedGraph.addEdge(2, 5);
        directedGraph.addEdge(3, 6);
        directedGraph.addEdge(4, 6);
        directedGraph.addEdge(5, 7);
        directedGraph.addEdge(6, 7);
        System.out.println(DirectedGraphTest.topologicalSort(directedGraph));
    }

    public static void main(String[] stringArray) {
        DirectedGraphTest.test();
    }
}

