/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.awt.Dialog;
import java.awt.Window;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.data.DimensionDataViewer;
import oracle.olap.data.DimensionMetadataContext;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyViewerDialog;

public class DimensionDataViewerDialog
implements DimensionDataViewer {
    private DimensionMetadataContext dimMetadataContext;
    private Connection conn;
    private String language;
    private JFrame parent;

    public DimensionDataViewerDialog(JFrame jFrame, Connection connection, DimensionMetadataContext dimensionMetadataContext, String string) {
        this.parent = jFrame;
        this.conn = connection;
        this.language = string;
        this.dimMetadataContext = dimensionMetadataContext;
    }

    @Override
    public void init(DimensionMetadataContext dimensionMetadataContext) {
        this.dimMetadataContext = dimensionMetadataContext;
    }

    @Override
    public void show() {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        try {
            Object object;
            Object object2;
            databaseImpl.setConnection(this.conn);
            List<String> list = this.dimMetadataContext.getHierarchies();
            ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
            String string = this.dimMetadataContext.getOwner();
            String string2 = this.dimMetadataContext.getName();
            String string3 = this.dimMetadataContext.getDefaultHierarchy();
            Dimension dimension = this.dimMetadataContext.getDimension();
            if (!dimension.isFlat()) {
                object2 = dimension.getHierarchies();
                object = object2.iterator();
                while (object.hasNext()) {
                    DimensionHierarchy dimensionHierarchy = object.next();
                    arrayList.add(new HierarchyET(this.conn, dimension, dimensionHierarchy));
                }
            } else {
                arrayList.add(new HierarchyET(this.conn, dimension, null));
            }
            object2 = OLAPArb.format("DIMENSION_DATA_VIEWER_TITLE", string.toUpperCase(), string2);
            object = new HierarchyViewerDialog(this.parent, (String)object2, arrayList, string3, new OLAPResources());
            ((Dialog)object).setModal(true);
            ((JDialog)object).setDefaultCloseOperation(2);
            ((Window)object).setSize(400, 400);
            ((Window)object).setLocationRelativeTo(this.parent);
            ((Dialog)object).setVisible(true);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public void cleanup() {
    }
}

