/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.data.DimensionMetadataContext;

public class DimensionMetadataContextImpl
implements DimensionMetadataContext {
    private String owner;
    private String name;
    private String defaultHierarchy;
    private List<String> hierarchies;
    private Dimension dimension;

    public DimensionMetadataContextImpl(Dimension dimension) {
        this.dimension = dimension;
        Schema schema = dimension.getSchema();
        if (schema != null) {
            this.owner = schema.getName();
        }
        this.name = dimension.getName();
        DimensionHierarchy dimensionHierarchy = dimension.getDefaultHierarchy();
        if (dimensionHierarchy != null) {
            this.defaultHierarchy = dimensionHierarchy.getName();
        }
        List<DimensionHierarchy> list = dimension.getHierarchies();
        this.hierarchies = new ArrayList<String>();
        for (DimensionHierarchy dimensionHierarchy2 : list) {
            this.hierarchies.add(dimensionHierarchy2.getName());
        }
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public String getDefaultHierarchy() {
        return this.defaultHierarchy;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }
}

