/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.tree.loader.TreeLoader;
import oracle.olap.hierarchyviewer.DimensionLoader;
import oracle.olap.hierarchyviewer.HierarchyLoader;

public class HierarchyET {
    private Connection conn;
    private String etViewName;
    private TreeLoader treeLoader;
    private List<String> levelNames;
    private String owner;
    private String dimensionName;
    private String hierarchyName;

    public HierarchyET(Connection connection, Dimension dimension, DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        Schema schema = dimension.getSchema();
        this.owner = schema.getName();
        this.conn = connection;
        this.dimensionName = dimension.getName();
        if (dimensionHierarchy != null) {
            this.hierarchyName = dimensionHierarchy.getName();
            this.etViewName = dimensionHierarchy.getViewName();
            List<DimensionHierarchyLevel> list = dimensionHierarchy.getHierarchyLevels();
            this.levelNames = new ArrayList<String>();
            for (DimensionHierarchyLevel dimensionHierarchyLevel : list) {
                this.levelNames.add(dimensionHierarchyLevel.getName());
            }
            this.treeLoader = new HierarchyLoader(connection, dimensionHierarchy);
            this.treeLoader.getTree().setLevelNames(this.levelNames);
        } else {
            this.etViewName = dimension.getViewName();
            this.treeLoader = new DimensionLoader(connection, dimension);
        }
    }

    public boolean isFlat() {
        return this.levelNames == null;
    }

    public String getETViewName() {
        return this.etViewName;
    }

    public TreeLoader getTreeLoader() {
        return this.treeLoader;
    }

    public List<String> getLevelNames() {
        return this.levelNames;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }
}

