/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.hierarchyviewer.DimensionLoader;

public class HierarchyLoader
extends DimensionLoader {
    private int rowNum;
    private DimensionHierarchy dimensionHierarchy;
    final String DEPTH = "depth";
    final String KEY = "key";
    final String PARENT = "parent";
    final String DESCRIPTION = "description";

    public HierarchyLoader(Connection connection, DimensionHierarchy dimensionHierarchy) throws SQLException {
        super(connection, dimensionHierarchy.getViewName());
        this.dimensionHierarchy = dimensionHierarchy;
        this.rowNum = 1;
    }

    @Override
    public void loadData() throws SQLException, IOException {
        this.column = this.checkAttributes();
        if (this.column != null) {
            this.useDescription = true;
        }
        this.loadData1(this.getETViewName());
    }

    @Override
    String checkAttributes() throws SQLException, IOException {
        String string = null;
        string = this.dimensionHierarchy.getLongDescriptionColumnName();
        if (string == null) {
            string = this.dimensionHierarchy.getShortDescriptionColumnName();
        }
        return string;
    }

    private void loadData1(String string) throws SQLException {
        this.setLoadingState(true);
        String string2 = null;
        string2 = this.useDescription ? String.format("select dim_key key, parent, depth, " + this.column + " description from %s  where depth < 2 order by " + "depth, parent", string) : String.format("select dim_key key, parent, depth from %s  where depth < 2 order by depth, parent", string);
        final String string3 = string2 = string2 + ", dim_order";
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HierarchyLoader.this.loadTree(string3);
                }
                catch (Throwable throwable) {
                    Logger.severe(HierarchyLoader.class, (Throwable)throwable);
                }
                finally {
                    HierarchyLoader.this.setLoadingState(false);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Logger.warn(HierarchyLoader.class, (Throwable)interruptedException);
        }
    }

    private void loadTree(String string) throws SQLException {
        Map map = null;
        ResultSetWrapper resultSetWrapper = null;
        try {
            Connections.getInstance().lock(this.connection);
            resultSetWrapper = this.dbUtil.executeQuery(string, map);
            ResultSet resultSet = resultSetWrapper.getResultSet();
            resultSet.setFetchSize(3000);
            int n = -1;
            int n2 = -1;
            while (resultSet.next()) {
                HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                hierarchyNodeData.dimKey = resultSet.getString("key");
                hierarchyNodeData.parent = resultSet.getString("parent");
                n2 = resultSet.getInt("depth");
                if (this.useDescription) {
                    hierarchyNodeData.desc = resultSet.getString("description");
                }
                this.load(hierarchyNodeData, hierarchyNodeData, n2);
                ++this.rowNum;
                if (n2 == n) continue;
                this.setFinishedLoadingDepth(n);
                n = n2;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(this.connection);
        }
        this.getTree().setCount(this.rowNum);
    }

    @Override
    public void loadChildren(Object object) {
        if (object instanceof DefaultNode) {
            Object object2;
            this.setLoadingState(true);
            DefaultNode defaultNode = (DefaultNode)object;
            String string = null;
            if (defaultNode.getUserObject() instanceof String) {
                string = (String)defaultNode.getUserObject();
            } else {
                object2 = (HierarchyNodeData)defaultNode.getUserObject();
                string = ((HierarchyNodeData)object2).getName();
            }
            object2 = this.getETViewName();
            String string2 = null;
            string2 = this.useDescription ? String.format("select dim_key key, parent, depth, " + this.column + " description " + "from %s where parent = '%s' ", object2, string) : String.format("select dim_key key, parent, depth from %s where parent = '%s' ", object2, string);
            final String string3 = string2 = string2 + " order by dim_order";
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HierarchyLoader.this.loadChildrenData(string3);
                    }
                    catch (SQLException sQLException) {
                        Logger.severe(HierarchyLoader.class, (Throwable)sQLException);
                    }
                    finally {
                        HierarchyLoader.this.setLoadingState(false);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Logger.warn(HierarchyLoader.class, (Throwable)interruptedException);
            }
        }
    }

    public void loadChildrenData(String string) throws SQLException {
        Map map = null;
        ResultSetWrapper resultSetWrapper = null;
        try {
            Connections.getInstance().lock(this.connection);
            resultSetWrapper = this.dbUtil.executeQuery(string, map);
            ResultSet resultSet = resultSetWrapper.getResultSet();
            resultSet.setFetchSize(3000);
            int n = -1;
            while (resultSet.next()) {
                HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                hierarchyNodeData.dimKey = resultSet.getString("key");
                hierarchyNodeData.parent = resultSet.getString("parent");
                n = resultSet.getInt("depth");
                if (this.useDescription) {
                    hierarchyNodeData.desc = resultSet.getString("description");
                }
                this.load(hierarchyNodeData, hierarchyNodeData, n);
                ++this.rowNum;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            Connections.getInstance().unlock(this.connection);
        }
        this.getTree().setCount(this.rowNum);
    }
}

